/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.parttime.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.parttime.batchimport.PartTimeEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class PartTimeJobImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(PartTimeJobImportHandler.class);
    private List<String> jobList = new ArrayList<String>();
    private Map<String, Long> jobMap = new HashMap<String, Long>();

    public PartTimeJobImportHandler(PartTimeEntryImportNumberToIdBO partTimeEntryImportNumberToIdBO) {
        super(partTimeEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject baseData = entryImportWrapper.getJsonObject().getJSONObject("bjob");
        if (baseData == null) {
            return;
        }
        String number = baseData.getString("number");
        this.jobList.add(number);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start JobImportHandler genOrgNumberIdMap");
                if (!this.jobList.isEmpty()) {
                    Map<String, Object> jobHisSimpleInfo = JobExternalService.getInstance().invokeQueryJobHisSimpleInfo(this.jobList, null);
                    DynamicObjectCollection data = (DynamicObjectCollection)jobHisSimpleInfo.get("data");
                    Map<String, Long> jobinfoMap = data.stream().filter(temp -> temp.get("enable").equals("1")).collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (Long)temp.get("boid"), (k1, k2) -> k1));
                    this.setJobMap(jobinfoMap);
                }
                LOGGER.info("end JobImportHandler genOrgNumberIdMap");
            }
            catch (Exception exception) {
                LOGGER.error("EntryImportSerivceImpl JobImportHandler listAllIdByNumber error exception is : ", (Throwable)exception);
                LOGGER.error("EntryImportSerivceImpl JobImportHandler JobImportHandler invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject ajob = temp.getJsonObject().getJSONObject("bjob");
                    if (ajob != null) {
                        temp.getValidateContext().setCompleteValidResult("jobNumber2Id", ResManager.loadKDString((String)"\u517c\u804c\u804c\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeJobImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                });
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        try {
            LOGGER.info("start jobNumber2Id");
            JSONObject importSource = entryImportWrapper.getJsonObject();
            String postpattern = importSource.getString("apositiontype");
            if (!postpattern.equals(ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportNumberToIdBO_7", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                return;
            }
            String number = (String)((JSONObject)entryImportWrapper.getJsonObject().get((Object)"bjob")).get((Object)"number");
            Long jobId = this.jobMap.get(number);
            if (jobId == null) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("jobNumber2Id", String.format(ResManager.loadKDString((String)"\u517c\u804c\u804c\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeJobImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]), number));
            }
            JSONObject bjob = JsonObjectUtil.genJSONObject.apply(jobId);
            bjob.put("boid", (Object)jobId);
            entryImportWrapper.getJsonObject().put("bjob", (Object)bjob);
            entryImportWrapper.getJsonObject().put("bjob_no", (Object)number);
            LOGGER.info("end jobNumber2Id jobId :", (Object)jobId);
        }
        catch (Exception exception) {
            LOGGER.error("error jobNumber2Id exception:", (Throwable)exception);
            String number = (String)((JSONObject)entryImportWrapper.getJsonObject().get((Object)"bjob")).get((Object)"number");
            entryImportWrapper.getValidateContext().setCompleteValidResult("jobNumber2Id", String.format(ResManager.loadKDString((String)"\u517c\u804c\u804c\u4f4d\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"PartTimeJobImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]), number));
        }
    }

    public List<String> getJobList() {
        return this.jobList;
    }

    public Map<String, Long> getJobMap() {
        return this.jobMap;
    }

    public void setJobList(List<String> jobList) {
        this.jobList = jobList;
    }

    public void setJobMap(Map<String, Long> jobMap) {
        this.jobMap = jobMap;
    }
}

