/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;

public class ServiceFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%s\u201d\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u3002", (String)"ServiceFactory_0", (String)"hr-hdm-business", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        serviceMap.put("IHSPMService", "kd.hr.hdm.business.domain.service.hspm.impl.IHSPMServiceImpl");
        serviceMap.put("IHRPIService", "kd.hr.hdm.business.domain.service.hrpi.impl.IHRPIServiceImpl");
        serviceMap.put("IHRCSService", "kd.hr.hdm.business.domain.service.hcrs.impl.IHRCSServiceImpl");
        serviceMap.put("IBRMRuleEngineService", "kd.hr.hdm.business.domain.service.brm.impl.HBRMRuleEngineServiceImpl");
        serviceMap.put("IHLCMService", "kd.hr.hdm.business.domain.service.hlcm.impl.IHLCMServiceImpl");
        serviceMap.put("IHBPMService", "kd.hr.hdm.business.domain.service.hbpm.impl.IHBPMServiceImpl");
        serviceMap.put("IHSSCService", "kd.hr.hdm.business.domain.service.hssc.impl.IHSSCServiceImpl");
    }
}

