/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.service.brm.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.domain.service.brm.IBRMRuleEngineService;
import kd.hr.hdm.business.reg.domain.service.impl.common.RuleEngineServiceImpl;
import kd.hr.hdm.common.util.RuleEngineUtil;

public class HBRMRuleEngineServiceImpl
implements IBRMRuleEngineService {
    private static final Log LOGGER = LogFactory.getLog(RuleEngineServiceImpl.class);

    @Override
    public Map<String, Object> callRuleEngine(String sceneNumber, String buNumber, Map<String, Object> inputParams) {
        return this.callRuleEngine("hpb", sceneNumber, buNumber, null, inputParams);
    }

    @Override
    public Map<String, Object> callRuleEngine(String bizApp, String sceneNumber, String buNumber, List<Long> executePolicyIds, Map<String, Object> inputParams) {
        HashMap requestMap = Maps.newHashMapWithExpectedSize((int)5);
        requestMap.put("bizApp", bizApp);
        requestMap.put("sceneNumber", sceneNumber);
        requestMap.put("buNumber", buNumber);
        if (!CollectionUtils.isEmpty(executePolicyIds)) {
            requestMap.put("executePolicyIds", executePolicyIds);
        }
        if (!CollectionUtils.isEmpty(inputParams)) {
            requestMap.put("inputParams", inputParams);
        }
        LOGGER.info("callRuleEngine bizApp:{} sceneNumber:{} buNumber:{} inputParams:{}", new Object[]{bizApp, sceneNumber, buNumber, inputParams});
        Map ruleResultMap = (Map)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"callRuleEngine", (Object[])new Object[]{requestMap});
        LOGGER.info("callRuleEngine response :{}", (Object)ruleResultMap);
        return ruleResultMap;
    }

    @Override
    public List<Map<String, Object>> batchCallRuleEngine(List<Map<String, Object>> inputParamsMapList, boolean buDif) {
        List<Map<String, Object>> ruleEngineResults = buDif ? this.brmBatchCallRuleEngineDif(inputParamsMapList) : this.brmBatchCallRuleEngine(inputParamsMapList);
        Map respResultMap = RuleEngineUtil.getRespResultMap(ruleEngineResults);
        return inputParamsMapList.stream().map(inputParamsMap -> {
            Object serialNumber = inputParamsMap.get("serialNumber");
            Map respResult = new HashMap();
            if (!HRObjectUtils.isEmpty(serialNumber)) {
                respResult = (Map)respResultMap.get(serialNumber.toString());
            }
            return respResult;
        }).collect(Collectors.toList());
    }

    @Override
    public List<List<Map<String, Object>>> batchCallRuleEngineResultList(List<Map<String, Object>> inputParamsMapList, boolean buDif) {
        List<Map<String, Object>> ruleEngineResults = buDif ? this.brmBatchCallRuleEngineDif(inputParamsMapList) : this.brmBatchCallRuleEngine(inputParamsMapList);
        Map respResultMap = RuleEngineUtil.getRespResultListMap(ruleEngineResults);
        return inputParamsMapList.stream().map(inputParamsMap -> {
            Object serialNumber = inputParamsMap.get("serialNumber");
            List respResult = new ArrayList();
            if (!HRObjectUtils.isEmpty(serialNumber)) {
                respResult = (List)respResultMap.get(serialNumber.toString());
            }
            return respResult;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> brmBatchCallRuleEngine(List<Map<String, Object>> inputParamsMapList) {
        LOGGER.info("brmBatchCallRuleEngine inputParamsMapList:{}", inputParamsMapList);
        List response = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngine", (Object[])new Object[]{inputParamsMapList});
        LOGGER.info("brmBatchCallRuleEngine response:{}", (Object)response);
        return response;
    }

    private List<Map<String, Object>> brmBatchCallRuleEngineDif(List<Map<String, Object>> inputParamsMapList) {
        LOGGER.info("brmBatchCallRuleEngineDif inputParamsMapList:{}", inputParamsMapList);
        List response = (List)HRMServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMRuleService", (String)"batchCallRuleEngineDif", (Object[])new Object[]{inputParamsMapList});
        LOGGER.info("brmBatchCallRuleEngineDif response:{}", (Object)response);
        return response;
    }
}

