/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.service.hspm.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIPersonServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;

public class IHSPMServiceImpl
implements IHSPMService {
    private static final Log LOGGER = LogFactory.getLog(IHSPMServiceImpl.class);

    @Override
    public Map<Object, Map<String, Object>> getCardFieldByErManFileIds(List<Long> erManFileIds, String groupFieldName) {
        LOGGER.info("invoke IHSPMService.getCardFields erManFileIds\uff1a{}", (Object)JSON.toJSONString(erManFileIds));
        List result = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{erManFileIds});
        LOGGER.info("invoke IHSPMService.getCardFields result\uff1a{}", (Object)JSON.toJSONString((Object)result));
        return result.stream().collect(Collectors.toMap(map -> map.get(HRStringUtils.isEmpty((String)groupFieldName) ? "id" : groupFieldName), map -> map, (v1, v2) -> v2));
    }

    @Override
    public Map<String, Object> getCardFieldByErManFileId(Long erManFileID) {
        Map<Object, Map<String, Object>> result = this.getCardFieldByErManFileIds(Lists.newArrayList((Object[])new Long[]{erManFileID}), "id");
        if (CollectionUtils.isEmpty(result)) {
            return new HashMap<String, Object>();
        }
        return Optional.ofNullable(result.get(erManFileID)).orElseGet(HashMap::new);
    }

    @Override
    public DynamicObject[] listPrimaryErManFilesByEmpNumber(List<String> empNumberList) {
        LOGGER.info("invoke IHSPMService.listPrimaryErmanFilesByEmpnumber empNumberList\uff1a{}", (Object)JSON.toJSONString(empNumberList));
        return (DynamicObject[])HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"listPrimaryErmanFilesByEmpnumber", (Object[])new Object[]{empNumberList});
    }

    @Override
    public Map<Object, Map<String, Object>> getCardFieldByNumbers(List<String> numbers) {
        QFilter filter = new QFilter("number", "in", numbers).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("empposrel.isprimary", "=", (Object)"1").and(new QFilter("empentrel.labrelstatusprd", "=", (Object)1010L)));
        DynamicObject[] erManFiles = IHRPIService.getInstance().listFieldsFilterInfo("id", filter, "hspm_ermanfile");
        if (erManFiles.length == 0) {
            LOGGER.warn("erManFiles is empty");
            return new HashMap<Object, Map<String, Object>>();
        }
        List<Long> erManFileIds = Arrays.stream(erManFiles).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map<Object, Map<String, Object>> erManFileMap = IHSPMService.getInstance().getCardFieldByErManFileIds(erManFileIds, "number");
        if (erManFileMap.isEmpty()) {
            LOGGER.error("erManFileMap is empty");
            return new HashMap<Object, Map<String, Object>>();
        }
        return erManFileMap;
    }

    @Override
    public Map<Object, Map<String, Object>> getCardFieldByBosUserIds(List<Long> userIds) {
        Map personInfoByUserIdsMap = HRPIPersonServiceHelper.queryPersonInfoByUserIds(userIds);
        if (personInfoByUserIdsMap == null || personInfoByUserIdsMap.isEmpty()) {
            LOGGER.warn("personInfoByUserIdsMap is empty");
            return new HashMap<Object, Map<String, Object>>();
        }
        Map personInfoByUserIdsData = (Map)personInfoByUserIdsMap.get("data");
        List employeeIds = personInfoByUserIdsData.values().stream().map(o -> (Long)o.get("employee")).collect(Collectors.toList());
        QFilter filter = new QFilter("employee", "in", employeeIds);
        filter.and(new QFilter("empposrel.isprimary", "=", (Object)"1"));
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        filter.and(new QFilter("businessstatus", "=", (Object)"1"));
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        DynamicObject[] erManFiles = IHRPIService.getInstance().listFieldsFilterInfo("id", filter, "hspm_ermanfile");
        if (erManFiles.length == 0) {
            LOGGER.warn("erManFiles is empty");
            return new HashMap<Object, Map<String, Object>>();
        }
        List<Long> erManFileIds = Arrays.stream(erManFiles).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map<Object, Map<String, Object>> erManFileMap = IHSPMService.getInstance().getCardFieldByErManFileIds(erManFileIds, "number");
        if (erManFileMap.isEmpty()) {
            LOGGER.error("erManFileMap is empty");
            return new HashMap<Object, Map<String, Object>>();
        }
        return erManFileMap;
    }
}

