/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.EntryImportValidator;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportValidateService;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonalChangeExternalService;
import kd.hr.hdm.common.transfer.enums.TransferTypeEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;

public class EntryImportValidateServiceImpl
implements TransferEntryImportValidateService {
    private static final Log LOGGER = LogFactory.getLog(EntryImportValidateServiceImpl.class);
    private static final String IS_VIRTUAL_ORG = "isvirtualorg";

    @Override
    public Predicate<List<EntryImportWrapper>> beforeDataInitValidate() {
        return entryImportWrappers -> {
            this.validateRepeat().test((List<EntryImportWrapper>)entryImportWrappers);
            entryImportWrappers.forEach(temp -> this.doCommonValiddate().test((EntryImportWrapper)temp));
            List collect = entryImportWrappers.stream().filter(temp -> temp.getValidateContext().getValidateResult().size() < 1).collect(Collectors.toList());
            this.validateBusinessFieldDate().test(collect);
            return true;
        };
    }

    @Override
    public Predicate<List<EntryImportWrapper>> afterDataInitValidate() {
        return entryImportWrappers -> {
            this.validateTransferDate().and(this.validateLicence()).and(this.checkRepeatInDb()).and(this.checkVirtualOrg()).and(this.excuteBatchPersonChangeCrossValidate()).test((List<EntryImportWrapper>)entryImportWrappers);
            entryImportWrappers.forEach(temp -> this.doBusinessValiddate().test((EntryImportWrapper)temp));
            return true;
        };
    }

    @Override
    public Predicate<EntryImportWrapper> doCommonValiddate() {
        return temp -> {
            String postPattern = temp.getJsonObject().getString("postpattern");
            Predicate<EntryImportWrapper> validate = EntryImportValidator.NOT_EMPTY.testOnNotEmpty("personnumber", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5de5\u53f7\u201d\u3002", (String)"EntryImportValidateServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0])).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("affaction", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d8\u52a8\u64cd\u4f5c\u201d\u3002", (String)"EntryImportValidateServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("transferreason", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u52a8\u539f\u56e0\u201d\u3002", (String)"EntryImportValidateServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("aorg", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5165\u90e8\u95e8\u201d\u3002", (String)"EntryImportValidateServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("amanagescope", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u52a8\u540e\u201c\u6240\u5c5e\u7ba1\u7406\u8303\u56f4\u201d\u3002", (String)"EntryImportValidateServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("postpattern", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4efb\u5c97\u6a21\u5f0f\u201d\u3002", (String)"EntryImportValidateServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("abaselocation", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u5165\u5de5\u4f5c\u5730\u201d\u3002", (String)"EntryImportValidateServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]))).and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("plandate", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8c03\u52a8\u65e5\u671f\u201d\u3002", (String)"EntryImportValidateServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0])));
            if (postPattern == null) {
                validate.test((EntryImportWrapper)temp);
                return true;
            }
            LOGGER.info("doCommonValiddate postPattern:{}", (Object)postPattern);
            if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("aposition", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5c97\u4f4d\u201d\u3002", (String)"EntryImportValidateServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("ajob", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u804c\u4f4d\u201d\u3002", (String)"EntryImportValidateServiceImpl_22", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                validate.and(EntryImportValidator.NOT_EMPTY.testOnNotEmpty("astposition", ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u3002", (String)"EntryImportValidateServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]))).test((EntryImportWrapper)temp);
            } else {
                validate.test((EntryImportWrapper)temp);
            }
            return true;
        };
    }

    @Override
    public Predicate<EntryImportWrapper> doBusinessValiddate() {
        return temp -> {
            LOGGER.info("start doBusinessValiddate");
            this.validateCompanyWhetherEquals().test((EntryImportWrapper)temp);
            LOGGER.info("end doBusinessValiddate");
            return true;
        };
    }

    public Predicate<List<EntryImportWrapper>> validateBusinessFieldDate() {
        return entryImportWrappers -> {
            HashSet<String> stPositionSet = new HashSet<String>();
            HashSet<String> positionSet = new HashSet<String>();
            HashSet<String> jobSet = new HashSet<String>();
            HashSet<String> evaluationJobSet = new HashSet<String>();
            for (EntryImportWrapper entryImportWrapper : entryImportWrappers) {
                JSONObject jsonObject = entryImportWrapper.getJsonObject();
                JSONObject evaluationJob = jsonObject.getJSONObject("aevaluationjob");
                if (evaluationJob != null) {
                    evaluationJobSet.add(evaluationJob.getString("number"));
                }
                String postPattern = jsonObject.getString("postpattern");
                if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                    String positionNumber = jsonObject.getJSONObject("aposition").getString("number");
                    positionSet.add(positionNumber);
                    continue;
                }
                if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                    String jobNumber = jsonObject.getJSONObject("ajob").getString("number");
                    jobSet.add(jobNumber);
                    continue;
                }
                if (!ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) continue;
                String stPositionNumber = jsonObject.getJSONObject("astposition").getString("number");
                stPositionSet.add(stPositionNumber);
            }
            Map<String, Object> stPosition = AdminOrgExternalService.getInstance().queryStdPositionByNumber(new ArrayList<String>(stPositionSet), new Date());
            Map<String, Object> position = AdminOrgExternalService.getInstance().queryPositionHisByNumber(new ArrayList<String>(positionSet), new Date());
            Map<String, Object> jobHisSimpleInfo = JobExternalService.getInstance().invokeQueryJobHisSimpleInfo(new ArrayList<String>(jobSet), null);
            Map<String, Object> evaluataionJob = JobExternalService.getInstance().invokeQueryJobHisSimpleInfo(new ArrayList<String>(evaluationJobSet), null);
            Map<String, Date> stpostionNumberAndDate = this.preResolveDate(stPosition);
            Map<String, Date> positionNumberAndDate = this.preResolveDate(position);
            Map<String, Date> jobNumberAndDate = this.preResolveDate(jobHisSimpleInfo);
            Map<String, Date> evaluationJobNumberAndDate = this.preResolveDate(evaluataionJob);
            this.compareDate((List<EntryImportWrapper>)entryImportWrappers, stpostionNumberAndDate, positionNumberAndDate, jobNumberAndDate, evaluationJobNumberAndDate);
            return true;
        };
    }

    private void compareDate(List<EntryImportWrapper> entryImportWrappers, Map<String, Date> stpostionNumberAndDate, Map<String, Date> positionNumberAndDate, Map<String, Date> jobNumberAndDate, Map<String, Date> evaluationJobNumberAndDate) {
        entryImportWrappers.forEach(entryImportWrapper -> {
            String stpositionNumber;
            Date firstBsed;
            boolean before;
            String evaluationJobNumber;
            Date date;
            Date userInputDate;
            JSONObject jsonObject = entryImportWrapper.getJsonObject();
            try {
                userInputDate = jsonObject.getDate("plandate");
            }
            catch (Exception exception) {
                entryImportWrapper.setCompleteValidResult("compareDate", ResManager.loadKDString((String)"\u201c\u8c03\u52a8\u65e5\u671f\u201d\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportValidateServiceImpl_33", (String)"hr-hdm-business", (Object[])new Object[0]));
                LOGGER.info("compareDate dateformat exception ", (Object)exception);
                return;
            }
            String formatDate = HRDateTimeUtils.format((Date)userInputDate, (String)"yyyy-MM-dd");
            String postPattern = jsonObject.getString("postpattern");
            JSONObject evaluationJobJson = jsonObject.getJSONObject("aevaluationjob");
            if (evaluationJobJson != null && (date = (Date)evaluationJobNumberAndDate.get(evaluationJobNumber = evaluationJobJson.getString("number"))) != null && (before = userInputDate.before(date))) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate1", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u586b\u7684\u8bc4\u5b9a\u804c\u4f4d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e%s", (String)"", (String)"", (Object[])new Object[0]), formatDate));
            }
            if (ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                boolean postionBefore;
                String positionNumber = jsonObject.getJSONObject("aposition").getString("number");
                Date positionFirstBesd = (Date)positionNumberAndDate.get(positionNumber);
                if (positionFirstBesd != null && (postionBefore = userInputDate.before(positionFirstBesd))) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u586b\u7684\u5c97\u4f4d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e%s", (String)"", (String)"", (Object[])new Object[0]), formatDate));
                }
            } else if (ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportValidateServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern)) {
                boolean jobBefore;
                String jobNumber = jsonObject.getJSONObject("ajob").getString("number");
                Date jobFirstBesd = (Date)jobNumberAndDate.get(jobNumber);
                if (jobFirstBesd != null && (jobBefore = userInputDate.before(jobFirstBesd))) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u586b\u7684\u4efb\u804c\u804c\u4f4d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e%s", (String)"", (String)"", (Object[])new Object[0]), formatDate));
                }
            } else if (ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportValidateServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]).equals(postPattern) && (firstBsed = (Date)stpostionNumberAndDate.get(stpositionNumber = jsonObject.getJSONObject("astposition").getString("number"))) != null && (before = userInputDate.before(firstBsed))) {
                entryImportWrapper.getValidateContext().setCompleteValidResult("validateBusinessFieldDate", String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u586b\u7684\u6807\u51c6\u5c97\u4f4d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e%s", (String)"", (String)"", (Object[])new Object[0]), formatDate));
            }
        });
    }

    private Map<String, Date> preResolveDate(Map<String, Object> invokeResult) {
        if (invokeResult == null) {
            return new HashMap<String, Date>(16);
        }
        Object data = invokeResult.get("data");
        if (data instanceof DynamicObjectCollection) {
            DynamicObjectCollection maps = (DynamicObjectCollection)data;
            return maps.stream().filter(temp -> temp.get("firstbsed") != null && temp.get("number") != null).collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (Date)temp.get("firstbsed"), (k1, k2) -> k1));
        }
        if (data instanceof List) {
            List maps = (List)data;
            return maps.stream().filter(temp -> temp.get("firstbsed") != null && temp.get("number") != null).collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (Date)temp.get("firstbsed"), (k1, k2) -> k1));
        }
        return new HashMap<String, Date>(16);
    }

    private Predicate<EntryImportWrapper> validateCompanyWhetherEquals() {
        return temp -> {
            LOGGER.info("start validateCompanyWhetherEquals");
            JSONObject jsonObject = temp.getJsonObject();
            ValidateContext validateContext = temp.getValidateContext();
            JSONObject affactionJSON = jsonObject.getJSONObject("affaction");
            Long affctionId = affactionJSON.getLong("id");
            Long bcompany = JsonObjectUtil.jsonObject2Long.apply(jsonObject, "bcompany");
            Long acompany = JsonObjectUtil.jsonObject2Long.apply(jsonObject, "acompany");
            boolean comRemained = bcompany.equals(acompany);
            if (comRemained && (1060L == affctionId || 201060L == affctionId)) {
                validateContext.setCompleteValidResult("acompany", ResManager.loadKDString((String)"\u8de8\u516c\u53f8\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u4e0e\u8c03\u51fa\u516c\u53f8\u4e0d\u80fd\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportValidateServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]));
            } else if (!(comRemained || 1050L != affctionId && 201050L != affctionId)) {
                validateContext.setCompleteValidResult("acompany", ResManager.loadKDString((String)"\u516c\u53f8\u5185\u8c03\u52a8\u65f6\uff0c\u8c03\u5165\u516c\u53f8\u5e94\u4e0e\u8c03\u51fa\u516c\u53f8\u76f8\u540c\u3002", (String)"EntryImportValidateServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            LOGGER.info("end validateCompanyWhetherEquals");
            return true;
        };
    }

    private boolean isPresetAffaction(JSONObject jsonObject) {
        JSONObject affactionJSON = jsonObject.getJSONObject("affaction");
        Long affctionId = affactionJSON.getLong("id");
        return 1060L == affctionId || 201060L == affctionId || 1050L == affctionId || 201050L == affctionId;
    }

    private Predicate<List<EntryImportWrapper>> validateTransferDate() {
        return entryImportWrapper -> {
            entryImportWrapper.forEach(temp -> {
                String transferOutLastdate;
                Date transferDate;
                JSONObject jsonObject = temp.getJsonObject();
                Long bDepempId = JsonObjectUtil.jsonObject2Long.apply(jsonObject, "bdepemp");
                Map<String, Object> map = ITransferBillService.getInstance().getEmpOrgrel(bDepempId);
                Date minDate = (Date)map.get("startdate");
                if (minDate != null && (transferDate = (Date)TransferCommonUtil.string2Date.apply(jsonObject.getString("plandate"))).before(minDate)) {
                    String errormsg = ResManager.loadKDString((String)"\u201c\u8c03\u52a8\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u751f\u6548\u7684\u5168\u804c\u4efb\u804c\u7ecf\u5386\u7684\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"EntryImportValidateServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]);
                    temp.getValidateContext().setCompleteValidResult("validateTransferDate_1", errormsg);
                }
                if ((transferOutLastdate = jsonObject.getString("transferoutlastdate")) == null) {
                    return;
                }
                Date transferoutlastdate = (Date)TransferCommonUtil.string2Date.apply(transferOutLastdate);
                if (minDate != null && transferoutlastdate != null && transferoutlastdate.before(minDate)) {
                    String errormsg = ResManager.loadKDString((String)"\u8c03\u51fa\u90e8\u95e8\u7684\u201c\u6700\u540e\u5de5\u4f5c\u65e5\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u751f\u6548\u7684\u5168\u804c\u4efb\u804c\u7ecf\u5386\u7684\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"EntryImportValidateServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]);
                    temp.getValidateContext().setCompleteValidResult("validateTransferDate_2", errormsg);
                }
            });
            return true;
        };
    }

    private Predicate<List<EntryImportWrapper>> validateRepeat() {
        return entryImportWrapper -> {
            Map<Object, List<EntryImportWrapper>> personnumber = entryImportWrapper.stream().filter(temp -> temp.getJsonObject().get((Object)"personnumber") != null).collect(Collectors.groupingBy(temp -> temp.getJsonObject().get((Object)"personnumber")));
            personnumber.forEach((key, value) -> {
                if (value.size() > 1) {
                    for (EntryImportWrapper importWrapper : value) {
                        importWrapper.getValidateContext().setCompleteValidResult("repeat", String.format(ResManager.loadKDString((String)"\u5de5\u53f7\u4e3a\u201c%s\u201d\u7684\u5458\u5de5\u5b58\u5728\u591a\u6761\u8c03\u52a8\u6570\u636e\u3002", (String)"EntryImportValidateServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]), importWrapper.getJsonObject().getString("personnumber")));
                    }
                }
            });
            return true;
        };
    }

    private Predicate<List<EntryImportWrapper>> validateLicence() {
        return entryImportWrapper -> {
            try {
                Map<Long, EntryImportWrapper> personIdMap = this.toEntryImportWrapperMap((List<EntryImportWrapper>)entryImportWrapper, "person");
                Map license = HRCertValidateServiceHelper.checkPersonLicenses(new ArrayList<Long>(personIdMap.keySet()));
                if (license == null || license.isEmpty()) {
                    String message = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"EntryImportValidateServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]);
                    personIdMap.forEach((personId, entryImportData) -> entryImportData.getValidateContext().setCompleteValidResult("validateLicence", message));
                } else {
                    personIdMap.forEach((personId, entryImportData) -> {
                        Map personInfo = (Map)license.get(personId);
                        if (personInfo != null && !personInfo.isEmpty() && !((Boolean)personInfo.get("status")).booleanValue()) {
                            String name = (String)personInfo.get("name");
                            String number = (String)personInfo.get("number");
                            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"EntryImportValidateServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]), name, number);
                            entryImportData.getValidateContext().setCompleteValidResult("validateLicence", message);
                        }
                    });
                }
            }
            catch (Exception exception) {
                String message = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"EntryImportValidateServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]);
                entryImportWrapper.forEach(temp -> temp.getValidateContext().setCompleteValidResult("validateLicence", message));
                LOGGER.error((Throwable)exception);
            }
            return true;
        };
    }

    private Predicate<List<EntryImportWrapper>> checkRepeatInDb() {
        return entryImportWrapper -> {
            LOGGER.info("start EntryImportValidateServiceImpl checkRepeatInDb");
            try {
                Map<Long, EntryImportWrapper> personIdMap = this.toEntryImportWrapperMap((List<EntryImportWrapper>)entryImportWrapper, "bdepemp");
                DynamicObjectCollection submitTransferBillById = TransferBillRepository.getInstance().getSubmitTransferBillById(new ArrayList<Long>(personIdMap.keySet()));
                submitTransferBillById.forEach(temp -> {
                    EntryImportWrapper dbExist = (EntryImportWrapper)personIdMap.get(temp.getLong("bdepemp"));
                    if (dbExist != null) {
                        if (TransferTypeEnum.BATCH.getType().equals(temp.getLong("transfertype"))) {
                            dbExist.getValidateContext().setCompleteValidResult("checkRepeatInDb", String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u6279\u91cf\u8c03\u52a8\u5355\u636e\u7f16\u53f7\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"EntryImportValidateServiceImpl_27", (String)"hr-hdm-business", (Object[])new Object[0]), dbExist.getJsonObject().getString("ename"), temp.getString("mid.billno")));
                        } else {
                            dbExist.getValidateContext().setCompleteValidResult("checkRepeatInDb", String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u8c03\u52a8\u5355\u636e\u7f16\u7801\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"EntryImportValidateServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]), dbExist.getJsonObject().getString("ename"), temp.getString("billno")));
                        }
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.info("error EntryImportValidateServiceImpl checkRepeatInDb", (Object)exception);
            }
            finally {
                LOGGER.info("end EntryImportValidateServiceImpl checkRepeatInDb");
            }
            return true;
        };
    }

    private Predicate<List<EntryImportWrapper>> checkVirtualOrg() {
        return entryImportWrapper -> {
            LOGGER.info("start EntryImportValidateServiceImpl checkVirtualOrg");
            try {
                Set aOrgIds = entryImportWrapper.stream().map(temp -> JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "aorg")).collect(Collectors.toSet());
                Set aCompanyIds = entryImportWrapper.stream().map(temp -> JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "acompany")).collect(Collectors.toSet());
                HashSet orgIds = new HashSet(aOrgIds);
                orgIds.addAll(aCompanyIds);
                AdminOrgExternalService adminOrgService = AdminOrgExternalService.getInstance();
                Map<String, Map<String, Object>> adminOrgInfoMap = adminOrgService.invokeAdminOrgInfoQuery(new ArrayList<Long>(orgIds));
                if (CollectionUtils.isEmpty(adminOrgInfoMap)) {
                    boolean bl = true;
                    return bl;
                }
                entryImportWrapper.forEach(temp -> {
                    Long aOrgId = JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "aorg");
                    Map aOrgInfo = (Map)adminOrgInfoMap.get("" + aOrgId);
                    if (aOrgInfo != null && HRStringUtils.equals((String)(aOrgInfo.get(IS_VIRTUAL_ORG) + ""), (String)"true")) {
                        temp.setCompleteValidResult("checkOrgIsVirtualOrg", String.format(ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8\u201c%1$s\u201d\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportValidateServiceImpl_34", (String)"hr-hdm-business", (Object[])new Object[0]), aOrgInfo.get("name")));
                    }
                    Long aCompanyId = JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "acompany");
                    Map aCompanyInfo = (Map)adminOrgInfoMap.get("" + aCompanyId);
                    if (aCompanyInfo != null && HRStringUtils.equals((String)(aCompanyInfo.get(IS_VIRTUAL_ORG) + ""), (String)"true")) {
                        temp.setCompleteValidResult("checkCompanyIsVirtualOrg", String.format(ResManager.loadKDString((String)"\u8c03\u5165\u516c\u53f8\u201c%1$s\u201d\u4e3a\u865a\u62df\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EntryImportValidateServiceImpl_35", (String)"hr-hdm-business", (Object[])new Object[0]), aCompanyInfo.get("name")));
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.info("error EntryImportValidateServiceImpl checkVirtualOrg", (Object)exception);
            }
            finally {
                LOGGER.info("end EntryImportValidateServiceImpl checkVirtualOrg");
            }
            return true;
        };
    }

    private Map<Long, EntryImportWrapper> toEntryImportWrapperMap(List<EntryImportWrapper> entryImportWrapper, String fieldKey) {
        return entryImportWrapper.stream().collect(Collectors.toMap(temp -> JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), fieldKey), temp -> temp, (k1, k2) -> k1));
    }

    private Predicate<List<EntryImportWrapper>> excuteBatchPersonChangeCrossValidate() {
        return entryImportWrappers -> {
            LOGGER.info("start EntryImportValidateServiceImpl excuteBatchPersonChangeCrossValidate");
            try {
                HashMap map = new HashMap(entryImportWrappers.size() << 1);
                ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>();
                entryImportWrappers.forEach(temp -> {
                    Long actionId = JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "affaction");
                    if (actionId != null && actionId != 0L) {
                        Map<String, Object> paramMap = this.buildPersonChangeOverlapCheckParam(temp.getJsonObject());
                        params.add(paramMap);
                        map.put(JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "bdepemp"), temp);
                    }
                });
                if (params.size() < 1) {
                    boolean bl = true;
                    return bl;
                }
                Map<String, Object> perChgResult = PersonalChangeExternalService.getInstance().invokerBatchPerChgCrossValidate(params);
                if (!((Boolean)perChgResult.get("success")).booleanValue()) {
                    entryImportWrappers.forEach(temp -> {
                        ValidateContext context = temp.getValidateContext();
                        if (!context.getValidateResult().containsKey("excuteBatchPersonChangeCrossValidate")) {
                            context.setResult("crossinterface", "Invoke crossinterface Exception.", "9");
                        }
                    });
                    LOGGER.error("excuteBatchPersonChangeCrossValidate result is error , the result is :[{}]", perChgResult);
                    boolean bl = true;
                    return bl;
                }
                Map crossValidateMap = (Map)perChgResult.get("data");
                crossValidateMap.forEach((depempId, result) -> {
                    EntryImportWrapper entryImportWrapper1 = (EntryImportWrapper)map.get(depempId);
                    for (Map temp : result) {
                        String crossValidRes = (String)temp.get("crossValidRes");
                        if (crossValidRes.equals("0")) continue;
                        String billNo = (String)temp.get("billNo");
                        String ename = entryImportWrapper1.getJsonObject().getString("ename");
                        long quitEffectTime = (Long)temp.get("effectTime");
                        Date quitEffectDate = new Date(quitEffectTime);
                        String actionName = (String)temp.get("actionName");
                        String quitTime = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
                        entryImportWrapper1.getValidateContext().setCompleteValidResult("excuteBatchPersonChangeCrossValidate", MessageFormat.format(ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u65e5\u671f\u3002", (String)"EntryImportValidateServiceImpl_31", (String)"hr-hdm-business", (Object[])new Object[0]), ename, actionName, quitTime, billNo));
                        break;
                    }
                });
            }
            catch (Exception exception) {
                LOGGER.error("error EntryImportValidateServiceImpl excuteBatchPersonChangeCrossValidate", (Throwable)exception);
            }
            finally {
                LOGGER.info("end EntryImportValidateServiceImpl excuteBatchPersonChangeCrossValidate");
            }
            return true;
        };
    }

    private Map<String, Object> buildPersonChangeOverlapCheckParam(JSONObject transferBill) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("billNo", transferBill.getString("billno"));
        params.put("actionId", String.valueOf(JsonObjectUtil.jsonObject2Long.apply(transferBill, "affaction")));
        params.put("effectTime", transferBill.getDate("realitydate").getTime());
        params.put("personId", String.valueOf(JsonObjectUtil.jsonObject2Long.apply(transferBill, "person")));
        params.put("employeeId", String.valueOf(JsonObjectUtil.jsonObject2Long.apply(transferBill, "bemployee")));
        params.put("managingScopeId", String.valueOf(JsonObjectUtil.jsonObject2Long.apply(transferBill, "bcmp")));
        params.put("depEmpId", String.valueOf(JsonObjectUtil.jsonObject2Long.apply(transferBill, "bdepemp")));
        return params;
    }

    private Predicate<JSONObject> fieldRemained(String bFieldName, String aFieldName, String fieldType) {
        return jsonObject -> {
            boolean result = true;
            try {
                if (fieldType.equals("0")) {
                    Long bField = JsonObjectUtil.jsonObject2Long.apply((JSONObject)jsonObject, bFieldName);
                    if (bField == null) {
                        result = false;
                    }
                    Long aField = JsonObjectUtil.jsonObject2Long.apply((JSONObject)jsonObject, aFieldName);
                    result = bField.equals(aField);
                    LOGGER.info("fieldRemained  bFieldName:{} , aFieldName:{} , bField:{} , aField:{} , fieldType:{}", new Object[]{bFieldName, aFieldName, bField, aField, fieldType});
                } else if (fieldType.equals("1")) {
                    String bField = JsonObjectUtil.jsonObject2String.apply((JSONObject)jsonObject, bFieldName);
                    if (bField == null) {
                        result = false;
                    }
                    String aField = JsonObjectUtil.jsonObject2String.apply((JSONObject)jsonObject, aFieldName);
                    result = bField.equals(aField);
                    LOGGER.info("fieldRemained bFieldName:{} , aFieldName:{} , bField:{} , aField:{} , fieldType:{}", new Object[]{bFieldName, aFieldName, bField, aField, fieldType});
                }
            }
            catch (Exception exception) {
                LOGGER.error("jsonObject : {} ,fieldRemained  bFieldName:{} , aFieldName:{} ", new Object[]{jsonObject.toString(), bFieldName, aFieldName});
            }
            return result;
        };
    }

    static enum CrossActionEnum implements Supplier<CrossActionEnum>
    {
        OTHER("9999"),
        QUIT("1020");

        private String actionId;

        private CrossActionEnum(String actionId) {
            this.actionId = actionId;
        }

        public String getActionId() {
            return this.actionId;
        }

        static CrossActionEnum getAction(String action) {
            CrossActionEnum[] enumConstants = (CrossActionEnum[])CrossActionEnum.class.getEnumConstants();
            return Arrays.asList(enumConstants).stream().filter(actionEnum -> HRStringUtils.equals((String)action, (String)actionEnum.getActionId())).findFirst().orElseGet(OTHER);
        }

        @Override
        public CrossActionEnum get() {
            return this;
        }
    }
}

