/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.application.transfer.service.ITransferBillApplicationService;
import kd.hr.hdm.business.common.batch.EntryImportDataBuilder;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.OrgImportHandler;
import kd.hr.hdm.business.domain.transfer.repository.BatchTransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hpfs.common.utils.ObjectUtils;

public class TransferEntryImportDataBuilder
extends EntryImportDataBuilder {
    private static final Log LOGGER = LogFactory.getLog(TransferEntryImportDataBuilder.class);
    private TransferEntryImportNumberToIdBO numberToIdBO;
    private Map<Long, EntryImportWrapper> employeeIds = new HashMap<Long, EntryImportWrapper>(500);
    private static final Map<String, String> ermanfileMap = new HashMap<String, String>(64);

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> baseDataNumber2Id() {
        return importSource -> {
            this.numberToIdBO = new TransferEntryImportNumberToIdBO();
            this.numberToIdBO.number2Id().apply((CopyOnWriteArrayList<EntryImportWrapper>)importSource);
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getPeopleRecordByNumber() {
        return importSource -> {
            List<String> personNumbers = importSource.stream().map(temp -> temp.getJsonObject().getString("personnumber")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = PersonExternalService.getInstance().listPrimaryErmanFilesByEmpnumber(personNumbers);
            List<Long> ermanFileIds = Arrays.asList(dynamicObjects).stream().map(temp -> temp.getLong("id")).collect(Collectors.toList());
            List<Map<String, Object>> ermanfileList = PersonExternalService.getInstance().invokeGetCardFields(ermanFileIds);
            Map<String, EntryImportWrapper> personnumber = importSource.stream().collect(Collectors.toMap(temp -> (String)temp.getJsonObject().get((Object)"personnumber"), temp -> temp));
            if (null == ermanfileList || ermanfileList.isEmpty()) {
                personnumber.forEach((personNumber, entryImportWrapper) -> entryImportWrapper.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4eba\u5458\uff0c\u8be5\u4eba\u5458\u53ef\u80fd\u5df2\u79bb\u804c\u6216\u8f93\u5165\u7684\u5de5\u53f7\u6709\u8bef\u3002", (String)"EntryImportDataBuilder_2", (String)"hr-hdm-business", (Object[])new Object[0])));
                return importSource;
            }
            Map<String, Map> resultMap = ermanfileList.stream().collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> temp));
            personnumber.forEach((personNumber, entryImportWrapper) -> {
                Map ermanfile = (Map)resultMap.get(personNumber);
                if (null == ermanfile) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("getPeopleRecordByNumber", ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u4eba\u5458\uff0c\u8be5\u4eba\u5458\u53ef\u80fd\u5df2\u79bb\u804c\u6216\u8f93\u5165\u7684\u5de5\u53f7\u6709\u8bef\u3002", (String)"EntryImportDataBuilder_2", (String)"hr-hdm-business", (Object[])new Object[0]));
                    return;
                }
                this.employeeIds.put((Long)ermanfile.get("employee_id"), (EntryImportWrapper)entryImportWrapper);
                JSONObject source = entryImportWrapper.getJsonObject();
                String importName = (String)source.get((Object)"ename");
                String ermanfileName = (String)ermanfile.get("name");
                if (importName != null && !importName.equals(ermanfileName)) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("importname", String.format(ResManager.loadKDString((String)"\u59d3\u540d\u4e0e\u5de5\u53f7\u4e0d\u5339\u914d\u3002", (String)"EntryImportDataBuilder_3", (String)"hr-hdm-business", (Object[])new Object[0]), personNumber));
                } else {
                    entryImportWrapper.getJsonObject().put("ename", (Object)ermanfileName);
                }
                ermanfileMap.forEach((transferMetaField, ermanfileField) -> source.put(transferMetaField, (Object)this.genJSONObject(ermanfile, (String)ermanfileField)));
                source.put("bpostpattern", ermanfile.get("apositiontype"));
                JSONObject jsonObject1 = new JSONObject();
                jsonObject1.put("importprop", (Object)"id");
                jsonObject1.put("id", ermanfile.get("depemp_id"));
                source.put("personfield", (Object)jsonObject1);
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setDefaultFieldValue() {
        return importSource -> {
            importSource.forEach(temp -> {
                JSONObject importdata = temp.getJsonObject();
                importdata.put("entryauditstatus", (Object)"A");
                importdata.put("entrybillstatus", (Object)"A");
                importdata.put("originator", (Object)"0");
                importdata.put("transferstage", (Object)"0");
                importdata.put("transfertype", (Object)this.genJSONObject(1563784896172811264L));
                importdata.put("aempgroup", (Object)this.genJSONObject(1010L));
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAffaction() {
        return importSource -> {
            this.setAffactionId((CopyOnWriteArrayList<EntryImportWrapper>)importSource, "hdm_transfer_hpfs_new", ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"EntryImportValidateServiceImpl_32", (String)"hr-hdm-business", (Object[])new Object[0]));
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getBelongCompany() {
        return importSource -> {
            OrgImportHandler orgImportHandler = (OrgImportHandler)this.numberToIdBO.getExecuteHandler().get("OrgImportHandler");
            List<Long> orgIds = orgImportHandler.getOrgIds();
            Map<String, Map<String, Object>> adminOrgInfoQuery = AdminOrgExternalService.getInstance().invokeAdminOrgInfoQuery(orgIds);
            for (EntryImportWrapper temp : importSource) {
                try {
                    JSONObject jsonObject = temp.getJsonObject();
                    Map<String, Object> adminOrg = adminOrgInfoQuery.get(JsonObjectUtil.jsonObject2Long.apply(temp.getJsonObject(), "aorg").toString());
                    Long belongCompany = (Long)adminOrg.get("belongcompany");
                    jsonObject.put("acompany", (Object)JsonObjectUtil.genJSONObject.apply(belongCompany));
                    jsonObject.put("arealitycompany", (Object)JsonObjectUtil.genJSONObject.apply(belongCompany));
                }
                catch (Exception exception) {
                    temp.getValidateContext().setCompleteValidResult("getBelongCompany", ResManager.loadKDString((String)"\u90e8\u95e8\u6ca1\u6709\u5339\u914d\u5bf9\u5e94\u7684\u516c\u53f8\u3002", (String)"EntryImportDataBuilder_23", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            }
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> getOrgChargers() {
        return importSource -> {
            OrgImportHandler orgImportHandler = (OrgImportHandler)this.numberToIdBO.getExecuteHandler().get("OrgImportHandler");
            List<Long> orgIds = orgImportHandler.getOrgIds();
            List<Map<String, Object>> maps = PersonExternalService.getInstance().invokeGetMainChargeInfoByOrg(orgIds);
            Map<Long, List> orgChargerIds = maps.stream().collect(Collectors.toMap(temp -> (Long)temp.get("adminorg"), temp -> {
                ArrayList<Long> list = new ArrayList<Long>();
                list.add((Long)temp.get("person"));
                return list;
            }, (oldValue, newValue) -> {
                oldValue.addAll(newValue);
                return oldValue;
            }));
            importSource.forEach(temp -> {
                JSONObject aorgJsonObject = temp.getJsonObject().getJSONObject("aorg");
                Long orgid = aorgJsonObject.getLong("id");
                List orgPersonChargerIds = (List)orgChargerIds.get(orgid);
                if (orgPersonChargerIds == null) {
                    return;
                }
                JSONObject sourceObject = temp.getJsonObject();
                JSONArray jsonArray = new JSONArray();
                orgPersonChargerIds.forEach(temp1 -> {
                    JSONObject jsonObject = this.genJSONObject((Long)temp1);
                    jsonArray.add((Object)jsonObject);
                });
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setPositionJob() {
        return importSource -> importSource;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setStpositionJob() {
        return importSource -> importSource;
    }

    @Override
    public Predicate<List<EntryImportWrapper>> validateStdPosition() {
        return entryImportWrapperList -> true;
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setBJobInfo() {
        return importSource -> {
            String selectProps = "hrbu,joblevel,jobgrade,job,jobscm,jobclass,jobfamily,jobseq,joblevel.joblevelscm,jobgrade.jobgradescm,employee";
            ArrayList<Long> employeeIdList = new ArrayList<Long>(this.employeeIds.keySet());
            List<Map<String, Object>> jobGradeList = PersonExternalService.getInstance().listBatchPropEmployeeAttachs(employeeIdList, selectProps, "hrpi_empjobrel");
            if (jobGradeList == null) {
                importSource.forEach(temp -> temp.getValidateContext().setCompleteValidResult("setBJobInfo", "listBatchPropEmployeeAttachs error"));
                return importSource;
            }
            if (jobGradeList.isEmpty() || jobGradeList.size() == 0) {
                return importSource;
            }
            List<Long> jobid = jobGradeList.stream().map(temp -> (Long)((Object)temp.getOrDefault("job", 0))).collect(Collectors.toList());
            Map<Long, String> jobClassInfoMap = JobExternalService.getInstance().invokeGetJobClassLongNameByJobAndBsed(jobid, new Date());
            jobGradeList.forEach(jobInfo -> {
                Long bjoborg = (Long)jobInfo.get("hrbu");
                Long employee = (Long)jobInfo.get("employee");
                EntryImportWrapper entryImportWrapper = this.employeeIds.get(employee);
                if (entryImportWrapper == null) {
                    return;
                }
                LOGGER.info("Transferbill jobhrbu is {}.", (Object)bjoborg);
                if (bjoborg == 0L) {
                    entryImportWrapper.getValidateContext().setCompleteValidResult("setBJobInfo", "listBatchPropEmployeeAttachs error");
                }
                JSONObject importInfo = entryImportWrapper.getJsonObject();
                importInfo.put("bjoborg", (Object)this.genJSONObject((Long)jobInfo.get("hrbu")));
                importInfo.put("bevaluationjob", (Object)this.genJSONObject((Long)jobInfo.get("job")));
                importInfo.put("bjobgradescm", (Object)this.genJSONObject((Long)jobInfo.get("jobgrade.jobgradescm")));
                importInfo.put("bjobgrade", (Object)this.genJSONObject((Long)jobInfo.get("jobgrade")));
                importInfo.put("bjoblevelscm", (Object)this.genJSONObject((Long)jobInfo.get("joblevel.joblevelscm")));
                importInfo.put("bjoblevel", (Object)this.genJSONObject((Long)jobInfo.get("joblevel")));
                importInfo.put("ajoborg", (Object)this.genJSONObject((Long)jobInfo.get("hrbu")));
                if (importInfo.get((Object)"aevaluationjob") == null && importInfo.get((Object)"ajoblevel") == null && importInfo.get((Object)"ajobgrade") == null) {
                    importInfo.put("aevaluationjob", (Object)this.genJSONObject((Long)jobInfo.get("job")));
                    importInfo.put("ajobgradescm", (Object)this.genJSONObject((Long)jobInfo.get("jobgrade.jobgradescm")));
                    importInfo.put("ajobgrade", (Object)this.genJSONObject((Long)jobInfo.get("jobgrade")));
                    importInfo.put("ajoblevelscm", (Object)this.genJSONObject((Long)jobInfo.get("joblevel.joblevelscm")));
                    importInfo.put("ajoblevel", (Object)this.genJSONObject((Long)jobInfo.get("joblevel")));
                    importInfo.put("ajobscm", (Object)this.genJSONObject((Long)jobInfo.get("jobscm")));
                    importInfo.put("ajobfamily", (Object)this.genJSONObject((Long)jobInfo.get("jobfamily")));
                    importInfo.put("ajobclass", (Object)this.genJSONObject((Long)jobInfo.get("jobclass")));
                    importInfo.put("ajobseq", (Object)this.genJSONObject((Long)jobInfo.get("jobseq")));
                    String jobAllClass = jobClassInfoMap.getOrDefault((Long)jobInfo.get("job"), "");
                    importInfo.put("bjobclasstext", (Object)jobAllClass);
                    importInfo.put("ajobclasstext", (Object)jobAllClass);
                }
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setRealityDate() {
        return importSource -> {
            importSource.forEach(temp -> {
                JSONObject jsonObject = temp.getJsonObject();
                Date date = jsonObject.getDate("plandate");
                jsonObject.put("transferdate", (Object)date);
                jsonObject.put("realitydate", (Object)date);
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> genBillNo() {
        return importSource -> {
            DynamicObject dynamicObject = BatchTransferBillRepository.getServiceHelper().generateEmptyDynamicObject();
            importSource.forEach(temp -> {
                List hdm_transferbatchentry = CodeRuleServiceHelper.getNumbers((String)"hdm_transferbatchentry", Collections.singletonList(dynamicObject));
                temp.getJsonObject().put("ebillno", hdm_transferbatchentry.get(0));
            });
            return importSource;
        };
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> setAppremoveInfo() {
        return importSource -> {
            importSource.forEach(temp -> {
                DynamicObject appointRemoveRelObj;
                Long employeeId;
                String appDispatchNum = temp.getJsonObject().getString("appdispatchnum");
                JSONObject employee = temp.getJsonObject().getJSONObject("bemployee");
                Long l = employeeId = employee == null ? null : employee.getLong("id");
                if (!ObjectUtils.isEmpty((Object)employeeId) && !HRObjectUtils.isEmpty((Object)(appointRemoveRelObj = ITransferBillApplicationService.getInstance().getAppointRemoveRelObj(appDispatchNum, employeeId)))) {
                    temp.getJsonObject().put("appremoverel", (Object)JsonObjectUtil.genJSONObject.apply(appointRemoveRelObj.getLong("id")));
                }
            });
            return importSource;
        };
    }

    @Override
    public Map<String, String> getErmanfileMappingMap() {
        return ermanfileMap;
    }

    static {
        ermanfileMap.put("person", "person_id");
        ermanfileMap.put("bemployee", "employee_id");
        ermanfileMap.put("bmanagescope", "managingscope_id");
        ermanfileMap.put("bcmp", "cmpemp_id");
        ermanfileMap.put("bdepemp", "depemp_id");
        ermanfileMap.put("personfield", "depemp_id");
        ermanfileMap.put("ermanfile", "id");
        ermanfileMap.put("bhrbu", "org_id");
        ermanfileMap.put("bempgroup", "empgroup_id");
        ermanfileMap.put("baffiliateorg", "affiliateadminorg_id");
        ermanfileMap.put("bcountry", "location_country_id");
        ermanfileMap.put("postype", "postype_id");
        ermanfileMap.put("posstatus", "posstatus_id");
        ermanfileMap.put("bcompany", "company_id");
        ermanfileMap.put("borg", "adminorg_id");
        ermanfileMap.put("bposition", "position_id");
        ermanfileMap.put("bstposition", "stdposition_id");
        ermanfileMap.put("bbaselocation", "location_id");
        ermanfileMap.put("laborreltype", "laborreltype_id");
        ermanfileMap.put("laborrelstatus", "laborrelstatus_id");
        ermanfileMap.put("bjob", "job_id");
    }
}

