/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.EvaluationJobImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.PositionImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.StpositionImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class JobGradeImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(JobGradeImportHandler.class);
    private final List<Map<String, Object>> queryJobGradeInfoParam = new ArrayList<Map<String, Object>>();
    private final Map<String, Long> jobGradeScmInfoMap = new HashMap<String, Long>();
    private static final String ERROR_SCENE = "jobgradenumber2Id";

    public JobGradeImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        JSONObject jobGrade = jsonObject.getJSONObject("ajobgrade");
        if (jobGrade == null) {
            return;
        }
        long jobGradeScmId = this.getJsonBaseDataDyId(jsonObject, "ajobgradescm");
        if (jobGradeScmId == 0L) {
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u201c\u804c\u7b49\u201d\u548c\u201c\u804c\u7b49\u65b9\u6848\u201d\u9700\u540c\u65f6\u586b\u5199\u3002", (String)"JobGradeImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            return;
        }
        String jobGradeName = jobGrade.getString("name");
        HashMap<String, Object> jobGradeQueryParam = new HashMap<String, Object>(2);
        jobGradeQueryParam.put("scmId", jobGradeScmId);
        jobGradeQueryParam.put("jobgradeName", jobGradeName);
        this.queryJobGradeInfoParam.add(jobGradeQueryParam);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                if (this.queryJobGradeInfoParam.isEmpty()) {
                    return importSource;
                }
                LOGGER.info("###EntryImportNumberToIdBO.genJobGradeBoid, invokeGetJobLevelRangeByScmId params is :{}", (Object)JSONObject.toJSONString(this.queryJobGradeInfoParam));
                Map<String, Object> result = JobExternalService.getInstance().invokeGetJobGradeRangeByScmId(this.queryJobGradeInfoParam);
                List data = (List)result.get("data");
                Map<String, Long> scmInfos = data.stream().collect(Collectors.toMap(jobGradeInfo -> {
                    try {
                        Long jobGradeId = (Long)jobGradeInfo.get("scmId");
                        DynamicObject jobGrade = (DynamicObject)jobGradeInfo.get("jobgrade");
                        OrmLocaleValue name = (OrmLocaleValue)jobGrade.get("name");
                        return jobGradeId + name.getLocaleValue();
                    }
                    catch (Exception exception) {
                        if (jobGradeInfo != null) {
                            LOGGER.error("JobLevelImportHandler listAllIdByNumber foreach error map info :{}", (Object)jobGradeInfo.toString());
                        } else {
                            LOGGER.error("JobLevelImportHandler listAllIdByNumber foreach error map is empty");
                        }
                        return "";
                    }
                }, temp -> {
                    DynamicObject jobGrade = (DynamicObject)temp.get("jobgrade");
                    return HRObjectUtils.isEmpty((Object)jobGrade) ? 0L : jobGrade.getLong("id");
                }, (k1, k2) -> k1));
                this.jobGradeScmInfoMap.putAll(scmInfos);
            }
            catch (Exception exception) {
                LOGGER.error("JobLevelImportHandler listAllIdByNumber error ", (Throwable)exception);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        LOGGER.info("start genJobGradeName2Id");
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        JSONObject aJobGrade = jsonObject.getJSONObject("ajobgrade");
        long aJobGradeScmId = this.getJsonBaseDataDyId(jsonObject, "ajobgradescm");
        if (aJobGrade == null || aJobGradeScmId == 0L) {
            return;
        }
        String aJobGradeName = aJobGrade.getString("name");
        Long jobGradeId = this.jobGradeScmInfoMap.get(aJobGradeScmId + aJobGradeName);
        if (jobGradeId == null || jobGradeId == 0L) {
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u4e0e\u804c\u7b49\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobGradeImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            return;
        }
        jsonObject.put("ajobgrade", (Object)JsonObjectUtil.genJSONObject.apply(jobGradeId));
        boolean evaluationJobIsCtr = entryImportWrapper.isEvaluationJobIsCtr();
        long aEvaluationJobId = this.getJsonBaseDataDyId(jsonObject, "aevaluationjob");
        if (aEvaluationJobId != 0L) {
            EvaluationJobImportHandler evaluationJobImportHandler = (EvaluationJobImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("EvaluationJobImportHandler");
            Map<Long, List<Long>> jobIdAndJobGradeRangeMap = evaluationJobImportHandler.getJobIdAndJobGradeRangeMap();
            List<Long> aEvaluationJobGradeRange = jobIdAndJobGradeRangeMap.get(aEvaluationJobId);
            if (CollectionUtils.isNotEmpty(aEvaluationJobGradeRange) && !aEvaluationJobGradeRange.contains(jobGradeId)) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u4e0e\u804c\u7b49\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobGradeImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        } else if (evaluationJobIsCtr) {
            long aStdPositionId;
            StpositionImportHandler stdPositionImportHandler;
            Map<Long, List<Long>> noRelJobGradeRangMap;
            List<Long> aStdPositionJobGradeRange;
            String postPattern = jsonObject.getString("postpattern");
            if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_0", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                long aPositionId;
                PositionImportHandler positionImportHandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
                Map<Long, List<Long>> noRelJobGradeRangMap2 = positionImportHandler.getNoRelJobGradeRangMap();
                List<Long> aPositionJobGradeRange = noRelJobGradeRangMap2.get(aPositionId = this.getJsonBaseDataDyId(jsonObject, "aposition"));
                if (CollectionUtils.isNotEmpty(aPositionJobGradeRange) && !aPositionJobGradeRange.contains(jobGradeId)) {
                    entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u4e0e\u804c\u7b49\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobGradeImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            } else if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0])) && CollectionUtils.isNotEmpty(aStdPositionJobGradeRange = (noRelJobGradeRangMap = (stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler")).getNoRelJobGradeRangMap()).get(aStdPositionId = this.getJsonBaseDataDyId(jsonObject, "astposition"))) && !aStdPositionJobGradeRange.contains(jobGradeId)) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u4e0e\u804c\u7b49\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobGradeImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        }
        LOGGER.info("end genJobGradeName2Id");
    }

    public List<Map<String, Object>> getQueryJobGradeInfoParam() {
        return this.queryJobGradeInfoParam;
    }

    public Map<String, Long> getJobGradeScmInfoMap() {
        return this.jobGradeScmInfoMap;
    }
}

