/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.EvaluationJobImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.PositionImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.StpositionImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class JobGradeScmImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(JobGradeScmImportHandler.class);
    private final Set<String> jobGradeScmNumberSet = new HashSet<String>(16);
    private final Map<String, Long> jobGradeNumberAndIdMap = new HashMap<String, Long>(16);
    private final Map<Long, Long> jobGradeScmIdAndCrateOrgId = new HashMap<Long, Long>(0);
    private static final String ERROR_SCENE = "jobgradescmNumber2Id";

    public JobGradeScmImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "ajobgradescm");
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        this.jobGradeScmNumberSet.add(number);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return entryImportWrappers -> {
            PositionImportHandler positionimporthandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
            StpositionImportHandler stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler");
            Set<String> positionNoRelJobGradeScmNumberSet = positionimporthandler.getNoRelJobGradeScmNumberSet();
            Set<String> StdPositionNoRelJobGradeScmNumberSet = stdPositionImportHandler.getNoRelJobGradeScmNumberSet();
            HashSet<String> queryJobGradeScmNumberSet = new HashSet<String>(16);
            queryJobGradeScmNumberSet.addAll(positionNoRelJobGradeScmNumberSet);
            queryJobGradeScmNumberSet.addAll(StdPositionNoRelJobGradeScmNumberSet);
            queryJobGradeScmNumberSet.addAll(this.jobGradeScmNumberSet);
            if (!queryJobGradeScmNumberSet.isEmpty()) {
                Map<String, Object> jobGradeScmInfo = JobExternalService.getInstance().invokeGetJobGradeScmIdByNumberMap(queryJobGradeScmNumberSet);
                if (jobGradeScmInfo == null || !jobGradeScmInfo.get("code").equals(200)) {
                    entryImportWrappers.forEach(temp -> {
                        if (temp.getJsonObject().getJSONObject("ajoblevelscm") != null) {
                            temp.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"JobGradeScmImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                        }
                    });
                } else {
                    List data = (List)jobGradeScmInfo.get("data");
                    for (Map temp2 : data) {
                        String jobGradeNumber = (String)temp2.get("number");
                        Long jobGradeScmId = (Long)temp2.get("boid");
                        Long createOrg = (Long)temp2.get("createorg");
                        this.jobGradeScmIdAndCrateOrgId.put(jobGradeScmId, createOrg);
                        this.jobGradeNumberAndIdMap.put(jobGradeNumber, jobGradeScmId);
                    }
                }
            }
            return entryImportWrappers;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String postPattern = jsonObject.getString("postpattern");
        long evaluationJobId = this.getJsonBaseDataDyId(jsonObject, "aevaluationjob");
        String aJobGradeScmNumber = this.getJsonBaseDataDyNumber(jsonObject, "ajobgradescm");
        boolean evaluationJobIsCtr = entryImportWrapper.isEvaluationJobIsCtr();
        EvaluationJobImportHandler evaluationJobImportHandler = (EvaluationJobImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("EvaluationJobImportHandler");
        Map<Long, Long> jobIdAndCrateOrgIdMap = evaluationJobImportHandler.getJobIdAndCrateOrgIdMap();
        Map<Long, Long> jobIdAndJobGradeScmIdMap = evaluationJobImportHandler.getJobIdAndJobGradeScmIdMap();
        long relativeJobLevelScmId = this.getRelativeJobGradeScmId(jsonObject, jobIdAndJobGradeScmIdMap, postPattern, evaluationJobId, evaluationJobIsCtr);
        if (HRStringUtils.isNotEmpty((String)aJobGradeScmNumber)) {
            long inputJobLevelScmId = Optional.ofNullable(this.jobGradeNumberAndIdMap.get(aJobGradeScmNumber)).orElse(0L);
            if (inputJobLevelScmId == 0L) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7b49\u65b9\u6848\u7f16\u7801\u65e0\u5339\u914d\u7684\u57fa\u7840\u8d44\u6599\u3002", (String)"JobGradeScmImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            if (relativeJobLevelScmId != inputJobLevelScmId && (relativeJobLevelScmId != 0L || evaluationJobId != 0L)) {
                String validResult = evaluationJobIsCtr ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u8bc4\u5b9a\u4fe1\u606f\u53d7\u4efb\u804c\u4fe1\u606f\u63a7\u5236\uff0c\u67e5\u8be2\u51fa\u201c%1$S\u201d\u5173\u8054\u7684\u804c\u7b49\u65b9\u6848\u4e0e\u586b\u5199\u7684\u4e0d\u4e00\u81f4\u3002", (String)"JobGradeScmImportHandler_2", (String)"hr-hdm-business", (Object[])new Object[0]), postPattern) : ResManager.loadKDString((String)"\u8c03\u52a8\u540e\u804c\u7b49\u65b9\u6848\u4e0e\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d\u4e0d\u5339\u914d\u3002", (String)"JobGradeScmImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]);
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, validResult);
                jsonObject.put("ajobgradescm", (Object)JsonObjectUtil.genJSONObject.apply(relativeJobLevelScmId));
                if (relativeJobLevelScmId == 0L && evaluationJobIsCtr) {
                    jsonObject.put("ajobgrade", null);
                }
                return;
            }
            jsonObject.put("ajobgradescm", (Object)JsonObjectUtil.genJSONObject.apply(inputJobLevelScmId));
        } else if (relativeJobLevelScmId != 0L) {
            jsonObject.put("ajobgradescm", (Object)JsonObjectUtil.genJSONObject.apply(relativeJobLevelScmId));
        } else if (evaluationJobId != 0L || evaluationJobIsCtr) {
            jsonObject.put("ajobgrade", null);
        }
        Long aJobOrgId = jobIdAndJobGradeScmIdMap.containsKey(evaluationJobId) ? Optional.ofNullable(jobIdAndCrateOrgIdMap.get(evaluationJobId)).orElse(0L) : Optional.ofNullable(this.jobGradeScmIdAndCrateOrgId.get(this.getJsonBaseDataDyId(jsonObject, "ajoblevelscm"))).orElse(0L);
        if (jsonObject.get((Object)"ajoborg") == null && aJobOrgId != 0L) {
            jsonObject.put("ajoborg", (Object)JsonObjectUtil.genJSONObject.apply(aJobOrgId));
        }
    }

    private long getRelativeJobGradeScmId(JSONObject jsonObject, Map<Long, Long> jobIdAndJobGradeScmIdMap, String postPattern, long evaluationJobId, boolean evaluationJobIsCtr) {
        long jobGradeScmId = 0L;
        if (evaluationJobId != 0L) {
            jobGradeScmId = Optional.ofNullable(jobIdAndJobGradeScmIdMap.get(evaluationJobId)).orElse(0L);
        }
        if (jobGradeScmId == 0L && evaluationJobIsCtr) {
            if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportDataBuilder_11", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                PositionImportHandler positionimporthandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
                Map<Long, Long> positionIdAndJobGradeScmIdMap = positionimporthandler.getNoRelJobPositionIdAndJobGradeScmIdMap();
                long aPositionId = this.getJsonBaseDataDyId(jsonObject, "aposition");
                jobGradeScmId = Optional.ofNullable(positionIdAndJobGradeScmIdMap.get(aPositionId)).orElse(0L);
            } else if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportDataBuilder_7", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                StpositionImportHandler stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler");
                Map<Long, Long> stdPositionIdAndJobGradeScmIdMap = stdPositionImportHandler.getNoRelJobStdPositionIdAndJobGradeScmIdMap();
                long aStdPositionId = this.getJsonBaseDataDyId(jsonObject, "astposition");
                jobGradeScmId = Optional.ofNullable(stdPositionIdAndJobGradeScmIdMap.get(aStdPositionId)).orElse(0L);
            }
        }
        return jobGradeScmId;
    }

    public Set<String> getJobGradeScmNumberSet() {
        return this.jobGradeScmNumberSet;
    }

    public Map<String, Long> getJobGradeNumberAndIdMap() {
        return this.jobGradeNumberAndIdMap;
    }
}

