/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class JobImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(JobImportHandler.class);
    private final List<String> jobNumbers = new ArrayList<String>(0);
    private final Map<String, Long> jobNumberAndIdMap = new HashMap<String, Long>(0);
    private final Map<Long, String> jobIdAndNumberMap = new HashMap<Long, String>(0);
    private static final String ERROR_SCENE = "jobNumber2Id";

    public JobImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "ajob");
        String postPattern = jsonObject.getString("postpattern");
        if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportNumberToIdBO_7", (String)"hr-hdm-business", (Object[])new Object[0])) && HRStringUtils.isNotEmpty((String)number)) {
            jsonObject.put("aposition", null);
            jsonObject.put("astposition", null);
            this.jobNumbers.add(number);
        }
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                LOGGER.info("start JobImportHandler listAllIdByNumber");
                if (!this.jobNumbers.isEmpty()) {
                    JobExternalService jobExternalService = JobExternalService.getInstance();
                    Map<String, Object> jobHisSimpleInfo = jobExternalService.invokeQueryJobHisSimpleInfo(this.jobNumbers, null);
                    if (jobHisSimpleInfo == null) {
                        LOGGER.warn("JobImportHandler listAllIdByNumber jobHisSimpleInfo is null");
                        CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                        return copyOnWriteArrayList;
                    }
                    Object data = jobHisSimpleInfo.get("data");
                    if (data == null) {
                        LOGGER.warn("JobImportHandler listAllIdByNumber data is null");
                        CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                        return copyOnWriteArrayList;
                    }
                    DynamicObjectCollection collection = (DynamicObjectCollection)data;
                    Map<String, Long> jobInfoMap = this.hisBaseDataToNumberBoIdGroupMap(collection);
                    this.jobNumberAndIdMap.putAll(jobInfoMap);
                }
                LOGGER.info("end JobImportHandler listAllIdByNumber");
            }
            catch (Exception e) {
                LOGGER.error("EntryImportSerivceImpl JobImportHandler listAllIdByNumber error", (Throwable)e);
                LOGGER.error("EntryImportSerivceImpl JobImportHandler JobImportHandler invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject jsonObject = temp.getJsonObject();
                    ValidateContext validateContext = temp.getValidateContext();
                    String number = this.getJsonBaseDataDyNumber(jsonObject, "ajob");
                    if (HRStringUtils.isNotEmpty((String)number)) {
                        validateContext.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u4efb\u804c\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_6", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                    }
                });
            }
            finally {
                LOGGER.info("JobImportHandler jobNumberAndIdMap:{}", this.jobNumberAndIdMap);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        ValidateContext validateContext = entryImportWrapper.getValidateContext();
        LOGGER.info("start JobImportHandler number2Id");
        String postPattern = jsonObject.getString("postpattern");
        if (!HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"EntryImportNumberToIdBO_7", (String)"hr-hdm-business", (Object[])new Object[0]))) {
            return;
        }
        String number = this.getJsonBaseDataDyNumber(jsonObject, "ajob");
        try {
            Long jobId = this.jobNumberAndIdMap.get(number);
            if (jobId == null) {
                validateContext.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u4efb\u804c\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_6", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                return;
            }
            this.jobIdAndNumberMap.put(jobId, number);
            jsonObject.put("ajob", (Object)JsonObjectUtil.genJSONObject.apply(jobId));
            jsonObject.put("arealityjob", (Object)JsonObjectUtil.genJSONObject.apply(jobId));
            LOGGER.info("end JobImportHandler number2Id jobId :", (Object)jobId);
        }
        catch (Exception e) {
            LOGGER.error("JobImportHandler number2Id error", (Throwable)e);
            validateContext.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u4efb\u804c\u804c\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_6", (String)"hr-hdm-business", (Object[])new Object[0]), number));
        }
    }

    public List<String> getJobNumbers() {
        return this.jobNumbers;
    }

    public Map<String, Long> getJobNumberAndIdMap() {
        return this.jobNumberAndIdMap;
    }

    public Map<Long, String> getJobIdAndNumberMap() {
        return this.jobIdAndNumberMap;
    }
}

