/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.EvaluationJobImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.PositionImportHandler;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.StpositionImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;

public class JobLevelImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(JobLevelImportHandler.class);
    private final List<Map<String, Object>> queryJobLevelInfoParam = new ArrayList<Map<String, Object>>();
    private final Map<String, Long> jobLevelScmInfoMap = new HashMap<String, Long>();
    private static final String ERROR_SCENE = "joblevelnumber2Id";

    public JobLevelImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        JSONObject jobLevel = jsonObject.getJSONObject("ajoblevel");
        if (jobLevel == null) {
            return;
        }
        long jobLevelScmId = this.getJsonBaseDataDyId(jsonObject, "ajoblevelscm");
        if (jobLevelScmId == 0L) {
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u201c\u804c\u7ea7\u201d\u548c\u201c\u804c\u7ea7\u65b9\u6848\u201d\u9700\u540c\u65f6\u586b\u5199\u3002", (String)"JobLevelImportHandler_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            return;
        }
        String jobLevelName = jobLevel.getString("name");
        HashMap<String, Object> jobGradeQueryParam = new HashMap<String, Object>(8);
        jobGradeQueryParam.put("scmId", jobLevelScmId);
        jobGradeQueryParam.put("joblevelName", jobLevelName);
        this.queryJobLevelInfoParam.add(jobGradeQueryParam);
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            if (this.queryJobLevelInfoParam.isEmpty()) {
                return importSource;
            }
            LOGGER.info("###EntryImportNumberToIdBO.genJoblevelBoid, invokeGetJobLevelRangeByScmId params is :{}", (Object)JSONObject.toJSONString(this.queryJobLevelInfoParam));
            Map<String, Object> result = JobExternalService.getInstance().invokeGetJobLevelRangeByScmId(this.queryJobLevelInfoParam);
            List data = (List)result.get("data");
            Map<String, Long> jobLevelInfoMap = data.stream().collect(Collectors.toMap(jobLevelInfo -> {
                try {
                    Long jobLevelId = (Long)jobLevelInfo.get("scmId");
                    DynamicObject jobLevel = (DynamicObject)jobLevelInfo.get("joblevel");
                    OrmLocaleValue name = (OrmLocaleValue)jobLevel.get("name");
                    return jobLevelId + name.getLocaleValue();
                }
                catch (Exception exception) {
                    if (jobLevelInfo != null) {
                        LOGGER.error("JobLevelImportHandler listAllIdByNumber foreach error map info :{}", (Object)jobLevelInfo.toString());
                    } else {
                        LOGGER.error("JobLevelImportHandler listAllIdByNumber foreach error map is empty");
                    }
                    return "";
                }
            }, temp -> {
                DynamicObject jobLevel = (DynamicObject)temp.get("joblevel");
                return HRObjectUtils.isEmpty((Object)jobLevel) ? 0L : jobLevel.getLong("id");
            }, (k1, k2) -> k1));
            this.jobLevelScmInfoMap.putAll(jobLevelInfoMap);
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        LOGGER.info("start genJobLevelName2Id");
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        JSONObject aJobLevel = jsonObject.getJSONObject("ajoblevel");
        long aJobLevelScmId = this.getJsonBaseDataDyId(jsonObject, "ajoblevelscm");
        if (aJobLevel == null || aJobLevelScmId == 0L) {
            return;
        }
        String aJobLevelName = aJobLevel.getString("name");
        Long jobLevelId = this.jobLevelScmInfoMap.get(aJobLevelScmId + aJobLevelName);
        if (jobLevelId == null || jobLevelId == 0L) {
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7ea7\u4e0e\u804c\u7ea7\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobLevelImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            return;
        }
        jsonObject.put("ajoblevel", (Object)JsonObjectUtil.genJSONObject.apply(jobLevelId));
        boolean evaluationJobIsCtr = entryImportWrapper.isEvaluationJobIsCtr();
        long aEvaluationJobId = this.getJsonBaseDataDyId(jsonObject, "aevaluationjob");
        if (aEvaluationJobId != 0L) {
            EvaluationJobImportHandler evaluationJobImportHandler = (EvaluationJobImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("EvaluationJobImportHandler");
            Map<Long, List<Long>> jobIdAndJobLevelRangeMap = evaluationJobImportHandler.getJobIdAndJobLevelRangeMap();
            List<Long> aEvaluationJobLevelRange = jobIdAndJobLevelRangeMap.get(aEvaluationJobId);
            if (CollectionUtils.isNotEmpty(aEvaluationJobLevelRange) && !aEvaluationJobLevelRange.contains(jobLevelId)) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7ea7\u4e0e\u804c\u7ea7\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobLevelImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        } else if (evaluationJobIsCtr) {
            long aStdPositionId;
            StpositionImportHandler stdPositionImportHandler;
            Map<Long, List<Long>> noRelJobLevelRangMap;
            List<Long> aStdPositionJobLevelRange;
            String postPattern = jsonObject.getString("postpattern");
            if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_0", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                long aPositionId;
                PositionImportHandler positionImportHandler = (PositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("PositionImportHandler");
                Map<Long, List<Long>> noRelJobLevelRangMap2 = positionImportHandler.getNoRelJobLevelRangMap();
                List<Long> aPositionJobLevelRange = noRelJobLevelRangMap2.get(aPositionId = this.getJsonBaseDataDyId(jsonObject, "aposition"));
                if (CollectionUtils.isNotEmpty(aPositionJobLevelRange) && !aPositionJobLevelRange.contains(jobLevelId)) {
                    entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7ea7\u4e0e\u804c\u7ea7\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobLevelImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            } else if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0])) && CollectionUtils.isNotEmpty(aStdPositionJobLevelRange = (noRelJobLevelRangMap = (stdPositionImportHandler = (StpositionImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("StpositionImportHandler")).getNoRelJobLevelRangMap()).get(aStdPositionId = this.getJsonBaseDataDyId(jsonObject, "astposition"))) && !aStdPositionJobLevelRange.contains(jobLevelId)) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, ResManager.loadKDString((String)"\u804c\u7ea7\u4e0e\u804c\u7ea7\u8303\u56f4\u4e0d\u5339\u914d\u3002", (String)"JobLevelImportHandler_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        }
        LOGGER.info("end genJobLevelName2Id");
    }

    public List<Map<String, Object>> getQueryJobLevelInfoParam() {
        return this.queryJobLevelInfoParam;
    }
}

