/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.batchimport.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.batch.AbstractImportHandler;
import kd.hr.hdm.business.common.batch.EntryImportWrapper;
import kd.hr.hdm.business.common.batch.JsonObjectUtil;
import kd.hr.hdm.business.domain.service.hbpm.IHBPMService;
import kd.hr.hdm.business.domain.transfer.batchimport.TransferEntryImportNumberToIdBO;
import kd.hr.hdm.business.domain.transfer.batchimport.handler.OrgImportHandler;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;

public class StpositionImportHandler
extends AbstractImportHandler {
    private static final Log LOGGER = LogFactory.getLog(StpositionImportHandler.class);
    private final List<Long> stdPositionIds = new ArrayList<Long>(16);
    private final Set<String> stdPositionNumbers = new HashSet<String>(16);
    private final Map<String, Long> stdPositionNumberAdnIdMap = new HashMap<String, Long>(16);
    private final Map<Long, Long> stdPositionAndJobIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, String> stdPositionJobIdAndNumberMap = new HashMap<Long, String>(0);
    private final Set<String> sdtPositionBelongOrgSet = new HashSet<String>(16);
    private final Map<Long, Long> noRelJobStdPositionIdAndJobLevelScmIdMap = new HashMap<Long, Long>(0);
    private final Map<Long, Long> noRelJobStdPositionIdAndJobGradeScmIdMap = new HashMap<Long, Long>(0);
    private final Set<String> noRelJobLevelScmNumberSet = new HashSet<String>(0);
    private final Set<String> noRelJobGradeScmNumberSet = new HashSet<String>(0);
    private final Map<Long, List<Long>> noRelJobLevelRangMap = new HashMap<Long, List<Long>>(0);
    private final Map<Long, List<Long>> noRelJobGradeRangMap = new HashMap<Long, List<Long>>(0);
    private static final String ERROR_SCENE = "stpositionNumber2Id";

    public StpositionImportHandler(TransferEntryImportNumberToIdBO transferEntryImportNumberToIdBO) {
        super(transferEntryImportNumberToIdBO);
    }

    @Override
    public void cacheNumnbers(EntryImportWrapper entryImportWrapper) {
        JSONObject jsonObject = entryImportWrapper.getJsonObject();
        String number = this.getJsonBaseDataDyNumber(jsonObject, "astposition");
        String postPattern = jsonObject.getString("postpattern");
        if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0])) && HRStringUtils.isNotEmpty((String)number)) {
            jsonObject.put("ajob", null);
            jsonObject.put("aposition", null);
            this.stdPositionNumbers.add(number);
        }
    }

    @Override
    public Function<CopyOnWriteArrayList<EntryImportWrapper>, CopyOnWriteArrayList<EntryImportWrapper>> listAllIdByNumber() {
        return importSource -> {
            try {
                Map<Long, Object> noJobPositionData;
                LOGGER.info("start StpositionImportHandler listAllIdByNumber");
                if (this.stdPositionNumbers.isEmpty()) {
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                AdminOrgExternalService adminOrgExternalService = AdminOrgExternalService.getInstance();
                Map<String, Object> stdPositionHisInfo = adminOrgExternalService.queryStdPositionByNumber(new ArrayList<String>(this.stdPositionNumbers), new Date());
                if (stdPositionHisInfo == null) {
                    LOGGER.warn("StpositionImportHandler listAllIdByNumber stdPositionHisInfo is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                Object data = stdPositionHisInfo.get("data");
                if (data == null) {
                    LOGGER.warn("StpositionImportHandler listAllIdByNumber data is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                List dataList = (List)data;
                Map<String, Long> stdPositionMap = this.hisBaseDataMapToNumberBoIdGroupMap(dataList);
                this.stdPositionNumberAdnIdMap.putAll(stdPositionMap);
                Map<String, Object> stdMap = adminOrgExternalService.invokeQueryStandardPosition(new ArrayList<Long>(stdPositionMap.values()));
                if (stdMap == null) {
                    LOGGER.warn("StpositionImportHandler listAllIdByNumber stdMap is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                Object stdData = stdMap.get("data");
                if (stdData == null) {
                    LOGGER.warn("StpositionImportHandler listAllIdByNumber stdData is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                List resultList = (List)stdData;
                if (CollectionUtils.isEmpty((Collection)resultList)) {
                    LOGGER.warn("StpositionImportHandler listAllIdByNumber resultList is null");
                    CopyOnWriteArrayList copyOnWriteArrayList = importSource;
                    return copyOnWriteArrayList;
                }
                boolean evaluationJobIsCtr = ((EntryImportWrapper)importSource.get(0)).isEvaluationJobIsCtr();
                HashSet noJobStdPositionIds = new HashSet(16);
                resultList.forEach(stdPosition -> {
                    Long stdPositionId = (Long)stdPosition.get("boid");
                    Long jobId = (Long)stdPosition.get("job.id");
                    String jobNumber = (String)stdPosition.get("job.number");
                    this.stdPositionAndJobIdMap.put(stdPositionId, jobId);
                    if (evaluationJobIsCtr) {
                        if (jobId != 0L) {
                            this.stdPositionJobIdAndNumberMap.put(jobId, jobNumber);
                        } else {
                            noJobStdPositionIds.add(stdPositionId);
                        }
                    }
                });
                if (noJobStdPositionIds.size() > 0 && (noJobPositionData = IHBPMService.getInstance().queryJobLevelGradeRangeAndScmByStdPositionVersion(new ArrayList<Long>(noJobStdPositionIds), null)) != null) {
                    noJobPositionData.forEach((stdPositionId, jobLevelGradeRangeAndScmData) -> {
                        Long jobLevelScmId;
                        Map jobLevelData;
                        Long jobGradeScmId;
                        Map jobLevelGradeRangeAndScm = (Map)jobLevelGradeRangeAndScmData;
                        Map jobGradeData = (Map)jobLevelGradeRangeAndScm.get("jobGradeData");
                        if (jobGradeData != null && (jobGradeScmId = (Long)jobGradeData.get("id")) != null && jobGradeScmId != 0L) {
                            String jobGradeScmNumber = (String)jobGradeData.get("number");
                            List jobGradeRang = (List)jobGradeData.get("ranges");
                            this.noRelJobStdPositionIdAndJobGradeScmIdMap.put((Long)stdPositionId, jobGradeScmId);
                            this.noRelJobGradeScmNumberSet.add(jobGradeScmNumber);
                            if (CollectionUtils.isNotEmpty((Collection)jobGradeRang)) {
                                List jobGradeIds = jobGradeRang.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                                this.noRelJobGradeRangMap.put((Long)stdPositionId, jobGradeIds);
                            }
                        }
                        if ((jobLevelData = (Map)jobLevelGradeRangeAndScm.get("jobLevelData")) != null && (jobLevelScmId = (Long)jobLevelData.get("id")) != null && jobLevelScmId != 0L) {
                            String jobLevelScmNumber = (String)jobLevelData.get("number");
                            List jobLevelRang = (List)jobLevelData.get("ranges");
                            this.noRelJobStdPositionIdAndJobLevelScmIdMap.put((Long)stdPositionId, jobLevelScmId);
                            this.noRelJobLevelScmNumberSet.add(jobLevelScmNumber);
                            if (CollectionUtils.isNotEmpty((Collection)jobLevelRang)) {
                                List jobLevelIds = jobLevelRang.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                                this.noRelJobLevelRangMap.put((Long)stdPositionId, jobLevelIds);
                            }
                        }
                    });
                }
                if (!this.stdPositionNumberAdnIdMap.isEmpty()) {
                    List validData;
                    Map<String, Object> validResult;
                    OrgImportHandler orgImporthandler = (OrgImportHandler)this.entryImportNumberToIdBO.getExecuteHandler().get("OrgImportHandler");
                    Map<String, Long> orgNumberAndIdMap = orgImporthandler.getOrgNumberAndIdMap();
                    ArrayList<Map<String, Long>> stdPositionAndOrgMapList = new ArrayList<Map<String, Long>>(resultList.size());
                    importSource.forEach(entryImportWrapper -> {
                        JSONObject jsonObject = entryImportWrapper.getJsonObject();
                        String postPattern = jsonObject.getString("postpattern");
                        if (HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                            String aOrgNumber = this.getJsonBaseDataDyNumber(jsonObject, "aorg");
                            String aStdPositionNumber = this.getJsonBaseDataDyNumber(jsonObject, "astposition");
                            Long aStdPositionId = this.stdPositionNumberAdnIdMap.get(aStdPositionNumber);
                            Long aOrgId = (Long)orgNumberAndIdMap.get(aOrgNumber);
                            if (aStdPositionId != null && aStdPositionId != 0L && aOrgId != null && aOrgId != 0L) {
                                HashMap<String, Long> stdPositionAndOrgMap = new HashMap<String, Long>(2);
                                stdPositionAndOrgMap.put("orgId", aOrgId);
                                stdPositionAndOrgMap.put("standardPositionId", aStdPositionId);
                                stdPositionAndOrgMapList.add(stdPositionAndOrgMap);
                            }
                        }
                    });
                    if (stdPositionAndOrgMapList.size() > 0 && (validResult = adminOrgExternalService.validStandardPositionAndOrg(stdPositionAndOrgMapList)) != null && CollectionUtils.isNotEmpty((Collection)(validData = (List)validResult.get("data")))) {
                        validData.forEach(valid -> {
                            Long stdPositionId = (Long)valid.get("standardPositionId");
                            Long orgId = (Long)valid.get("orgId");
                            Boolean isBelong = (Boolean)valid.get("valide");
                            if (stdPositionId != null && stdPositionId != 0L && orgId != null && orgId != 0L && isBelong.booleanValue()) {
                                this.sdtPositionBelongOrgSet.add(String.format("%s_%s", stdPositionId, orgId));
                            }
                        });
                    }
                }
                LOGGER.info("end StpositionImportHandler listAllIdByNumber");
            }
            catch (Exception e) {
                LOGGER.error("EntryImportSerivceImpl StpositionImportHandler listAllIdByNumber error", (Throwable)e);
                LOGGER.error("EntryImportSerivceImpl StpositionImportHandler listAllIdByNumber invokeParam : {}", (Object)importSource.toString());
                importSource.forEach(temp -> {
                    JSONObject jsonObject = temp.getJsonObject();
                    String number = this.getJsonBaseDataDyNumber(jsonObject, "astposition");
                    if (HRStringUtils.isNotEmpty((String)number)) {
                        temp.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u6807\u51c6\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_5", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                    }
                });
            }
            finally {
                LOGGER.info("StpositionImportHandler stdPositionAndJobIdMap:{}", this.stdPositionAndJobIdMap);
                LOGGER.info("StpositionImportHandler stdPositionJobIdAndNumberMap:{}", this.stdPositionJobIdAndNumberMap);
                LOGGER.info("StpositionImportHandler noRelJobStdPositionIdAndJobLevelScmIdMap:{}", this.noRelJobStdPositionIdAndJobLevelScmIdMap);
                LOGGER.info("StpositionImportHandler noRelJobStdPositionIdAndJobGradeScmIdMap:{}", this.noRelJobStdPositionIdAndJobGradeScmIdMap);
                LOGGER.info("StpositionImportHandler noRelJobLevelScmNumberSet:{}", this.noRelJobLevelScmNumberSet);
                LOGGER.info("StpositionImportHandler noRelJobGradeScmNumberSet:{}", this.noRelJobGradeScmNumberSet);
                LOGGER.info("StpositionImportHandler noRelJobLevelRangMap:{}", this.noRelJobLevelRangMap);
                LOGGER.info("StpositionImportHandler noRelJobGradeRangMap:{}", this.noRelJobGradeRangMap);
            }
            return importSource;
        };
    }

    @Override
    public void number2Id(EntryImportWrapper entryImportWrapper) {
        LOGGER.info("start StpositionImportHandler number2Id");
        JSONObject importSource = entryImportWrapper.getJsonObject();
        String postPattern = importSource.getString("postpattern");
        if (!HRStringUtils.equals((String)postPattern, (String)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"EntryImportNumberToIdBO_2", (String)"hr-hdm-business", (Object[])new Object[0]))) {
            return;
        }
        String number = this.getJsonBaseDataDyNumber(importSource, "astposition");
        Long stdPositionId = this.stdPositionNumberAdnIdMap.get(number);
        try {
            if (stdPositionId == null) {
                entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u6807\u51c6\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_5", (String)"hr-hdm-business", (Object[])new Object[0]), number));
                return;
            }
            Long aOrgId = this.getJsonBaseDataDyId(importSource, "aorg");
            if (!this.sdtPositionBelongOrgSet.contains(String.format("%s_%s", stdPositionId, aOrgId))) {
                entryImportWrapper.setCompleteValidResult("validateStdPosition", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8be5\u8c03\u52a8\u6807\u51c6\u5c97\u4f4d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u6ca1\u6709\u5305\u542b\u8c03\u52a8\u90e8\u95e8\u3002", (String)"EntryImportDataBuilder_8", (String)"hr-hdm-business", (Object[])new Object[0]));
                return;
            }
            JSONObject stdPositionJson = JsonObjectUtil.genJSONObject.apply(stdPositionId);
            importSource.put("astposition", (Object)stdPositionJson);
            importSource.put("arealitystposition", (Object)stdPositionJson);
            Long jobId = this.stdPositionAndJobIdMap.get(stdPositionId);
            JSONObject jobJson = JsonObjectUtil.genJSONObject.apply(jobId);
            importSource.put("ajob", (Object)jobJson);
            importSource.put("arealityjob", (Object)jobJson);
            Long jobLevelScmId = Optional.ofNullable(this.noRelJobStdPositionIdAndJobLevelScmIdMap.get(stdPositionId)).orElse(0L);
            Long jobGradeScmId = Optional.ofNullable(this.noRelJobStdPositionIdAndJobGradeScmIdMap.get(stdPositionId)).orElse(0L);
            if (jobId == 0L && jobLevelScmId == 0L && jobGradeScmId == 0L) {
                entryImportWrapper.setEvaluationJobIsCtr(false);
            }
            LOGGER.info("end StpositionImportHandler number2Id stpositionId:{}", (Object)stdPositionId);
        }
        catch (Exception e) {
            LOGGER.error("StpositionImportHandler number2Id error", (Throwable)e);
            entryImportWrapper.setCompleteValidResult(ERROR_SCENE, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u5bf9\u5e94\u7684\u8c03\u5165\u6807\u51c6\u5c97\u4f4dID\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImportNumberToIdBO_5", (String)"hr-hdm-business", (Object[])new Object[0]), number));
        }
    }

    public List<Long> getStdPositionIds() {
        return this.stdPositionIds;
    }

    public Set<String> getStdPositionNumbers() {
        return this.stdPositionNumbers;
    }

    public Map<String, Long> getStdPositionNumberAdnIdMap() {
        return this.stdPositionNumberAdnIdMap;
    }

    public Map<Long, Long> getStdPositionAndJobIdMap() {
        return this.stdPositionAndJobIdMap;
    }

    public Map<Long, String> getStdPositionJobIdAndNumberMap() {
        return this.stdPositionJobIdAndNumberMap;
    }

    public Map<Long, Long> getNoRelJobStdPositionIdAndJobLevelScmIdMap() {
        return this.noRelJobStdPositionIdAndJobLevelScmIdMap;
    }

    public Map<Long, Long> getNoRelJobStdPositionIdAndJobGradeScmIdMap() {
        return this.noRelJobStdPositionIdAndJobGradeScmIdMap;
    }

    public Set<String> getNoRelJobLevelScmNumberSet() {
        return this.noRelJobLevelScmNumberSet;
    }

    public Set<String> getNoRelJobGradeScmNumberSet() {
        return this.noRelJobGradeScmNumberSet;
    }

    public Map<Long, List<Long>> getNoRelJobLevelRangMap() {
        return this.noRelJobLevelRangMap;
    }

    public Map<Long, List<Long>> getNoRelJobGradeRangMap() {
        return this.noRelJobGradeRangMap;
    }
}

