/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;
import org.apache.commons.lang3.time.DateUtils;

public class StaffIsUpdateJudgementVO {
    private final Log LOGGER = LogFactory.getLog(StaffIsUpdateJudgementVO.class);
    private DynamicObject before;
    private IDataModel model;
    private DynamicObject after;
    List<String> mvpField = Arrays.asList("arealityorg", "realitydate", "arealityjob", "arealityposition");
    private boolean isUpdate = false;

    public StaffIsUpdateJudgementVO(DynamicObject before, IDataModel model) {
        List<Map<String, String>> dimension;
        long afterPositionId;
        long afterJobId;
        this.before = before;
        this.model = model;
        this.after = model.getDataEntity();
        long beforeOrgId = TransferStaffService.getInstance().getRealOrgTeamId("arealityorg.id", before);
        DynamicObject beforeJob = before.getDynamicObject("arealityjob");
        DynamicObject beforePosition = before.getDynamicObject("arealityposition");
        Date beforeDate = before.getDate("realitydate");
        long afterOrgId = TransferStaffService.getInstance().getRealOrgTeamId("aorg.id", this.after);
        DynamicObject afterJob = (DynamicObject)model.getValue("ajob");
        DynamicObject afterPosition = (DynamicObject)model.getValue("aposition");
        Date afterDate = (Date)model.getValue("realitydate");
        if (!Objects.equals(beforeOrgId, afterOrgId)) {
            this.isUpdate = true;
        }
        long beforeJobId = beforeJob == null ? 0L : beforeJob.getLong("id");
        long l = afterJobId = afterJob == null ? 0L : afterJob.getLong("id");
        if (!this.isUpdate && beforeJobId != afterJobId) {
            this.isUpdate = true;
        }
        long beforePositionId = beforePosition == null ? 0L : beforePosition.getLong("id");
        long l2 = afterPositionId = afterPosition == null ? 0L : afterPosition.getLong("id");
        if (!this.isUpdate && beforePositionId != afterPositionId) {
            this.isUpdate = true;
        }
        if (!this.isUpdate && !((String)TransferCommonUtil.formatDate.apply(beforeDate)).equals(TransferCommonUtil.formatDate.apply(afterDate))) {
            this.isUpdate = true;
        }
        if ((dimension = TransferStaffService.getInstance().queryStaffDynamicdimension()) != null && !dimension.isEmpty()) {
            dimension.stream().forEach(item -> {
                String field = (String)item.get("mapfield");
                if (!this.isUpdate && HRStringUtils.isNotEmpty((String)field) && this.isUpdate(before, this.after, field)) {
                    this.isUpdate = true;
                }
            });
        }
    }

    public StaffIsUpdateJudgementVO(DynamicObject before, DynamicObject after) {
        this.before = before;
        this.after = after;
        this.getDimensionSet().forEach(field -> {
            if (!this.isUpdate && this.isUpdate(before, after, (String)field)) {
                this.isUpdate = true;
            }
        });
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public boolean isUpdate(DynamicObject before, DynamicObject after, String field) {
        Object newValue2;
        Object oldValue2;
        Map<String, IDataEntityProperty> propertyMap = after.getDataEntityType().getProperties().stream().collect(Collectors.toMap(IMetadata::getName, property -> property, (oldValue, newValue) -> newValue));
        if (!after.containsProperty(field.split("\\.")[0])) {
            return false;
        }
        if ("arealityorg".equals(field)) {
            oldValue2 = TransferStaffService.getInstance().getRealOrgTeamId("arealityorg.id", before);
            newValue2 = TransferStaffService.getInstance().getRealOrgTeamId("arealityorg.id", after);
        } else {
            try {
                oldValue2 = before.get(field);
                newValue2 = after.get(field);
            }
            catch (ORMDesignException exception) {
                this.LOGGER.error("StaffIsUpdateJudgementVO.isUpdate invalid mapField", (Throwable)exception);
                return false;
            }
        }
        if (ObjectUtils.isEmpty((Object)oldValue2) && ObjectUtils.isEmpty((Object)newValue2)) {
            return false;
        }
        IDataEntityProperty property2 = propertyMap.get(field);
        if (property2 instanceof BasedataProp) {
            oldValue2 = oldValue2 == null ? Long.valueOf(0L) : oldValue2;
            newValue2 = newValue2 == null ? Long.valueOf(0L) : newValue2;
        }
        String fieldDyIdName = field + ".id";
        return ObjectUtils.isEmpty((Object)oldValue2) ^ ObjectUtils.isEmpty((Object)newValue2) || (oldValue2 instanceof DynamicObject || property2 instanceof BasedataProp) && before.getLong(fieldDyIdName) != after.getLong(fieldDyIdName) || oldValue2 instanceof Date && !DateUtils.isSameDay((Date)before.getDate(field), (Date)after.getDate(field)) || oldValue2 instanceof String && !HRStringUtils.equals((String)before.getString(field), (String)after.getString(field)) || oldValue2 instanceof Integer && before.getInt(field) != after.getInt(field);
    }

    public DynamicObject getBefore() {
        return this.before;
    }

    public IDataModel getModel() {
        return this.model;
    }

    public DynamicObject getAfter() {
        return this.after;
    }

    public List<String> getMvpField() {
        return this.mvpField;
    }

    public final Set<String> getDimensionSet() {
        List<Map<String, String>> dimension = TransferStaffService.getInstance().queryStaffDynamicdimension();
        HashSet<String> dimensionSet = new HashSet<String>(16);
        if (dimension != null && !dimension.isEmpty()) {
            dimension.stream().forEach(item -> dimensionSet.add((String)item.get("mapfield")));
        }
        dimensionSet.addAll(this.mvpField);
        return dimensionSet;
    }

    public void setBefore(DynamicObject before) {
        this.before = before;
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    public void setAfter(DynamicObject after) {
        this.after = after;
    }

    public void setMvpField(List<String> mvpField) {
        this.mvpField = mvpField;
    }

    public void setUpdate(boolean update) {
        this.isUpdate = update;
    }
}

