/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.domain.transfer.dto.TransferCoordinationMsgDTO;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferCallBackService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferChgSaveParamsExtendServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferEmpJobRelChgSaveExtendServiceImpl;
import kd.sdk.hr.common.bean.DepempBean;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hdm.business.transfer.ITransferChgSaveParamsExtendService;
import kd.sdk.hr.hdm.business.transfer.ITransferEmpJobRelChgSaveExtendService;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgFlowTypeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.perchg.executor.model.ChgRecordEntryDto;
import kd.sdk.hr.hpfs.utils.ChgActionUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class TransferHPFSTemplatePropertyHandler
extends HPFSTemplatePropertyHandler {
    private static final TransferHPFSTemplatePropertyHandler HANDLER = new TransferHPFSTemplatePropertyHandler();
    private static final String[] CUSTOM_PARAM_ENTITY_NUMBERS = new String[]{"hrpi_cmpemp", "hrpi_managingscope", "hrpi_baselocation", "hrpi_empjobrel"};
    private static final String[] CMPEMP_PARAM_ENTITY_NUMBERS = new String[]{"hspm_ermanfile", "hrpi_depemp", "hrpi_empposorgrel", "hrpi_emporgrelall"};

    private TransferHPFSTemplatePropertyHandler() {
    }

    public static TransferHPFSTemplatePropertyHandler getInstance() {
        return HANDLER;
    }

    @Override
    public void setPreProperty(DynamicObject bill) {
        bill.set("b_ermanfile", bill.get("ermanfile"));
        bill.set("b_effectivedate", bill.get("realitydate"));
        bill.set("bb_p_chgtype", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        bill.set("bb_e_chgtype", (Object)ChgModeEnum.UNCHANGED.getChgMode());
        bill.set("bb_d_chgtype", (Object)ChgModeEnum.INVALID.getChgMode());
        bill.set("ba_d_chgtype", (Object)ChgModeEnum.ADD_NEW.getChgMode());
    }

    @Override
    protected void prePersonParamsBuilder(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        perChgBizInfoNew.setEffectivedate(bill.getDate("realitydate"));
    }

    @Override
    protected void updateByAcffactionResult(PerChgBizInfoNew perChgBizInfoNew, boolean affectionRecordResult) {
        LOGGER.info("updateByAcffactionResult param: {}", (Object)affectionRecordResult);
        boolean pass = ITransferCallBackService.getInstance().transferStatusValidate(perChgBizInfoNew.getBillId());
        if (!pass) {
            return;
        }
        if (!affectionRecordResult) {
            ITransferCallBackService.getInstance().executeFailCallBack(perChgBizInfoNew.getBillId());
        } else {
            TransferCoordinationMsgDTO coordinationMsgDTO = new TransferCoordinationMsgDTO();
            coordinationMsgDTO.setBillId(perChgBizInfoNew.getBillId());
            Optional<DepempBean> depempOptional = perChgBizInfoNew.getDepempList().stream().filter(depempBean -> depempBean.getaDeempId() != null && depempBean.getaDeempId() != 0L).findFirst();
            if (depempOptional.isPresent()) {
                Long aDeempId = depempOptional.get().getaDeempId();
                coordinationMsgDTO.setNewDepEmpId(aDeempId);
                ITransferCallBackService.getInstance().executeSuccessCallBack(coordinationMsgDTO);
            } else {
                LOGGER.error("aDeempId is null");
            }
        }
    }

    @Override
    public void saveEntryFields(DynamicObject[] dys) {
        TransferBillRepository.getInstance().batchSave(dys);
    }

    @Override
    public void setBillProperty(DynamicObject dy) {
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashMap perChgBizInfoNewMap = Maps.newHashMapWithExpectedSize((int)perChgBizInfoNews.size());
        for (PerChgBizInfoNew perChgBizInfoNew : perChgBizInfoNews) {
            if (!perChgBizInfoNew.isSuccess()) {
                throw new KDBizException(perChgBizInfoNew.getErrMsg());
            }
            perChgBizInfoNewMap.put(perChgBizInfoNew.getBillId(), perChgBizInfoNew);
        }
        this.setCustomPersonParams(bills, perChgBizInfoNewMap);
    }

    private void setCustomPersonParams(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        this.setCmpEmp(bills, perChgBizInfoNewMap);
        this.setBaseLocation(bills, perChgBizInfoNewMap);
        this.setEmpJobRel(bills, perChgBizInfoNewMap);
        this.setCustomPersonParamsExtend(bills, perChgBizInfoNewMap);
        perChgBizInfoNewMap.values().forEach(this::setPersonParams);
    }

    private void setCustomPersonParamsExtend(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        PluginProxy pluginProxy = PluginProxy.create((Object)new TransferChgSaveParamsExtendServiceImpl(), ITransferChgSaveParamsExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.ITransferChgSaveParamsExtendService", null);
        pluginProxy.callReplaceIfPresent(service -> {
            service.setCustomPersonParamsExtend(bills, perChgBizInfoNewMap);
            return "";
        });
    }

    private void setCmpEmp(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> cmpEmpIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            if (bill.getLong("bmanagescope.id") == bill.getLong("amanagescope.id")) continue;
            todoMap.put(bill.getLong("id"), bill);
            cmpEmpIds.add(bill.getLong("ermanfile.cmpemp.id"));
        }
        Map<Long, DynamicObject> managingScopeMap = this.listManagingScope(cmpEmpIds);
        Map<Long, DynamicObject> cmpEmpMap = this.listCmpEmp(cmpEmpIds);
        List chgActionIds = perChgBizInfoNewMap.values().stream().map(PerChgBizInfoNew::getChgActionId).collect(Collectors.toList());
        Map actionTypeMap = ChgActionUtils.getChgCategoryActionType(chgActionIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill = (DynamicObject)entry.getValue();
            PerChgBizInfoNew perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long cmpEmpId = bill.getLong("ermanfile.cmpemp.id");
            DynamicObject managingScope = managingScopeMap.get(cmpEmpId);
            DynamicObject cmpEmp = cmpEmpMap.get(cmpEmpId);
            if (managingScope != null) {
                DynamicObject hisManagingScope = this.expireManagingScope(perChgBizInfoNew, bill, managingScope);
                ChgRecordHelper.updIdsRecord((String)"hrpi_managingscope", (DynamicObject)managingScope, (DynamicObject)hisManagingScope, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
                DynamicObject hisCmpEmp = this.expireCmpEmp(perChgBizInfoNew, bill, cmpEmp);
                ChgRecordHelper.updIdsRecord((String)"hrpi_cmpemp", (DynamicObject)cmpEmp, (DynamicObject)hisCmpEmp, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            }
            DynamicObject newManagingScope = this.createManagingScope(perChgBizInfoNew, bill, actionTypeMap);
            DynamicObject newCmpEmp = this.createCmpEmp(perChgBizInfoNew, newManagingScope, bill);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_managingscope", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newManagingScope.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newManagingScope);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_cmpemp", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newCmpEmp.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newCmpEmp);
            LOGGER.info("newCmpEmp:{}", perChgBizInfoNew.getEntityRecord().get("hrpi_cmpemp"));
            Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
            this.updateCmpEmp(newCmpEmp, entityRecordMap);
        }
    }

    private void setPersonParams(PerChgBizInfoNew perChgBizInfoNew) {
        List data = (List)perChgBizInfoNew.getPersonParams().get("data");
        Map entityRecordMap = perChgBizInfoNew.getEntityRecord();
        Arrays.stream(CUSTOM_PARAM_ENTITY_NUMBERS).forEach(entityNumber -> {
            List chgRecordEntryList = (List)entityRecordMap.get(entityNumber);
            if (HRCollUtil.isNotEmpty((Collection)chgRecordEntryList)) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)chgRecordEntryList.size());
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                DynamicObjectCollection dynamicObjects = new DynamicObjectCollection((DynamicObjectType)dataEntityType, null);
                chgRecordEntryList.forEach(chgRecordEntry -> dynamicObjects.add((Object)chgRecordEntry.getDataDy()));
                map.put("hisDyns", dynamicObjects);
                data.add(map);
            }
        });
    }

    private void updateCmpEmp(DynamicObject newCmpEmp, Map<String, List<ChgRecordEntryDto>> entityRecordMap) {
        Arrays.stream(CMPEMP_PARAM_ENTITY_NUMBERS).forEach(entityName -> {
            List chgRecordEntryDTOs = (List)entityRecordMap.get(entityName);
            Optional<ChgRecordEntryDto> optional = chgRecordEntryDTOs.stream().filter(chgRecordEntryDTO -> ChgModeEnum.ADD_NEW.getChgMode().equals(chgRecordEntryDTO.getChgMode())).findFirst();
            optional.ifPresent(chgRecordEntryDto -> chgRecordEntryDto.getDataDy().set("cmpemp", (Object)newCmpEmp));
        });
    }

    private DynamicObject expireCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject cmpEmp) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, cmpEmp, "hrpi_cmpemp");
        newHisDy.set("lastworkdate", (Object)bill.getDate("realitydate"));
        return newHisDy;
    }

    private DynamicObject expireManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject managingScope) {
        DynamicObject newHisDy = this.createNewHisDy(perChgBizInfoNew, bill, managingScope, "hrpi_managingscope");
        newHisDy.set("lastworkdate", (Object)bill.getDate("realitydate"));
        return newHisDy;
    }

    private DynamicObject createNewHisDy(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject currentDy, String entityNumber) {
        DynamicObject newHisDy = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)currentDy, (String)entityNumber);
        newHisDy.set("bsled", (Object)MAX_DATE);
        newHisDy.set("businessstatus", (Object)"2");
        newHisDy.set("sysenddate", (Object)bill.getDate("realitydate"));
        newHisDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)bill.getDate("realitydate"), (long)-1L));
        return newHisDy;
    }

    private DynamicObject expireLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject location) {
        return this.createNewHisDy(perChgBizInfoNew, bill, location, "hrpi_baselocation");
    }

    public DynamicObject expireEmpJobRel(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, DynamicObject empJobRel) {
        return this.createNewHisDy(perChgBizInfoNew, bill, empJobRel, "hrpi_empjobrel");
    }

    private DynamicObject createDynamicObject(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, String entityNum) {
        DynamicObject dataEntity = ChgRecordHelper.createDynamicObject((PerChgBizInfoNew)perChgBizInfoNew, (String)entityNum);
        dataEntity.set("person", (Object)bill.getDynamicObject("person"));
        dataEntity.set("employee", (Object)bill.getDynamicObject("bemployee"));
        dataEntity.set("startdate", (Object)bill.getDate("realitydate"));
        dataEntity.set("bsed", (Object)bill.getDate("realitydate"));
        dataEntity.set("bsled", (Object)MAX_DATE);
        dataEntity.set("enddate", (Object)MAX_DATE);
        dataEntity.set("businessstatus", (Object)"1");
        dataEntity.set("initstatus", (Object)"2");
        dataEntity.set("datastatus", (Object)"1");
        return dataEntity;
    }

    private DynamicObject createManagingScope(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, Map<Long, DynamicObject> actionTypeMap) {
        DynamicObject managingScope = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_managingscope");
        if (actionTypeMap != null && !actionTypeMap.isEmpty()) {
            managingScope.set("variationtype", (Object)actionTypeMap.get(bill.getLong("affaction.id")));
        }
        managingScope.set("managingscope", (Object)bill.getDynamicObject("amanagescope"));
        managingScope.set("workplace", (Object)bill.getDynamicObject("arealitybaselocation"));
        managingScope.set("cmpemp_id", (Object)ORM.create().genLongId("hrpi_cmpemp"));
        managingScope.set("isprimaryscope", (Object)Character.valueOf('1'));
        managingScope.set("lastworkdate", (Object)MAX_DATE);
        return managingScope;
    }

    private DynamicObject createLocation(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        DynamicObject location = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_baselocation");
        location.set("location", (Object)bill.getDynamicObject("abaselocation"));
        return location;
    }

    public DynamicObject createEmpJobRel(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill, Map<Long, DynamicObject> actionTypeMap) {
        DynamicObject empJobRel = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_empjobrel");
        empJobRel.set("adminorg", bill.get("arealityorg"));
        empJobRel.set("jobclass", bill.get("ajobclass"));
        empJobRel.set("joblevel", bill.get("ajoblevel"));
        empJobRel.set("jobscm", bill.get("ajobscm"));
        empJobRel.set("hrbu", bill.get("ajoborg"));
        empJobRel.set("jobseq", bill.get("ajobseq"));
        empJobRel.set("jobgradescm", bill.get("ajobgradescm"));
        empJobRel.set("jobgrade", bill.get("ajobgrade"));
        empJobRel.set("jobfamily", bill.get("ajobfamily"));
        if (actionTypeMap != null && !actionTypeMap.isEmpty()) {
            empJobRel.set("variationtype", (Object)actionTypeMap.get(bill.getLong("affaction.id")));
        }
        empJobRel.set("joblevelscm", bill.get("ajoblevelscm"));
        empJobRel.set("company", bill.get("arealitycompany"));
        empJobRel.set("position", bill.get("arealityposition"));
        empJobRel.set("job", bill.get("aevaluationjob"));
        return empJobRel;
    }

    private DynamicObject createCmpEmp(PerChgBizInfoNew perChgBizInfoNew, DynamicObject managingScope, DynamicObject bill) {
        DynamicObject cmpEmp = this.createDynamicObject(perChgBizInfoNew, bill, "hrpi_cmpemp");
        cmpEmp.set("id", (Object)managingScope.getLong("cmpemp_id"));
        cmpEmp.set("managingscope", (Object)managingScope.getDynamicObject("managingscope"));
        cmpEmp.set("isprimaryscope", (Object)Character.valueOf('1'));
        cmpEmp.set("company", (Object)bill.getDynamicObject("acompany"));
        return cmpEmp;
    }

    private void setBaseLocation(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        PerChgBizInfoNew perChgBizInfoNew;
        HashMap todoMap = Maps.newHashMapWithExpectedSize((int)bills.length);
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        for (DynamicObject bill : bills) {
            if (bill.getLong("bbaselocation.id") == bill.getLong("arealitybaselocation.id")) {
                perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
                ChgRecordHelper.deleteEntityRecord((PerChgBizInfoNew)perChgBizInfoNew, (String)"hrpi_baselocation");
                continue;
            }
            todoMap.put(bill.getLong("id"), bill);
            employeeIds.add(bill.getLong("bemployee.id"));
        }
        Map<Long, DynamicObject> locationMap = this.listLocation(employeeIds);
        for (Map.Entry entry : todoMap.entrySet()) {
            DynamicObject bill;
            bill = (DynamicObject)entry.getValue();
            perChgBizInfoNew = perChgBizInfoNewMap.get(bill.getLong("id"));
            long employeeId = bill.getLong("bemployee.id");
            DynamicObject location = locationMap.get(employeeId);
            if (location != null) {
                DynamicObject hisLocation = this.expireLocation(perChgBizInfoNew, bill, location);
                ChgRecordHelper.updIdsRecord((String)"hrpi_baselocation", (DynamicObject)location, (DynamicObject)hisLocation, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.INVALID.getChgMode());
            }
            DynamicObject newLocation = this.createLocation(perChgBizInfoNew, bill);
            ChgRecordHelper.addChgIdRecord((String)"hrpi_baselocation", (PerChgBizInfoNew)perChgBizInfoNew, (Long)newLocation.getLong("id"), (String)ChgFlowTypeEnum.FLOW_UNRELATED.getFlowType(), (DynamicObject)newLocation);
        }
    }

    private void setEmpJobRel(DynamicObject[] bills, Map<Long, PerChgBizInfoNew> perChgBizInfoNewMap) {
        PluginProxy pluginProxy = PluginProxy.create((Object)new TransferEmpJobRelChgSaveExtendServiceImpl(), ITransferEmpJobRelChgSaveExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.ITransferEmpJobRelChgSaveExtendService", null);
        pluginProxy.callReplaceIfPresent(service -> {
            service.setEmpJobRelExtend(bills, perChgBizInfoNewMap);
            return "";
        });
    }

    public Map<Long, DynamicObject> listEmpJobRel(List<Long> employeeIds) {
        QFilter qFilters = new QFilter("employee", "in", employeeIds);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_empjobrel", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listCmpEmp(List<Long> cmpEmpIdList) {
        QFilter qFilters = new QFilter("id", "in", cmpEmpIdList);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_cmpemp", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listManagingScope(List<Long> cmpEmpIdList) {
        QFilter qFilters = new QFilter("cmpemp", "in", cmpEmpIdList);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_managingscope", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("cmpemp.id"), dy -> dy, (o, n) -> n));
    }

    private Map<Long, DynamicObject> listLocation(List<Long> employeeIds) {
        QFilter qFilters = new QFilter("employee", "in", employeeIds);
        DynamicObject[] dynamicObjects = this.listEmployeeAttach("hrpi_baselocation", qFilters);
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy, (o, n) -> n));
    }

    private DynamicObject[] listEmployeeAttach(String entityName, QFilter qFilters) {
        qFilters.and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("businessstatus", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1"));
        return RepositoryUtils.queryDynamicObjects((String)entityName, null, (QFilter[])new QFilter[]{qFilters});
    }
}

