/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.IBatchTransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferSaveValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferSubmitValidatorServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferPermItermIdEnum;
import kd.hr.hdm.common.transfer.enums.TransferPostpatternEnum;

public class BatchTransferValidatorServiceImpl
implements IBatchTransferValidatorService {
    private static final Log LOGGER = LogFactory.getLog(BatchTransferValidatorServiceImpl.class);

    @Override
    public List<DataDiv> submitEffectValidate(List<DynamicObject> entryTransferBill, String menuFlag) {
        return this.submitEffectValidate(PermissionValidateUtil.getPermissionAppId(null), entryTransferBill, menuFlag);
    }

    @Override
    public List<DataDiv> submitEffectValidate(String appId, List<DynamicObject> entryTransferBill, String menuFlag) {
        List<DataDiv> dataDivs = entryTransferBill.stream().map(temp -> new DataDiv((DynamicObject)temp, new ValidateContext())).collect(Collectors.toList());
        try {
            List<Object> bemployeeIds = dataDivs.stream().map(temp -> temp.getDynamicObject().get("bemployee.id")).collect(Collectors.toList());
            TransferSubmitValidatorServiceImpl transferValidatorService = (TransferSubmitValidatorServiceImpl)ITransferSubmitValidatorService.getInstance();
            transferValidatorService.checkSubmitDataRule(TransferPermItermIdEnum.SUBMITEFFECT.itermId, appId, "hdm_transferbatch", TransferPermItermIdEnum.getSubmitMsg((String)"batch", (String)TransferOperateTypeEnum.SUBMITEFFECT.getName())).test(dataDivs);
            transferValidatorService.checkRepeat().test(dataDivs);
            transferValidatorService.checkRepeatInDb(entryTransferBill).test(dataDivs);
            ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(bemployeeIds).test(dataDivs);
            transferValidatorService.batchCheckRepeatInPerChg().test(dataDivs);
            transferValidatorService.getStaffInfo().test(dataDivs);
            transferValidatorService.validateSubmitPostpatternEffctDate("1", menuFlag, "hdm_transfer_org_createdate_submitvalidate", "hdm_transfer_company_createdate_submitvalidate").test(dataDivs);
            ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)"", (String)"", (Object[])new Object[0])).test(dataDivs);
        }
        catch (Exception exception) {
            LOGGER.error("TransferValidatorServiceImpl batchValidate error exception", (Throwable)exception);
            dataDivs.forEach(temp -> temp.getValidatorContext().setResult("exception", exception.getMessage()));
        }
        return dataDivs;
    }

    @Override
    public Map<String, Object> buildOperateInfoByValResult(List<DataDiv> dataDivs, TransferOperateTypeEnum operateTypeEnum) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Integer sumPerson = dataDivs.size();
        Integer failPersoner = 0;
        Integer successPerson = 0;
        ArrayList detailExcelDataList = Lists.newArrayListWithExpectedSize((int)dataDivs.size());
        Map<String, String> exportFieldMap = this.getExportFieldMap();
        for (DataDiv dataDiv : dataDivs) {
            Integer n;
            Integer n2;
            ValidateContext validatorContext = dataDiv.getValidatorContext();
            DynamicObject transferbill = dataDiv.getDynamicObject();
            if ("2".equals(validatorContext.getFlag())) {
                transferbill.set("entryvalidateresult", (Object)"B");
                transferbill.set("entryerrormsg", (Object)validatorContext.getAllValidateInfo());
                n2 = failPersoner;
                n = failPersoner = Integer.valueOf(failPersoner + 1);
            } else {
                transferbill.set("entryvalidateresult", (Object)"A");
                transferbill.set("entryerrormsg", null);
                n2 = successPerson;
                n = successPerson = Integer.valueOf(successPerson + 1);
            }
            detailExcelDataList.add(this.getDetailExcelData(dataDiv, exportFieldMap));
        }
        result.put("sumperson", sumPerson);
        result.put("failperson", failPersoner);
        result.put("successperson", successPerson);
        result.put("headDataList", this.getDetailExcelHead(exportFieldMap));
        result.put("exportDataList", detailExcelDataList);
        result.put("operatetype", operateTypeEnum.getType());
        result.put("errorreason", this.buildErrorReasonMsg(dataDivs));
        return result;
    }

    @Override
    public List<DataDiv> saveValidate(DynamicObject batchTransferBill, List<DynamicObject> entryTransferBill, String menuFlag) {
        List<DataDiv> dataDivs = entryTransferBill.stream().map(temp -> new DataDiv((DynamicObject)temp, new ValidateContext(), DataDiv.DataType.batchBill.getFlag())).collect(Collectors.toList());
        List<Object> bemployeeIds = dataDivs.stream().map(temp -> temp.getDynamicObject().get("bemployee.id")).collect(Collectors.toList());
        ITransferSubmitValidatorService submitValidatorService = ITransferSubmitValidatorService.getInstance();
        ITransferSaveValidatorService saveValidatorService = ITransferSaveValidatorService.getInstance();
        submitValidatorService.checkRepeat().and(submitValidatorService.checkRepeatInDb(entryTransferBill)).and(ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(bemployeeIds)).and(submitValidatorService.batchCheckRepeatInPerChg()).and(saveValidatorService.validateStaffInfo()).and(submitValidatorService.validateSubmitPostpatternEffctDate("0", menuFlag, "hdm_transfer_org_createdate_savevalidate", "hdm_transfer_company_createdate_savevalidate")).and(ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"", (String)"", (Object[])new Object[0]))).test(dataDivs);
        return dataDivs;
    }

    @Override
    public List<DataDiv> submitValidate(DynamicObject batchTransferBill, List<DynamicObject> entryTransferBill, String menuFlag) {
        List<DataDiv> dataDivs = entryTransferBill.stream().map(temp -> new DataDiv((DynamicObject)temp, new ValidateContext())).collect(Collectors.toList());
        try {
            List<Object> bemployeeIds = dataDivs.stream().map(temp -> temp.getDynamicObject().get("bemployee.id")).collect(Collectors.toList());
            TransferSubmitValidatorServiceImpl transferValidatorService = (TransferSubmitValidatorServiceImpl)ITransferSubmitValidatorService.getInstance();
            transferValidatorService.checkSubmitDataRule(TransferPermItermIdEnum.SUBMIT.itermId, PermissionValidateUtil.getAppId(), "hdm_transferbatch", TransferPermItermIdEnum.getSubmitMsg((String)"batch", (String)TransferOperateTypeEnum.SUBMIT.getName())).and(transferValidatorService.checkRepeat()).and(transferValidatorService.checkRepeatInDb(entryTransferBill)).and(ITransferValidatorService.getInstance().validateExteranlProfileAndChgRecord(bemployeeIds)).and(transferValidatorService.batchCheckRepeatInPerChg()).and(transferValidatorService.getStaffInfo()).and(transferValidatorService.validateSubmitPostpatternEffctDate("1", menuFlag, "hdm_transfer_org_createdate_submitvalidate", "hdm_transfer_company_createdate_submitvalidate")).and(ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"", (String)"", (Object[])new Object[0]))).test(dataDivs);
        }
        catch (Exception exception) {
            LOGGER.error("TransferValidatorServiceImpl batchValidate error exception:{}", (Object)exception.getMessage());
            dataDivs.forEach(temp -> temp.getValidatorContext().setResult("exception", exception.getMessage()));
        }
        return dataDivs;
    }

    @Override
    public boolean isMvpFieldChanged(DynamicObject newTransferBill, DynamicObject oldTransferBill) {
        return newTransferBill.getLong("arealityorg.id") != oldTransferBill.getLong("arealityorg.id") || newTransferBill.getLong("arealityjob.id") != oldTransferBill.getLong("arealityjob.id") || newTransferBill.getLong("arealityposition.id") != oldTransferBill.getLong("arealityposition.id") || !HRDateTimeUtils.dayEquals((Date)newTransferBill.getDate("realitydate"), (Date)oldTransferBill.getDate("realitydate"));
    }

    private List<HRExportHeadObject> getDetailExcelHead(Map<String, String> exportFieldMap) {
        List<HRExportHeadObject> excelHeadList = exportFieldMap.entrySet().stream().map(entry -> new HRExportHeadObject((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        excelHeadList.add(new HRExportHeadObject("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"BatchTransferValidatorServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0])));
        excelHeadList.add(new HRExportHeadObject("errormsg", ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"BatchTransferValidatorServiceImpl_27", (String)"hr-hdm-business", (Object[])new Object[0])));
        return excelHeadList;
    }

    private Map<String, Object> getDetailExcelData(DataDiv dataDiv, Map<String, String> exportFieldMap) {
        DynamicObject transferBill = dataDiv.getDynamicObject();
        ValidateContext validatorContext = dataDiv.getValidatorContext();
        HashMap<String, Object> data = new HashMap<String, Object>(32);
        exportFieldMap.forEach((key, value) -> {
            if ("postpattern".equals(key)) {
                data.put("postpattern", TransferPostpatternEnum.getEnumByCode((String)transferBill.getString("postpattern")).getName());
            } else {
                this.putValueToMap((String)key).accept(transferBill, data);
            }
        });
        if ("2".equals(validatorContext.getFlag())) {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"BatchTransferValidatorServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]));
            data.put("errormsg", String.join((CharSequence)"\uff1b", validatorContext.getValidateResult().values()));
        } else {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"BatchTransferValidatorServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        return data;
    }

    private BiConsumer<DynamicObject, Map<String, Object>> putValueToMap(String field) {
        return (transferBill, map) -> {
            Object value = transferBill.get(field);
            if (value == null) {
                return;
            }
            if (DynamicObject.class.equals(value.getClass())) {
                map.put(field, ((DynamicObject)transferBill.get(field)).getString("name"));
            } else {
                map.put(field, transferBill.get(field).toString());
            }
        };
    }

    private Map<String, String> getExportFieldMap() {
        LinkedHashMap<String, String> exportFieldMap = new LinkedHashMap<String, String>(32);
        exportFieldMap.put("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BatchTransferValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"BatchTransferValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("affaction", ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c", (String)"BatchTransferValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("transfertype", ResManager.loadKDString((String)"\u8c03\u52a8\u7c7b\u522b", (String)"BatchTransferValidatorServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("transferreason", ResManager.loadKDString((String)"\u8c03\u52a8\u539f\u56e0", (String)"BatchTransferValidatorServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("transferdate", ResManager.loadKDString((String)"\u8c03\u52a8\u65e5\u671f", (String)"BatchTransferValidatorServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("transferoutlastdate", ResManager.loadKDString((String)"\u8c03\u51fa\u90e8\u95e8\u6700\u540e\u5de5\u4f5c\u65e5", (String)"BatchTransferValidatorServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("aorg", ResManager.loadKDString((String)"\u8c03\u5165\u90e8\u95e8", (String)"BatchTransferValidatorServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("amanagescope", ResManager.loadKDString((String)"\u8c03\u5165\u6240\u5c5e\u7ba1\u7406\u8303\u56f4", (String)"BatchTransferValidatorServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("postpattern", ResManager.loadKDString((String)"\u4efb\u5c97\u6a21\u5f0f", (String)"BatchTransferValidatorServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("aposition", ResManager.loadKDString((String)"\u8c03\u5165\u5c97\u4f4d", (String)"BatchTransferValidatorServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("astposition", ResManager.loadKDString((String)"\u8c03\u5165\u6807\u51c6\u5c97\u4f4d", (String)"BatchTransferValidatorServiceImpl_11", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("ajob", ResManager.loadKDString((String)"\u8c03\u5165\u4efb\u804c\u804c\u4f4d", (String)"BatchTransferValidatorServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("abaselocation", ResManager.loadKDString((String)"\u8c03\u5165\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"BatchTransferValidatorServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("aevaluationjob", ResManager.loadKDString((String)"\u8c03\u52a8\u540e\u8bc4\u5b9a\u804c\u4f4d", (String)"BatchTransferValidatorServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("ajobgradescm", ResManager.loadKDString((String)"\u8c03\u52a8\u540e\u804c\u7b49\u65b9\u6848", (String)"BatchTransferValidatorServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("ajobgrade", ResManager.loadKDString((String)"\u8c03\u52a8\u540e\u804c\u7b49", (String)"BatchTransferValidatorServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("ajoblevel", ResManager.loadKDString((String)"\u8c03\u52a8\u540e\u804c\u7ea7", (String)"BatchTransferValidatorServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]));
        return exportFieldMap;
    }

    private String buildErrorReasonMsg(List<DataDiv> dataDivs) {
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        errorMsgMap.put("other", ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"BatchTransferValidatorServiceImpl_23", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("queryStaff", ResManager.loadKDString((String)"\u7f16\u5236\u5f02\u5e38", (String)"BatchTransferValidatorServiceImpl_24", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("bdepemp", ResManager.loadKDString((String)"\u6709\u91cd\u590d\u7684\u8c03\u52a8\u4eba\u5458\u3002", (String)"BatchTransferValidatorServiceImpl_25", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("crossinterface", ResManager.loadKDString((String)"\u4ea4\u53c9\u4e8b\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"BatchTransferValidatorServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("validatePartTimeAndDisPatch", ResManager.loadKDString((String)"\u4ea4\u53c9\u4e8b\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"BatchTransferValidatorServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("getChgRecord", ResManager.loadKDString((String)"\u4ea4\u53c9\u4e8b\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"BatchTransferValidatorServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]));
        errorMsgMap.put("transferdate", ResManager.loadKDString((String)"\u4ea4\u53c9\u4e8b\u52a1\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"BatchTransferValidatorServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]));
        HashSet tipsSet = new HashSet();
        dataDivs.stream().forEach(dataDiv -> {
            if ("1".equals(dataDiv.getValidatorContext().getFlag()) || tipsSet.size() == 4) {
                return;
            }
            Map<String, String> validateResult = dataDiv.getValidatorContext().getValidateResult();
            validateResult.entrySet().stream().forEach(entry -> {
                if (errorMsgMap.containsKey(entry.getKey())) {
                    tipsSet.add(errorMsgMap.get(entry.getKey()));
                } else {
                    tipsSet.add(errorMsgMap.get("other"));
                }
            });
        });
        return String.join((CharSequence)"\u3001", tipsSet);
    }
}

