/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.application.transfer.service.handler.HdmBaseDataHandler;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.domain.transfer.repository.LocationRepository;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillDomainService;

public class TransferBillDomainServiceImpl
implements ITransferBillDomainService {
    private static final Log LOGGER = LogFactory.getLog(TransferBillDomainServiceImpl.class);
    private static final LocationRepository LOCATION_REPOSITORY = LocationRepository.getInstance();
    private static final HdmBaseDataHandler HDMBASEDATA_HANDLER = HdmBaseDataHandler.getInstance();

    @Override
    public DynamicObject findTransferBillById(String selectProperties, Object pk) {
        return TransferBillRepository.getInstance().queryOne(selectProperties, pk);
    }

    @Override
    public long getCountryId(long employeeId) {
        LOGGER.info("HDM TransferBillDomainService getCountryId employeeId : {}", (Object)Long.toString(employeeId));
        DynamicObject baseLoaction = LOCATION_REPOSITORY.getLoacition(employeeId);
        DynamicObject location = (DynamicObject)HDMBASEDATA_HANDLER.getProperty(baseLoaction, "location");
        DynamicObject country = (DynamicObject)HDMBASEDATA_HANDLER.getProperty(location, "country");
        return country.getLong("id");
    }

    @Override
    public long getBaseLocationId(long employeeId) {
        LOGGER.info("HDM TransferBillDomainService getBaseLocationId employeeId :{}", (Object)Long.toString(employeeId));
        DynamicObject baseLoaction = LOCATION_REPOSITORY.getLoacition(employeeId);
        if (null == baseLoaction) {
            return 0L;
        }
        return baseLoaction.getLong("id");
    }

    @Override
    public Map<String, Object> getErmanfile(Long ermanfileId) {
        return (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{ermanfileId});
    }

    @Override
    public void terminateWorkFlow(DynamicObject dy) {
        String billId = dy.get("id").toString();
        Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)billId);
        if (!Objects.isNull(instanceId) && !instanceId.equals(0L)) {
            try {
                LOGGER.info("Transferbill terminate work flow , instanceid : [{}]", (Object)instanceId);
                try (TXHandle txHandle = TX.notSupported();){
                    IHSSCService.getInstance().terminateSSCTask(dy);
                    WorkflowServiceHelper.abandon((Long)instanceId);
                }
            }
            catch (Exception exception) {
                LOGGER.error((Throwable)exception);
            }
        }
    }
}

