/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillListService;

public class TransferBillListServiceImpl
implements ITransferBillListService {
    private static final String FIELD_ISLEGAL = "islegal";
    private static final String FIELD_REASON = "reason";
    private static final Map<String, String> AUDISTATUSMAPPING = new HashMap<String, String>();

    @Override
    public List<HRExportHeadObject> initCommitConfirmExcelHead(String keywords, String menuFlag, String confirmPageId) {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        String audistatus = "";
        if ("in".equals(menuFlag)) {
            audistatus = ResManager.loadKDString((String)"\u8c03\u5165", (String)"TransferBillListServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]);
        } else if ("out".equals(menuFlag)) {
            audistatus = ResManager.loadKDString((String)"\u8c03\u51fa", (String)"TransferBillListServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
        }
        headObjectList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TransferBillListServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"TransferBillListServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("org", ResManager.loadKDString((String)"\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7", (String)"TransferBillListServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject("transferstatus", ResManager.loadKDString((String)"\u8c03\u52a8\u72b6\u6001", (String)"TransferBillListServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0])));
        if ("hdm_deletecomfirm".equals(confirmPageId) && "apply".equals(menuFlag)) {
            headObjectList.add(new HRExportHeadObject("auditstatus", ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"TransferBillListServiceImpl_31", (String)"hr-hdm-business", (Object[])new Object[0])));
        } else {
            headObjectList.add(new HRExportHeadObject("auditstatus", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5ba1\u6279\u72b6\u6001", (String)"TransferBillListServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]), audistatus)));
        }
        headObjectList.add(new HRExportHeadObject(FIELD_ISLEGAL, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u662f\u5426\u53ef%s", (String)"TransferBillListServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]), keywords)));
        headObjectList.add(new HRExportHeadObject(FIELD_REASON, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0d\u53ef%s\u539f\u56e0", (String)"TransferBillListServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[0]), keywords)));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> initCommitConfirmExportData(List<DataDiv> transferBills, String menuFlag, String confirmPageId) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)(transferBills.size() << 1));
        for (int index = 0; index < transferBills.size(); ++index) {
            DynamicObject transferBill = transferBills.get(index).getDynamicObject();
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", transferBill.getLong("id"));
            exportData.put("name", transferBill.getString("person.name"));
            exportData.put("person.number", transferBill.getString("person.number"));
            String orgName = "out".equals(menuFlag) ? transferBill.getDynamicObject("bmainorg").getLocaleString("name").toString() : transferBill.getDynamicObject("org").getLocaleString("name").toString();
            exportData.put("org", orgName);
            exportData.put("transferstatus", TransferBillListServiceImpl.transferStatusMapping(transferBill.getString("transferstatus")));
            String status = "in".equals(menuFlag) ? transferBill.getString("transferinstatus") : ("out".equals(menuFlag) ? transferBill.getString("transferoutstatus") : ("hdm_deletecomfirm".equals(confirmPageId) && "apply".equals(menuFlag) ? transferBill.getString("billstatus") : transferBill.getString("auditstatus")));
            exportData.put("auditstatus", TransferBillListServiceImpl.audistatusMapping(status, menuFlag, confirmPageId));
            ValidateContext validateContext = transferBills.get(index).getValidatorContext();
            String level = validateContext.getResultLevel();
            if ("1".equals(level)) {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u5426", (String)"TransferBillListServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]));
                exportData.put(FIELD_REASON, validateContext.map2String());
            } else {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u662f", (String)"TransferBillListServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    @Override
    public List<HRExportHeadObject> inituncommitConfirmExcelHead() {
        ArrayList<HRExportHeadObject> headObjectList = new ArrayList<HRExportHeadObject>();
        headObjectList.add(new HRExportHeadObject("name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"TransferBillListServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u662f\u5426\u53ef\u64a4\u9500", (String)"TransferBillListServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0])));
        headObjectList.add(new HRExportHeadObject(FIELD_REASON, ResManager.loadKDString((String)"\u4e0d\u53ef\u64a4\u9500\u539f\u56e0", (String)"TransferBillListServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0])));
        return headObjectList;
    }

    @Override
    public List<Map<String, Object>> inituncommitConfirmExportData(DynamicObject[] quitBills, Map<Integer, String> errorlog) {
        ArrayList exportDataList = Lists.newArrayListWithExpectedSize((int)quitBills.length);
        for (int index = 0; index < quitBills.length; ++index) {
            DynamicObject quitBill = quitBills[index];
            HashMap exportData = Maps.newHashMapWithExpectedSize((int)16);
            exportData.put("id", quitBill.getLong("id"));
            if (errorlog.get(index) != null) {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u5426", (String)"TransferBillListServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]));
                exportData.put(FIELD_REASON, errorlog.get(index));
            } else {
                exportData.put(FIELD_ISLEGAL, ResManager.loadKDString((String)"\u662f", (String)"TransferBillListServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            exportDataList.add(exportData);
        }
        return exportDataList;
    }

    private static String transferStatusMapping(String transferStatus) {
        return AUDISTATUSMAPPING.get(transferStatus);
    }

    private static String audistatusMapping(String audistatus, String menuFlag, String confirmPageId) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        String title = "";
        if ("in".equals(menuFlag)) {
            title = ResManager.loadKDString((String)"\u8c03\u5165", (String)"TransferBillListServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]);
        } else if ("out".equals(menuFlag)) {
            ResManager.loadKDString((String)"\u8c03\u51fa", (String)"TransferBillListServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
        }
        if ("apply".equals(menuFlag)) {
            mapping.put("A", ResManager.loadKDString((String)"\u6682\u5b58", (String)"TransferBillListServiceImpl_27", (String)"hr-hdm-business", (Object[])new Object[0]));
            mapping.put("G", ResManager.loadKDString((String)"\u5f85\u91cd\u65b0\u63d0\u4ea4", (String)"TransferBillListServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]));
            if ("hdm_deletecomfirm".equals(confirmPageId)) {
                mapping.put("C", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5ba1\u6279\u901a\u8fc7", (String)"TransferBillListServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]), title));
            } else {
                mapping.put("C", ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"TransferBillListServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]));
                mapping.put("H", ResManager.loadKDString((String)"\u5904\u7406\u5b8c\u6210", (String)"TransferBillListServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        } else {
            mapping.put("A", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f85%s\u90e8\u95e8\u63d0\u4ea4\u3002", (String)"TransferBillListServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]), title));
            mapping.put("G", String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f85%s\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"TransferBillListServiceImpl_25", (String)"hr-hdm-business", (Object[])new Object[0]), title));
            mapping.put("C", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5ba1\u6279\u901a\u8fc7", (String)"TransferBillListServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]), title));
        }
        mapping.put("B", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u63d0\u4ea4", (String)"TransferBillListServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]), title));
        mapping.put("D", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5ba1\u6279\u4e2d", (String)"TransferBillListServiceImpl_22", (String)"hr-hdm-business", (Object[])new Object[0]), title));
        mapping.put("E", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5ba1\u6279\u4e0d\u901a\u8fc7\u3002", (String)"TransferBillListServiceImpl_23", (String)"hr-hdm-business", (Object[])new Object[0]), title));
        mapping.put("F", ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"TransferBillListServiceImpl_24", (String)"hr-hdm-business", (Object[])new Object[0]));
        mapping.put("LD", String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u5220\u9664", (String)"TransferBillListServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[0]), title));
        return (String)mapping.get(audistatus);
    }

    static {
        AUDISTATUSMAPPING.put("0", ResManager.loadKDString((String)"\u5f85\u8c03\u52a8", (String)"TransferBillListServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]));
        AUDISTATUSMAPPING.put("1", ResManager.loadKDString((String)"\u8c03\u52a8\u4e2d", (String)"TransferBillListServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]));
        AUDISTATUSMAPPING.put("2", ResManager.loadKDString((String)"\u8c03\u52a8\u5b8c\u6210", (String)"TransferBillListServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]));
        AUDISTATUSMAPPING.put("3", ResManager.loadKDString((String)"\u8c03\u52a8\u7ec8\u6b62", (String)"TransferBillListServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]));
        AUDISTATUSMAPPING.put("4", ResManager.loadKDString((String)"\u5f85\u751f\u6548", (String)"TransferBillListServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]));
    }
}

