/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.ResultBuilder;
import kd.hr.hdm.business.domain.transfer.helper.DirectLeaderHelper;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.HdmConsumer;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.WorkFlowFlagEnum;
import kd.hr.hdm.common.transfer.util.DyTransferUtil;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hdm.common.transfer.util.TransferPageHelperUtil;
import org.apache.commons.lang3.StringUtils;

public class TransferBillServiceImpl
implements ITransferBillService {
    private static final Log LOGGER = LogFactory.getLog(TransferBillServiceImpl.class);
    private static final HRBaseServiceHelper BASE_SERVICE_HELPER = new HRBaseServiceHelper("hdm_transferlayoutbill");
    private static final int INTERFACE_MAX_NUMBER = 500;
    private static final List<String> VIDFIELDLIST = new ArrayList<String>();
    private static final List<String> STRUCTVIDLIST = new ArrayList<String>();
    private static final List<String> POSITIONLIST = new ArrayList<String>();
    private static final List<String> JOBFIELDLIST = new ArrayList<String>();

    @Override
    public DynamicObject generate() {
        return BASE_SERVICE_HELPER.generateEmptyDynamicObject();
    }

    @Override
    public DynamicObjectCollection getSubmitTransferBillById(List<DynamicObject> dynamicObjects) {
        List<Long> collect = dynamicObjects.stream().map(temp -> temp.getLong("bdepemp.id")).collect(Collectors.toList());
        List<Long> id = dynamicObjects.stream().map(temp -> temp.getLong("id")).collect(Collectors.toList());
        return TransferBillRepository.getInstance().getSubmitTransferBillById(collect, id);
    }

    @Override
    public void secondSubmit(List<DynamicObject> dynamicObjects) {
        dynamicObjects.forEach(temp -> {
            temp.set("workflowflag", (Object)WorkFlowFlagEnum.SECONDSUBMIT.getFlag());
            this.setSecondApproveStatus((DynamicObject)temp);
        });
        this.update(dynamicObjects);
        ITransferPersonChangeService.getInstance().excuteBatchPersonChangeNotice(dynamicObjects, PersonChangeOperateTypeEnum.OPERATE_TYPE_PERSON_CHANGE_MODIFY);
    }

    @Override
    public void update(List<DynamicObject> dynamicObjects) {
        TransferBillRepository.getInstance().batchUpdate(dynamicObjects);
    }

    @Override
    public DynamicObject queryOne(String fields, long id) {
        return TransferBillRepository.getInstance().queryOne(fields, id);
    }

    @Override
    public DynamicObject[] query(String fields, QFilter[] qFilters) {
        return TransferBillRepository.getInstance().query(fields, qFilters);
    }

    @Override
    public void setOrgLongNumberAndVid(List<DynamicObject> dynamicObjects) {
        this.setOrgVid(dynamicObjects);
        this.setOrgStuctVid(dynamicObjects);
        this.setPositionVid(dynamicObjects);
        this.setStdPositionVid(dynamicObjects);
        this.setJobVid(dynamicObjects);
        ITransferBillService.getInstance().update(dynamicObjects);
    }

    @Override
    public List<Long> getOrgChargers(List<Long> orgIds) {
        LOGGER.info("start TransferBillServiceImpl invokeGetMainChargeInfoByOrg param: {}", orgIds);
        List<Map<String, Object>> maps = PersonExternalService.getInstance().invokeGetMainChargeInfoByOrg(orgIds);
        if (null == maps || maps.size() == 0) {
            LOGGER.error("TransferBillServiceImpl invokeGetMainChargeInfoByOrg result is null");
            return new ArrayList<Long>();
        }
        LOGGER.info("end TransferBillServiceImpl invokeGetMainChargeInfoByOrg result : {}", maps);
        List<Long> person = maps.stream().map(temp -> (Long)temp.get("person")).collect(Collectors.toList());
        return person;
    }

    @Override
    public List<Long> invokeGetSuperiorByRole(List<Long> roleIds) {
        LOGGER.info("start TransferBillServiceImpl invokeGetSuperiorByRole param: {}", roleIds);
        List<Map<String, Object>> maps = PersonExternalService.getInstance().invokeGetSuperiorByRole(roleIds);
        if (null == maps || maps.size() == 0) {
            LOGGER.error("TransferBillServiceImpl invokeGetSuperiorByRole result is null");
            return new ArrayList<Long>();
        }
        LOGGER.info("end TransferBillServiceImpl invokeGetSuperiorByRole result : {}", maps);
        List<Long> person = maps.stream().map(temp -> (Long)temp.get("person.id")).collect(Collectors.toList());
        return person;
    }

    @Override
    public List<Long> invokeGetSuperiorByRule(DynamicObject dyn) {
        try {
            long personId = ORM.create().genLongId("hrpi_person");
            HashMap dynVsIdMap = Maps.newHashMapWithExpectedSize((int)1);
            dynVsIdMap.put(dyn, personId);
            List<Map<String, Object>> infInParamList = DirectLeaderHelper.buildParamMap(new DynamicObject[]{dyn}, dynVsIdMap);
            LOGGER.info("start TransferBillServiceImpl invokeGetSuperiorByRule param: {}", infInParamList);
            Map<Long, List<Map<String, Object>>> idVsLeaderListMap = PersonExternalService.getInstance().invokeGetSuperiorByRule(infInParamList);
            if (CollectionUtils.isEmpty(idVsLeaderListMap)) {
                return Lists.newArrayListWithExpectedSize((int)1);
            }
            List<Map<String, Object>> leaderList = idVsLeaderListMap.getOrDefault(personId, Lists.newArrayListWithExpectedSize((int)0));
            List<Long> personIdList = leaderList.stream().filter(map -> Objects.nonNull(map.get("person.id"))).map(map -> (Long)map.get("person.id")).collect(Collectors.toList());
            LOGGER.info("end TransferBillServiceImpl invokeGetSuperiorByRule personIdList : {}", personIdList);
            return personIdList;
        }
        catch (Exception exception) {
            LOGGER.error("\u83b7\u53d6\u76f4\u63a5\u4e0a\u7ea7\u5931\u8d25\uff1a", (Throwable)exception);
            return Lists.newArrayListWithExpectedSize((int)1);
        }
    }

    @Override
    public void setAHrBu(DynamicObject transferbillDy) {
        Long orgId = transferbillDy.getLong("arealityorg.id");
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>();
        HashSet<Long> set = new HashSet<Long>();
        set.add(103010L);
        map.put(orgId, set);
        try {
            List<Map<String, Long>> maps = PersonExternalService.getInstance().invokeGetHrBuByBusinessType(map, 1010L);
            if (null == maps || maps.size() == 0) {
                LOGGER.info(MessageFormat.format("ITransferBillService invokeGetHrBuByBusinessType data is null orgId :[{0}]", orgId));
            } else {
                LOGGER.info("ITransferBillService invokeGetHrBuByBusinessType data info :[{}]", (Object)maps.toString());
                Long hrBuId = maps.get(0).get("hrBuId");
                transferbillDy.set("ahrbu", (Object)hrBuId);
            }
        }
        catch (Exception exception) {
            LOGGER.error("setAHrBu error:", (Throwable)exception);
        }
    }

    @Override
    public Map<String, Object> getEmpOrgrel(Long depempId) {
        Map orgRelMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"getEmpOrgrel", (Object[])new Object[]{depempId});
        return orgRelMap;
    }

    @Override
    public void setPositionVid(List<DynamicObject> transferBills) {
        Set<Long> positionIds = this.buildInvokePositionParam(transferBills);
        try {
            Map<String, Object> stringObjectMap = AdminOrgExternalService.getInstance().invokeQueryPositionHis(new ArrayList<Long>(positionIds), new Date());
            Map data = (Map)stringObjectMap.get("data");
            LOGGER.info("ITransferBillService start setPostioinVid inoke result info :  {} ", (Object)stringObjectMap.toString());
            if (null == data) {
                LOGGER.info("ITransferBillService setPositionVid data is null");
                return;
            }
            List hisdata = (List)data.get("hisdata");
            if (null == hisdata) {
                LOGGER.info("ITransferBillService setPositionVid hisdata is null");
                return;
            }
            Map<Long, Map> groupByBoid = hisdata.stream().collect(Collectors.toMap(temp -> (Long)temp.get("boid"), temp -> temp));
            block2: for (DynamicObject transferBill : transferBills) {
                for (String positionField : POSITIONLIST) {
                    Long positionId = this.getId(transferBill, positionField);
                    if (-1L == positionId) continue;
                    LOGGER.info("ITransferBillService setPostioinVid boid : {}", (Object)positionId);
                    Map result = groupByBoid.get(positionId);
                    if (result == null) {
                        LOGGER.info(MessageFormat.format("ITransferBillService setPostioinVid error : positionField:{0},positionId:{1}", positionField, String.valueOf(positionId)));
                        continue block2;
                    }
                    Object id = result.get("id");
                    LOGGER.info("ITransferBillService setPostioinVid fid : {}", id);
                    transferBill.set(positionField, id);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        LOGGER.info("end ITransferBillService setPostioinVid");
    }

    @Override
    public void setOrgStuctVid(List<DynamicObject> transferBills) {
        List<Long> longs = this.buildInvokeAdminOrgQueryInfoParam(transferBills);
        try {
            Map<String, Map<String, Object>> orgLongNumberVid = AdminOrgExternalService.getInstance().invokeAdminOrgStructQuery(longs);
            block2: for (DynamicObject transferBill : transferBills) {
                for (String structVidField : STRUCTVIDLIST) {
                    long orgId = this.getId(transferBill, structVidField);
                    if (-1L == orgId) continue;
                    if (orgLongNumberVid.get(String.valueOf(orgId)) == null) {
                        LOGGER.info(MessageFormat.format("invoke adminOrgStructQuery error : field:{0},orgId:{1}", structVidField, String.valueOf(orgId)));
                        continue block2;
                    }
                    this.setStructVid(String.valueOf(orgId), orgLongNumberVid, transferBill, String.format(Locale.ROOT, "%slonghis", structVidField));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    @Override
    public void setOrgVid(List<DynamicObject> transferBills) {
        List<Long> longs = this.buildInvokeAdminOrgQueryInfoParam(transferBills);
        try {
            Map<String, Map<String, Object>> orgLongNumberVid = AdminOrgExternalService.getInstance().invokeAdminOrgInfoQuery(longs);
            block2: for (DynamicObject dynamicObject : transferBills) {
                for (String vidField : VIDFIELDLIST) {
                    long orgId = this.getId(dynamicObject, vidField);
                    if (-1L == orgId) continue;
                    if (orgLongNumberVid.get(String.valueOf(orgId)) == null) continue block2;
                    this.setVid(String.valueOf(orgId), orgLongNumberVid, dynamicObject, vidField);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    private void setVid(String orgid, Map<String, Map<String, Object>> orgLongNumberVid, DynamicObject dynamicObject, String vidField) {
        Map<String, Object> stringObjectMap = orgLongNumberVid.get(orgid);
        if (stringObjectMap == null) {
            LOGGER.error("invoke adminOrgInfoQuery error : vid is null , orgid : {} ", (Object)orgid);
            return;
        }
        dynamicObject.set(vidField, stringObjectMap.get("vid"));
    }

    private void setStructVid(String orgid, Map<String, Map<String, Object>> orgLongNumberVid, DynamicObject dynamicObject, String strucVid) {
        Map<String, Object> stringObjectMap = orgLongNumberVid.get(orgid);
        if (stringObjectMap == null) {
            LOGGER.error("invoke adminOrgStructQuery error : strucVid is null , orgid : {}", (Object)orgid);
            return;
        }
        dynamicObject.set(strucVid, stringObjectMap.get("adminorgstructvid"));
    }

    private List<Map<String, Object>> buildInvokeAdminOrgParam(List<DynamicObject> dynamicObjects) {
        Set<Long> adminOrgIds = this.listAllInvokeAdminOrgId(dynamicObjects);
        ArrayList<Map<String, Object>> param = new ArrayList<Map<String, Object>>(adminOrgIds.size());
        for (Long adminOrgId : adminOrgIds) {
            HashMap<String, Comparable<Long>> temp = new HashMap<String, Comparable<Long>>(4);
            temp.put("id", adminOrgId);
            temp.put("date", new Date());
            param.add(temp);
        }
        return param;
    }

    private List<Long> buildInvokeAdminOrgQueryInfoParam(List<DynamicObject> dynamicObjects) {
        Set<Long> adminOrgIds = this.listAllInvokeAdminOrgId(dynamicObjects);
        ArrayList<Long> list = new ArrayList<Long>();
        list.addAll(adminOrgIds);
        return list;
    }

    private Set<Long> buildInvokePositionParam(List<DynamicObject> dynamicObjects) {
        HashSet<Long> positionId = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            for (String positionField : POSITIONLIST) {
                positionId.add(this.getId(dynamicObject, positionField));
            }
        }
        return positionId;
    }

    private List<Long> buildInvokeStdPositionParam(List<DynamicObject> dynamicObjects) {
        HashSet<Long> positionId = new HashSet<Long>(8);
        for (DynamicObject dynamicObject : dynamicObjects) {
            positionId.add(this.getId(dynamicObject, "bstposition"));
            positionId.add(this.getId(dynamicObject, "aplanstposition"));
            positionId.add(this.getId(dynamicObject, "astposition"));
            positionId.add(this.getId(dynamicObject, "arealitystposition"));
        }
        ArrayList<Long> objects = new ArrayList<Long>();
        objects.addAll(positionId);
        return objects;
    }

    private Set<Long> listAllInvokeAdminOrgId(List<DynamicObject> dynamicObjects) {
        HashSet<Long> orgIds = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            for (String vidField : VIDFIELDLIST) {
                long orgId = this.getId(dynamicObject, vidField);
                if (-1L == orgId) continue;
                orgIds.add(orgId);
            }
        }
        return orgIds;
    }

    private long getId(DynamicObject dynamicObject, String field) {
        Object result = dynamicObject.get(field);
        if (null == result) {
            return -1L;
        }
        if (result instanceof DynamicObject) {
            DynamicObject dy = (DynamicObject)result;
            return dy.getLong("id");
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        return -1L;
    }

    private void setSecondApproveStatus(DynamicObject dynamicObject) {
        String workflowflag = dynamicObject.getString("workflowflag");
        String originator = dynamicObject.getString("originator");
        LOGGER.info("TransferBillServiceImpl setApproveStatus workflowflag :{} , originator : {}", (Object)workflowflag, (Object)originator);
        if (originator.equals("1")) {
            dynamicObject.set("transferinstatus", (Object)TransferApproveStatusEnum.transferOutSubmit.getApproveStatus());
        } else if (originator.equals("2")) {
            dynamicObject.set("transferoutstatus", (Object)TransferApproveStatusEnum.transferInSubmit.getApproveStatus());
        } else {
            throw new KDBizException("get transfer originator error");
        }
    }

    @Override
    public void setStdPositionVid(List<DynamicObject> transferBills) {
        List<Long> stdPositionIds = this.buildInvokeStdPositionParam(transferBills);
        try {
            Map<String, Object> stdMap = AdminOrgExternalService.getInstance().invokeQueryStandardPosition(stdPositionIds);
            Object data = stdMap.get("data");
            if (null == data) {
                LOGGER.info("invoke setStdPositionVid result is null ");
                return;
            }
            List resultList = (List)data;
            Map<String, String> collect = resultList.stream().collect(Collectors.toMap(temp -> String.valueOf(temp.get("boid")), temp -> String.valueOf(temp.get("id"))));
            LOGGER.info("invoke setStdPositionVid result : {}", (Object)collect.toString());
            for (DynamicObject transferBill : transferBills) {
                String areleatystposition;
                String astposition;
                String aplanposition;
                long bpositionId = this.getId(transferBill, "bstposition");
                long aplanpositionId = this.getId(transferBill, "aplanstposition");
                long astpositionId = this.getId(transferBill, "astposition");
                long areleatystpositionId = this.getId(transferBill, "arealitystposition");
                String bposition = collect.get(String.valueOf(bpositionId));
                if (HRStringUtils.isNotEmpty((String)bposition)) {
                    transferBill.set("bstposition", (Object)Long.valueOf(bposition));
                    LOGGER.info("ITransferBillService.setStdPositionVid bstposition:{},fvid:{}", (Object)bpositionId, (Object)bposition);
                }
                if (HRStringUtils.isNotEmpty((String)(aplanposition = collect.get(String.valueOf(aplanpositionId))))) {
                    transferBill.set("aplanstposition", (Object)Long.valueOf(aplanposition));
                    LOGGER.info("ITransferBillService.setStdPositionVid aplanstposition:{},fvid:{}", (Object)aplanpositionId, (Object)aplanposition);
                }
                if (HRStringUtils.isNotEmpty((String)(astposition = collect.get(String.valueOf(astpositionId))))) {
                    transferBill.set("astposition", (Object)Long.valueOf(astposition));
                    LOGGER.info("ITransferBillService.setStdPositionVid astposition:{},fvid:{}", (Object)astpositionId, (Object)astposition);
                }
                if (!HRStringUtils.isNotEmpty((String)(areleatystposition = collect.get(String.valueOf(areleatystpositionId))))) continue;
                transferBill.set("arealitystposition", (Object)Long.valueOf(areleatystposition));
                LOGGER.info("ITransferBillService.setStdPositionVid arealitystposition:{},fvid:{}", (Object)areleatystpositionId, (Object)areleatystposition);
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    @Override
    public void setJobVid(List<DynamicObject> transferBills) {
        ArrayList<Long> jobIds = new ArrayList<Long>();
        transferBills.forEach(transferbill -> JOBFIELDLIST.forEach(jobField -> jobIds.add(this.getId((DynamicObject)transferbill, (String)jobField))));
        Map<String, Object> invokeResult = AdminOrgExternalService.getInstance().invokeSelectJobHisinfo(jobIds, new Date());
        if (null == invokeResult || 0 == invokeResult.size()) {
            return;
        }
        Object object = invokeResult.get("data");
        if (null == object) {
            return;
        }
        List data = (List)object;
        Map<Object, Object> jobBoidAndVid = data.stream().collect(Collectors.toMap(temp -> temp.get("boid"), temp -> temp.get("id"), (o1, o2) -> o1));
        transferBills.forEach(transferbill -> JOBFIELDLIST.forEach(jobField -> {
            Object jobvid = jobBoidAndVid.get(this.getId((DynamicObject)transferbill, (String)jobField));
            if (jobvid == null) {
                // empty if block
            }
            transferbill.set(jobField, jobvid);
        }));
    }

    @Override
    public void setAMainOrg(List<DynamicObject> transferBillDys) {
        HashSet<Long> set = new HashSet<Long>();
        set.add(103010L);
        Map<Long, Set<Long>> invokeParam = transferBillDys.stream().filter(temp -> TransferOriginatorEnum.OUT.getOriginator().equals(temp.getString("originator"))).collect(Collectors.toMap(temp -> Optional.ofNullable(temp.getLong("arealityorg.id")).orElseGet(() -> temp.getLong("arealitycompany.id")), temp -> set, (k1, k2) -> k1));
        List<Map<String, Long>> hrbuList = PersonExternalService.getInstance().invokeGetHrBuByBusinessType(invokeParam, 1010L);
        if (!ObjectUtils.isEmpty(hrbuList)) {
            Map<Long, Long> adminOrgIdMap = hrbuList.stream().collect(Collectors.toMap(temp -> (Long)temp.get("adminOrgId"), temp -> (Long)temp.get("hrBuId"), (k1, k2) -> k1));
            transferBillDys.forEach(transferBillDy -> {
                Long orgId = Optional.ofNullable(transferBillDy.getLong("arealityorg.id")).orElseGet(() -> transferBillDy.getLong("arealitycompany.id"));
                transferBillDy.set("org", adminOrgIdMap.get(orgId));
            });
        }
    }

    @Override
    public void setBMainOrg(DynamicObject transferBillDy) {
        String originator = transferBillDy.getString("originator");
        if (TransferOriginatorEnum.IN.getOriginator().equals(originator)) {
            transferBillDy.set("bmainorg", transferBillDy.get("ermanfile.org"));
        }
    }

    @Override
    public HdmConsumer<IFormView, IDataModel, Integer> setTransferBillDateRange() {
        return (view, model, rowIndex) -> {
            DynamicObject depempDy = (DynamicObject)model.getValue("bdepemp");
            if (!ObjectUtils.isEmpty((Object)depempDy)) {
                Map<String, Object> map = ITransferBillService.getInstance().getEmpOrgrel(depempDy.getLong("id"));
                DateTimeEdit planDate = (DateTimeEdit)view.getControl("plandate");
                Date tempDate = (Date)map.get("startdate");
                LOGGER.info("Invoke person interface return date : {}", (Object)tempDate);
                if (tempDate != null) {
                    planDate.setMinDate(tempDate);
                    DateTimeEdit transferOutLastDate = (DateTimeEdit)view.getControl("transferoutlastdate");
                    transferOutLastDate.setMinDate(tempDate);
                }
            }
        };
    }

    @Override
    public Map<String, Object> queryTransferBillInfoByBdepempIds(List<Long> bdepempIds, String[] statusFilters) {
        if (ObjectUtils.isEmpty(bdepempIds)) {
            return ResultBuilder.failed("1010", "bdepempIds are empty.").get();
        }
        if (bdepempIds.size() > 500) {
            return ResultBuilder.failed("1020", "Exceeded the maximum number of requests.").get();
        }
        try {
            DynamicObject[] dynamicObjects = TransferBillRepository.getInstance().queryTransferBillInfoByBdepempIds(bdepempIds, statusFilters);
            Map<Long, List> collect = Arrays.stream(dynamicObjects).collect(Collectors.toMap(o -> (Long)o.get("bdepemp.id"), dynamicObject -> {
                ArrayList<Map> resultList = new ArrayList<Map>();
                Map dyMap = DyTransferUtil.getPropMap((DynamicObject)dynamicObject, null, (boolean)true);
                if (!dyMap.isEmpty()) {
                    resultList.add(dyMap);
                }
                return resultList;
            }, (k1, k2) -> {
                k1.addAll(k2);
                return k1;
            }));
            return ResultBuilder.success(collect).get();
        }
        catch (Exception ex) {
            LOGGER.error("QueryTransferBillInfoByBdepempIds Exception\uff1a", (Throwable)ex);
            return ResultBuilder.failed("1030", "Query deal exception.").get();
        }
    }

    @Override
    public DynamicObject[] getMyTransferBills(long employeeId) {
        QFilter employeeFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter originatorQFilter = new QFilter("originator", "=", (Object)"4");
        return TransferBillRepository.getInstance().query(TransferPageHelperUtil.QUERYFIELD, new QFilter[]{employeeFilter, originatorQFilter});
    }

    @Override
    public void setAJobInfoEnable(IFormView formView) {
        IDataModel model = formView.getModel();
        Object jobOrg = model.getValue("ajoborg");
        Object jobGradeScm = model.getValue("ajobgradescm");
        Object jobLevelScm = model.getValue("ajoblevelscm");
        if (null == jobOrg) {
            formView.setEnable(Boolean.FALSE, new String[]{"aevaluationjob"});
        }
        if (null == jobGradeScm) {
            formView.setEnable(Boolean.FALSE, new String[]{"ajobgrade"});
        }
        if (null == jobLevelScm) {
            formView.setEnable(Boolean.FALSE, new String[]{"ajoblevel"});
        }
        try {
            DynamicObject evaluationJob = (DynamicObject)model.getValue("aevaluationjob");
            if (null == evaluationJob && jobOrg != null) {
                formView.setEnable(Boolean.TRUE, new String[]{"ajobgradescm", "ajoblevelscm"});
            } else if (null != evaluationJob) {
                long jobId = evaluationJob.getLong("id");
                List<Long> jobIds = Collections.singletonList(jobId);
                JobExternalService jobExternalService = JobExternalService.getInstance();
                Map<Long, Map<String, Object>> gradeResult = jobExternalService.getJobGradeRangeByJobId(jobIds, new Date());
                Map<String, Object> gradeInfoMap = gradeResult.get(jobId);
                Object gradeScmId = gradeInfoMap.get("jobGradeScmId");
                Map<Long, Map<String, Object>> levelResult = jobExternalService.getJobLevelRangeByJobId(jobIds, new Date());
                Map<String, Object> levelInfoMap = levelResult.get(jobId);
                Object levelScmId = levelInfoMap.get("jobLevelScmId");
                if (gradeScmId == null || (Long)gradeScmId == 0L) {
                    formView.setEnable(Boolean.FALSE, new String[]{"ajobgradescm", "ajobgrade"});
                } else {
                    formView.setEnable(Boolean.FALSE, new String[]{"ajobgradescm"});
                }
                if (levelScmId == null || (Long)levelScmId == 0L) {
                    formView.setEnable(Boolean.FALSE, new String[]{"ajoblevelscm", "ajoblevel"});
                } else {
                    formView.setEnable(Boolean.FALSE, new String[]{"ajoblevelscm"});
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("TransferBillServiceImpl setAJobInfoEnable error", (Throwable)e);
            formView.setEnable(Boolean.FALSE, new String[]{"ajobgradescm", "ajoblevelscm"});
        }
    }

    @Override
    public void setDefaultAEvaluationJobInfo(IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity();
        DynamicObject aEvaluationJob = dataEntity.getDynamicObject("aevaluationjob");
        DynamicObject aJobGrade = dataEntity.getDynamicObject("ajobgrade");
        DynamicObject aJobLevel = dataEntity.getDynamicObject("ajoblevel");
        if (aEvaluationJob == null && aJobGrade == null && aJobLevel == null) {
            dataModel.setValue("ajoborg", dataEntity.get("bjoborg"));
            DynamicObject bEvaluationJob = dataEntity.getDynamicObject("bevaluationjob");
            dataModel.setValue("aevaluationjob", (Object)bEvaluationJob);
            Object bJobGradeScm = dataEntity.get("bjobgradescm");
            dataModel.setValue("ajobgradescm", bJobGradeScm);
            Object bJobGrade = dataEntity.get("bjobgrade");
            dataModel.setValue("ajobgrade", bJobGrade);
            Object bJobLevelScm = dataEntity.get("bjoblevelscm");
            dataModel.setValue("ajoblevelscm", bJobLevelScm);
            Object bJobLevel = dataEntity.get("bjoblevel");
            dataModel.setValue("ajoblevel", bJobLevel);
            Object bJobClassText = dataEntity.get("bjobclasstext");
            dataModel.setValue("ajobclasstext", bJobClassText);
            if (null != bEvaluationJob) {
                Object jobScm = bEvaluationJob.get("jobscm");
                dataModel.setValue("ajobscm", jobScm);
                Object jobFamily = bEvaluationJob.get("jobfamily");
                dataModel.setValue("ajobfamily", jobFamily);
                Object jobClass = bEvaluationJob.get("jobclass");
                dataModel.setValue("ajobclass", jobClass);
                Object jobSeq = bEvaluationJob.get("jobseq");
                dataModel.setValue("ajobseq", jobSeq);
            }
        }
    }

    @Override
    public void setTransferInLabel(IFormView formView, Map<String, String> labelMap) {
        if (labelMap == null || labelMap.size() < 1) {
            return;
        }
        IDataModel model = formView.getModel();
        labelMap.forEach((labelName, labelValue) -> {
            DynamicObject dy;
            Label lblSource = (Label)formView.getControl(labelName);
            Object value = model.getValue(labelValue);
            if (value instanceof DynamicObject && StringUtils.isNotEmpty((CharSequence)(dy = (DynamicObject)value).getString("name"))) {
                lblSource.setText(dy.getString("name"));
            }
            if (value instanceof String) {
                lblSource.setText(String.valueOf(value));
            }
            if (HRObjectUtils.isEmpty((Object)value)) {
                lblSource.setText("-");
            }
        });
    }

    static {
        VIDFIELDLIST.add("bcompany");
        VIDFIELDLIST.add("borg");
        VIDFIELDLIST.add("aplancompany");
        VIDFIELDLIST.add("aplanorg");
        VIDFIELDLIST.add("acompany");
        VIDFIELDLIST.add("aorg");
        VIDFIELDLIST.add("arealitycompany");
        VIDFIELDLIST.add("arealityorg");
        VIDFIELDLIST.add("baffiliateorg");
        VIDFIELDLIST.add("aaffiliateorg");
        STRUCTVIDLIST.add("borg");
        STRUCTVIDLIST.add("aplanorg");
        STRUCTVIDLIST.add("aorg");
        STRUCTVIDLIST.add("arealityorg");
        STRUCTVIDLIST.add("baffiliateorg");
        STRUCTVIDLIST.add("aaffiliateorg");
        POSITIONLIST.add("aposition");
        POSITIONLIST.add("bposition");
        POSITIONLIST.add("aplanposition");
        POSITIONLIST.add("arealityposition");
        JOBFIELDLIST.add("ajob");
        JOBFIELDLIST.add("aplanjob");
        JOBFIELDLIST.add("arealityjob");
        JOBFIELDLIST.add("bjob");
        JOBFIELDLIST.add("aevaluationjob");
    }
}

