/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hdm.business.domain.transfer.dto.TransferCoordinationMsgDTO;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferCallBackService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.mq.sender.TransferStaffSend;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;

public class TransferCallBackServiceImpl
implements ITransferCallBackService {
    private static final Log LOGGER = LogFactory.getLog(TransferCallBackServiceImpl.class);

    @Override
    public boolean transferStatusValidate(long billId) {
        DynamicObject transferBill = TransferBillRepository.getInstance().queryOne("transferstatus", billId);
        String transferStatus = transferBill.getString("transferstatus");
        return !TransferStatusEnum.TRANSFER_FINISH.getStatus().equals(transferStatus) && !TransferStatusEnum.TRANSFER_TERM.getStatus().equals(transferStatus);
    }

    @Override
    public void executeFailCallBack(long billId) {
        ITransferPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
    }

    @Override
    public void executeSuccessCallBack(TransferCoordinationMsgDTO coordinationMsgDTO) {
        LOGGER.info("executeSuccessCallBack param:{}", (Object)coordinationMsgDTO);
        long billId = coordinationMsgDTO.getBillId();
        ITransferPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId);
        TransferStaffSend.sendStaffEffectMsg(Collections.singletonList(this.getData(billId)), coordinationMsgDTO.getNewDepEmpId());
        ITransferBillService.getInstance().setOrgLongNumberAndVid(Collections.singletonList(this.getData(billId)));
    }

    private DynamicObject getData(long billIds) {
        DynamicObject[] query = ITransferBillService.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), new QFilter("id", "=", (Object)billIds).toArray());
        return query[0];
    }
}

