/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParamMap;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.TransferStaffVO;
import kd.hr.hdm.business.domain.transfer.repository.PermissionRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmDialogValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferConfirmValidatorServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferCrossVerifyEnum;
import kd.hr.hdm.common.transfer.enums.TransferStaffEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;

public class TransferConfirmDialogValidatorServiceImpl
implements ITransferConfirmDialogValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferConfirmDialogValidatorServiceImpl.class);

    @Override
    public Predicate<DataDiv> validateAuth(String customParam) {
        return this.validateAuth(PermissionValidateUtil.getPermissionAppId(null), customParam);
    }

    @Override
    public Predicate<DataDiv> validateAuth(String appId, String customParam) {
        return dataDiv -> {
            if (!PermissionRepository.getInstance().checkOperatePermission(customParam, "HRQXX0136", appId)) {
                dataDiv.getValidatorContext().setResult("validateAuth", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u786e\u8ba4\u5230\u5c97\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"TransferSingleNotarIzeEdit_7", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateStaff(DynamicObject transferBill, IDataModel model) {
        return dataDiv -> {
            try {
                Date beforeDate = transferBill.getDate("realitydate");
                TransferConfirmValidatorServiceImpl confirmValidatorService = (TransferConfirmValidatorServiceImpl)ITransferConfirmValidatorService.getInstance();
                transferBill.set("realitydate", model.getValue("realitydate"));
                transferBill.set("ajob", model.getValue("ajob"));
                transferBill.set("aposition", model.getValue("arealityposition"));
                transferBill.set("astposition", model.getValue("arealitystposition"));
                Date afterDate = (Date)model.getValue("realitydate");
                String beforeDateString = (String)TransferCommonUtil.formatDate.apply(beforeDate);
                String afterDateString = (String)TransferCommonUtil.formatDate.apply(afterDate);
                boolean isUpdate = !beforeDateString.equals(afterDateString);
                LOGGER.info("TransferSingleNotarIzeEdit before date {}", (Object)beforeDateString);
                LOGGER.info("TransferSingleNotarIzeEdit after date {}", (Object)afterDateString);
                if (isUpdate) {
                    transferBill.set("realitydate", (Object)afterDate);
                    StaffResponse<StaffQueryOutParamMap> staffUseInfoDetail = TransferStaffService.getInstance().getStaffUseInfoDetail(TransferStaffEnum.UPDATE.name(), Collections.singletonList(transferBill));
                    if (staffUseInfoDetail == null) {
                        dataDiv.getValidatorContext().setResult("validateStaff", ResManager.loadKDString((String)"\u7f16\u5236\u67e5\u8be2\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TransferSingleNotarIzeEdit_10", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    StaffQueryOutParamMap staffUseInfoDetailData = (StaffQueryOutParamMap)staffUseInfoDetail.getData();
                    StaffQueryOutParam staffQueryOutParam = (StaffQueryOutParam)staffUseInfoDetailData.get((Object)TransferStaffVO.getQueryStaffKey(transferBill));
                    boolean allow = staffQueryOutParam.isAllow();
                    if (!allow) {
                        dataDiv.getValidatorContext().setResult("validateStaff", staffQueryOutParam.getReasonList().toString());
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.error("validateStaff error: ", (Throwable)e);
                return false;
            }
        };
    }

    @Override
    public Predicate<DataDiv> perChgCrossValidate(DynamicObject transferBill, IDataModel model) {
        return dataDiv -> {
            Map<String, Object> crossResultMap = this.excutePerChgCrossValidate(transferBill, TransferCrossVerifyEnum.CROSS_CONFIRM);
            switch ((String)crossResultMap.get("key")) {
                case "999": 
                case "1": {
                    model.setValue("realitydate", null);
                    dataDiv.getValidatorContext().setResult("perChgCrossValidate", (String)crossResultMap.get("info"));
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateReality(DynamicObject transferBill, IDataModel model) {
        return dataDiv -> {
            Date value = (Date)model.getValue("realitydate");
            if (value.after((Date)TransferCommonUtil.GETZEROCLOCK.get())) {
                dataDiv.getValidatorContext().setResult("validateReality", ResManager.loadKDString((String)"\u201c\u786e\u8ba4\u5230\u5c97\u201d\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5b9e\u9645\u8c03\u52a8\u65e5\u671f\u4e3a\u672a\u6765\u65e5\u671f\u7684\u6570\u636e\u3002", (String)"TransferSingleNotarIzeEdit_8", (String)"hr-hdm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateEmpOrgel(DynamicObject transferBill, IDataModel model) {
        return dataDiv -> {
            DynamicObject depempDy = transferBill.getDynamicObject("bdepemp");
            Date value = (Date)model.getValue("realitydate");
            if (Objects.nonNull(depempDy)) {
                Map<String, Object> map = ITransferBillService.getInstance().getEmpOrgrel(depempDy.getLong("id"));
                Date tempDate = (Date)map.get("startdate");
                if (tempDate == null) {
                    return true;
                }
                if (value.before(tempDate)) {
                    ResManager.loadKDString((String)"\u5b9e\u9645\u8c03\u52a8\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8be5\u4eba\u5458\u5f53\u524d\u4efb\u804c\u7ecf\u5386\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"TransferSingleNotarIzeEdit_14", (String)"hr-hdm-formplugin", (Object[])new Object[0]);
                    return false;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateBillStatus() {
        return dataDiv -> {
            DynamicObject transferbill = dataDiv.getDynamicObject();
            String transferStatus = transferbill.getString("transferstatus");
            if (HRStringUtils.equals((String)transferStatus, (String)"3")) {
                dataDiv.getValidatorContext().setResult("validateBillStatus", String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u7684\u8c03\u52a8\u6d41\u7a0b\u5df2\u7ec8\u6b62\u3002", (String)"TransferConfirmDialogValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), transferbill.getString("person.name")));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> validateSavePostpatternEffctDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDiv -> ITransferValidatorService.getInstance().validateBusinessFieldEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig).test(Collections.singletonList(dataDiv));
    }

    @Override
    public Map<String, Object> excutePerChgCrossValidate(DynamicObject ermanfile, TransferCrossVerifyEnum corss) {
        return ITransferPersonChangeService.getInstance().excutePerChgCrossValidate(ermanfile, TransferCrossVerifyEnum.CROSS_CONFIRM);
    }
}

