/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.service.ITransferDeleteValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.HrcsExternalService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferSubmitValidatorServiceImpl;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;

public class TransferDeleteValidatorServiceImpl
implements ITransferDeleteValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferSubmitValidatorServiceImpl.class);

    @Override
    public Predicate<List<DataDiv>> checkDeleteDataRule(String permItemId, String appid, String pageId, String errorMsg) {
        return dataDivs -> {
            List id = dataDivs.stream().map(temp -> temp.getDynamicObject().get("id")).collect(Collectors.toList());
            QFilter[] ids = new QFilter("id", "in", id).toArray();
            Map<Object, Boolean> hasPermission = HrcsExternalService.getInstance().invokeMatchDataRule(RequestContext.get().getCurrUserId(), appid, pageId, permItemId, ids, null);
            LOGGER.info("TransferValidatorServiceImpl checkDataRule invoke result : {}", (Object)hasPermission.toString());
            dataDivs.forEach(dataDiv -> {
                DynamicObject dynamicObject = dataDiv.getDynamicObject();
                Object key = dynamicObject.get("id");
                Boolean result = (Boolean)hasPermission.get(key);
                if (result == null) {
                    LOGGER.error("TransferValidatorServiceImpl checkDataRule error the value is null for id : {} ", (Object)key.toString());
                }
                if (!result.booleanValue()) {
                    dataDiv.getValidatorContext().setResult("dataRule", errorMsg);
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateDelete(String origin) {
        return dataDivs -> {
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                DynamicObject dynamicObject = temp.getDynamicObject();
                String string = dynamicObject.getString("originator");
                if (origin.equals("out")) {
                    String auditstatus = dynamicObject.getString("transferoutstatus");
                    boolean islegale = HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus());
                    if (!islegale) {
                        temp.getValidatorContext().setResult("transferoutstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u8c03\u51fa\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferDeleteValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                    if (string.equals("2") && temp.getValidatorContext().getValidateResult().size() < 1) {
                        temp.getValidatorContext().setResult("transferoutstatus", ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u8d77\u65b9\u53ef\u4ee5\u5220\u9664\u3002", (String)"TransferDeleteValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                } else if (origin.equals("in")) {
                    String auditstatus = dynamicObject.getString("transferinstatus");
                    boolean islegale = HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus());
                    if (!islegale) {
                        temp.getValidatorContext().setResult("transferoutstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u8c03\u5165\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferDeleteValidatorServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                    if (string.equals("1") && temp.getValidatorContext().getValidateResult().size() < 1) {
                        temp.getValidatorContext().setResult("transferoutstatus", ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u8d77\u65b9\u53ef\u4ee5\u5220\u9664\u3002", (String)"TransferDeleteValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                } else {
                    String billStatus = dynamicObject.getString("billstatus");
                    boolean islegale = HRStringUtils.equals((String)billStatus, (String)"A");
                    if (!islegale) {
                        temp.getValidatorContext().setResult("transferoutstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"TransferDeleteValidatorServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]));
                    }
                }
            });
            return true;
        };
    }
}

