/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonCallBackService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.TransferStaffService;
import kd.hr.hdm.business.mq.sender.TransferStaffSend;

public class TransferPersonCallBackServiceImpl
implements ITransferPersonCallBackService {
    private static final Log LOGGER = LogFactory.getLog(TransferPersonCallBackServiceImpl.class);
    private static final String CROSS_MSG_PUBNO = "MP20220402000104";
    private static final String IN_MSG_PUBNO = "MP20220402000103";
    private static final String MSGSYN_ACTIONID = "msgSynActionId";
    private static final String RECORD_ID = "recordId";
    private static final String BILL_ID = "billId";

    @Override
    public String executeFailCallBack(DynamicObject transferBill, JSONObject jsonObject, long billId) {
        ITransferPersonChangeService.getInstance().excutePersonChangeEffectFail(billId);
        return "";
    }

    @Override
    public String executeSuccessCallBack(DynamicObject exceptionRecordDy, JSONObject chgResult, long billId, JSONArray messageArray) {
        ITransferPersonChangeService.getInstance().excutePersonChangeEffectSuccess(billId);
        DynamicObject transferBill = this.getData(billId);
        this.sendMsg(chgResult, billId);
        TransferStaffSend.sendStaffEffectMsg(Collections.singletonList(this.getData(billId)), chgResult.getLong("newDepEmpId"));
        this.setVid(transferBill);
        return "";
    }

    private void sendMsg(JSONObject chgResult, Long billId) {
        DynamicObject transferBillDy = ITransferBillService.getInstance().queryOne("id,transferclassify,person,affaction,bmanagescope,bdepemp,bemployee", billId);
        long affactionId = transferBillDy.getLong("affaction.id");
        String msgNo = this.getMsgNo(affactionId);
        if (msgNo == null) {
            return;
        }
        Map<String, Object> messageContent = this.getMessageContent(chgResult, transferBillDy);
        String message = String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"TransferAckPersonChangeCallBack_0", (String)"hr-hdm-business", (Object[])new Object[0]), transferBillDy.getString("person.name"), transferBillDy.getString("affaction.name"));
        this.effectTransferProducer(String.valueOf(chgResult.get((Object)BILL_ID)), message, chgResult.getLong(MSGSYN_ACTIONID), messageContent, msgNo);
    }

    private void effectTransferProducer(String msgNumber, String msgTitle, Long actionId, Map<String, Object> content, String msgId) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>(8);
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", msgId);
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("actionId", actionId);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(content));
        LOGGER.info("PerChgResultCallBack------effectQuitProducer----messageParms: {}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private Map<String, Object> getMessageContent(JSONObject chgResult, DynamicObject transferBill) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("affactionId", transferBill.getDynamicObject("affaction").getLong("id"));
        params.put("chgcategoryId", transferBill.getDynamicObject("affaction.chgcategory").getLong("id"));
        params.put(RECORD_ID, chgResult.get((Object)RECORD_ID));
        return params;
    }

    private String getMsgNo(long affactionId) {
        if (1050L == affactionId || 201050L == affactionId) {
            return IN_MSG_PUBNO;
        }
        if (1060L == affactionId || 201060L == affactionId) {
            return CROSS_MSG_PUBNO;
        }
        LOGGER.info("TransferAckPersonChangeCallBack sendMsg error incorrect transferclassify \u3010{}\u3011", (Object)affactionId);
        return null;
    }

    private void setVid(DynamicObject transferbillDy) {
        ITransferBillService.getInstance().setOrgLongNumberAndVid(Collections.singletonList(transferbillDy));
    }

    private DynamicObject getData(long datas) {
        DynamicObject[] query = ITransferBillService.getInstance().query(TransferStaffService.getInstance().getSelectProperties(), new QFilter("id", "=", (Object)datas).toArray());
        return query[0];
    }
}

