/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.TipsUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.handler.TransferHPFSTemplatePropertyHandler;
import kd.hr.hdm.business.domain.transfer.repository.TransferBatchRepository;
import kd.hr.hdm.business.domain.transfer.repository.TransferBillRepository;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPersonChangeService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonalChangeExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PositionExternalService;
import kd.hr.hdm.business.mq.sender.TransferAckPersonChangeSend;
import kd.hr.hdm.common.transfer.enums.PersonChangeOperateTypeEnum;
import kd.hr.hdm.common.transfer.enums.TransferCrossVerifyEnum;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;
import org.apache.commons.collections4.CollectionUtils;

public class TransferPersonChangeServiceImpl
implements ITransferPersonChangeService {
    private static final Log LOGGER = LogFactory.getLog(TransferPersonChangeServiceImpl.class);
    private static final String QUERT_FIELDS = "transferform,ajob,arealityjob,auditstatus,id,billno,person_id,bemployee_id,bdepemp_id,ermanfile_id,bmanagescope,confirmperson_id,arealitycompany,transferstatus,arealityorg,arealityposition,affaction.isnewchgaction,arealitystposition,arealitybaselocation,bcmp_id,transferdate,realitydate,transferclassify,affaction_id,bcompany,transfereffectstatus,arealitydarkpositionid,postpattern,originator,arealityrolerel,transfertype,mid,aevaluationjob,bevaluationjob,ajobclasstext,bjobclasstext,ahrbu";
    private static final String KEY_ORG = "org";
    private static final String KEY_STANDARD_POSITION = "standardposition";
    private static final String KEY_JOB = "job";
    private static final String KEY_DARK_POSITION = "position";
    private static final String KEY_WORKROLE = "workrole";
    private static final String KEY_WORKROLE_ID = "workrole.id";
    private static final String KEY_EFFECT = "effect";
    private static final String KEY_USER = "user";
    private static final String KEY_RESULT_CODE = "code";
    private static final String KEY_RESULT_ERROR_MSG = "ErrMsg";
    private static final String KEY_RESULT_DATA = "data";
    private static final String KEY_BILLNOSOURCE = "billNoSource";
    private static final String CODE_SUCCESS = "200";
    private static final String MSGPUGNO_DISDARKPOSITION = "MP20220809000767";
    private static final Long ACTIONID_DISDARKPOSITION = 101320L;
    private static final Integer MAX_COUNT = 1000;
    private static final Long PROMPT_OUT_QUITVALID = 1393352890122414080L;
    private static final Long PROMPT_IN_QUITVALID = 1393351463236970496L;
    private static final Long PROMPT_APPLY_QUITVALID = 1568755792176253952L;
    private static final Long PROMPT_CONFIRM_QUITVALID = 1393354713050818560L;
    private static final Long PROMPT_ADD_DATE_QUITVALID = 1442607466306222080L;
    private static final Long PROMPT_EDIT_DATE_QUITVALID = 1442611772363262976L;
    private static final Long PROMPT_ALLOW_DATE_QUITVALID = 1449323106924532736L;

    @Override
    public void excutePersonChangeCrossValidate(DataDiv dataDiv) {
        if (!this.checkDataDiv(dataDiv)) {
            LOGGER.error("checkDataDiv result fail, ecutePersonChangeOverlapCheck exit");
            return;
        }
        DynamicObject transferBill = dataDiv.getDynamicObject();
        String billNo = transferBill.getString("billno");
        Map<String, Object> params = this.buildPersonChangeOverlapCheckParam(dataDiv);
        Map<String, Object> perChgResult = PersonalChangeExternalService.getInstance().invokerPerChgCrossValidate(params);
        LOGGER.info("excutePersonChangeOverlapCheck, the billNo is : [{}],params is : [{}],perChgResult is : [{}]", new Object[]{billNo, params, perChgResult});
        if (!this.checkPerChgCrossValidateResult(perChgResult)) {
            dataDiv.getValidatorContext().setResult("crossinterface", "Invoke crossinterface Exception.", "9");
            LOGGER.error("excutePersonChangeOverlapCheck result is error , the billId is : [{}], the result is :[{}]", (Object)billNo, perChgResult);
            return;
        }
        List crossValidates = (List)perChgResult.get(KEY_RESULT_DATA);
        this.chooseCrossValidate(dataDiv, crossValidates);
    }

    @Override
    public void excuteBatchPersonChangeCrossValidate(List<DataDiv> dataDivs) {
        if (ObjectUtils.isEmpty(dataDivs)) {
            LOGGER.error("excuteBatchPersonChangeCrossValidate request param is empty");
            return;
        }
        Map depempMap = dataDivs.stream().collect(Collectors.groupingBy(dataDiv -> {
            DynamicObject bdepemp = dataDiv.getDynamicObject().getDynamicObject("bdepemp");
            return bdepemp.getLong("id");
        }, Collectors.toMap(dataValidate -> {
            if (dataValidate.getFlag() == DataDiv.DataType.singleBill.getFlag()) {
                return dataValidate.getDynamicObject().getString("billno");
            }
            return dataValidate.getDynamicObject().getString("ebillno");
        }, Function.identity())));
        List<Map<String, Object>> params = dataDivs.stream().map(dataDiv -> this.buildPersonChangeOverlapCheckParam((DataDiv)dataDiv)).collect(Collectors.toList());
        Map<String, Object> resultMap = PersonalChangeExternalService.getInstance().invokerBatchPerChgCrossValidate(params);
        if (!this.checkPerChgCrossValidateResult(resultMap)) {
            dataDivs.forEach(dataDiv -> dataDiv.getValidatorContext().setResult("crossinterface", "Invoke crossinterface Exception.", "9"));
            LOGGER.error("invokerBatchPerChgCrossValidate result is error , the result is :[{}]", resultMap);
            return;
        }
        Map crossValidateMap = (Map)resultMap.get(KEY_RESULT_DATA);
        for (Map.Entry crossValidateResult : crossValidateMap.entrySet()) {
            if (ObjectUtils.isEmpty(crossValidateResult.getValue())) continue;
            List crossList = (List)crossValidateResult.getValue();
            Map<String, List<Map>> crossMap = crossList.stream().collect(Collectors.groupingBy(cross -> String.valueOf(cross.get(KEY_BILLNOSOURCE))));
            Long depempId = (Long)crossValidateResult.getKey();
            Map validateMap = depempMap.get(depempId);
            for (Map.Entry<String, List<Map>> cross2 : crossMap.entrySet()) {
                List<Map<String, Object>> crossValidates = cross2.getValue();
                DataDiv dataDiv2 = (DataDiv)validateMap.get(cross2.getKey().toString());
                if (ObjectUtils.isEmpty(crossValidates) || ObjectUtils.isEmpty((Object)dataDiv2)) continue;
                this.chooseCrossValidate(dataDiv2, crossValidates);
            }
        }
    }

    private void chooseCrossValidate(DataDiv dataDiv, List<Map<String, Object>> crossValidates) {
        DynamicObject transferBill = dataDiv.getDynamicObject();
        long transferTypeId = transferBill.getLong("transfertype.id");
        if (transferTypeId == 1563784896172811264L) {
            this.dealBatchCrossValidate(dataDiv, crossValidates);
        } else {
            this.dealCrossValidate(dataDiv, crossValidates);
        }
    }

    @Override
    public void excutePersonChangeNotice(DynamicObject transferBill, PersonChangeOperateTypeEnum operateTypeEnum) {
        try {
            DynamicObject transferBillData = this.getTransferBillData(transferBill.getLong("id"));
            DynamicObject transferBillTemp = null != transferBillData ? transferBillData : transferBill;
            TransferAckPersonChangeSend.sendNoticePersonChangeMsg(transferBillTemp, operateTypeEnum.getValue());
        }
        catch (Exception e) {
            LOGGER.error("notify person change error, the billId is :[{}], the errorMsg is :[{}]", (Object)transferBill.getLong("id"), (Object)e.getMessage());
        }
    }

    @Override
    public void excuteBatchPersonChangeNotice(List<DynamicObject> transferBills, PersonChangeOperateTypeEnum operateTypeEnum) {
        if (transferBills.size() == 1) {
            this.excutePersonChangeNotice(transferBills.get(0), operateTypeEnum);
            return;
        }
        Integer operate = operateTypeEnum.getValue();
        List<Long> transferIds = transferBills.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> transferList = this.batchGetTransferBillDataCollections(transferIds);
        transferList.forEach(transfer -> TransferAckPersonChangeSend.sendNoticePersonChangeMsg(transfer, operate));
    }

    @Override
    public void excutePersonChangeEffect(Long billId, PersonChangeOperateTypeEnum operateTypeEnum) throws Exception {
        DynamicObject transferBillData = this.getTransferBillData(billId);
        if (HRObjectUtils.isEmpty((Object)transferBillData)) {
            LOGGER.error("Transfer bill data does not exist, the billId is {}", (Object)billId);
            return;
        }
        if ("1".equals(transferBillData.getString("transfereffectstatus"))) {
            LOGGER.warn("the transfer billId\uff1a[{}] personnel affairs are changing, please do not repeat the operation", (Object)billId);
            return;
        }
        this.setJobAllClass(transferBillData);
        this.setAHrBu(transferBillData);
        this.dealPositionInfo(transferBillData);
        boolean isNewChgation = transferBillData.getBoolean("affaction.isnewchgaction");
        if (!isNewChgation) {
            transferBillData.set("transfereffectstatus", (Object)"1");
        }
        ITransferBillService.getInstance().update(Collections.singletonList(transferBillData));
        this.sendAckPersonChangeMsg(transferBillData, operateTypeEnum);
    }

    private void sendAckPersonChangeMsg(DynamicObject transferBill, PersonChangeOperateTypeEnum operateTypeEnum) {
        boolean isNewChgation = transferBill.getBoolean("affaction.isnewchgaction");
        if (isNewChgation) {
            DynamicObject[] bills = RepositoryUtils.queryDynamicObjects((String)"hdm_transferbasebill", null, (QFilter[])new QFilter[]{new QFilter("id", "=", transferBill.getPkValue())});
            TransferHPFSTemplatePropertyHandler.getInstance().saveHPFSEffectMessage(bills);
        } else {
            TransferAckPersonChangeSend.sendAckPersonChangeMsg(transferBill, operateTypeEnum.getValue());
        }
    }

    @Override
    public void excutePersonChangeEffectFail(Long billId) {
        LOGGER.info("excutePersonChangeEffectFail param:{}", (Object)billId);
        DynamicObject transferBillData = this.getTransferBillData(billId);
        Long darkPosition = transferBillData.getLong("arealitydarkpositionid.id");
        this.disableDarkPosition(darkPosition, billId);
        transferBillData.set("transfereffectstatus", (Object)"3");
        ITransferBillService.getInstance().update(Collections.singletonList(transferBillData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excutePersonChangeEffectSuccess(Long billId) {
        DynamicObject transferBillData = this.getTransferBillData(billId);
        transferBillData.set("transfereffectstatus", (Object)"2");
        transferBillData.set("transferstatus", (Object)"2");
        transferBillData.set("auditstatus", (Object)"H");
        try {
            this.enableTransferInDarkPosition(transferBillData);
            Long darkPosition = this.getTransferOutDarkPositionId(transferBillData);
            this.disableDarkPosition(darkPosition, billId);
        }
        catch (Exception e) {
            LOGGER.error("update position error, the billId is: [{}], the error msg is :[{}]", transferBillData.get("id"), (Object)e.getMessage());
        }
        try (TXHandle tx = TX.required();){
            ITransferBillService.getInstance().update(Collections.singletonList(transferBillData));
            if (TransferTypeEnum.BATCH.getType().equals(transferBillData.getLong("transfertype.id"))) {
                DynamicObject batchTransferBill = TransferBatchRepository.getInstance().queryOne("entryentity.transferstatus,transferednumber,auditstatus", transferBillData.getLong("mid.id"));
                batchTransferBill.set("transferednumber", (Object)(batchTransferBill.getInt("transferednumber") + 1));
                this.updateBatchTransferBillStatus(batchTransferBill);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Map<String, Object> excutePerChgCrossValidate(DynamicObject transferBill, TransferCrossVerifyEnum cross) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        this.setResultInfo(result, "-1", "Init date cross validate result.");
        Map<String, Object> params = this.buildPersonChangeOverlapCheckParam(transferBill);
        Map<String, Object> perChgResult = PersonalChangeExternalService.getInstance().invokerPerChgCrossValidate(params);
        if (!this.checkPerChgCrossValidateResult(perChgResult)) {
            LOGGER.error("excutePerChgCrossValidate invoke is error , the result is :[{}]", perChgResult);
            this.setResultInfo(result, "999", "excutePerChgCrossValidate result is error.");
            return result;
        }
        List crossList = (List)perChgResult.get(KEY_RESULT_DATA);
        if (CollectionUtils.isEmpty((Collection)crossList)) {
            this.setResultInfo(result, CODE_SUCCESS, "excutePerChgCrossValidate result pass.");
            return result;
        }
        boolean isTip = true;
        ArrayList<String> notAllowedNameList = new ArrayList<String>(crossList.size());
        String personName = transferBill.getString("person.name");
        boolean isSigle = 1 == crossList.size();
        for (Map validateResult : crossList) {
            CrossActionEnum actionEnum = CrossActionEnum.getAction(validateResult.get("actionId").toString());
            LOGGER.info("CrossValidate Interface no match actionId is : [{}]", (Object)validateResult.get("actionId").toString());
            String crossValidRes = (String)validateResult.get("crossValidRes");
            isTip = "0".equals(crossValidRes);
            if (CrossActionEnum.QUIT == actionEnum && (isSigle || !"0".equals(crossValidRes))) {
                this.handleQuitPerChgTip(result, crossValidRes, personName, validateResult, cross);
            } else {
                String msg;
                String billNo;
                String actionName;
                String quitEffect;
                block8: {
                    Date quitEffectDate = new Date((Long)validateResult.get("effectTime"));
                    quitEffect = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
                    actionName = (String)validateResult.get("actionName");
                    billNo = (String)validateResult.get("billNo");
                    if (isTip) {
                        if (isSigle) {
                            msg = ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u8d77\u8c03\u52a8\u3002", (String)"TransferPersonChangeServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]);
                            break block8;
                        } else {
                            notAllowedNameList.add(MessageFormat.format("{0}\uff08{1}\uff09", actionName, billNo));
                            continue;
                        }
                    }
                    msg = TransferCrossVerifyEnum.CROSS_TRANSFERBILL_SAVE_NEW == cross ? ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u65e5\u671f\u6216\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"TransferPersonChangeServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u65e5\u671f\u3002", (String)"TransferPersonChangeServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]);
                }
                this.setResultInfo(result, crossValidRes, MessageFormat.format(msg, personName, actionName, quitEffect, billNo));
            }
            if (isTip) continue;
        }
        if (!isTip) return result;
        if (isSigle) return result;
        if (notAllowedNameList.isEmpty()) return result;
        StringBuilder perchgNameStringBuilder = new StringBuilder();
        notAllowedNameList.stream().forEach(notAllowedName -> {
            perchgNameStringBuilder.append((String)notAllowedName);
            perchgNameStringBuilder.append('\u3001');
        });
        perchgNameStringBuilder.deleteCharAt(perchgNameStringBuilder.length() - 1);
        String tipStr = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u6709\u201c{1}\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u8d77\u8c03\u52a8\u3002", (String)"TransferPersonChangeServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]), personName, perchgNameStringBuilder.toString());
        this.setResultInfo(result, "0", tipStr);
        return result;
    }

    private void handleQuitPerChgTip(Map<String, Object> result, String crossValidRes, String personName, Map<String, Object> validateResult, TransferCrossVerifyEnum cross) {
        Long promptId = 0L;
        switch (cross) {
            case CROSS_TRANSFERBILL_SAVE_EDIT: 
            case CROSS_INFOCHANGE: {
                promptId = PROMPT_EDIT_DATE_QUITVALID;
                break;
            }
            case CROSS_TRANSFERBILL_SAVE_NEW: {
                promptId = PROMPT_ADD_DATE_QUITVALID;
                break;
            }
            case CROSS_TRANSFERBILL_IN: {
                promptId = PROMPT_IN_QUITVALID;
                break;
            }
            case CROSS_TRANSFERBILL_OUT: {
                promptId = PROMPT_OUT_QUITVALID;
                break;
            }
            case CROSS_TRANSFER_APPLY: {
                promptId = PROMPT_APPLY_QUITVALID;
                break;
            }
            case CROSS_CONFIRM: {
                promptId = PROMPT_CONFIRM_QUITVALID;
                break;
            }
        }
        if (!promptId.equals(0L)) {
            String tipStr = !promptId.equals(PROMPT_CONFIRM_QUITVALID) && HRStringUtils.equals((String)"0", (String)crossValidRes) ? TipsUtil.getPromptById(PROMPT_ALLOW_DATE_QUITVALID) : TipsUtil.getPromptById(promptId);
            Date quitEffectDate = new Date((Long)validateResult.get("effectTime"));
            String quitEffect = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
            this.setResultInfo(result, crossValidRes, MessageFormat.format(tipStr, personName, quitEffect, validateResult.get("billNo")));
        } else {
            this.setResultInfo(result, "999", "NO match prompt info errors.");
        }
    }

    @Override
    public void updateBatchTransferBillStatus(DynamicObject batchTransferBill) {
        DynamicObjectCollection transferBillEntry = batchTransferBill.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : transferBillEntry) {
            String transferStatus = item.getString("transferstatus");
            if (transferStatus.equals(TransferStatusEnum.TRANSFER_FINISH.getStatus()) || transferStatus.equals(TransferStatusEnum.TRANSFER_TERM.getStatus())) continue;
            return;
        }
        batchTransferBill.set("auditstatus", (Object)"H");
        TransferBillRepository.getInstance().update(batchTransferBill);
    }

    private void setResultInfo(Map<String, Object> result, String key, String info) {
        result.put("key", key);
        result.put("info", info);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dealCrossValidate(DataDiv dataDiv, List<Map<String, Object>> crossValidates) {
        boolean isTip = true;
        ArrayList<String> notAllowedNameList = new ArrayList<String>(crossValidates.size());
        DynamicObject transferBill = dataDiv.getDynamicObject();
        String personName = transferBill.getString("person.name");
        boolean isSigle = 1 == crossValidates.size();
        for (Map<String, Object> validateResult : crossValidates) {
            CrossActionEnum actionEnum = CrossActionEnum.getAction(validateResult.get("actionId").toString());
            String crossValidRes = (String)validateResult.get("crossValidRes");
            isTip = "0".equals(crossValidRes);
            if (CrossActionEnum.QUIT == actionEnum && (isSigle || !"0".equals(crossValidRes))) {
                this.dealQuitCrossValidate(dataDiv, validateResult);
            } else {
                String tipStr;
                String billNo;
                String actionName;
                String quitEffect;
                block7: {
                    Date quitEffectDate = new Date((Long)validateResult.get("effectTime"));
                    quitEffect = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
                    actionName = (String)validateResult.get("actionName");
                    billNo = (String)validateResult.get("billNo");
                    if (isTip) {
                        if (isSigle) {
                            tipStr = ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u8d77\u8c03\u52a8\u3002", (String)"TransferPersonChangeServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]);
                            break block7;
                        } else {
                            notAllowedNameList.add(MessageFormat.format("{0}\uff08{1}\uff09", actionName, billNo));
                            continue;
                        }
                    }
                    tipStr = ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u65e5\u671f\u3002", (String)"TransferPersonChangeServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]);
                }
                dataDiv.getValidatorContext().setResult("transferdate", MessageFormat.format(tipStr, personName, actionName, quitEffect, billNo), crossValidRes);
            }
            if (isTip) continue;
        }
        if (isTip && !isSigle && !notAllowedNameList.isEmpty()) {
            StringBuilder perchgNameStringBuilder = new StringBuilder();
            notAllowedNameList.stream().forEach(notAllowedName -> {
                perchgNameStringBuilder.append((String)notAllowedName);
                perchgNameStringBuilder.append('\u3001');
            });
            perchgNameStringBuilder.deleteCharAt(perchgNameStringBuilder.length() - 1);
            String tipStr = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5df2\u6709\u201c{1}\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d1\u8d77\u8c03\u52a8\u3002", (String)"TransferPersonChangeServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]), personName, perchgNameStringBuilder.toString());
            dataDiv.getValidatorContext().setTips("transferdate", tipStr);
        }
    }

    private void dealBatchCrossValidate(DataDiv dataDiv, List<Map<String, Object>> crossValidates) {
        for (Map<String, Object> validateResult : crossValidates) {
            String crossValidRes = (String)validateResult.get("crossValidRes");
            if ("0".equals(crossValidRes)) continue;
            Date quitEffectDate = new Date((Long)validateResult.get("effectTime"));
            String quitTime = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
            String tipStr = MessageFormat.format(ResManager.loadKDString((String)"\u5458\u5de5\u201c{0}\u201d\u5df2\u5904\u4e8e{1}\u6d41\u7a0b\u4e2d\uff0c{1}\u65e5\u671f\u4e3a\u201c{2}\u201d\uff0c{1}\u5355\u636e\u7f16\u53f7\u4e3a\u201c{3}\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u65e5\u671f\u3002", (String)"TransferPersonChangeServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0]), dataDiv.getDynamicObject().getString("person.name"), validateResult.get("actionName"), quitTime, validateResult.get("billNo"));
            dataDiv.getValidatorContext().setResult("transferdate", tipStr);
            break;
        }
    }

    private void dealQuitCrossValidate(DataDiv dataDiv, Map<String, Object> validateResult) {
        DynamicObject transferBill = dataDiv.getDynamicObject();
        if (null != validateResult.get("billNo")) {
            String tipstr = "";
            String quitEffect = "";
            String transferStatus = transferBill.getString("transferstatus");
            String personName = transferBill.getString("person.name");
            String crossValidRes = (String)validateResult.get("crossValidRes");
            long quitEffectTime = (Long)validateResult.get("effectTime");
            Date quitEffectDate = new Date(quitEffectTime);
            quitEffect = HRDateTimeUtils.formatDate((Date)quitEffectDate, null);
            String originalFlag = transferBill.getString("originator");
            if ("4".equals(transferStatus)) {
                tipstr = TipsUtil.getPromptById(PROMPT_CONFIRM_QUITVALID);
            } else if (HRStringUtils.equals((String)"0", (String)crossValidRes)) {
                tipstr = TipsUtil.getPromptById(PROMPT_ALLOW_DATE_QUITVALID);
            } else if (HRStringUtils.equals((String)TransferOriginatorEnum.IN.getOriginator(), (String)originalFlag)) {
                tipstr = TipsUtil.getPromptById(PROMPT_IN_QUITVALID);
            } else if (HRStringUtils.equals((String)TransferOriginatorEnum.OUT.getOriginator(), (String)originalFlag)) {
                tipstr = TipsUtil.getPromptById(PROMPT_OUT_QUITVALID);
            } else if (HRStringUtils.equals((String)TransferOriginatorEnum.APPLY.getOriginator(), (String)originalFlag)) {
                tipstr = TipsUtil.getPromptById(PROMPT_APPLY_QUITVALID);
            } else if (HRStringUtils.equals((String)TransferOriginatorEnum.MY.getOriginator(), (String)originalFlag)) {
                tipstr = TipsUtil.getPromptById(PROMPT_EDIT_DATE_QUITVALID);
            }
            dataDiv.getValidatorContext().setResult("transferdate", MessageFormat.format(tipstr, personName, quitEffect, validateResult.get("billNo")), crossValidRes);
        }
    }

    private boolean checkPerChgCrossValidateResult(Map<String, Object> perChgResult) {
        if (ObjectUtils.isEmpty(perChgResult)) {
            return false;
        }
        return (Boolean)perChgResult.get("success");
    }

    private boolean checkDataDiv(DataDiv dataDiv) {
        if (ObjectUtils.isEmpty((Object)dataDiv) || ObjectUtils.isEmpty((Object)dataDiv.getDynamicObject())) {
            dataDiv.getValidatorContext().setResult("all", ResManager.loadKDString((String)"\u8c03\u52a8\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"TransferPersonChangeServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]), "9");
            return false;
        }
        return true;
    }

    private Map<String, Object> buildPersonChangeOverlapCheckParam(DataDiv dataDiv) {
        DynamicObject transferBill = dataDiv.getDynamicObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dataDiv.getFlag() == DataDiv.DataType.singleBill.getFlag()) {
            params.put("billNo", transferBill.getString("billno"));
        } else {
            params.put("billNo", transferBill.getString("ebillno"));
        }
        params.put("actionId", transferBill.getString("affaction.id"));
        params.put("effectTime", this.getTransferTimestamp(transferBill));
        params.put("personId", transferBill.getString("person.id"));
        params.put("employeeId", transferBill.getString("bemployee.id"));
        params.put("managingScopeId", transferBill.getString("bmanagescope.id"));
        params.put("depEmpId", transferBill.getString("bdepemp.id"));
        return params;
    }

    private Map<String, Object> buildPersonChangeOverlapCheckParam(DynamicObject transferBill) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("billNo", transferBill.getString("billno"));
        params.put("actionId", transferBill.getString("affaction.id"));
        params.put("effectTime", this.getTransferTimestamp(transferBill));
        params.put("personId", transferBill.getString("person.id"));
        params.put("employeeId", transferBill.getString("bemployee.id"));
        params.put("managingScopeId", transferBill.getString("bmanagescope.id"));
        params.put("depEmpId", transferBill.getString("bdepemp.id"));
        return params;
    }

    private long getTransferTimestamp(DynamicObject transferBill) {
        if (ObjectUtils.isEmpty((Object)transferBill)) {
            return 0L;
        }
        return null == transferBill.getString("realitydate") ? transferBill.getDate("transferdate").getTime() : transferBill.getDate("realitydate").getTime();
    }

    private void enableTransferInDarkPosition(DynamicObject transferBill) {
        Long darkPosition = transferBill.getLong("arealitydarkpositionid.id");
        if (ObjectUtils.isEmpty((Object)darkPosition)) {
            return;
        }
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put(KEY_DARK_POSITION, darkPosition);
        LOGGER.info("enableTransferInDarkPosition begin, the billId is : [{}], the request param is : [{}]", (Object)transferBill.getLong("id"), (Object)Collections.singletonList(paramMap).toString());
        Map<String, Object> resultMap = PositionExternalService.getInstance().invokerEnableDarkPosition(Collections.singletonList(paramMap));
        LOGGER.info("enableTransferInDarkPosition end, the billId is : [{}], the response is : [{}]", (Object)transferBill.getLong("id"), resultMap);
    }

    private Long getTransferOutDarkPositionId(DynamicObject transferBill) {
        long ermanfileID = transferBill.getLong("ermanfile_id");
        List<Map<String, Object>> ermanfileList = PersonExternalService.getInstance().invokeGetCardFields(Collections.singletonList(ermanfileID));
        Map<String, Object> ermanfile = ermanfileList.get(0);
        if (ObjectUtils.isEmpty(ermanfile) || null == ermanfile.get("darkposition_id")) {
            return 0L;
        }
        return Long.parseLong(ermanfile.get("darkposition_id").toString());
    }

    private void disableDarkPosition(Long darkPosition, Long billId) {
        if (darkPosition == null || darkPosition == 0L) {
            LOGGER.info("disableDarkPosition end, the darkPosition is empty, the billId is : [{}]", (Object)billId);
            return;
        }
        LOGGER.info("disableDarkPosition begin, the billId is : [{}], the darkPosition is : [{}]", (Object)billId, (Object)darkPosition);
        this.sendDisableDarkPositionMsg(billId, darkPosition);
    }

    private void sendDisableDarkPositionMsg(Long billId, Long darkPosition) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>();
        HashMap<String, List<Long>> content = new HashMap<String, List<Long>>();
        content.put(KEY_DARK_POSITION, Collections.singletonList(darkPosition));
        String msgTitle = ResManager.loadKDString((String)"\u8c03\u52a8\u5931\u6548\u6697\u5c97", (String)"TransferPersonChangeServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]);
        String msgDesc = ResManager.loadKDString((String)"\u8c03\u52a8\u5931\u6548\u6697\u5c97\u901a\u77e5", (String)"TransferPersonChangeServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]);
        String msgNumber = String.format("%1$s_%2$s", billId, System.currentTimeMillis());
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", MSGPUGNO_DISDARKPOSITION);
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("msgDesc", msgDesc);
        messageParams.put("msgTag", msgTitle);
        messageParams.put("actionId", ACTIONID_DISDARKPOSITION);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(content));
        LOGGER.info("disableDarkPosition----messageParms: {}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private void dealPositionInfo(DynamicObject transferBill) {
        String postpattern = transferBill.getString("postpattern");
        if ("1".equals(postpattern)) {
            DynamicObject position = (DynamicObject)transferBill.get("arealityposition");
            if (!ObjectUtils.isEmpty((Object)position.get(KEY_WORKROLE))) {
                transferBill.set("arealityrolerel", position.get(KEY_WORKROLE_ID));
            }
        } else if ("0".equals(postpattern) || "2".equals(postpattern)) {
            this.createTransferInDarkPosition(transferBill);
        } else {
            LOGGER.error("arealitystposition and arealityposition is empty, the billId is :[{}]", (Object)transferBill.getLong("id"));
        }
    }

    private void createTransferInDarkPosition(DynamicObject transferBill) {
        Map<String, Object> resultMap;
        String postpattern = transferBill.getString("postpattern");
        Map<String, Object> paramMap = this.buildTransferInDarkPositionParam(transferBill, postpattern);
        LOGGER.info("createTransferInDarkPosition begin, the request param is : [{}]", (Object)Collections.singletonList(paramMap).toString());
        if ("0".equals(postpattern)) {
            resultMap = PositionExternalService.getInstance().invokerAddDarkPosition(Collections.singletonList(paramMap));
        } else if ("2".equals(postpattern)) {
            resultMap = PositionExternalService.getInstance().invokerAddDarkPositionByJob(Collections.singletonList(paramMap));
        } else {
            LOGGER.error("createTransferInDarkPosition error no match postpattern : [{}]", (Object)postpattern);
            throw new KDBizException("createTransferInDarkPosition error no match postpattern");
        }
        LOGGER.info("createTransferInDarkPosition end,  the response is : [{}]", resultMap);
        if (this.isAddDarkPositionFail(resultMap)) {
            if (resultMap != null && resultMap.get(KEY_RESULT_ERROR_MSG) != null) {
                LOGGER.error("Create dark position error, the billId is :[{}], the error message is :[{}]", (Object)transferBill.getLong("id"), resultMap.get(KEY_RESULT_ERROR_MSG));
            } else {
                LOGGER.error("Create dark position error, the billId is :[{}], the result is empty", (Object)transferBill.getLong("id"));
            }
            return;
        }
        List dataList = (List)resultMap.get(KEY_RESULT_DATA);
        Map resultData = (Map)dataList.get(0);
        transferBill.set("arealityrolerel", resultData.get(KEY_WORKROLE));
        transferBill.set("arealitydarkpositionid", resultData.get(KEY_DARK_POSITION));
        if ("2".equals(postpattern)) {
            transferBill.set("arealitystposition", resultData.get(KEY_STANDARD_POSITION));
        }
    }

    private boolean isAddDarkPositionFail(Map<String, Object> resultMap) {
        return !this.isRequestPositionSuccess(resultMap) && ObjectUtils.isEmpty(((Map)((List)resultMap.get(KEY_RESULT_DATA)).get(0)).get(KEY_DARK_POSITION));
    }

    private boolean isRequestPositionSuccess(Map<String, Object> resultMap) {
        return !ObjectUtils.isEmpty(resultMap) && CODE_SUCCESS.equals(resultMap.get(KEY_RESULT_CODE)) && !ObjectUtils.isEmpty((Object)resultMap.get(KEY_RESULT_DATA));
    }

    private Map<String, Object> buildTransferInDarkPositionParam(DynamicObject transferBill, String postPattern) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(KEY_USER, transferBill.getLong("person_id"));
        paramMap.put(KEY_EFFECT, transferBill.getDate("realitydate"));
        if (postPattern.equals("0")) {
            paramMap.put(KEY_STANDARD_POSITION, transferBill.getLong("arealitystposition.id"));
        } else if (postPattern.equals("2")) {
            paramMap.put(KEY_JOB, transferBill.getLong("arealityjob.id"));
        }
        paramMap.put(KEY_ORG, transferBill.getLong("arealityorg.id"));
        return paramMap;
    }

    private DynamicObject getTransferBillData(long billId) {
        return ITransferBillService.getInstance().queryOne(QUERT_FIELDS, billId);
    }

    private List<DynamicObject> batchGetTransferBillDataCollections(List<Long> billIds) {
        ArrayList<DynamicObject> data = new ArrayList<DynamicObject>(billIds.size());
        if (ObjectUtils.isEmpty(billIds)) {
            return data;
        }
        int start = 0;
        int limit = 0;
        int queryCount = (int)Math.ceil((double)billIds.size() / (double)MAX_COUNT.intValue());
        for (int i = 0; i < queryCount; ++i) {
            start = i * MAX_COUNT;
            limit = billIds.size() - start > MAX_COUNT ? MAX_COUNT : billIds.size() - start;
            List ids = billIds.stream().skip(start).limit(limit).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] bills = ITransferBillService.getInstance().query(QUERT_FIELDS, new QFilter[]{filter});
            data.addAll(Arrays.asList(bills));
        }
        return data;
    }

    private void setAHrBu(DynamicObject transferbillDy) {
        ITransferBillService.getInstance().setAHrBu(transferbillDy);
    }

    private void setJobAllClass(DynamicObject transferbill) {
        DynamicObject aevaluationJob = transferbill.getDynamicObject("aevaluationjob");
        DynamicObject bevaluationJob = transferbill.getDynamicObject("bevaluationjob");
        if (aevaluationJob == null && bevaluationJob == null) {
            return;
        }
        long ajobId = 0L;
        if (aevaluationJob != null) {
            ajobId = aevaluationJob.getLong("id");
        }
        long bjobId = 0L;
        if (bevaluationJob != null) {
            bjobId = bevaluationJob.getLong("id");
        }
        Map<Long, String> jobClassInfoMap = JobExternalService.getInstance().invokeGetJobClassLongNameByJobAndBsed(Arrays.asList(ajobId, bjobId), new Date());
        String ajobAllClass = jobClassInfoMap.getOrDefault(ajobId, "");
        String bjobAllClass = jobClassInfoMap.getOrDefault(bjobId, "");
        transferbill.set("ajobclasstext", (Object)ajobAllClass);
        transferbill.set("bjobclasstext", (Object)bjobAllClass);
    }

    static enum CrossActionEnum implements Supplier<CrossActionEnum>
    {
        OTHER("9999"),
        QUIT("1020");

        private final String actionId;

        private CrossActionEnum(String actionId) {
            this.actionId = actionId;
        }

        public String getActionId() {
            return this.actionId;
        }

        static CrossActionEnum getAction(String action) {
            CrossActionEnum[] enumConstants = (CrossActionEnum[])CrossActionEnum.class.getEnumConstants();
            return Arrays.asList(enumConstants).stream().filter(actionEnum -> HRStringUtils.equals((String)action, (String)actionEnum.getActionId())).findFirst().orElseGet(OTHER);
        }

        @Override
        public CrossActionEnum get() {
            return this;
        }
    }
}

