/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferPostPatternService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferConfirmValidatorServiceImpl;

public class TransferPostPatternServiceImpl
implements ITransferPostPatternService {
    private static final Log LOGGER = LogFactory.getLog(TransferPostPatternServiceImpl.class);

    @Override
    public void setPositionMustInputByPostPattern(DynamicObject transferBill, IDataModel model, IFormView formView) {
        if (Objects.isNull(transferBill)) {
            return;
        }
        try {
            TransferConfirmValidatorServiceImpl confirmValidatorService = (TransferConfirmValidatorServiceImpl)ITransferConfirmValidatorService.getInstance();
            String originator = transferBill.getString("originator");
            LOGGER.info("###TransferPostPatternServiceImpl.setPositionMustInputByPostPattern, originator:{}", (Object)originator);
            Map<String, Boolean> fieldConfigMap = confirmValidatorService.getDevConfigFieldsByOriginator(originator);
            BasedataEdit aPositionTextEdit = (BasedataEdit)formView.getControl("aposition");
            BasedataEdit astPositionTextEdit = (BasedataEdit)formView.getControl("astposition");
            BasedataEdit aJobTextEdit = (BasedataEdit)formView.getControl("ajob");
            aPositionTextEdit.setMustInput(false);
            astPositionTextEdit.setMustInput(false);
            aJobTextEdit.setMustInput(false);
            String postPattern = model.getDataEntity().getString("postpattern");
            if ("0".equals(postPattern)) {
                Boolean astPositionConfigValue = fieldConfigMap.get("astposition");
                astPositionTextEdit.setMustInput(Objects.nonNull(astPositionConfigValue) ? astPositionConfigValue : true);
                return;
            }
            if ("1".equals(postPattern)) {
                Boolean aPositionConfigValue = fieldConfigMap.get("aposition");
                aPositionTextEdit.setMustInput(Objects.nonNull(aPositionConfigValue) ? aPositionConfigValue : true);
                return;
            }
            if ("2".equals(postPattern)) {
                Boolean aJobConfigValue = fieldConfigMap.get("ajob");
                aJobTextEdit.setMustInput(Objects.nonNull(aJobConfigValue) ? aJobConfigValue : true);
            }
        }
        catch (Exception e) {
            LOGGER.error("###TransferPostPatternServiceImpl.setPositionMustInputByPostPattern, error:", (Throwable)e);
        }
    }
}

