/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.PermissionValidateUtil;
import kd.hr.hdm.business.domain.transfer.entity.DataDiv;
import kd.hr.hdm.business.domain.transfer.entity.ValidateContext;
import kd.hr.hdm.business.domain.transfer.service.ITransferBillService;
import kd.hr.hdm.business.domain.transfer.service.ITransferConfirmValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferDeleteValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferInfoChangeValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferTerminalValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferUnSubmitValidatorService;
import kd.hr.hdm.business.domain.transfer.service.ITransferValidatorService;
import kd.hr.hdm.business.domain.transfer.service.external.AdminOrgExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.DevParamConfigExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.JobExternalService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferConfirmValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferDeleteValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferInfoChangeValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferSubmitValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferTerminalServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.impl.TransferUnSubmitValidatorServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.validator.Validator;
import kd.hr.hdm.common.transfer.enums.TransferApproveStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferOriginatorEnum;
import kd.hr.hdm.common.transfer.enums.TransferPermItermIdEnum;
import kd.hr.hdm.common.transfer.enums.TransferStatusEnum;
import kd.hr.hdm.common.transfer.enums.TransferTypeEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class TransferValidatorServiceImpl
implements ITransferValidatorService {
    private static final Log LOGGER = LogFactory.getLog(TransferValidatorServiceImpl.class);

    public List<DataDiv> validate(List<DynamicObject> dynamicObjects) {
        return dynamicObjects.stream().map(temp -> new DataDiv((DynamicObject)temp, new ValidateContext())).collect(Collectors.toList());
    }

    @Override
    public Function<String, List<DataDiv>> batchValidate(List<DynamicObject> dynamicObjects) {
        return this.submitValidate(dynamicObjects, "1");
    }

    @Override
    public Function<String, List<DataDiv>> batchSubmitEffectValidate(List<DynamicObject> dynamicObjects) {
        return this.submitValidate(dynamicObjects, "4");
    }

    @Override
    public List<DataDiv> batchConfirmValidate(List<DynamicObject> dynamicObjects) {
        List<DataDiv> dataDivs = this.validate(dynamicObjects);
        TransferConfirmValidatorServiceImpl transferValidatorService = (TransferConfirmValidatorServiceImpl)ITransferConfirmValidatorService.getInstance();
        dataDivs.stream().forEach(dataDiv -> transferValidatorService.confirmValidate(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8c03\u52a8\u72b6\u6001\u4e3a\u201c\u5f85\u751f\u6548\u201d\u4e14\u540c\u6b65\u72b6\u6001\u4e0d\u4e3a\u201c\u540c\u6b65\u4e2d\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u786e\u8ba4\u5230\u5c97\u201d\u64cd\u4f5c\u3002", (String)"TransferValidatorServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[0])).and(transferValidatorService.synchronizeStatusValidate()).and(transferValidatorService.quitValidate()).test((DataDiv)dataDiv));
        return dataDivs;
    }

    @Override
    public List<DataDiv> batchInfoChangealidate(List<DynamicObject> dynamicObjects) {
        List<DataDiv> dataDivs = this.validate(dynamicObjects);
        TransferInfoChangeValidatorServiceImpl transferValidatorService = (TransferInfoChangeValidatorServiceImpl)ITransferInfoChangeValidatorService.getInstance();
        dataDivs.stream().forEach(dataDiv -> transferValidatorService.confirmInfoChangeValidate(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8c03\u52a8\u72b6\u6001\u4e3a\u201c\u5f85\u751f\u6548\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u4fe1\u606f\u53d8\u66f4\u201d\u64cd\u4f5c\u3002", (String)"TransferValidatorServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0])).and(transferValidatorService.infochangeValidate(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u8c03\u52a8\u72b6\u6001\u4e3a\u201c\u5f85\u751f\u6548\u201d\u4e14\u540c\u6b65\u7ed3\u679c\u4e0d\u4e3a\u201c\u540c\u6b65\u4e2d\u201d\u7684\u6570\u636e\u8fdb\u884c\u201c\u4fe1\u606f\u53d8\u66f4\u201d\u64cd\u4f5c\u3002", (String)"TransferValidatorServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[0]))).test((DataDiv)dataDiv));
        return dataDivs;
    }

    @Override
    public List<DataDiv> batchUnsubmitValidate(List<DynamicObject> dynamicObjects, String origin, String appId) {
        List<DataDiv> dataDivs;
        block2: {
            dataDivs = null;
            try {
                dataDivs = this.validate(dynamicObjects);
                String pageId = this.getPageId(origin);
                TransferUnSubmitValidatorServiceImpl transferValidatorService = (TransferUnSubmitValidatorServiceImpl)ITransferUnSubmitValidatorService.getInstance();
                List<DataDiv> finalDataDivs = dataDivs;
                transferValidatorService.checkUnSubmitDataRule(TransferPermItermIdEnum.UNSUBMIT.itermId, appId, pageId, TransferPermItermIdEnum.getUnSubmitMsg((String)origin)).test(finalDataDivs);
                transferValidatorService.unsubmitValidate(origin).test(finalDataDivs);
            }
            catch (Exception e) {
                LOGGER.error("TransferValidatorServiceImpl batchUnsubmitValidate error exception:{}", (Object)e.getMessage());
                if (dataDivs == null) break block2;
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("exception", e.getMessage()));
            }
        }
        return dataDivs;
    }

    @Override
    public Function<String, List<DataDiv>> batchSecondSubmitValidate(List<DynamicObject> dynamicObjects) {
        return menuFlag -> {
            List<DataDiv> dataDivs = this.validate(dynamicObjects);
            dataDivs.forEach(temp -> this.getPredicate((String)menuFlag).test((DataDiv)temp));
            return dataDivs;
        };
    }

    @Override
    public List<DataDiv> batchDeleteValidate(List<DynamicObject> asList, String origin, String appId) {
        List<DataDiv> validate;
        block2: {
            validate = null;
            try {
                validate = this.validate(asList);
                String pageId = this.getPageId(origin);
                TransferDeleteValidatorServiceImpl transferValidatorService = (TransferDeleteValidatorServiceImpl)ITransferDeleteValidatorService.getInstance();
                List<DataDiv> finalValidate = validate;
                transferValidatorService.checkDeleteDataRule(TransferPermItermIdEnum.DELETE.itermId, appId, pageId, TransferPermItermIdEnum.getDeleteMsg((String)origin)).test(finalValidate);
                transferValidatorService.validateDelete(origin).test(finalValidate);
            }
            catch (Exception e) {
                LOGGER.error("TransferValidatorServiceImpl batchUnsubmitValidate error exception:", (Throwable)e);
                if (validate == null) break block2;
                validate.forEach(temp -> temp.getValidatorContext().setResult("exception", e.getMessage()));
            }
        }
        return validate;
    }

    @Override
    public String checkRepeatByErmanfile(Map<String, Object> ermanfile) {
        String result = "";
        DynamicObject[] employee_ids = this.getCrossTransferBill(ermanfile.get("depemp_id"));
        if (null != employee_ids && employee_ids.length > 0) {
            DynamicObject processingBill = employee_ids[0];
            if (TransferTypeEnum.BATCH.getType().equals(processingBill.getLong("transfertype.id"))) {
                result = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u6279\u91cf\u8c03\u52a8\u5355\u636e\u7f16\u7801\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"TransferSubmitValidatorServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]), ermanfile.get("name"), processingBill.getString("mid.billno"));
            } else {
                String billno = employee_ids[0].getString("billno");
                result = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5df2\u5904\u4e8e\u8c03\u52a8\u6d41\u7a0b\u4e2d\uff0c\u8c03\u52a8\u5355\u636e\u7f16\u7801\u4e3a%2$s\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u8c03\u52a8\u4eba\u5458\u3002", (String)"TransferValidatorServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[0]), ermanfile.get("name"), billno);
            }
        }
        return result;
    }

    @Override
    public Predicate<List<DataDiv>> validatePostpatternEffctDate(String condition, String menuFlag) {
        return dataDivs -> {
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                String msg;
                DynamicObject dy;
                DynamicObject dynamicObject = temp.getDynamicObject();
                String postPattern = dynamicObject.getString("postpattern");
                Date transferEffectDate = dynamicObject.getDate("realitydate");
                TransferConfirmValidatorServiceImpl confirmValidatorService = (TransferConfirmValidatorServiceImpl)ITransferConfirmValidatorService.getInstance();
                Map<String, Boolean> fieldConfigMap = confirmValidatorService.getDevConfigFieldsByOriginator(dynamicObject.getString("originator"));
                switch (postPattern) {
                    case "0": {
                        dy = dynamicObject.getDynamicObject("astposition");
                        if (dy == null && !Boolean.FALSE.equals(fieldConfigMap.get("astposition"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6807\u51c6\u5c97\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TransferValidatorServiceImpl_22", (String)"hr-hdm-business", (Object[])new Object[0]));
                        }
                        msg = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"TransferValidatorServiceImpl_23", (String)"hr-hdm-business", (Object[])new Object[0]);
                        break;
                    }
                    case "1": {
                        dy = dynamicObject.getDynamicObject("aposition");
                        if (dy == null && !Boolean.FALSE.equals(fieldConfigMap.get("aposition"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"TransferValidatorServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]));
                        }
                        msg = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"TransferValidatorServiceImpl_24", (String)"hr-hdm-business", (Object[])new Object[0]);
                        break;
                    }
                    case "2": {
                        dy = dynamicObject.getDynamicObject("ajob");
                        if (dy == null && !Boolean.FALSE.equals(fieldConfigMap.get("ajob"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a", (String)"TransferValidatorServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]));
                        }
                        msg = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"TransferValidatorServiceImpl_25", (String)"hr-hdm-business", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        throw new KDBizException("validatePostpatternEffctDate missing match postpattern :" + postPattern);
                    }
                }
                if (Objects.isNull(dy) && "3".equals(condition)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"TransferValidatorServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[]{msg}));
                }
                if (Objects.nonNull(dy)) {
                    Date businessDate = dy.getDate("firstbsed");
                    String operation = this.mapToOperationName(condition);
                    String format = HRDateTimeUtils.format((Date)transferEffectDate, (String)"yyyy-MM-dd");
                    boolean before = transferEffectDate.before(businessDate);
                    if (before) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a\u5f53\u524d\u6240\u9009\u7684\u201c%2$s\u201d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u201c%3$s\u201d\u3002", (String)"TransferValidatorServiceImpl_27", (String)"hr-hdm-business", (Object[])new Object[0]), operation, msg, format);
                        temp.getValidatorContext().setResult("transferEffectDate", errorMsg);
                    }
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<DataDiv> terminalValidate(String transferStatus, String transferEffectStatus) {
        return dataDiv -> {
            TransferTerminalServiceImpl transferValidatorService = (TransferTerminalServiceImpl)ITransferTerminalValidatorService.getInstance();
            Boolean terminalBoolean = transferValidatorService.terminalValidate(transferStatus, transferEffectStatus).test((DataDiv)dataDiv);
            return terminalBoolean;
        };
    }

    @Override
    public Predicate<DataDiv> batchTransferTerminalValidate() {
        return dataDiv -> {
            DynamicObject batchTransferBillDy = dataDiv.getDynamicObject();
            DynamicObjectCollection entryDyCollection = batchTransferBillDy.getDynamicObjectCollection("entryentity");
            String billstatus = batchTransferBillDy.getString("billstatus");
            if (HRStringUtils.equals((String)"C", (String)billstatus)) {
                if (ObjectUtils.isEmpty((Collection)entryDyCollection)) {
                    return true;
                }
                List list = entryDyCollection.stream().filter(o -> "4".equals(o.getString("transferstatus")) && ("0".equals(o.getString("transfereffectstatus")) || "3".equals(o.getString("transfereffectstatus")))).collect(Collectors.toList());
                if (list.size() == 0) {
                    dataDiv.getValidatorContext().setResult("batchtransferterminalvalidate", ResManager.loadKDString((String)"\u8c03\u52a8\u7ec8\u6b62\u5931\u8d25\uff1a\u4e0d\u80fd\u7ec8\u6b62\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u7684\u5355\u636e\u3002", (String)"TransferValidatorServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
                return list.size() > 0;
            }
            if (!HRStringUtils.equals((String)"B", (String)billstatus) && !HRStringUtils.equals((String)"D", (String)billstatus)) {
                dataDiv.getValidatorContext().setResult("batchtransferterminalvalidate", ResManager.loadKDString((String)"\u53ea\u80fd\u7ec8\u6b62\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u201c\u5ba1\u6279\u901a\u8fc7\u201d\u7684\u6570\u636e\u3002", (String)"TransferValidatorServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]));
                return false;
            }
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validatePartTimeAndDisPatchProfile(List<Object> employeeIds) {
        return dataDivs -> {
            LOGGER.info("start validatePartTimeAndDisPatchProfile");
            Map<String, DataDiv> dataDivMap = dataDivs.stream().collect(Collectors.toMap(temp -> temp.getDynamicObject().getString("bemployee.id"), k1 -> k1, (k1, k2) -> k1));
            Map<String, Object> profiles = PersonExternalService.getInstance().listEmpOrgRelGroup("employee", employeeIds);
            if (profiles == null) {
                LOGGER.info("start validatePartTimeAndDisPatchProfile node1 return");
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("validatePartTimeAndDisPatch", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_33", (String)"hr-hdm-business", (Object[])new Object[0])));
                return true;
            }
            boolean success = (Boolean)profiles.get("success");
            if (!success) {
                LOGGER.info("start validatePartTimeAndDisPatchProfile node2 return,result:{}", profiles);
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("validatePartTimeAndDisPatch", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_33", (String)"hr-hdm-business", (Object[])new Object[0])));
                return true;
            }
            Map data = (Map)profiles.get("data");
            data.forEach((employeeId, profileInfos) -> {
                DataDiv dataDiv = (DataDiv)dataDivMap.get(employeeId);
                if (dataDiv == null) {
                    LOGGER.info("start validatePartTimeAndDisPatchProfile node3 return");
                    return;
                }
                boolean valid = this.checkOrgAndPostPatternRealtionFieldIsEmpty().test(dataDiv);
                if (!valid) {
                    LOGGER.info("start validatePartTimeAndDisPatchProfile node4 return");
                    return;
                }
                DynamicObject transferbill = dataDiv.getDynamicObject();
                AtomicInteger i = new AtomicInteger();
                profileInfos.forEach(profileInfo -> {
                    String postPattern;
                    LOGGER.info("start profileInfos foreach index index :{}", (Object)i.getAndIncrement());
                    String postype = (String)profileInfo.get("postype");
                    StringBuilder errorMsg = new StringBuilder(transferbill.getString("person.name"));
                    errorMsg.append(ResManager.loadKDString((String)"\u5df2\u5b58\u5728", (String)"TransferValidatorServiceImpl_34", (String)"hr-hdm-business", (Object[])new Object[0]));
                    if (postype.equals(ResManager.loadKDString((String)"\u517c\u804c\u4efb\u804c", (String)"TransferValidatorServiceImpl_35", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                        errorMsg.append(ResManager.loadKDString((String)"\u517c\u804c\u5728", (String)"TransferValidatorServiceImpl_36", (String)"hr-hdm-business", (Object[])new Object[0]));
                    } else if (postype.equals(ResManager.loadKDString((String)"\u5916\u6d3e\u4efb\u804c", (String)"TransferValidatorServiceImpl_37", (String)"hr-hdm-business", (Object[])new Object[0]))) {
                        errorMsg.append(ResManager.loadKDString((String)"\u5916\u6d3e\u5728", (String)"TransferValidatorServiceImpl_38", (String)"hr-hdm-business", (Object[])new Object[0]));
                    } else {
                        LOGGER.info("start validatePartTimeAndDisPatchProfile node5 return");
                        return;
                    }
                    DynamicObject arealityOrg = transferbill.getDynamicObject("arealityorg");
                    long adminOrgId = (Long)profileInfo.get("adminorg_id");
                    errorMsg.append(arealityOrg.getString("name"));
                    errorMsg.append('\u3001');
                    switch (postPattern = transferbill.getString("postpattern")) {
                        case "0": {
                            DynamicObject arealityStposition = transferbill.getDynamicObject("arealitystposition");
                            Long stdpositionId = (Long)profileInfo.get("stdposition_id");
                            LOGGER.info("profile stdpositioncompare info ", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityStposition.getLong("id") == stdpositionId.longValue() ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityStposition.getLong("id") != stdpositionId.longValue()) break;
                            dataDiv.getValidatorContext().setResult("validatePartTimeAndDisPatch", String.format(ResManager.loadKDString((String)"%1$s%2$s\u7684\u6863\u6848\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_39", (String)"hr-hdm-business", (Object[])new Object[0]), errorMsg, arealityStposition.getString("name")));
                            break;
                        }
                        case "1": {
                            DynamicObject arealityPosition = transferbill.getDynamicObject("arealityposition");
                            Long positionId = (Long)profileInfo.get("position_id");
                            LOGGER.info("profile positioncompare info ", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityPosition.getLong("id") == positionId.longValue() ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityPosition.getLong("id") != positionId.longValue()) break;
                            dataDiv.getValidatorContext().setResult("validatePartTimeAndDisPatch", String.format(ResManager.loadKDString((String)"%1$s%2$s\u7684\u6863\u6848\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_39", (String)"hr-hdm-business", (Object[])new Object[0]), errorMsg, arealityPosition.getString("name")));
                            break;
                        }
                        case "2": {
                            DynamicObject arealityJob = transferbill.getDynamicObject("arealityjob");
                            Long jobId = (Long)profileInfo.get("job_id");
                            LOGGER.info("profile jobcompare info ", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityJob.getLong("id") == jobId.longValue() ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityJob.getLong("id") != jobId.longValue()) break;
                            dataDiv.getValidatorContext().setResult("validatePartTimeAndDisPatch", String.format(ResManager.loadKDString((String)"%1$s%2$s\u7684\u6863\u6848\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_39", (String)"hr-hdm-business", (Object[])new Object[0]), errorMsg, arealityJob.getString("name")));
                            break;
                        }
                        default: {
                            LOGGER.info("start validatePartTimeAndDisPatchProfile node5 return");
                            dataDiv.getValidatorContext().setResult("validatePartTimeAndDisPatch", "no suitable postpattern for validatePartTimeAndDisPatch");
                        }
                    }
                });
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> getChgRecord(Supplier<List<Long>> employeeIds) {
        return dataDivs -> {
            LOGGER.info("start getChgRecord");
            Map<Long, DataDiv> dataDivMap = dataDivs.stream().collect(Collectors.toMap(temp -> temp.getDynamicObject().getLong("bemployee.id"), k1 -> k1, (k1, k2) -> k1));
            Map<String, Object> employee = PersonExternalService.getInstance().getChgRecord("employeeId", (List)employeeIds.get(), Lists.newArrayList((Object[])new String[]{"0", "2"}), 1030L);
            if (employee == null) {
                LOGGER.info("start getChgRecord node1 return");
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("getChgRecord", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_33", (String)"hr-hdm-business", (Object[])new Object[0])));
                return true;
            }
            boolean success = (Boolean)employee.get("success");
            if (!success) {
                LOGGER.info("start getChgRecord node2 return");
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("getChgRecord", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_33", (String)"hr-hdm-business", (Object[])new Object[0])));
                return true;
            }
            Map data = (Map)employee.get("data");
            AtomicInteger i = new AtomicInteger();
            dataDivMap.forEach((employeeId, dataDiv) -> {
                LOGGER.info("start getChgRecord foreach index {}", (Object)i.getAndIncrement());
                DynamicObject transferbill = dataDiv.getDynamicObject();
                List partTimeBill = (List)data.get(employeeId);
                if (partTimeBill == null) {
                    LOGGER.info("start getChgRecord node3 return {}", employeeId);
                    return;
                }
                List<Long> billIds = partTimeBill.stream().filter(chg -> HRStringUtils.equals((String)String.valueOf(chg.get("chgaction")), (String)"1070") || HRStringUtils.equals((String)String.valueOf(chg.get("chgaction")), (String)"201070")).map(temp -> (Long)temp.get("billId")).collect(Collectors.toList());
                if (billIds.size() == 0) {
                    return;
                }
                List<Map<String, Object>> partTimeBillInfos = PersonExternalService.getInstance().queryPositionInfoByIds(billIds);
                Map<Long, Map> groupByPartTimeBillId = partTimeBillInfos.stream().collect(Collectors.toMap(temp -> (Long)temp.get("id"), temp -> temp, (k1, k2) -> k1));
                block10: for (Map stringObjectMap : partTimeBill) {
                    long billId = (Long)stringObjectMap.get("billId");
                    Map partTimeBillInfo = groupByPartTimeBillId.get(billId);
                    if (partTimeBillInfo == null) {
                        dataDiv.getValidatorContext().setResult("getChgRecord", ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u517c\u804c\u5355\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferValidatorServiceImpl_40", (String)"hr-hdm-business", (Object[])new Object[0]));
                        LOGGER.info("start getChgRecord node4 return {}", employeeId);
                        continue;
                    }
                    String chgcategoryName = (String)stringObjectMap.get("chgcategoryName");
                    String postPattern = transferbill.getString("postpattern");
                    DynamicObject arealityOrg = transferbill.getDynamicObject("arealityorg");
                    DynamicObject adminorg = (DynamicObject)partTimeBillInfo.get("adminorg");
                    long adminOrgId = adminorg.getLong("boid");
                    String positiontype = (String)partTimeBillInfo.get("positiontype");
                    StringBuilder errorMsg = new StringBuilder(transferbill.getString("person.name"));
                    switch (postPattern) {
                        case "0": {
                            DynamicObject arealityStposition = transferbill.getDynamicObject("arealitystposition");
                            DynamicObject stdposition = (DynamicObject)partTimeBillInfo.get("stdposition");
                            if (arealityStposition == null) {
                                LOGGER.info("start getChgRecord node5 return {}", employeeId);
                                continue block10;
                            }
                            if (!"0".equals(positiontype)) {
                                LOGGER.info("start getChgRecord node6 return {}", employeeId);
                                continue block10;
                            }
                            if (stdposition == null) {
                                LOGGER.info("start getChgRecord node7 return {}", employeeId);
                                continue block10;
                            }
                            long stdpositionId = stdposition.getLong("boid");
                            LOGGER.info("getChgRecord stdpostion compare info {}", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityStposition.getLong("id") == stdpositionId ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityStposition.getLong("id") != stdpositionId) continue block10;
                            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5df2\u5904\u4e8e\u201c%1$s\u201d\u6d41\u7a0b\u4e2d\uff0c%2$s\u90e8\u95e8\u4e3a\u201c%3$s\u201d\uff0c%4$s\u6807\u51c6\u5c97\u4f4d\u4e3a\u201c%5$s\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_42", (String)"hr-hdm-business", (Object[])new Object[0]), chgcategoryName, chgcategoryName, arealityOrg.getString("name"), chgcategoryName, arealityStposition.getString("name")));
                            dataDiv.getValidatorContext().setResult("getChgRecord", errorMsg.toString());
                            continue block10;
                        }
                        case "1": {
                            DynamicObject arealityPosition = transferbill.getDynamicObject("arealityposition");
                            if (arealityPosition == null) {
                                LOGGER.info("start getChgRecord node8 return {}", employeeId);
                                continue block10;
                            }
                            if (!"1".equals(positiontype)) {
                                LOGGER.info("start getChgRecord node9 return {}", employeeId);
                                continue block10;
                            }
                            DynamicObject position = (DynamicObject)partTimeBillInfo.get("position");
                            if (position == null) {
                                LOGGER.info("start getChgRecord node10 return {}", employeeId);
                                continue block10;
                            }
                            long positionId = position.getLong("boid");
                            LOGGER.info("getChgRecord position compare info {}", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityPosition.getLong("id") == positionId ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityPosition.getLong("id") != positionId) continue block10;
                            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5df2\u5904\u4e8e\u201c%1$s\u201d\u6d41\u7a0b\u4e2d\uff0c%2$s\u90e8\u95e8\u4e3a\u201c%3$s\u201d\uff0c%4$s\u5c97\u4f4d\u4e3a\u201c%5$s\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_43", (String)"hr-hdm-business", (Object[])new Object[0]), chgcategoryName, chgcategoryName, arealityOrg.getString("name"), chgcategoryName, arealityPosition.getString("name")));
                            dataDiv.getValidatorContext().setResult("getChgRecord", errorMsg.toString());
                            continue block10;
                        }
                        case "2": {
                            DynamicObject arealityJob = transferbill.getDynamicObject("arealityjob");
                            if (arealityJob == null) {
                                LOGGER.info("start getChgRecord node11 return {}", employeeId);
                                continue block10;
                            }
                            if (!"2".equals(positiontype)) {
                                LOGGER.info("start getChgRecord node12 return {}", employeeId);
                                continue block10;
                            }
                            DynamicObject job = (DynamicObject)partTimeBillInfo.get("job");
                            if (job == null) {
                                LOGGER.info("start getChgRecord node13 return {}", employeeId);
                                continue block10;
                            }
                            long jobId = job.getLong("boid");
                            LOGGER.info("getChgRecord job compare info {}", (Object)(arealityOrg.getLong("id") == adminOrgId && arealityJob.getLong("id") == jobId ? 1 : 0));
                            if (arealityOrg.getLong("id") != adminOrgId || arealityJob.getLong("id") != jobId) continue block10;
                            errorMsg.append(String.format(ResManager.loadKDString((String)"\u5df2\u5904\u4e8e\u201c%1$s\u201d\u6d41\u7a0b\u4e2d\uff0c%2$s\u90e8\u95e8\u4e3a\u201c%3$s\u201d\uff0c%4$s\u804c\u4f4d\u4e3a\u201c%5$s\u201d\uff0c\u65e0\u6cd5\u53d1\u8d77\u8c03\u52a8\uff0c\u8bf7\u4fee\u6539\u8c03\u52a8\u540e\u4fe1\u606f\u3002", (String)"TransferValidatorServiceImpl_44", (String)"hr-hdm-business", (Object[])new Object[0]), chgcategoryName, chgcategoryName, arealityOrg.getString("name"), chgcategoryName, arealityJob.getString("name")));
                            dataDiv.getValidatorContext().setResult("getChgRecord", errorMsg.toString());
                            dataDiv.getValidatorContext().setResult("getChgRecord", errorMsg.toString());
                            continue block10;
                        }
                    }
                    LOGGER.info("start getChgRecord node14 return {}", employeeId);
                    dataDiv.getValidatorContext().setResult("getChgRecord", "no suitable postpattern for validatePartTimeAndDisPatch");
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateExteranlProfileAndChgRecord(List<Object> employeeIds) {
        return dataDivs -> {
            this.validatePartTimeAndDisPatchProfile(employeeIds).test((List<DataDiv>)dataDivs);
            List filterUnValidEmployeeId = dataDivs.stream().filter(temp -> temp.getValidatorContext().getValidateResult().size() < 1).map(temp -> temp.getDynamicObject().getLong("bemployee.id")).collect(Collectors.toList());
            this.getChgRecord(() -> filterUnValidEmployeeId).test((List<DataDiv>)dataDivs);
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateBusinessFieldEffectDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDivs -> {
            this.validateCompanyEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig).and(this.validateOrgEffectDate(condition, menuFlag, orgValidateConfig, companyValidateConfig)).and(this.validatePostpatternEffctDate(condition, menuFlag)).and(this.validateEvaluationJobEffectDate(condition, menuFlag)).test((List<DataDiv>)dataDivs);
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateCompanyEffectDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDivs -> {
            DynamicObject companyConfig;
            boolean businessvalue;
            Boolean needValidate;
            String selectFields = "businesskey,app,businessvalue,description";
            DynamicObject[] devConfigList = DevParamConfigExternalService.getInstance().listDevParamConfigByAppNumber(selectFields, "hdm");
            List whtherCompanyValidate = Arrays.stream(devConfigList).filter(temp -> temp.getString("businesskey").equals(companyValidateConfig)).collect(Collectors.toList());
            if (whtherCompanyValidate != null && !whtherCompanyValidate.isEmpty() && !(needValidate = Boolean.valueOf(businessvalue = Boolean.parseBoolean((companyConfig = (DynamicObject)whtherCompanyValidate.get(0)).getString("businessvalue")))).booleanValue()) {
                return true;
            }
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                DynamicObject transferbill = temp.getDynamicObject();
                Date transferEffectDate = transferbill.getDate("realitydate");
                DynamicObject comapny = transferbill.getDynamicObject("arealitycompany");
                if (comapny == null) {
                    return;
                }
                if (Objects.nonNull(transferbill)) {
                    Date businessDate = comapny.getDate("establishmentdate");
                    String format = HRDateTimeUtils.format((Date)transferEffectDate, (String)"yyyy-MM-dd");
                    boolean before = transferEffectDate.before(businessDate);
                    if (before) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a\u5f53\u524d\u6240\u9009\u516c\u53f8\u7684\u8bbe\u7acb\u65e5\u671f\u665a\u4e8e\u201c%2$s\u201d\u3002", (String)"TransferValidatorServiceImpl_48", (String)"hr-hdm-business", (Object[])new Object[0]), this.mapToOperationName(condition), format);
                        temp.getValidatorContext().setResult("transferEffectDate", errorMsg);
                    }
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateOrgEffectDate(String condition, String menuFlag, String orgValidateConfig, String companyValidateConfig) {
        return dataDivs -> {
            DynamicObject companyConfig;
            boolean businessvalue;
            Boolean needValidate;
            String selectFields = "businesskey,app,businessvalue,description";
            DynamicObject[] devConfigList = DevParamConfigExternalService.getInstance().listDevParamConfigByAppNumber(selectFields, "hdm");
            List whtherCompanyValidate = Arrays.stream(devConfigList).filter(temp -> temp.getString("businesskey").equals(orgValidateConfig)).collect(Collectors.toList());
            if (whtherCompanyValidate != null && !whtherCompanyValidate.isEmpty() && !(needValidate = Boolean.valueOf(businessvalue = Boolean.parseBoolean((companyConfig = (DynamicObject)whtherCompanyValidate.get(0)).getString("businessvalue")))).booleanValue()) {
                return true;
            }
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                DynamicObject transferbill = temp.getDynamicObject();
                Date transferEffectDate = transferbill.getDate("realitydate");
                DynamicObject comapny = transferbill.getDynamicObject("arealityorg");
                if (comapny == null) {
                    return;
                }
                if (Objects.nonNull(transferbill)) {
                    Date businessDate = comapny.getDate("establishmentdate");
                    String format = HRDateTimeUtils.format((Date)transferEffectDate, (String)"yyyy-MM-dd");
                    boolean before = transferEffectDate.before(businessDate);
                    if (before) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a\u5f53\u524d\u6240\u9009\u90e8\u95e8\u7684\u8bbe\u7acb\u65e5\u671f\u665a\u4e8e\u201c%2$s\u201d\u3002", (String)"TransferValidatorServiceImpl_49", (String)"hr-hdm-business", (Object[])new Object[0]), this.mapToOperationName(condition), format);
                        temp.getValidatorContext().setResult("transferEffectDate", errorMsg);
                    }
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateEvaluationJobEffectDate(String condition, String menuFlag) {
        return dataDivs -> {
            dataDivs.stream().filter(dataDiv -> dataDiv.getValidatorContext().getValidateResult().size() < 1).forEach(temp -> {
                DynamicObject transferbill = temp.getDynamicObject();
                Date transferEffectDate = transferbill.getDate("realitydate");
                DynamicObject evaluationJob = transferbill.getDynamicObject("aevaluationjob");
                if (evaluationJob == null) {
                    return;
                }
                if (Objects.nonNull(transferbill)) {
                    Date businessDate = evaluationJob.getDate("firstbsed");
                    String format = HRDateTimeUtils.format((Date)transferEffectDate, (String)"yyyy-MM-dd");
                    boolean before = transferEffectDate.before(businessDate);
                    if (before) {
                        String errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff1a\u5f53\u524d\u6240\u9009\u8bc4\u5b9a\u804c\u4f4d\u7684\u751f\u6548\u65e5\u671f\u665a\u4e8e\u201c%2$s\u201d\u3002", (String)"TransferValidatorServiceImpl_50", (String)"hr-hdm-business", (Object[])new Object[0]), this.mapToOperationName(condition), format);
                        temp.getValidatorContext().setResult("transferEffectDate", errorMsg);
                    }
                }
            });
            return true;
        };
    }

    private String mapToOperationName(String condition) {
        switch (condition) {
            case "0": {
                return ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TransferValidatorServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]);
            }
            case "1": {
                return ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TransferValidatorServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]);
            }
            case "2": {
                return ResManager.loadKDString((String)"\u4fe1\u606f\u53d8\u66f4", (String)"TransferValidatorServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]);
            }
            case "3": {
                return ResManager.loadKDString((String)"\u786e\u8ba4\u5230\u5c97", (String)"TransferValidatorServiceImpl_31", (String)"hr-hdm-business", (Object[])new Object[0]);
            }
            case "4": {
                return ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)"TransferValidatorServiceImpl_32", (String)"hr-hdm-business", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private DynamicObject[] getCrossTransferBill(Object employeeId) {
        QFilter qFilter = new QFilter("bdepemp", "=", employeeId);
        QFilter qFilter1 = new QFilter("transferstatus", "in", (Object)new String[]{TransferStatusEnum.TRANSFERING.getStatus(), TransferStatusEnum.TO_EFFECT.getStatus()});
        QFilter qFilter2 = new QFilter("transferstatus", "=", (Object)"0").and(new QFilter("originator", "!=", (Object)TransferOriginatorEnum.MY.getOriginator()));
        DynamicObject[] query = ITransferBillService.getInstance().query("billno,bdepemp,mid,transfertype", new QFilter[]{qFilter, qFilter1.or(qFilter2)});
        return query;
    }

    private String getPageId(String menuFlag) {
        String pageId = "in".equals(menuFlag) ? "hdm_transferinbill" : ("out".equals(menuFlag) ? "hdm_transferoutbill" : "hdm_transferapply");
        return pageId;
    }

    private Predicate<DataDiv> getPredicate(String menuFlag) {
        return Validator.CUSTOMIZE.testOnCustomized("auditstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u8c03\u5165\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u63d0\u4ea4\u201d\u201c\u5f85\u8c03\u5165\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferValidatorServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            if ("in".equals(menuFlag)) {
                String auditstatus = dynamicObject.getString("transferinstatus");
                if (HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus()) || HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInReSubmit.getApproveStatus())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }).and(Validator.CUSTOMIZE.testOnCustomized("auditstatus", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u8c03\u51fa\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u63d0\u4ea4\u201d\u201c\u5f85\u8c03\u51fa\u90e8\u95e8\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"TransferValidatorServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]), temp -> {
            DynamicObject dynamicObject = temp.getDynamicObject();
            if ("out".equals(menuFlag)) {
                String auditstatus = dynamicObject.getString("transferoutstatus");
                if (HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInInit.getApproveStatus()) || HRStringUtils.equals((String)auditstatus, (String)TransferApproveStatusEnum.transferInReSubmit.getApproveStatus())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }));
    }

    private Function<String, List<DataDiv>> submitValidate(List<DynamicObject> dynamicObjects, String type) {
        return menuFlag -> {
            List<DataDiv> dataDivs = this.validate(dynamicObjects);
            try {
                String opName;
                TransferPermItermIdEnum permItem;
                String pageId = this.getPageId((String)menuFlag);
                TransferSubmitValidatorServiceImpl transferValidatorService = (TransferSubmitValidatorServiceImpl)ITransferSubmitValidatorService.getInstance();
                if (HRStringUtils.equals((String)"4", (String)type)) {
                    permItem = TransferPermItermIdEnum.SUBMITEFFECT;
                    opName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5e76\u751f\u6548", (String)"TransferValidatorServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[0]);
                    transferValidatorService.submitEffectValidate((String)menuFlag).test(dataDivs);
                } else {
                    permItem = TransferPermItermIdEnum.SUBMIT;
                    opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"TransferValidatorServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[0]);
                    transferValidatorService.submitValidate((String)menuFlag).test(dataDivs);
                }
                transferValidatorService.checkSubmitDataRule(permItem.itermId, PermissionValidateUtil.getAppId(), pageId, TransferPermItermIdEnum.getSubmitMsg((String)menuFlag, (String)opName)).test(dataDivs);
                transferValidatorService.checkRepeat().test(dataDivs);
                transferValidatorService.checkRepeatInDb(dynamicObjects).test(dataDivs);
                List<Object> bemployeeIds = dataDivs.stream().map(temp -> temp.getDynamicObject().get("bemployee.id")).collect(Collectors.toList());
                this.validateExteranlProfileAndChgRecord(bemployeeIds).test(dataDivs);
                transferValidatorService.batchCheckRepeatInPerChg().test(dataDivs);
                transferValidatorService.getStaffInfo().test(dataDivs);
                transferValidatorService.validateSubmitPostpatternEffctDate(type, (String)menuFlag, "hdm_transfer_org_createdate_submitvalidate", "hdm_transfer_company_createdate_submitvalidate").test(dataDivs);
                ITransferValidatorService.getInstance().validateBaseDataEnable(ResManager.loadKDString((String)opName, (String)"", (String)"", (Object[])new Object[0])).test(dataDivs);
            }
            catch (Exception e) {
                LOGGER.error("TransferValidatorServiceImpl batchValidate error exception", (Throwable)e);
                dataDivs.forEach(temp -> temp.getValidatorContext().setResult("exception", e.getMessage()));
            }
            return dataDivs;
        };
    }

    private Predicate<DataDiv> checkOrgAndPostPatternRealtionFieldIsEmpty() {
        return dataDiv -> {
            String postPattern;
            DynamicObject transferbill = dataDiv.getDynamicObject();
            DynamicObject org = transferbill.getDynamicObject("arealityorg");
            if (org == null) {
                return false;
            }
            switch (postPattern = transferbill.getString("postpattern")) {
                case "0": {
                    DynamicObject stPosition = transferbill.getDynamicObject("arealitystposition");
                    if (stPosition != null) break;
                    return false;
                }
                case "1": {
                    DynamicObject position = transferbill.getDynamicObject("arealityposition");
                    if (position != null) break;
                    return false;
                }
                case "2": {
                    DynamicObject job = transferbill.getDynamicObject("arealityjob");
                    if (job != null) break;
                    return false;
                }
                default: {
                    return true;
                }
            }
            return true;
        };
    }

    @Override
    public Predicate<List<DataDiv>> validateBaseDataEnable(String operationName) {
        return dataDivs -> {
            try {
                int size = dataDivs.size() << 1;
                ArrayList<String> positionNumbers = new ArrayList<String>(size);
                HashMap<String, DataDiv> postionCache = new HashMap<String, DataDiv>(size);
                ArrayList<String> stPositionNumbers = new ArrayList<String>(size);
                HashMap<String, DataDiv> stPostionCache = new HashMap<String, DataDiv>(size);
                ArrayList<String> jobNumbers = new ArrayList<String>(size);
                HashMap<String, DataDiv> jobCache = new HashMap<String, DataDiv>(size);
                ArrayList<String> orgNumbers = new ArrayList<String>(size);
                HashMap<String, DataDiv> orgCache = new HashMap<String, DataDiv>(size);
                ArrayList<String> companyNumbers = new ArrayList<String>(size);
                HashMap<String, DataDiv> companyCache = new HashMap<String, DataDiv>(size);
                dataDivs.forEach(temp -> {
                    DynamicObject companyDy;
                    DynamicObject orgDy;
                    DynamicObject jobDy;
                    DynamicObject stpositionDy;
                    DynamicObject transferBill = temp.getDynamicObject();
                    DynamicObject positionDy = transferBill.getDynamicObject("arealityposition");
                    if (positionDy != null) {
                        positionNumbers.add(positionDy.getString("number"));
                        postionCache.put(positionDy.getString("number"), (DataDiv)temp);
                    }
                    if ((stpositionDy = transferBill.getDynamicObject("arealitystposition")) != null) {
                        stPositionNumbers.add(stpositionDy.getString("number"));
                        stPostionCache.put(stpositionDy.getString("number"), (DataDiv)temp);
                    }
                    if ((jobDy = transferBill.getDynamicObject("arealityjob")) != null) {
                        jobNumbers.add(jobDy.getString("number"));
                        jobCache.put(jobDy.getString("number"), (DataDiv)temp);
                    }
                    if ((orgDy = transferBill.getDynamicObject("arealityorg")) != null) {
                        orgNumbers.add(orgDy.getString("number"));
                        orgCache.put(orgDy.getString("number"), (DataDiv)temp);
                    }
                    if ((companyDy = transferBill.getDynamicObject("arealitycompany")) != null) {
                        companyNumbers.add(companyDy.getString("number"));
                        companyCache.put(companyDy.getString("number"), (DataDiv)temp);
                    }
                });
                this.validatePositionEnable(positionNumbers, postionCache, operationName).and(this.validateStPositionEnable(stPositionNumbers, stPostionCache, operationName)).and(this.validateJobEnable(jobNumbers, jobCache, operationName)).and(this.validateOrgEnable(orgNumbers, orgCache, operationName)).and(this.validateCompanyEnable(companyNumbers, companyCache, operationName)).test((List<DataDiv>)dataDivs);
            }
            catch (Exception e) {
                LOGGER.error("validateBaseDataEnable error:", (Throwable)e);
            }
            return true;
        };
    }

    private Predicate<List<DataDiv>> validatePositionEnable(List<String> positionNumbers, Map<String, DataDiv> postionCache, String operationName) {
        return dataDivs -> {
            if (positionNumbers.isEmpty()) {
                return true;
            }
            Map<String, Object> position = AdminOrgExternalService.getInstance().queryPositionHisByNumber(new ArrayList<String>(positionNumbers), new Date());
            List data = (List)position.get("data");
            Map<String, String> positionMap = data.stream().collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (String)temp.get("enable"), (k1, k2) -> k1));
            postionCache.forEach((positionNumber, value) -> {
                String enable = (String)positionMap.get(positionNumber);
                if (enable == null) {
                    return;
                }
                if (!"1".equals(enable)) {
                    value.getValidatorContext().setResult("validatePositionEnable", String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u5c97\u4f4d%2$s\u5df2\u7981\u7528\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]), operationName, positionNumber));
                }
            });
            return true;
        };
    }

    private Predicate<List<DataDiv>> validateStPositionEnable(List<String> positionNumbers, Map<String, DataDiv> postionCache, String operationName) {
        return dataDivs -> {
            if (positionNumbers.isEmpty()) {
                return true;
            }
            Map<String, Object> position = AdminOrgExternalService.getInstance().queryStdPositionByNumber(positionNumbers, new Date());
            List data = (List)position.get("data");
            Map<String, String> positionMap = data.stream().collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (String)temp.get("enable"), (k1, k2) -> k1));
            postionCache.forEach((positionNumber, value) -> {
                String enable = (String)positionMap.get(positionNumber);
                if (enable == null) {
                    return;
                }
                if (!"1".equals(enable)) {
                    value.getValidatorContext().setResult("validatePositionEnable", String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u6807\u51c6\u5c97\u4f4d%2$s\u5df2\u7981\u7528\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]), operationName, positionNumber));
                }
            });
            return true;
        };
    }

    private Predicate<List<DataDiv>> validateJobEnable(List<String> jobNumbers, Map<String, DataDiv> postionCache, String operationName) {
        return dataDivs -> {
            if (jobNumbers.isEmpty()) {
                return true;
            }
            Map<String, Object> jobHisSimpleInfo = JobExternalService.getInstance().invokeQueryJobHisSimpleInfo(jobNumbers, null);
            DynamicObjectCollection data = (DynamicObjectCollection)jobHisSimpleInfo.get("data");
            Map<String, String> positionMap = data.stream().collect(Collectors.toMap(temp -> (String)temp.get("number"), temp -> (String)temp.get("enable"), (k1, k2) -> k1));
            postionCache.forEach((positionNumber, value) -> {
                String enable = (String)positionMap.get(positionNumber);
                if (enable == null) {
                    return;
                }
                if (!"1".equals(enable)) {
                    value.getValidatorContext().setResult("validatePositionEnable", String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u804c\u4f4d%2$s\u5df2\u7981\u7528\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]), operationName, positionNumber));
                }
            });
            return true;
        };
    }

    private Predicate<List<DataDiv>> validateCompanyEnable(List<String> orgNumbers, Map<String, DataDiv> postionCache, String operationName) {
        return dataDivs -> {
            if (orgNumbers.isEmpty()) {
                return true;
            }
            Map<String, Map<String, Object>> adminorgMap = AdminOrgExternalService.getInstance().queryAdminorgByNumber(orgNumbers, new Date());
            postionCache.forEach((positionNumber, value) -> {
                Map orgInfoMap = (Map)adminorgMap.get(positionNumber);
                if (orgInfoMap == null) {
                    return;
                }
                if (!orgInfoMap.getOrDefault("enable", "1").equals("1")) {
                    value.getValidatorContext().setResult("validatePositionEnable", String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u516c\u53f8%2$s\u5df2\u7981\u7528\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]), operationName, positionNumber));
                    return;
                }
            });
            return true;
        };
    }

    private Predicate<List<DataDiv>> validateOrgEnable(List<String> orgNumbers, Map<String, DataDiv> postionCache, String operationName) {
        return dataDivs -> {
            if (orgNumbers.isEmpty()) {
                return true;
            }
            Map<String, Map<String, Object>> adminorgMap = AdminOrgExternalService.getInstance().queryAdminorgByNumber(orgNumbers, new Date());
            postionCache.forEach((positionNumber, value) -> {
                Map orgInfoMap = (Map)adminorgMap.get(positionNumber);
                if (orgInfoMap == null) {
                    return;
                }
                if (!orgInfoMap.getOrDefault("enable", "1").equals("1")) {
                    value.getValidatorContext().setResult("validatePositionEnable", String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u90e8\u95e8%2$s\u5df2\u7981\u7528\uff0c\u8bf7\u8fdb\u884c\u4fee\u6539", (String)"", (String)"", (Object[])new Object[0]), operationName, positionNumber));
                    return;
                }
            });
            return true;
        };
    }
}

