/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.domain.transfer.service.invoke;

import java.util.Arrays;
import java.util.function.Function;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.domain.transfer.service.invoke.InvokeParam;
import org.apache.commons.lang3.time.StopWatch;

public class InvokeHandler<T> {
    private static final Log LOGGER = LogFactory.getLog(InvokeHandler.class);
    private static final InvokeHandler INVOKE_HANDLER = new InvokeHandler();

    private InvokeHandler() {
    }

    public static InvokeHandler getInstance() {
        return INVOKE_HANDLER;
    }

    public T invokeService(InvokeParam invokeParam, Object ... param) {
        return this.invokeService(param).apply(invokeParam);
    }

    private Function<InvokeParam, T> invokeService(Object ... param) {
        return invokeParam -> {
            StopWatch stopWatch = new StopWatch(invokeParam.getMethodId());
            try {
                Object invokeResult;
                stopWatch.start();
                LOGGER.info("InvokeHandler start invoke {},invoke param:{} ", (Object)invokeParam.getMethodId(), (Object)Arrays.toString(param));
                Object object = invokeResult = HRMServiceHelper.invokeBizService((String)invokeParam.getCloudId(), (String)invokeParam.getAppId(), (String)invokeParam.getServiceId(), (String)invokeParam.getMethodId(), (Object[])param);
                return object;
            }
            catch (Exception e) {
                LOGGER.error("InvokeHandler Invoke {},error ", (Object)invokeParam.getMethodId());
                LOGGER.error("error info: ", (Throwable)e);
            }
            finally {
                stopWatch.stop();
                LOGGER.info("InvokeHandler finish invoke {},cost time :{}", (Object)invokeParam.getMethodId(), (Object)stopWatch.getNanoTime());
            }
            return null;
        };
    }
}

