/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.consumer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.parttime.service.IParttimeBillService;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;
import kd.hr.hdm.business.repository.ParttimeEndRepository;
import kd.hr.hdm.common.parttime.constants.ParttimeActionConstants;
import kd.hr.hdm.common.parttime.enums.PartTimeStatusEnum;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;

public class PartPersonChangeCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(PartPersonChangeCallBack.class);
    private static final String OLD_COMEMP_ID = "oldComEmpId";
    private static final String OLD_DEPEMP_ID = "oldDepEmpId";
    private static final String OLD_EMPLOYEE_ID = "oldEmployeeId";
    private static final String OLD_ERFILE_ID = "oldErfileId";
    private static final String MSGPUBNO_PART = "MP20220510000693";
    private static final String MSGPUBNO_PARTEND = "MP20220510000694";
    private static final String MSGPUBNO_DISPOS = "MP20220810000797";
    private static final long ACTIONID_DISDARKPOS = 101330L;

    public void onMessage(Object message, String s, boolean b, MessageAcker messageAcke) {
        LOGGER.info("PartPersonChangeCallBack, the response message is : [{}]", (Object)JSONObject.toJSONString((Object)message));
        JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
        JSONObject chgResult = (JSONObject)messageArray.get(0);
        this.dealWithMessage(chgResult);
    }

    public void dealWithMessage(JSONObject chgResult) {
        if (!chgResult.getBoolean("success").booleanValue()) {
            if (HRStringUtils.equals((String)chgResult.getString("billSource"), (String)"hdm_parttimeapplybill")) {
                this.disableDarkPosition(chgResult);
            }
        } else if (HRStringUtils.equals((String)chgResult.getString("billSource"), (String)"hdm_parttimeapplybill")) {
            this.partCallBack(chgResult);
        } else if (HRStringUtils.equals((String)chgResult.getString("billSource"), (String)"hdm_parttimeendbill")) {
            this.partEndCallBack(chgResult);
        }
    }

    private void partEndCallBack(JSONObject chgResult) {
        Long positionId;
        Long billId = chgResult.getLong("billId");
        DynamicObject parttimeEndBill = ParttimeEndRepository.getInstance().queryOne("isend,partfile,bcmpemp,bdepemp,affaction,bemployee", billId);
        parttimeEndBill.set("isend", (Object)Boolean.TRUE);
        ParttimeEndRepository.getInstance().saveOne(parttimeEndBill);
        Long msgSynActionId = chgResult.getLong("msgSynActionId");
        if (!parttimeEndBill.getBoolean("affaction.isnewchgaction") && ParttimeActionConstants.PARTEND_ACTION_ID.equals(parttimeEndBill.getLong("affaction.id"))) {
            Map<String, Object> messageContent = this.getMessageContent(chgResult, parttimeEndBill, parttimeEndBill.getLong("affaction.id"), parttimeEndBill.getLong("affaction.chgcategory_id"), "hdm_parttimeendbill");
            this.sendToHRMP(messageContent, parttimeEndBill, msgSynActionId, MSGPUBNO_PARTEND);
        }
        long partFileId = parttimeEndBill.getLong("partfile_id");
        Map<String, Object> cardMap = PersonExternalService.getInstance().invokeGetCardFields(Collections.singletonList(partFileId)).get(0);
        String posType = (String)cardMap.get("apositiontype");
        if ((PosTypeEnum.JOB.getCode().equals(posType) || PosTypeEnum.STD_POS.getCode().equals(posType)) && null != (positionId = (Long)cardMap.get("position_id"))) {
            this.sendDisableDarkPositionMsg(billId, positionId);
        }
    }

    private void sendDisableDarkPositionMsg(Long billId, Long positionId) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>();
        HashMap<String, List<Long>> content = new HashMap<String, List<Long>>();
        content.put("position", Collections.singletonList(positionId));
        String msgTitle = ResManager.loadKDString((String)"\u517c\u804c\u5931\u6548\u6697\u5c97", (String)"PartPersonChangeCallBack_2", (String)"hr-hdm-business", (Object[])new Object[0]);
        String msgDesc = ResManager.loadKDString((String)"\u517c\u804c\u5931\u6548\u6697\u5c97\u901a\u77e5", (String)"PartPersonChangeCallBack_3", (String)"hr-hdm-business", (Object[])new Object[0]);
        String msgNumber = String.format("%1$s_%2$s", billId, System.currentTimeMillis());
        messageParams.put("msgNumber", msgNumber);
        messageParams.put("msgPubNo", MSGPUBNO_DISPOS);
        messageParams.put("msgTitle", msgTitle);
        messageParams.put("msgDesc", msgDesc);
        messageParams.put("msgTag", msgTitle);
        messageParams.put("actionId", 101330L);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(content));
        LOGGER.info("disableDarkPosition----messageParms: {}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private DynamicObject getParttimeById(long billId) {
        return ParttimeApplyRepository.getInstance().queryOne("adepemp,parttimestatus,partperson,primarycmpemp,primarydepemp,primaryemployee,partfile,effectdate,aposition,astdposition,bjob,apositiontype,affaction", billId);
    }

    private void disableDarkPosition(JSONObject chgResult) {
        Long billId = chgResult.getLong("billId");
        DynamicObject partDy = this.getParttimeById(billId);
        if (ObjectUtils.isEmpty((Object)partDy)) {
            LOGGER.info("PartPersonChangeCallBack partbill is null");
            return;
        }
        String posType = partDy.getString("apositiontype");
        long positionId = partDy.getLong("aposition.id");
        if ((PosTypeEnum.JOB.getCode().equals(posType) || PosTypeEnum.STD_POS.getCode().equals(posType)) && positionId != 0L) {
            this.sendDisableDarkPositionMsg(billId, positionId);
        }
    }

    private void partCallBack(JSONObject chgResult) {
        Long billId = chgResult.getLong("billId");
        Long newDepEmpId = chgResult.getLong("newDepEmpId");
        Long newErFileId = chgResult.getLong("newErfileId");
        DynamicObject partDy = this.getParttimeById(billId);
        if (ObjectUtils.isEmpty((Object)partDy)) {
            LOGGER.info("PartPersonChangeCallBack partbill is null");
            return;
        }
        IParttimeBillService.getInstance().changeBoIdToVId(partDy);
        partDy.set("adepemp", (Object)newDepEmpId);
        partDy.set("partfile", (Object)newErFileId);
        partDy.set("parttimestatus", (Object)PartTimeStatusEnum.ALREADY.getCode());
        ParttimeApplyRepository.getInstance().saveOne(partDy);
        if (partDy.getBoolean("affaction.isnewchgaction")) {
            return;
        }
        if (ParttimeActionConstants.PART_ACTION_ID.equals(partDy.getLong("affaction.id"))) {
            Map<String, Object> messageContent = this.getMessageContent(chgResult, partDy, partDy.getLong("affaction.id"), partDy.getLong("affaction.chgcategory_id"), "hdm_parttimeapplybill");
            Long msgSynActionId = chgResult.getLong("msgSynActionId");
            this.sendToHRMP(messageContent, partDy, msgSynActionId, MSGPUBNO_PART);
        }
    }

    private void sendToHRMP(Map<String, Object> messageContent, DynamicObject billObj, Long actionId, String msgPubNo) {
        HashMap<String, Object> messageParams = new HashMap<String, Object>(16);
        messageParams.put("msgNumber", String.valueOf(billObj.getLong("id")));
        messageParams.put("msgPubNo", msgPubNo);
        if (HRStringUtils.equals((String)msgPubNo, (String)MSGPUBNO_PART)) {
            messageParams.put("msgTitle", ResManager.loadKDString((String)"%s\u517c\u804c\u64cd\u4f5c", (String)"PartPersonChangeCallBack_0", (String)"hr-hdm-business", (Object[])new Object[]{billObj.getDynamicObject("partperson").getString("name")}));
        } else {
            messageParams.put("msgTitle", ResManager.loadKDString((String)"%s\u517c\u804c\u7ec8\u6b62\u64cd\u4f5c", (String)"PartPersonChangeCallBack_1", (String)"hr-hdm-business", (Object[])new Object[]{billObj.getDynamicObject("partfile").getString("name")}));
        }
        messageParams.put("actionId", actionId);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(messageContent));
        LOGGER.info("Parttime---CallBack------sendToHRMP----messageParams:{}", (Object)JSONObject.toJSONString(messageParams));
        HRProducerServiceHelper.publishAction(messageParams);
    }

    private Map<String, Object> getMessageContent(JSONObject chgResult, DynamicObject billObj, Long action, Long category, String billSource) {
        HashMap<String, Object> params = new HashMap<String, Object>(32);
        params.put("billId", chgResult.get((Object)"billId"));
        params.put("billSource", chgResult.get((Object)"billSource"));
        params.put("affactionId", action);
        params.put("chgcategoryId", category);
        params.put("recordId", chgResult.get((Object)"recordId"));
        if (HRStringUtils.equals((String)"hdm_parttimeapplybill", (String)billSource)) {
            params.put(OLD_ERFILE_ID, billObj.getDynamicObject("partperson").getLong("id"));
            params.put(OLD_COMEMP_ID, billObj.getDynamicObject("primarycmpemp").getLong("id"));
            params.put(OLD_DEPEMP_ID, billObj.getDynamicObject("primarydepemp").getLong("id"));
            params.put(OLD_EMPLOYEE_ID, billObj.getDynamicObject("primaryemployee").getLong("id"));
        } else {
            params.put(OLD_ERFILE_ID, billObj.get("partfile.id"));
            params.put(OLD_COMEMP_ID, billObj.get("bcmpemp.id"));
            params.put(OLD_DEPEMP_ID, billObj.get("bdepemp.id"));
            params.put(OLD_EMPLOYEE_ID, billObj.get("bemployee.id"));
        }
        params.put("newErfileId", chgResult.getLong("newErfileId"));
        params.put("newComEmpId", chgResult.getLong("newComEmpId"));
        params.put("newDepEmpId", chgResult.getLong("newDepEmpId"));
        params.put("newEmployeeId", chgResult.getLong("newEmployeeId"));
        return params;
    }
}

