/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.mq.sender;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.hr.hdm.business.domain.transfer.service.TransferEffectMqExtendServiceImpl;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import kd.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.hr.hpfs.business.perchg.bizentity.PerChgParam;
import kd.hr.hpfs.business.perchg.executor.model.ChgRecordExecutorDto;
import kd.sdk.hr.hdm.business.transfer.ITransferEffectMqExtendService;

public class TransferAckPersonChangeSend {
    private static final Log LOGGER = LogFactory.getLog(TransferAckPersonChangeSend.class);
    private static final String PAGE_HRPI_BASE_LOCATION = "hrpi_baselocation";
    private static final String PAGE_HRPI_EMPJOBREL = "hrpi_empjobrel";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendNoticePersonChangeMsg(DynamicObject transferBill, Integer operateType) {
        MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_chgrecord_queue");
        ChgRecordExecutorDto cred = new ChgRecordExecutorDto();
        cred.setOperation(operateType.toString());
        cred.setBillId(transferBill.getString("id"));
        cred.setBillNo(transferBill.getString("billno"));
        cred.setAppId("hdm");
        cred.setResultCallBackQueue("hdm_transferNotice_result_queue");
        cred.setBillSource("hdm_transferbasebill");
        cred.setBsed(Long.valueOf(TransferAckPersonChangeSend.getTransferTimestamp(transferBill)));
        cred.setActionId(transferBill.getString("affaction_id"));
        cred.setPersonId(transferBill.getString("person_id"));
        cred.setEmployeeId(transferBill.getString("bemployee_id"));
        cred.setManagingScopeId(transferBill.getString("bcmp_id"));
        cred.setDepEmpId(transferBill.getString("bdepemp_id"));
        LOGGER.info("sendNoticePersonChangeMsg, the message info is : [{}]", (Object)JSONObject.toJSONString((Object)cred));
        try {
            pub.publish(JSONObject.toJSONString((Object)cred));
        }
        catch (Exception exception) {
            LOGGER.error("sendNoticePersonChangeMsg fail, the exception info is : [{}]", (Object)exception.getMessage());
        }
        finally {
            pub.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendAckPersonChangeMsg(DynamicObject transferBill, Integer operateType) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("operatetype", operateType);
        paramMap.put("billdata", (Integer)TransferAckPersonChangeSend.buildPerChgParam(transferBill));
        PluginProxy pluginProxy = PluginProxy.create((Object)new TransferEffectMqExtendServiceImpl(), ITransferEffectMqExtendService.class, (String)"kd.sdk.hr.hdm.business.transfer.ITransferEffectMqExtendService", null);
        pluginProxy.callReplaceIfPresent(service -> {
            service.extendEffectMqExtend(transferBill, paramMap);
            return "";
        });
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", "hpfs_perchg_queue");){
            LOGGER.info("sendAckPersonChangeMsg, the message info is : [{}]", (Object)JSONObject.toJSONString(paramMap));
            pub.publish(JSONObject.toJSONString(paramMap));
        }
    }

    private static PerChgParam buildPerChgParam(DynamicObject transferBill) {
        PerChgParam perchgParam = new PerChgParam();
        perchgParam.setAppId("hdm");
        perchgParam.setUserId(Long.valueOf(transferBill.getLong("confirmperson_id")));
        perchgParam.setResultCallBackQueue("hdm_transferAck_result_queue");
        perchgParam.setBizInfoList(Collections.singletonList(TransferAckPersonChangeSend.buildPerChgBizInfo(transferBill)));
        return perchgParam;
    }

    private static PerChgBizInfo buildPerChgBizInfo(DynamicObject transferBill) {
        Long jobrelId;
        PerChgBizInfo perchg = new PerChgBizInfo();
        perchg.setBillId(Long.valueOf(transferBill.getLong("id")));
        perchg.setBillNo(transferBill.getString("billno"));
        perchg.setBillSource("hdm_transferbasebill");
        perchg.setOldPersonId(Long.valueOf(transferBill.getLong("person_id")));
        perchg.setOldComempId(Long.valueOf(transferBill.getLong("bcmp_id")));
        perchg.setOldDepempId(Long.valueOf(transferBill.getLong("bdepemp_id")));
        perchg.setOldEmployeeId(Long.valueOf(transferBill.getLong("bemployee_id")));
        perchg.setOldErfileId(Long.valueOf(transferBill.getLong("ermanfile_id")));
        perchg.setActionId(Long.valueOf(transferBill.getLong("affaction_id")));
        perchg.setBsed(transferBill.getDate("realitydate"));
        HashMap<String, List<Long>> dataRowMap = new HashMap<String, List<Long>>();
        dataRowMap.put("hdm_transferbasebill", Collections.singletonList(transferBill.getLong("id")));
        Long baseLocationId = TransferAckPersonChangeSend.getTransferOutBaseLocationId(transferBill.getLong("ermanfile_id"));
        if (!ObjectUtils.isEmpty((Object)baseLocationId)) {
            dataRowMap.put(PAGE_HRPI_BASE_LOCATION, Collections.singletonList(baseLocationId));
        }
        if (!ObjectUtils.isEmpty((Object)(jobrelId = TransferAckPersonChangeSend.getTransferJobRelId(transferBill.getLong("bemployee_id"))))) {
            dataRowMap.put(PAGE_HRPI_EMPJOBREL, Collections.singletonList(jobrelId));
        }
        perchg.setDataRow(dataRowMap);
        return perchg;
    }

    private static Long getTransferOutBaseLocationId(long ermanfileID) {
        Map<String, Object> ermanfile;
        List<Map<String, Object>> ermanfileList = PersonExternalService.getInstance().invokeGetCardFields(Collections.singletonList(ermanfileID));
        if (!ObjectUtils.isEmpty(ermanfileList) && !ObjectUtils.isEmpty((Object)(ermanfile = ermanfileList.get(0)).get("baselocation"))) {
            return (Long)ermanfile.get("baselocation");
        }
        LOGGER.error("baselocation is empty, the ermanfileID is [{}]", (Object)ermanfileID);
        return null;
    }

    private static Long getTransferJobRelId(Long employeeId) {
        List<Map<String, Object>> jobGradeList = PersonExternalService.getInstance().listBatchPropEmployeeAttachs(Lists.newArrayList((Object[])new Long[]{employeeId}), "businessstatus,id", PAGE_HRPI_EMPJOBREL);
        if (!ObjectUtils.isEmpty(jobGradeList)) {
            return (Long)jobGradeList.stream().filter(map -> "1".equals(map.get("businessstatus"))).findFirst().get().get("id");
        }
        return null;
    }

    private static long getTransferTimestamp(DynamicObject transferBill) {
        if (ObjectUtils.isEmpty((Object)transferBill)) {
            return 0L;
        }
        return null == transferBill.getString("realitydate") ? transferBill.getDate("transferdate").getTime() : transferBill.getDate("realitydate").getTime();
    }
}

