/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.personnelchange.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.common.HPFSTemplatePropertyHandler;
import kd.hr.hdm.business.domain.transfer.service.external.PersonExternalService;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.common.reg.constants.LabRelConstants;

public class PersonnelChangeServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PersonnelChangeServiceHelper.class);

    public static boolean isQuit(long employeeId) {
        Long laborrelStatus = RegPeronalBillHelper.getInstance().queryLabRelStatusCls(employeeId);
        return LabRelConstants.QUIT.equals(laborrelStatus);
    }

    public static Map<String, Long> getAffactionMap(String type, String page) {
        boolean isEmpty;
        List<Map<String, Object>> affactionInfos = PersonExternalService.getInstance().getAffactionInfos(page);
        LOGGER.info("affactionInfos:{}", affactionInfos);
        boolean bl = isEmpty = affactionInfos == null || affactionInfos.isEmpty();
        if (!isEmpty) {
            try {
                return affactionInfos.stream().collect(Collectors.toMap(item -> {
                    Object key = item.get(type);
                    LOGGER.info("key:{}", key);
                    if (key instanceof OrmLocaleValue) {
                        return ((OrmLocaleValue)key).getLocaleValue();
                    }
                    if (key instanceof Map) {
                        return ((Map)key).get(Lang.get().toString()).toString();
                    }
                    return key.toString();
                }, item -> (Long)item.get("id")));
            }
            catch (Exception exception) {
                LOGGER.error("getAffactionMap error:", (Throwable)exception);
            }
        }
        return new HashMap<String, Long>();
    }

    public static Map<String, DynamicObject> getNewAffactionMap(String sign, Set<String> values, String key) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("sign", sign);
        requestMap.put("values", values);
        requestMap.put("isNewChgAction", HPFSTemplatePropertyHandler.isNewChgAction(key));
        Map result = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getChgActionByNumberOrName", (Object[])new Object[]{requestMap});
        LOGGER.info("getNewAffactionmap result:{}", (Object)result);
        if (((Boolean)result.get("success")).booleanValue()) {
            Map data = (Map)result.get("data");
            return data;
        }
        return new HashMap<String, DynamicObject>();
    }

    public static List<Long> getAffactionMapByBusinessKey(String key, String formId) {
        List<Long> affactionIds = HPFSTemplatePropertyHandler.isNewChgAction(key) ? PersonnelChangeServiceHelper.getActionResByBillSource(formId) : PersonExternalService.getInstance().getAffactionIds(formId);
        return affactionIds;
    }

    public static List<Long> getActionResByBillSource(String formId) {
        Map result = (Map)HRMServiceHelper.invokeBizService((String)"hr", (String)"hpfs", (String)"IHPFSPersonChgService", (String)"getActionResByBillSource", (Object[])new Object[]{formId});
        LOGGER.info("getActionResByBillSource result:{}", (Object)result);
        if (((Boolean)result.get("success")).booleanValue()) {
            List data = (List)result.get("data");
            return data.stream().map(map -> (Long)map.get("id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    public static List<Long> getLaborrelstatusByAffaction(DynamicObject affaction) {
        List<DynamicObject> laborrelstatusDys = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction(affaction);
        return laborrelstatusDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    public static List<DynamicObject> getLaborrelstatusDyByAffaction(DynamicObject affaction) {
        Map<Object, Object> laborrelstatusMap = new HashMap(8);
        long affactionId = affaction.getLong("id");
        try {
            ArrayList<Long> affactionIds = new ArrayList<Long>();
            affactionIds.add(affactionId);
            laborrelstatusMap = affaction.getBoolean("isnewchgaction") ? IPersonAboutService.getInstance().queryLaborrelstatusStatusByNewAffactions(affactionIds) : IPersonAboutService.getInstance().queryLaborrelstatusStatusByOldAffactions(affactionIds);
        }
        catch (Exception e) {
            LOGGER.error("getLaborrelstatusStatusByAffaction error:", (Throwable)e);
        }
        return laborrelstatusMap.containsKey(affactionId) ? (List)laborrelstatusMap.get(affactionId) : new ArrayList(0);
    }

    public static Map<Long, List<DynamicObject>> getLaborrelstatusByAffactions(List<Long> affactionIds) {
        try {
            Map<Long, List<DynamicObject>> laborrelstatusMap = HPFSTemplatePropertyHandler.isNewChgAction("hdm_reg_hpfs_new") ? IPersonAboutService.getInstance().queryLaborrelstatusStatusByNewAffactions(affactionIds) : IPersonAboutService.getInstance().queryLaborrelstatusStatusByOldAffactions(affactionIds);
            return laborrelstatusMap;
        }
        catch (Exception e) {
            LOGGER.error("getLaborrelstatusByAffactions error:", (Throwable)e);
            return new HashMap<Long, List<DynamicObject>>(0);
        }
    }
}

