/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.Collections;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.business.reg.RegAskServiceHelper;
import kd.hr.hdm.business.reg.RegExamServiceHelper;
import kd.hr.hdm.business.reg.RegMessageServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;

public class RegDetailInfoHelper {
    private static final Log LOGGER = LogFactory.getLog(RegDetailInfoHelper.class);

    private RegDetailInfoHelper() {
    }

    public static final RegDetailInfoHelper getInstance() {
        return RegDetailInfoHelperHolder.INSTANCE;
    }

    public Long urgeRegAsk(String detailsId, Long ermanFileId) {
        DynamicObject askDetailsObject = RegAskServiceHelper.DETAILS_SERVICE_HELPER.queryOne("message,person,bemployee,askperson", (Object)Long.valueOf(detailsId));
        if (askDetailsObject == null) {
            return 0L;
        }
        Long messageId = askDetailsObject.getLong("message");
        RegMessageServiceHelper.deleteMessage(messageId);
        Long personId = askDetailsObject.getLong("person.id");
        Long askPersonId = askDetailsObject.getLong("askperson.id");
        Long detailId = askDetailsObject.getLong("id");
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=hdm_regaskreply&detailId=" + detailId + "&ermanfile=" + ermanFileId;
        String messageTemplateNumber = "hdm_regask_other_urge";
        Map<Long, Long> userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(Collections.singletonList(personId));
        if (askPersonId.equals(userIdMap.get(personId))) {
            messageTemplateNumber = "hdm_regask_yourself_urge";
        }
        LocaleString tag = ResManager.getLocaleString((String)"\u8f6c\u6b63\u95ee\u8be2", (String)"RegDetailInfoHelper_2", (String)"hr-hdm-business");
        return RegMessageServiceHelper.sendMessageNotice(contentUrl, Collections.singletonList(askPersonId), messageTemplateNumber, (long)ermanFileId, tag);
    }

    public Long urgeRegExam(String detailsId, Long ermanFileId) {
        DynamicObject examDetailsObject = RegExamServiceHelper.DETAILS_SERVICE_HELPER.queryOne("message,person,bemployee,examperson", (Object)Long.valueOf(detailsId));
        if (examDetailsObject == null) {
            return 0L;
        }
        Long messageId = examDetailsObject.getLong("message");
        RegMessageServiceHelper.deleteMessage(messageId);
        Long personId = examDetailsObject.getLong("person.id");
        Long examPersonId = examDetailsObject.getLong("examperson.id");
        Long detailId = examDetailsObject.getLong("id");
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=hdm_regexamreply&detailId=" + detailId + "&ermanfile=" + ermanFileId;
        String messageTemplateNumber = "hdm_regexam_other_urge";
        Map<Long, Long> userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(Collections.singletonList(personId));
        if (examPersonId.equals(userIdMap.get(personId))) {
            messageTemplateNumber = "hdm_regexam_yourself_urge";
        }
        LocaleString tag = ResManager.getLocaleString((String)"\u8f6c\u6b63\u8003\u8bc4", (String)"RegDetailInfoHelper_9", (String)"hr-hdm-business");
        return RegMessageServiceHelper.sendMessageNotice(contentUrl, Collections.singletonList(examPersonId), messageTemplateNumber, (long)ermanFileId, tag);
    }

    public String getTrialPeriodResultImageWeb(String regStatus) {
        String imageUrl = null;
        Lang lang = RequestContext.get().getLang();
        if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
            imageUrl = "/icons/pc/label/hr_zztg_130_120.png";
            if (Lang.en_US.equals((Object)lang)) {
                imageUrl = "/icons/pc/label/hr_zztgyw_116_112.png";
            }
        }
        if (RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
            imageUrl = "/icons/pc/label/hr_zzbtg_130_120.png";
            if (Lang.en_US.equals((Object)lang)) {
                imageUrl = "/icons/pc/label/hr_zzbtgyw_116_112.png";
            }
        }
        return imageUrl;
    }

    public String getTrialPeriodResultImageMob(String regStatus) {
        String imageUrl = null;
        Lang lang = RequestContext.get().getLang();
        if (RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regStatus)) {
            imageUrl = "/icons/mobile/label/zztg_60_60.png";
            if (Lang.en_US.equals((Object)lang)) {
                imageUrl = "/icons/mobile/label/pass_60_60.png";
            }
        }
        if (RegBusinessStatusEnum.REJECT_REG.getCode().equals(regStatus)) {
            imageUrl = "/icons/mobile/label/zzbtg_60_60.png";
            if (Lang.en_US.equals((Object)lang)) {
                imageUrl = "/icons/mobile/label/fail_60_60.png";
            }
        }
        return imageUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedule(String pkId) {
        try (TXHandle tx = TX.required();){
            HRBaseServiceHelper schServiceHelper = new HRBaseServiceHelper("sch_schedule");
            DynamicObject schDy = schServiceHelper.queryOne("status", (Object)pkId);
            schDy.set("status", (Object)"0");
            schServiceHelper.updateOne(schDy);
        }
    }

    private static class RegDetailInfoHelperHolder {
        private static final RegDetailInfoHelper INSTANCE = new RegDetailInfoHelper();

        private RegDetailInfoHelperHolder() {
        }
    }
}

