/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hdm.business.reg.RegBaseHPFSTemplateHandler;
import kd.hr.hdm.business.reg.domain.repository.database.RegProcessRepository;
import kd.hr.hdm.business.reg.mq.PersonChangeCallBack;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hdm.perchg.IRegChgExtendService;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class RegEffectHPFSTemplateHandler
extends RegBaseHPFSTemplateHandler {
    private static final RegEffectHPFSTemplateHandler handler = new RegEffectHPFSTemplateHandler();

    private RegEffectHPFSTemplateHandler() {
    }

    public static RegEffectHPFSTemplateHandler getInstance() {
        return handler;
    }

    @Override
    public void setPreProperty(DynamicObject bill) {
        super.setPreProperty(bill);
        bill.set("b_effectivedate", bill.get("effectdate"));
        bill.set("bb_e_chgtype", (Object)"1");
    }

    @Override
    public void setBillProperty(DynamicObject dy) {
        dy.set("bb_e_tid", dy.get("ermanfile.employee.id"));
        dy.set("beforelaborrelstatus", dy.get("laborrelstatus"));
    }

    @Override
    protected void prePersonParamsBuilder(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        perChgBizInfoNew.setEffectivedate(bill.getDate("effectdate"));
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashSet<Long> employeeIds = new HashSet<Long>(bills.length);
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            employeeIds.add(bill.getLong("ermanfile.employee.id"));
            billMap.put(bill.getLong("id"), bill);
        }
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter idFilter = new QFilter("employee", "in", employeeIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        DynamicObject[] trialperiods = RepositoryUtils.queryDynamicObjects((String)"hrpi_trialperiod", null, (QFilter[])new QFilter[]{iscurrentversionFilter, idFilter, dataStatusFilter});
        Map trialperiodMap = Arrays.stream(trialperiods).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (oldV, newV) -> oldV));
        DynamicObject[] regprocessArray = RegProcessRepository.getInstance().queryOriginalArray("bemployee, trialperiodrst.id, examstatus,askstatus,regstatus", new QFilter("bemployee", "in", employeeIds).toArray());
        Map<Long, Long> regprocessMap = Arrays.stream(regprocessArray).collect(Collectors.toMap(dy -> dy.getLong("bemployee"), dy -> dy.getLong("trialperiodrst.id"), (oldV, newV) -> oldV));
        DynamicObject[] trialperiodrstArray = RepositoryUtils.queryDynamicObjects((String)"hrpi_trialperiodrst", null, (QFilter[])new QFilter[]{iscurrentversionFilter, idFilter, dataStatusFilter});
        Map trialperiodrstMap = Arrays.stream(trialperiodrstArray).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (oldV, newV) -> oldV));
        HashMap map = new HashMap(perChgBizInfoNews.size());
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            Long billId = perChgBizInfoNew.getBillId();
            DynamicObject bill = (DynamicObject)billMap.get(billId);
            long employeeId = bill.getLong("ermanfile.employee.id");
            DynamicObject trialperiod = (DynamicObject)trialperiodMap.get(employeeId);
            DynamicObject newTrialperiod = this.getNewTrialperiod((PerChgBizInfoNew)perChgBizInfoNew, trialperiod, bill, (Long)regprocessMap.get(employeeId), perChgBizInfoNew.getEffectivedate());
            ChgRecordHelper.updIdsRecord((String)"hrpi_trialperiod", (DynamicObject)trialperiod, (DynamicObject)newTrialperiod, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.MODIFY.getChgMode());
            DynamicObject trialperiodrst = (DynamicObject)trialperiodrstMap.get(employeeId);
            DynamicObject newTrialperiodrst = this.getNewTrialperiodrst((PerChgBizInfoNew)perChgBizInfoNew, trialperiodrst, bill, (Long)regprocessMap.get(employeeId), perChgBizInfoNew.getEffectivedate());
            ChgRecordHelper.updIdsRecord((String)"hrpi_trialperiodrst", (DynamicObject)trialperiodrst, (DynamicObject)newTrialperiodrst, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.MODIFY.getChgMode());
            this.setPersonParams((PerChgBizInfoNew)perChgBizInfoNew, entityNumbers);
            map.put(billId, perChgBizInfoNew);
        });
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IRegChgExtendService.class, (String)"kd.sdk.hr.hdm.perchg.IRegChgExtendService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setCustomPersonParamsExtend(bills, map);
            return null;
        });
    }

    private DynamicObject getNewTrialperiodrst(PerChgBizInfoNew perChgBizInfoNew, DynamicObject trialperiodrst, DynamicObject bill, Long trialperiodrstId, Date effectivedate) {
        DynamicObject newTrialperiodrst = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)trialperiodrst, (String)"hrpi_trialperiodrst");
        Date effectdate = bill.getDate("effectdate");
        newTrialperiodrst.set("sysenddate", (Object)effectdate);
        newTrialperiodrst.set("probationrst", (Object)trialperiodrstId);
        newTrialperiodrst.set("enddate", (Object)HRDateTimeUtils.addDay((Date)effectdate, (long)-1L));
        newTrialperiodrst.set("bsed", (Object)effectivedate);
        newTrialperiodrst.set("bsled", (Object)MAX_DATE);
        return newTrialperiodrst;
    }

    private DynamicObject getNewTrialperiod(PerChgBizInfoNew perChgBizInfoNew, DynamicObject trialperiod, DynamicObject bill, Long trialperiodrstId, Date effectivedate) {
        LOGGER.info("trialperiod probationunit original is:{}", trialperiod.get("probationunit"));
        DynamicObject newHisDy = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)trialperiod, (String)"hrpi_trialperiod");
        Date effectdate = bill.getDate("effectdate");
        newHisDy.set("realregulardate", (Object)effectdate);
        newHisDy.set("trialperiodrst", (Object)trialperiodrstId);
        newHisDy.set("sysenddate", (Object)effectdate);
        newHisDy.set("number", (Object)bill.getString("billno"));
        newHisDy.set("regstatus", (Object)bill.getString("regstatus"));
        newHisDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)effectdate, (long)-1L));
        LOGGER.info("trialperiod probationunit new is:{}", newHisDy.get("probationunit"));
        newHisDy.set("bsed", (Object)effectivedate);
        newHisDy.set("bsled", (Object)MAX_DATE);
        return newHisDy;
    }

    @Override
    protected void updateByAcffactionResult(PerChgBizInfoNew perChgBizInfoNew, boolean affectionRecordResult) {
        LOGGER.info("updateByAcffactionResult:{},billid={}", (Object)affectionRecordResult, (Object)perChgBizInfoNew.getBillId());
        JSONObject chgResult = new JSONObject();
        chgResult.put("success", (Object)affectionRecordResult);
        chgResult.put("billId", (Object)perChgBizInfoNew.getBillId());
        chgResult.put("billSource", (Object)perChgBizInfoNew.getBillSource());
        chgResult.put("recordId", (Object)perChgBizInfoNew.getChgRecordId());
        chgResult.put("msgSynActionId", (Object)perChgBizInfoNew.getChgActionId());
        new PersonChangeCallBack().dealWithMessage(chgResult);
    }
}

