/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.business.reg.RegMessageServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;

public class RegExamServiceHelper {
    private static final String PAGE_REGEXAMRESULT = "hdm_regexamresult";
    private static final String PAGE_REGEXAMDETAILS = "hdm_regexamdetails";
    private static final String PAGE_REGEXAMTEMPLATE = "hdm_regtestmodel";
    public static final HRBaseServiceHelper RESULT_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regexamresult");
    public static final HRBaseServiceHelper DETAILS_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regexamdetails");
    public static final HRBaseServiceHelper TEMPLATE_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regtestmodel");

    public static Map<String, Object> updateExamResult(Long employee, Long personId, Long templateId, String examResult, String calculateType, BigDecimal score) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        QFilter filter = new QFilter("bemployee", "=", (Object)employee);
        DynamicObject result = RESULT_SERVICE_HELPER.queryOne("bemployee,person,template,examresult,calculatetype,examscore", new QFilter[]{filter});
        if (result == null) {
            result = RESULT_SERVICE_HELPER.generateEmptyDynamicObject();
        }
        result.set("bemployee", (Object)employee);
        result.set("person", (Object)personId);
        if (examResult != null) {
            result.set("examresult", (Object)examResult);
        } else {
            result.set("examresult", (Object)"");
        }
        if (calculateType != null) {
            result.set("calculatetype", (Object)calculateType);
        }
        BigDecimal oldScore = result.getBigDecimal("examscore");
        if (score == null) {
            score = new BigDecimal(0);
        }
        result.set("examscore", (Object)score);
        boolean isChangeScore = false;
        if (score.compareTo(oldScore) != 0) {
            isChangeScore = true;
        }
        DynamicObject saveResult = (DynamicObject)RESULT_SERVICE_HELPER.saveOne(result);
        resultMap.put("resultId", saveResult.getLong("id"));
        resultMap.put("isChangeScore", isChangeScore);
        return resultMap;
    }

    public static Map<String, Object> updateExamResultWhenAddExam(DynamicObject result, List<Long> examPersons, Long employee, Long personId, Long templateId, String calculateType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        QFilter employeeFiler = new QFilter("bemployee", "=", (Object)employee);
        QFilter askPersonFilter = new QFilter("examperson_id", "in", examPersons);
        QFilter filter = new QFilter("isnewest", "=", (Object)Boolean.TRUE);
        DynamicObject[] details = DETAILS_SERVICE_HELPER.query("id", new QFilter[]{employeeFiler, askPersonFilter, filter});
        Long oldTemplate = null;
        if (result == null) {
            result = RESULT_SERVICE_HELPER.generateEmptyDynamicObject();
        } else {
            oldTemplate = (Long)result.get("template_id");
        }
        boolean isChangeScore = false;
        if (examPersons.size() != details.length || !templateId.equals(oldTemplate)) {
            BigDecimal oldScore = result.getBigDecimal("examscore");
            if (oldScore.compareTo(new BigDecimal(0)) != 0) {
                isChangeScore = true;
            }
            result.set("examresult", (Object)"");
            result.set("examscore", (Object)new BigDecimal(0));
        }
        result.set("bemployee", (Object)employee);
        result.set("person", (Object)personId);
        if (templateId != null) {
            result.set("template", (Object)templateId);
        }
        if (calculateType != null) {
            result.set("calculatetype", (Object)calculateType);
        }
        DynamicObject saveResult = (DynamicObject)RESULT_SERVICE_HELPER.saveOne(result);
        Long resultId = saveResult.getLong("id");
        if (oldTemplate != null && !oldTemplate.equals(templateId)) {
            ArrayList<Long> resultIdList = new ArrayList<Long>();
            resultIdList.add(resultId);
            RegExamServiceHelper.updateOldExamDetails(resultIdList);
        }
        resultMap.put("resultId", resultId);
        resultMap.put("isChangeScore", isChangeScore);
        return resultMap;
    }

    public static void newExamDetails(Long employee, Long personId, Long templateId, List<Long> examPersonIds, Long resultId, List<Long> messageIds, Map<Long, Long> detailMap, Map<Long, String> roleMap) {
        DynamicObjectCollection itemEntry = RegExamServiceHelper.getTemplateEntry(templateId);
        int size = examPersonIds.size();
        DynamicObjectCollection detailsObjects = new DynamicObjectCollection();
        for (int i = 0; i < size; ++i) {
            DynamicObject detailsObject = DETAILS_SERVICE_HELPER.generateEmptyDynamicObject();
            detailsObject.set("id", (Object)detailMap.get(messageIds.get(i)));
            detailsObject.set("bemployee", (Object)employee);
            detailsObject.set("person", (Object)personId);
            detailsObject.set("template", (Object)templateId);
            detailsObject.set("examperson", (Object)examPersonIds.get(i));
            detailsObject.set("role", (Object)roleMap.get(examPersonIds.get(i)));
            detailsObject.set("result", (Object)resultId);
            detailsObject.set("message", (Object)messageIds.get(i));
            detailsObject.set("initiator", (Object)RequestContext.get().getCurrUserId());
            detailsObject.set("initiatetime", (Object)new Date());
            detailsObject.set("status", (Object)"1020");
            detailsObject.set("isnewest", (Object)Boolean.TRUE);
            DynamicObjectCollection detailsEntryObjects = DETAILS_SERVICE_HELPER.generateEmptyEntryCollection(detailsObject, "entryentity");
            for (DynamicObject itemObject : itemEntry) {
                DynamicObject detailsItemObject = DETAILS_SERVICE_HELPER.generateEmptyEntryDynamicObject("entryentity");
                detailsItemObject.set("examtype", itemObject.get("regexamtype"));
                detailsItemObject.set("examitem", itemObject.get("regexamitem"));
                detailsItemObject.set("seq", itemObject.get("seq"));
                detailsEntryObjects.add((Object)detailsItemObject);
            }
            detailsObject.set("entryentity", (Object)detailsEntryObjects);
            detailsObjects.add((Object)detailsObject);
        }
        DETAILS_SERVICE_HELPER.save(detailsObjects);
    }

    public static Map<String, Long> sendExamMessageToUser(Long ermanFileId, Long examPerson, String messageTemplateNumber) {
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        Long detailId = ORM.create().genLongId(PAGE_REGEXAMDETAILS);
        String contentUrl = UrlService.getDomainContextUrl() + "/?formId=hdm_regexamreply&detailId=" + detailId + "&ermanfile=" + ermanFileId;
        LocaleString tag = ResManager.getLocaleString((String)"\u8f6c\u6b63\u8003\u8bc4", (String)"RegExamServiceHelper_4", (String)"hr-hdm-business");
        long messageId = RegMessageServiceHelper.sendMessageNotice(contentUrl, Collections.singletonList(examPerson), messageTemplateNumber, (long)ermanFileId, tag);
        resultMap.put("messageId", messageId);
        resultMap.put("detailId", detailId);
        return resultMap;
    }

    public static BigDecimal getScore(Long resultId) {
        String calType;
        QFilter commonFilter = new QFilter("result", "=", (Object)resultId).and("isnewest", "=", (Object)Boolean.TRUE);
        DynamicObject[] detailObjects = null;
        DynamicObject resultObject = RESULT_SERVICE_HELPER.queryOne("person,calculatetype", (Object)resultId);
        switch (calType = resultObject.getString("calculatetype")) {
            case "A": {
                QFilter otherFilter = new QFilter("role", "=", (Object)"A");
                detailObjects = DETAILS_SERVICE_HELPER.query("score", new QFilter[]{commonFilter, otherFilter});
                break;
            }
            case "B": {
                detailObjects = DETAILS_SERVICE_HELPER.query("score", new QFilter[]{commonFilter});
                break;
            }
            case "C": {
                Long personId = resultObject.getLong("person");
                ArrayList<Long> personIdList = new ArrayList<Long>();
                personIdList.add(personId);
                Map<Long, Long> userIdMap = RegPeronalBillHelper.getInstance().queryUserIdMap(personIdList);
                QFilter otherFilter = new QFilter("examperson", "!=", (Object)userIdMap.get(personId));
                detailObjects = DETAILS_SERVICE_HELPER.query("score", new QFilter[]{commonFilter, otherFilter});
                break;
            }
        }
        if (detailObjects != null && detailObjects.length > 0) {
            BigDecimal score = new BigDecimal(0);
            for (DynamicObject detailObject : detailObjects) {
                score = score.add(detailObject.getBigDecimal("score"));
            }
            BigDecimal sizeBD = new BigDecimal(detailObjects.length);
            return score.divide(sizeBD, 2, 4);
        }
        return new BigDecimal(0);
    }

    public static void updateOldExamDetails(List<Long> resultIds) {
        DynamicObject[] detailsObjects;
        int size = resultIds.size();
        if (size == 0) {
            return;
        }
        QFilter resultFilter = new QFilter("isnewest", "=", (Object)Boolean.TRUE).and(new QFilter("result", "in", resultIds));
        for (DynamicObject detailsObject : detailsObjects = DETAILS_SERVICE_HELPER.query("isnewest", new QFilter[]{resultFilter})) {
            detailsObject.set("isnewest", (Object)Boolean.FALSE);
        }
        DETAILS_SERVICE_HELPER.update(detailsObjects);
    }

    public static void updateOldExamDetails(Long employee, List<Long> examPersonIds, Long detailId) {
        QFilter commonFilter = new QFilter("bemployee", "=", (Object)employee).and("isnewest", "=", (Object)Boolean.TRUE);
        QFilter personFilter = new QFilter("examperson", "in", examPersonIds);
        QFilter pkFilter = new QFilter("id", "!=", (Object)detailId);
        DynamicObject[] objects = DETAILS_SERVICE_HELPER.query("isnewest", new QFilter[]{commonFilter, personFilter, pkFilter});
        if (objects.length > 0) {
            for (DynamicObject object : objects) {
                object.set("isnewest", (Object)Boolean.FALSE);
            }
            DETAILS_SERVICE_HELPER.update(objects);
        }
    }

    private static DynamicObjectCollection getTemplateEntry(Long templateId) {
        DynamicObject templateObjects = TEMPLATE_SERVICE_HELPER.queryOne((Object)templateId);
        return templateObjects.getDynamicObjectCollection("entryentity");
    }
}

