/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.repository.RegKeyEventRepository;
import kd.hr.hdm.common.parttime.enums.PosTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class RegPeronalBillHelper {
    private static final Log logger = LogFactory.getLog(RegPeronalBillHelper.class);
    private static final String[] BUSINESS_CARD_ARR = new String[]{"superior", "charge"};

    private RegPeronalBillHelper() {
    }

    public static RegPeronalBillHelper getInstance() {
        return RegPersonBillHelperHolder.INSTANCE;
    }

    public DynamicObject[] queryRegApplyInfo(Long employeeId, String filter, String billStatus) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hdm_regapplysource");
        QFilter idFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter[] filters = new QFilter[]{idFilter};
        if (!HRStringUtils.isEmpty((String)billStatus)) {
            QFilter statusFilter = new QFilter("billstatus", filter, (Object)billStatus);
            filters = new QFilter[]{idFilter, statusFilter};
        }
        String select = "id,regcategory,regcomment,effectdate,postponeprobation,postponeprobationunit,probationex,probationunitex,postponedate,comment,regstatus";
        return serviceHelper.query(select, filters, "createtime desc");
    }

    public void loadCommonPersonInfo(Map<String, Object> erManfile, IFormView view) {
        String personHeadImage = (String)erManfile.get("headsculpture");
        String personName = (String)erManfile.get("name");
        String genderName = (String)erManfile.get("gender");
        String empNumber = (String)erManfile.get("number");
        String positionName = (String)erManfile.get("position");
        String stdpositionName = (String)erManfile.get("stdposition");
        String jobName = (String)erManfile.get("job");
        String posType = (String)erManfile.get("apositiontype");
        String adminOrgName = (String)erManfile.get("adminorg");
        String labortypeName = (String)erManfile.get("laborreltype");
        String labortStatusName = (String)erManfile.get("laborrelstatus");
        String dependencyType = (String)erManfile.get("dependencytype");
        String company = (String)erManfile.get("company");
        Image imgHeadSculpture = (Image)view.getControl("headsculpture");
        personHeadImage = HRStringUtils.isEmpty((String)personHeadImage) ? "/images/pc/emotion/default_person_82_82.png" : HRImageUrlUtil.getImageFullUrl((String)personHeadImage);
        imgHeadSculpture.setUrl(personHeadImage);
        Label lblPersonName = (Label)view.getControl("name");
        lblPersonName.setText(personName);
        Label gender = (Label)view.getControl("label_gender");
        if (HRStringUtils.isNotEmpty((String)genderName)) {
            gender.setText(genderName);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flexgender"});
        }
        Label lblNumber = (Label)view.getControl("number");
        lblNumber.setText(empNumber);
        Label labelDependencytype = (Label)view.getControl("label_dependencytype");
        if (HRStringUtils.isEmpty((String)dependencyType)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"label_dependencytype"});
        } else {
            labelDependencytype.setText(dependencyType);
        }
        Label lblLaborType = (Label)view.getControl("laborreltype");
        lblLaborType.setText(labortypeName);
        Label lblLaborStatus = (Label)view.getControl("laborrelstatus");
        lblLaborStatus.setText(labortStatusName);
        if (StringUtils.isEmpty((String)company)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexcompany"});
        } else {
            Label companyLab = (Label)view.getControl("label_company");
            companyLab.setText(company);
        }
        Label lblStdPosName = (Label)view.getControl("stdposition");
        Label lblPosName = (Label)view.getControl("position");
        Label lblJobName = (Label)view.getControl("job");
        lblStdPosName.setText(stdpositionName);
        lblPosName.setText(positionName);
        lblJobName.setText(jobName);
        if (PosTypeEnum.STD_POS.getCode().equals(posType)) {
            view.setVisible(Boolean.TRUE, new String[]{"flexstdposition", "flexjob"});
            view.setVisible(Boolean.FALSE, new String[]{"flexposition"});
        } else if (PosTypeEnum.POS.getCode().equals(posType)) {
            view.setVisible(Boolean.TRUE, new String[]{"flexposition", "flexjob"});
            view.setVisible(Boolean.FALSE, new String[]{"flexstdposition"});
        } else if (PosTypeEnum.JOB.getCode().equals(posType)) {
            view.setVisible(Boolean.TRUE, new String[]{"flexjob"});
            view.setVisible(Boolean.FALSE, new String[]{"flexposition", "flexstdposition"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"flexposition", "flexstdposition", "flexjob"});
            logger.error("unexpect value of posType ... ");
        }
        if (StringUtils.isEmpty((String)jobName)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexjob"});
        }
        if (StringUtils.isEmpty((String)adminOrgName)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexorg"});
        } else {
            Label lblOrgName = (Label)view.getControl("adminorg");
            lblOrgName.setText(adminOrgName);
        }
    }

    public void loadRegularBaseInfo(Long employeeId, String regularStatus, DynamicObject entity, IFormView view) {
        List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_empentrel"});
        Map empentrel = (Map)empentrelList.get(0);
        List trialPeriodList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_trialperiod"});
        if (!CollectionUtils.isEmpty((Collection)trialPeriodList)) {
            DynamicObject[] applyInfoSubmit;
            Map trialPeriod = (Map)trialPeriodList.get(0);
            Boolean isProbation = (Boolean)empentrel.get("isprobation");
            Date actualRegularDate = null;
            if (!Objects.isNull(trialPeriod)) {
                Date entryDate = (Date)empentrel.get("startdate");
                Date estimateRegularDate = (Date)trialPeriod.get("preregulardate");
                actualRegularDate = (Date)trialPeriod.get("realregulardate");
                Object probation = trialPeriod.get("probation");
                String periodUnit = (String)trialPeriod.get("probationunit");
                String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
                String formatEntryDate = HRInteDateTimeUtil.formatDate((String)"hrpi_empentrel", (String)"startdate", (Date)entryDate);
                String formatEstimateRegularDate = HRInteDateTimeUtil.formatDate((String)"hrpi_trialperiod", (String)"preregulardate", (Date)estimateRegularDate);
                entity.set("entrydate", (Object)formatEntryDate);
                entity.set("preregulardate", (Object)formatEstimateRegularDate);
                FieldEdit fieldProbation = (FieldEdit)view.getControl("reg_probation");
                if (isProbation.booleanValue()) {
                    if (probation != null) {
                        entity.set("reg_probation", (Object)(probation + periodUnitName));
                    }
                } else {
                    fieldProbation.setText(ResManager.loadKDString((String)"\u65e0", (String)"RegPeronalBillHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            }
            if ((applyInfoSubmit = RegPeronalBillHelper.getInstance().queryRegApplyInfo(employeeId, "=", RegBillStatusEnum.APPROVEPASSED.getCode())) != null && applyInfoSubmit.length != 0 && !StringUtils.equals((String)applyInfoSubmit[0].getString("regstatus"), (String)"1030")) {
                String category = null;
                long categoryId = 0L;
                String regComment = null;
                long regCommentId = 0L;
                DynamicObject categoryObj = (DynamicObject)applyInfoSubmit[0].get("regcategory");
                DynamicObject commentObj = (DynamicObject)applyInfoSubmit[0].get("regcomment");
                actualRegularDate = applyInfoSubmit[0].getDate("effectdate");
                if (categoryObj != null) {
                    category = categoryObj.getString("name");
                    categoryId = categoryObj.getLong("id");
                }
                if (commentObj != null) {
                    regComment = commentObj.getString("name");
                    regCommentId = commentObj.getLong("id");
                }
                entity.set("regcomment", (Object)regComment);
                entity.set("regcategory", (Object)category);
                entity.set("reg_comment", (Object)applyInfoSubmit[0].getString("comment"));
                if (StringUtils.equals((String)"1040", (String)regularStatus) || StringUtils.equals((String)"1050", (String)regularStatus)) {
                    if (regCommentId == RegCommentEnum.AGREE.getId()) {
                        String formatRealRegularDate = HRInteDateTimeUtil.formatDate((String)"hdm_regapplysource", (String)"effectdate", (Date)actualRegularDate);
                        entity.set("realregulardate", (Object)formatRealRegularDate);
                    } else {
                        view.setVisible(Boolean.FALSE, new String[]{"realregulardate"});
                    }
                    view.setVisible(Boolean.FALSE, new String[]{"probationex", "postponedate", "postponeprobationview"});
                } else if (StringUtils.equals((String)"1010", (String)regularStatus) && categoryId == RegCategoryEnum.POSTPHONE.getId()) {
                    String postponeProbation = applyInfoSubmit[0].getString("postponeprobation");
                    String postponeProbationUnit = applyInfoSubmit[0].getString("postponeprobationunit");
                    String postponeProbationUnitName = RegDirectUtil.getProbationUnit((String)postponeProbationUnit);
                    entity.set("postponeprobationview", (Object)(postponeProbation + postponeProbationUnitName));
                    String postpone = applyInfoSubmit[0].getString("probationex");
                    String postponeUnit = applyInfoSubmit[0].getString("probationunitex");
                    String postponeUnitName = RegDirectUtil.getProbationUnit((String)postponeUnit);
                    Date postponeDate = applyInfoSubmit[0].getDate("postponedate");
                    String name = applyInfoSubmit[0].getDataEntityType().getName();
                    String formatPostponeDate = HRInteDateTimeUtil.formatDate((String)name, (String)"postponedate", (Date)postponeDate);
                    entity.set("probationex", (Object)(postpone + postponeUnitName));
                    entity.set("postponedate", (Object)formatPostponeDate);
                    view.setVisible(Boolean.FALSE, new String[]{"realregulardate"});
                } else {
                    view.setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap", "fieldsetpanelap4"});
                }
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"fieldsetpanelap", "fieldsetpanelap4"});
            }
        }
    }

    public void loadChargeInfoAndSup(Map<String, Object> erManFile, IFormView view) {
        EntryProp superiorEntryProp = (EntryProp)view.getModel().getProperty("superiorentry");
        DynamicObjectType superiorType = superiorEntryProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection superior = view.getModel().getEntryEntity("superiorentry");
        List superiorinfoList = (List)erManFile.get("superiorinfo");
        if (CollectionUtils.isEmpty((Collection)superiorinfoList)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexsup"});
        } else {
            Map item = (Map)superiorinfoList.get(0);
            DynamicObject dynamicObject = new DynamicObject(superiorType);
            superior.add((Object)dynamicObject);
            RegPeronalBillHelper.setLeaderInfo(view, item, "superiorimage1");
            view.getPageCache().put("superior", JSONObject.toJSONString((Object)superiorinfoList));
        }
        EntryProp entryProp = (EntryProp)view.getModel().getProperty("chargeentry");
        DynamicObjectType type = entryProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection chargeInfo = view.getModel().getEntryEntity("chargeentry");
        List chargeinfoList = (List)erManFile.get("chargeinfo");
        if (CollectionUtils.isEmpty((Collection)chargeinfoList)) {
            view.setVisible(Boolean.FALSE, new String[]{"flexcharge"});
        } else {
            Map item = (Map)chargeinfoList.get(0);
            DynamicObject dynamicObject = new DynamicObject(type);
            chargeInfo.add((Object)dynamicObject);
            RegPeronalBillHelper.setLeaderInfo(view, item, "chargeimage1");
            view.getPageCache().put("charge", JSONObject.toJSONString((Object)chargeinfoList));
        }
        if (CollectionUtils.isEmpty((Collection)chargeinfoList) && CollectionUtils.isEmpty((Collection)superiorinfoList)) {
            view.setVisible(Boolean.FALSE, new String[]{"commonline", "statusline"});
        }
    }

    public void loadAskOrExamHead(IFormView view, IDataModel model) {
        Label initiatorLabel = (Label)view.getControl("lbl_initiator");
        DynamicObject initiator = (DynamicObject)model.getValue("initiator");
        if (!Objects.isNull(initiator)) {
            initiatorLabel.setText(initiator.getString("name"));
        }
        Label initiateTimeLabel = (Label)view.getControl("lblinitiatetime");
        initiateTimeLabel.setText(this.formatTimeStamp(model.getValue("initiatetime")));
    }

    private String formatTimeStamp(Object time) {
        String format = "";
        if (Objects.isNull(time)) {
            return format;
        }
        format = HRDateTimeUtils.format((Date)((Date)time), (String)"yyyy-MM-dd");
        return format;
    }

    public Map<Long, Long> queryUserIdMap(List<Long> askPersons) {
        HashMap<String, List<Long>> idMaps = new HashMap<String, List<Long>>();
        idMaps.put("person", askPersons);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)askPersons.size());
        try {
            Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
            Map data = (Map)result.get("data");
            for (Map.Entry item : data.entrySet()) {
                Map map = (Map)item.getValue();
                resultMap.put(map.get("person"), map.get("user"));
            }
        }
        catch (Exception e) {
            logger.error("RegPeronalBillHelper.queryUserIdMap error : " + ExceptionUtils.getStackTrace((Throwable)e));
            logger.error("RegPeronalBillHelper.queryUserIdMap errordata : {}", (Object)JSONObject.toJSONString(askPersons));
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u4eba\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegPeronalBillHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public Map<String, Object> queryHRPersonMap() {
        Map map = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
        Map resultMap = (Map)map.get("data");
        if (!((Boolean)map.get("success")).booleanValue()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7cfb\u7edf\u4eba\u5458\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegPeronalBillHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        return resultMap;
    }

    public Long queryLabRelStatusCls(Long employeeId) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(employeeId);
        logger.info("IHRPIEmployeeService getEmployeeStatus param: {}", list);
        Map employeeList = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{list});
        logger.info("IHRPIEmployeeService getEmployeeStatus result: {}", (Object)employeeList);
        if (CollectionUtils.isEmpty((Map)employeeList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4eba\u5458\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegPeronalBillHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        DynamicObject employee = (DynamicObject)employeeList.get(employeeId);
        return (Long)employee.get("labrelstatuscls_id");
    }

    public Map<Long, DynamicObject> getEmployeeStatus(List<Long> list) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{list});
    }

    private static void setLeaderInfo(IFormView view, Map<String, Object> leaderInfo, String chargeimage3) {
        Image chargeImage = (Image)view.getControl(chargeimage3);
        String personHeadImage = (String)leaderInfo.get("headsculpture");
        if (!HRStringUtils.isEmpty((String)personHeadImage) && !personHeadImage.contains("/images/pc/emotion/default_person_82_82.png")) {
            chargeImage.setUrl(HRImageUrlUtil.getImageFullUrl((String)personHeadImage));
        }
    }

    public void beforeShowTips(BeforeShowTipsEvent evt, IFormView view) {
        Control source = (Control)evt.getSource();
        FormShowParameter formshowParameter = evt.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
        }
        String controlKey = source.getKey();
        for (String businessKey : BUSINESS_CARD_ARR) {
            if (!controlKey.startsWith(businessKey)) continue;
            String key = businessKey;
            String leaderStr = view.getPageCache().get(key);
            List leaderList = (List)JSONObject.parseObject((String)leaderStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
            Map leaderMap = (Map)leaderList.get(0);
            formshowParameter.setCustomParam("id", (Object)String.valueOf(leaderMap.get("id")));
            formshowParameter.setCustomParam("name", (Object)String.valueOf(leaderMap.get("name")));
            formshowParameter.setCustomParam("number", (Object)String.valueOf(leaderMap.get("number")));
            evt.setFormshowParameter(formshowParameter);
        }
    }

    public void refreshKeyEventCountForRegSelfBill(IFormView view) {
        IFormView grandFatherView;
        IFormView targetView = null;
        IFormView parentView = view.getParentView();
        if (parentView != null && "hdm_regselfhelpbill_mob".equals(parentView.getFormShowParameter().getFormId())) {
            targetView = parentView;
        }
        if (parentView != null && !"hdm_regselfhelpbill_mob".equals(parentView.getFormShowParameter().getFormId()) && (grandFatherView = parentView.getParentView()) != null && "hdm_regselfhelpbill_mob".equals(grandFatherView.getFormShowParameter().getFormId())) {
            targetView = grandFatherView;
        }
        if (targetView != null) {
            Label label = (Label)targetView.getControl("keyeventcount");
            DynamicObject[] dys = this.getProbationKeyEvent(targetView);
            label.setText(String.valueOf(dys.length));
            view.sendFormAction(targetView);
        }
    }

    private DynamicObject[] getProbationKeyEvent(IFormView targetView) {
        long employeeId = targetView.getModel().getDataEntity().getLong("ermanfile.employee.id");
        QFilter qFilter = new QFilter("bemployee", "=", (Object)employeeId);
        qFilter.and(new QFilter("importsource", "=", (Object)"2"));
        return RegKeyEventRepository.getInstance().query("id", new QFilter[]{qFilter}, null);
    }

    private static class RegPersonBillHelperHolder {
        private static final RegPeronalBillHelper INSTANCE = new RegPeronalBillHelper();

        private RegPersonBillHelperHolder() {
        }
    }
}

