/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.common.reg.constants.TrialPeriodResultConstants;
import org.apache.commons.lang3.StringUtils;

public class RegProcessServiceHelper {
    public static final HRBaseServiceHelper PROCESS_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regprocess");

    public static void updateWhenRegBatch(List<Long> employees, List<Long> personIds, boolean isDirectReg, String regStatus, Map<Long, Boolean> overDueMap) {
        DynamicObjectCollection processObjects = RegProcessServiceHelper.queryProcessByEmps(employees, personIds);
        for (DynamicObject processObject : processObjects) {
            processObject.set("regstatus", (Object)regStatus);
            processObject.set("isdirectreg", (Object)isDirectReg);
            long trialPeriodResult = RegProcessServiceHelper.getTrialPeriodResult(regStatus);
            if (trialPeriodResult == TrialPeriodResultConstants.REG_NOT_PASS || trialPeriodResult == TrialPeriodResultConstants.REG_PASS) {
                processObject.set("trialperiodrst", (Object)trialPeriodResult);
            }
            if (overDueMap == null || !"1040".equals(regStatus)) continue;
            long employeeId = processObject.getLong("bemployee");
            processObject.set("isoverdue", (Object)overDueMap.get(employeeId));
        }
        PROCESS_SERVICE_HELPER.save(processObjects);
        RegProcessServiceHelper.saveBatchRegTrace(employees, personIds, regStatus);
    }

    private static long getTrialPeriodResult(String regStatus) {
        if ("1040".equals(regStatus)) {
            return TrialPeriodResultConstants.REG_PASS;
        }
        if ("1050".equals(regStatus)) {
            return TrialPeriodResultConstants.REG_NOT_PASS;
        }
        return 0L;
    }

    private static void saveBatchRegTrace(List<Long> employees, List<Long> personIds, String regStatus) {
        String traceType = null;
        if ("1040".equals(regStatus)) {
            traceType = "1070";
        }
        if ("1050".equals(regStatus)) {
            traceType = "2010";
        }
        if (traceType == null) {
            return;
        }
        long traceId = RequestContext.get().getCurrUserId() == 0L ? 1L : RequestContext.get().getCurrUserId();
        RegTraceServiceHelper.logBatchRegular(employees, personIds, traceId, traceType);
    }

    public static boolean updateWhenAsk(long employee, long personId, String status) {
        boolean isChangeStatus;
        DynamicObject processObject = RegProcessServiceHelper.queryProcessByEmp(employee, personId, "askstatus");
        boolean bl = isChangeStatus = !StringUtils.equalsIgnoreCase((CharSequence)processObject.getString("askstatus"), (CharSequence)status);
        if (isChangeStatus) {
            processObject.set("askstatus", (Object)status);
            PROCESS_SERVICE_HELPER.saveOne(processObject);
        }
        return isChangeStatus;
    }

    public static boolean updateWhenExam(long employee, long personId, String status) {
        boolean isChangeStatus;
        DynamicObject processObject = RegProcessServiceHelper.queryProcessByEmp(employee, personId, "examstatus");
        boolean bl = isChangeStatus = !StringUtils.equalsIgnoreCase((CharSequence)processObject.getString("examstatus"), (CharSequence)status);
        if (isChangeStatus) {
            processObject.set("examstatus", (Object)status);
            PROCESS_SERVICE_HELPER.saveOne(processObject);
        }
        return isChangeStatus;
    }

    private static DynamicObject queryProcessByEmp(long employee, long personId, String selectProperties) {
        QFilter filter = new QFilter("bemployee", "=", (Object)employee);
        DynamicObject processObject = PROCESS_SERVICE_HELPER.queryOne(selectProperties, new QFilter[]{filter});
        if (processObject == null) {
            processObject = PROCESS_SERVICE_HELPER.generateEmptyDynamicObject();
            processObject.set("bemployee", (Object)employee);
            processObject.set("person", (Object)personId);
        }
        return processObject;
    }

    private static DynamicObjectCollection queryProcessByEmps(List<Long> employees, List<Long> personIds) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        QFilter filter = new QFilter("bemployee", "in", employees);
        DynamicObject[] processObjects = PROCESS_SERVICE_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
        ArrayList<Long> existProcessEmps = new ArrayList<Long>(processObjects.length);
        for (DynamicObject processObject : processObjects) {
            result.add((Object)processObject);
            existProcessEmps.add(processObject.getLong("bemployee"));
        }
        int size = employees.size();
        for (int i = 0; i < size; ++i) {
            Long employee = employees.get(i);
            if (existProcessEmps.contains(employee)) continue;
            DynamicObject processObject = PROCESS_SERVICE_HELPER.generateEmptyDynamicObject();
            processObject.set("bemployee", (Object)employee);
            processObject.set("person", (Object)personIds.get(i));
            result.add((Object)processObject);
        }
        return result;
    }

    public static String getRegStatusByEmployee(Long employeeId) {
        List trialPeriodList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_trialperiod"});
        if (HRCollUtil.isEmpty((Collection)trialPeriodList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8be5\u4eba\u5458\u8bd5\u7528\u671f\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegProcessServiceHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        Object regStatus = ((Map)trialPeriodList.get(0)).get("regstatus");
        return HRObjectUtils.isEmpty(regStatus) ? "1010" : String.valueOf(regStatus);
    }
}

