/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRImageAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.common.reg.constants.RegTraceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class RegTraceHelper {
    private static String FLEXMSGLIST = "flexmsgflowlist";
    private static String IMGURLFINISH = "/icons/pc/state/agree_13_13.png";
    private static final String HDM_REGTRACE = "hdm_regtrace";

    private RegTraceHelper() {
    }

    public static RegTraceHelper getInstance() {
        return RegTraceHelperHolder.INSTANCE;
    }

    public FlexPanelAp createRegMsgFlowPanelAp(Long bemployee) {
        FlexPanelAp listPanelAp = new HRFlexPanelAp.Builder(FLEXMSGLIST).setGrow(0).setShrink(0).setWidth("100%").setJustifyContent("flex-start").setAlignItems("stretch").setDirection("column").build();
        QFilter filter = new QFilter("bemployee", "=", (Object)bemployee);
        DynamicObject[] traceObjects = RegTraceServiceHelper.REG_TRACE_SERVICE_HELPER.query("person.headsculpture,bemployee_id,trace.name,trace.picturefield,type,optime", new QFilter[]{filter}, "optime desc");
        int size = traceObjects.length;
        for (int i = 0; i < size; ++i) {
            DynamicObject traceObject = traceObjects[i];
            FlexPanelAp msgFlowListItemAp = this.customMsgFlowListItemAp("flexmsgflowlistitem" + i);
            FlexPanelAp placeHolderPanelAp = this.customPlaceHolderPanelAp("flexplaceholder" + i);
            FlexPanelAp msgStateShowPanelAp = this.customMsgStateShowPanelAp("flexmsgstateshow" + i);
            LabelAp connectLineWhiteAp = this.customConnectLineAp("lblconnectline" + i, "#ffffff");
            LabelAp connectLineGrayAp = this.customConnectLineAp("lblconnectline" + i, "#CCCCCC");
            ImageAp stateIconImgAp = this.customStateIconImgAp("imgstateicon" + i);
            if (i == 0) {
                msgStateShowPanelAp.getItems().add(connectLineWhiteAp);
            } else {
                msgStateShowPanelAp.getItems().add(connectLineGrayAp);
            }
            msgStateShowPanelAp.getItems().add(stateIconImgAp);
            if (i != size - 1) {
                msgStateShowPanelAp.getItems().add(connectLineGrayAp);
            } else {
                msgStateShowPanelAp.getItems().add(connectLineWhiteAp);
            }
            FlexPanelAp msgBackgroundAp = this.customMsgBackgroundPanelAp("flexmsgbackground" + i);
            String headSculpture = "/images/pc/emotion/default_person_82_82.png";
            StringBuilder regMsgText = new StringBuilder();
            String personHead = traceObject.getString("person.headsculpture");
            String traceHead = traceObject.getString("trace.picturefield");
            String type = traceObject.getString("type");
            if (HRStringUtils.equals((String)type, (String)"1070") || HRStringUtils.equals((String)type, (String)"2010")) {
                if (!HRStringUtils.isEmpty((String)personHead)) {
                    headSculpture = HRImageUrlUtil.getImageFullUrl((String)personHead);
                }
                regMsgText.append(traceObject.getString("person.name")).append(' ').append(traceObject.getString("person.number"));
            } else {
                Long traceUserId;
                if (!HRStringUtils.isEmpty((String)traceHead)) {
                    headSculpture = HRImageUrlUtil.getImageFullUrl((String)traceHead);
                }
                if (!ObjectUtils.isEmpty((Object)(traceUserId = Long.valueOf(traceObject.getLong("trace.id")))) && 1L == traceUserId) {
                    headSculpture = traceHead;
                }
                regMsgText.append(traceObject.getString("trace.name")).append(' ').append(traceObject.getString("trace.number"));
            }
            regMsgText.append(this.getTypeName(type));
            Long userId = RequestContext.get().getCurrUserId();
            String dateFormat = InteServiceHelper.getDateFormat((Long)userId);
            Map timeFormat = InteServiceHelper.getTimeFormat((Long)userId);
            StringBuilder format = new StringBuilder(dateFormat);
            Date opTime = null;
            String regMsgTime = "";
            if (!StringUtils.equals((String)"1070", (String)type)) {
                format.append(' ').append((String)timeFormat.get("timeFormat"));
                opTime = traceObject.getDate("optime");
                regMsgTime = HRInteDateTimeUtil.formatDate((String)HDM_REGTRACE, (String)"optime", (Date)opTime);
            } else {
                Long employeeId = traceObject.getLong("bemployee_id");
                DynamicObject[] bills = RegPeronalBillHelper.getInstance().queryRegApplyInfo(employeeId, "=", RegBillStatusEnum.APPROVEPASSED.getCode());
                if (bills != null && bills.length > 0) {
                    opTime = bills[0].getDate("effectdate");
                    regMsgTime = HRDateTimeUtils.format((Date)opTime, (String)format.toString());
                }
            }
            ImageAp headSculImgAp = this.customHeadSculptureImageAp("imgheadscul" + i, headSculpture);
            FlexPanelAp msgInfoPanelAp = this.customMsgInfoPanelAp("flexmsginfo" + i);
            LabelAp msgTextLabelAp = this.customMsgTextLabelAp("lblmsgtext" + i, regMsgText.toString(), "#333333", 14, "4px", true);
            LabelAp msgTimeLabelAp = this.customMsgTextLabelAp("lblmsgtime" + i, regMsgTime, "#BBBBBB", 12, "0px", false);
            msgInfoPanelAp.getItems().add(msgTextLabelAp);
            msgInfoPanelAp.getItems().add(msgTimeLabelAp);
            msgBackgroundAp.getItems().add(headSculImgAp);
            msgBackgroundAp.getItems().add(msgInfoPanelAp);
            msgFlowListItemAp.getItems().add(placeHolderPanelAp);
            msgFlowListItemAp.getItems().add(msgStateShowPanelAp);
            msgFlowListItemAp.getItems().add(msgBackgroundAp);
            listPanelAp.getItems().add(msgFlowListItemAp);
        }
        return listPanelAp;
    }

    private String getTypeName(String type) {
        String result = RegTraceEnum.getValueByCode((String)type);
        return result;
    }

    private FlexPanelAp customMsgFlowListItemAp(String apKey) {
        FlexPanelAp listItemPanelAp = new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(1).setWidth("100%").setJustifyContent("flex-start").setAlignItems("center").setDirection("row").setWrap(false).build();
        return listItemPanelAp;
    }

    private FlexPanelAp customPlaceHolderPanelAp(String apKey) {
        FlexPanelAp placeHolderPanelAp = new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setWidth("10px").build();
        return placeHolderPanelAp;
    }

    private FlexPanelAp customMsgStateShowPanelAp(String apKey) {
        FlexPanelAp msgStatePanelAp = new HRFlexPanelAp.Builder(apKey).setGrow(0).setShrink(0).setWrap(false).setAlignItems("center").setDirection("column").setWidth("30px").setHeight("68px").build();
        return msgStatePanelAp;
    }

    private FlexPanelAp customMsgBackgroundPanelAp(String apKey) {
        FlexPanelAp msgBackgroundAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setBackColor("#F5F6F8").setGrow(1).setShrink(1).setWrap(false).setRadius("2px").setJustifyContent("flex-start").setAlignItems("center").setDirection("row").setHeight("50px").setPaddingLeft("6px")).build();
        return msgBackgroundAp;
    }

    private ImageAp customHeadSculptureImageAp(String apKey, String imgKey) {
        ImageAp imageAp = new HRImageAp.Builder(apKey).setId(apKey).setRadius("20px").setWidth("38px").setHeight("38px").setGrow(0).setShrink(0).setImageKey(imgKey).build();
        return imageAp;
    }

    private FlexPanelAp customMsgInfoPanelAp(String apKey) {
        FlexPanelAp msgInfoPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(apKey).setGrow(1).setShrink(1).setWrap(false).setDirection("column").setMarginLeft("12px")).build();
        return msgInfoPanelAp;
    }

    private LabelAp customMsgTextLabelAp(String apKey, String labelName, String color, int fontSize, String marginBottom, boolean isBolder) {
        LabelAp msgTextLabelAp = ((HRLabelAp.Builder)new HRLabelAp.Builder(apKey).setName(labelName).setGrow(0).setShrink(0).setWidth(new LocaleString("100%")).setFontSize(fontSize).setForeColor(color).setMarginBottom(marginBottom)).build();
        if (isBolder) {
            msgTextLabelAp.setFontWeight("bolder");
        }
        return msgTextLabelAp;
    }

    private LabelAp customConnectLineAp(String apKey, String color) {
        LabelAp lineLabelAp = new HRLabelAp.Builder(apKey).setBackColor(color).setGrow(1).setShrink(0).setClickable(false).setAutoTextWrap(false).setWidth(new LocaleString("2px")).build();
        return lineLabelAp;
    }

    private ImageAp customStateIconImgAp(String apKey) {
        ImageAp iconImgAp = ((HRImageAp.Builder)((HRImageAp.Builder)new HRImageAp.Builder(apKey).setId(apKey).setImageKey(IMGURLFINISH).setGrow(0).setShrink(0).setRadius("10px").setWidth("14px").setHeight("14px").setMarginTop("4px")).setMarginBottom("4px")).build();
        return iconImgAp;
    }

    private static class RegTraceHelperHolder {
        private static final RegTraceHelper INSTANCE = new RegTraceHelper();

        private RegTraceHelperHolder() {
        }
    }
}

