/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class RegTraceServiceHelper {
    private static final Log logger = LogFactory.getLog(RegTraceServiceHelper.class);
    private static final String PAGE_REGTRACE = "hdm_regtrace";
    public static final HRBaseServiceHelper REG_TRACE_SERVICE_HELPER = new HRBaseServiceHelper("hdm_regtrace");

    public static void logRegular(long employeeId, long personId, long traceId, String regType) {
        DynamicObject logObject = RegTraceServiceHelper.generateLogObject(employeeId, personId, traceId, regType);
        REG_TRACE_SERVICE_HELPER.saveOne(logObject);
    }

    public static void logBatchRegular(List<Long> employeeIds, List<Long> personIds, long traceId, String regType) {
        if (employeeIds == null || personIds == null || employeeIds.size() != personIds.size()) {
            logger.error("\u8c03\u7528\u8f6c\u6b63\u8db3\u8ff9\u6279\u91cf\u65b9\u6cd5\u4f20\u53c2\u9519\u8bef");
        } else {
            HRBaseServiceHelper regTraceServiceHelper = new HRBaseServiceHelper(PAGE_REGTRACE);
            DynamicObjectCollection logObjects = new DynamicObjectCollection();
            int size = employeeIds.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject logObject = RegTraceServiceHelper.generateLogObject(employeeIds.get(i), personIds.get(i), traceId, regType);
                logObjects.add((Object)logObject);
            }
            regTraceServiceHelper.save(logObjects);
        }
    }

    public static boolean isExistTrace(Long employeeId) {
        QFilter filter = new QFilter("bemployee", "=", (Object)employeeId);
        return REG_TRACE_SERVICE_HELPER.isExists(filter);
    }

    private static DynamicObject generateLogObject(long employeeId, long personId, long traceId, String regType) {
        DynamicObject logObject = REG_TRACE_SERVICE_HELPER.generateEmptyDynamicObject();
        logObject.set("bemployee", (Object)employeeId);
        logObject.set("person", (Object)personId);
        logObject.set("trace", (Object)traceId);
        logObject.set("type", (Object)regType);
        logObject.set("optime", (Object)new Date());
        return logObject;
    }
}

