/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hdm.business.reg.RegBaseHPFSTemplateHandler;
import kd.hr.hdm.business.reg.RegNewHpfsServiceHelper;
import kd.hr.hdm.common.reg.constants.RegActionConstants;
import kd.sdk.hr.common.bean.PerChgBizInfoNew;
import kd.sdk.hr.hdm.perchg.IRegWaitChgExtendService;
import kd.sdk.hr.hpfs.business.mservice.helper.ChgRecordHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class RegWaitEffectHPFSTemplateHandler
extends RegBaseHPFSTemplateHandler {
    private static final RegWaitEffectHPFSTemplateHandler HANDLER = new RegWaitEffectHPFSTemplateHandler();
    private static final String[] entityNumbers = new String[]{"hrpi_trialperiod"};

    private RegWaitEffectHPFSTemplateHandler() {
    }

    public static RegWaitEffectHPFSTemplateHandler getInstance() {
        return HANDLER;
    }

    @Override
    public void setPreProperty(DynamicObject bill) {
        super.setPreProperty(bill);
        bill.set("b_effectivedate", (Object)new Date());
    }

    @Override
    protected void prePersonParamsBuilder(PerChgBizInfoNew perChgBizInfoNew, DynamicObject bill) {
        perChgBizInfoNew.setChgActionId(RegActionConstants.REG_DELAY_ACTION_ID_NEW);
    }

    @Override
    public void buildCustomPersonParams(List<PerChgBizInfoNew> perChgBizInfoNews, DynamicObject[] bills) {
        HashSet<Long> employeeIds = new HashSet<Long>(bills.length);
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            employeeIds.add(bill.getLong("ermanfile.employee.id"));
            billMap.put(bill.getLong("id"), bill);
        }
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)"1");
        DynamicObject[] trialperiods = RepositoryUtils.queryDynamicObjects((String)"hrpi_trialperiod", null, (QFilter[])new QFilter[]{iscurrentversionFilter, employeeFilter, dataStatusFilter});
        Map trialperiodMap = Arrays.stream(trialperiods).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (oldV, newV) -> oldV));
        HashMap map = new HashMap(perChgBizInfoNews.size());
        perChgBizInfoNews.forEach(perChgBizInfoNew -> {
            Long billId = perChgBizInfoNew.getBillId();
            DynamicObject bill = (DynamicObject)billMap.get(billId);
            long employeeId = bill.getLong("ermanfile.employee.id");
            DynamicObject trialperiod = (DynamicObject)trialperiodMap.get(employeeId);
            DynamicObject newTrialperiod = this.getNewTrialperiod((PerChgBizInfoNew)perChgBizInfoNew, trialperiod, bill, perChgBizInfoNew.getEffectivedate());
            ChgRecordHelper.updIdsRecord((String)"hrpi_trialperiod", (DynamicObject)trialperiod, (DynamicObject)newTrialperiod, (PerChgBizInfoNew)perChgBizInfoNew, (String)ChgModeEnum.MODIFY.getChgMode());
            this.setPersonParams((PerChgBizInfoNew)perChgBizInfoNew, entityNumbers);
            map.put(billId, perChgBizInfoNew);
        });
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IRegWaitChgExtendService.class, (String)"kd.sdk.hr.hdm.perchg.IRegWaitChgExtendService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            hrPlugin.setCustomPersonParamsExtend(bills, map);
            return null;
        });
    }

    @Override
    protected void saveBatchPersonAttach(List<PerChgBizInfoNew> perChgBizInfoNews) {
        RegNewHpfsServiceHelper.savePersonsAndRecordHpfsChg(perChgBizInfoNews, entityNumbers);
    }

    private DynamicObject getNewTrialperiod(PerChgBizInfoNew perChgBizInfoNew, DynamicObject trialperiod, DynamicObject bill, Date effectivedate) {
        DynamicObject newHisDy = ChgRecordHelper.getHisDyById((PerChgBizInfoNew)perChgBizInfoNew, (DynamicObject)trialperiod, (String)"hrpi_trialperiod");
        newHisDy.set("probationunit", (Object)bill.getString("probationunitex"));
        newHisDy.set("preregulardate", (Object)bill.getDate("postponedate"));
        newHisDy.set("probation", (Object)bill.getInt("probationex"));
        newHisDy.set("regstatus", (Object)bill.getString("regstatus"));
        newHisDy.set("bsed", (Object)effectivedate);
        newHisDy.set("bsled", (Object)MAX_DATE);
        return newHisDy;
    }
}

