/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.domain.service.common.IRegDateService;
import kd.hr.hdm.business.repository.RegNearPreDateRepository;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.constants.RegBillTypeEnum;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class RegBillServiceImpl
implements IRegBillService {
    private static final Log LOGGER = LogFactory.getLog(RegBillServiceImpl.class);
    private static final String FORMAT_DATE = "yyyy-MM-dd";

    @Override
    public boolean doValidateEffectDateAndPreActualDate(DynamicObject bill, Map<String, List<String>> errorMap) {
        return this.doValidateEffectDateAndPreActualDate(bill, errorMap, Boolean.TRUE);
    }

    @Override
    public boolean doValidateEffectDateAndPreActualDate(DynamicObject bill, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        String warningMsg;
        String warningMsgForRisk;
        long regCategoryId = bill.getLong("regcategory.id");
        Date regDate = bill.getDate("effectdate");
        Date entryDate = bill.getDate("entrydate");
        Date preRegularDate = bill.getDate("preactualdate");
        if (entryDate == null || preRegularDate == null) {
            LOGGER.info("one or more of ( ENTRYDATE , PREACTUALDATE )  is empty process go on");
            return false;
        }
        List<String> warningMsgList = errorMap.get(RegBillServiceEnum.WARNING.getCode());
        List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
        if (RegCategoryEnum.INADVANCE.getId() == regCategoryId && (regDate.after(preRegularDate) || DateUtils.isSameDay((Date)regDate, (Date)preRegularDate))) {
            if (tipsWithBillNo.booleanValue()) {
                errorMsgList.add(ResManager.loadKDString((String)"%s\uff1a\u63d0\u524d\u8f6c\u6b63\u60c5\u51b5\u4e0b\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_22", (String)"hr-hdm-business", (Object[])new Object[]{this.getBillno(bill)}));
            } else {
                errorMsgList.add(ResManager.loadKDString((String)"\u5982\u679c\u5458\u5de5\u63d0\u524d\u8f6c\u6b63\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            return true;
        }
        if (null != regDate && regDate.before(entryDate)) {
            if (tipsWithBillNo.booleanValue()) {
                errorMsgList.add(ResManager.loadKDString((String)"%s\uff1a\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_23", (String)"hr-hdm-business", (Object[])new Object[]{this.getBillno(bill)}));
            } else {
                errorMsgList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            return true;
        }
        if (RegCategoryEnum.POSTPHONE.getId() == regCategoryId) {
            Date oldDate = IRegDateService.getInstance().calcDate(entryDate, bill.getInt("probation"), bill.getString("probationunit"));
            Date postPoneDate = IRegDateService.getInstance().calcDate(entryDate, bill.getInt("probationex"), bill.getString("probationunitex"));
            if (postPoneDate.before(oldDate) || DateUtils.isSameDay((Date)postPoneDate, (Date)oldDate)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u5ef6\u957f\u8bd5\u7528\u671f\u9700\u5927\u4e8e\u539f\u8bd5\u7528\u671f\u201c%s\u201d\u3002", (String)"RegBillServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[]{bill.getInt("probation") + RegDateUnitEnum.getName((String)bill.getString("probationunit"))}));
                return true;
            }
        }
        if (tipsWithBillNo.booleanValue()) {
            warningMsgForRisk = ResManager.loadKDString((String)"%s\uff1a\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u665a\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u53ef\u80fd\u4f1a\u6709\u7528\u5de5\u98ce\u9669\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[]{this.getBillno(bill)});
            warningMsg = ResManager.loadKDString((String)"%s\uff1a\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u4f46\u8f6c\u6b63\u5206\u7c7b\u4e0d\u662f\u201c\u63d0\u524d\u8f6c\u6b63\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[]{this.getBillno(bill)});
        } else {
            warningMsgForRisk = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u665a\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u53ef\u80fd\u4f1a\u6709\u7528\u5de5\u98ce\u9669\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[0]);
            warningMsg = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u4f46\u8f6c\u6b63\u5206\u7c7b\u4e0d\u662f\u201c\u63d0\u524d\u8f6c\u6b63\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]);
        }
        if (!HRObjectUtils.isEmpty((Object)regDate) && HRDateTimeUtils.format((Date)regDate, (String)FORMAT_DATE).compareTo(HRDateTimeUtils.format((Date)preRegularDate, (String)FORMAT_DATE)) > 0) {
            warningMsgList.add(warningMsgForRisk);
        }
        if (RegCategoryEnum.INADVANCE.getId() != regCategoryId && !HRObjectUtils.isEmpty((Object)regDate) && HRDateTimeUtils.format((Date)regDate, (String)FORMAT_DATE).compareTo(HRDateTimeUtils.format((Date)preRegularDate, (String)FORMAT_DATE)) < 0) {
            warningMsgList.add(warningMsg);
        }
        errorMap.put(RegBillServiceEnum.WARNING.getCode(), warningMsgList);
        return false;
    }

    @Override
    public void doValidateEffectDateBeforePreActualDate(DynamicObject bill, Map<String, List<String>> errorMap, RegBillServiceEnum level) {
        Long regCateGory = bill.getLong("regcategory_id");
        Date regDate = bill.getDate("effectdate");
        String billType = bill.getString("regbilltype");
        Date preRegularDate = bill.getDate("preactualdate");
        if (regDate == null || regCateGory == 0L || preRegularDate == null) {
            return;
        }
        List<String> warningMsgList = errorMap.get(level.getCode());
        if (!RegCategoryEnum.INADVANCE.getId().equals(regCateGory) && regDate.compareTo(preRegularDate) < 0 && !"1".equals(billType)) {
            warningMsgList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u4f46\u8f6c\u6b63\u5206\u7c7b\u4e0d\u662f\u201c\u63d0\u524d\u8f6c\u6b63\u201d\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[0]));
        } else if (RegCategoryEnum.INADVANCE.getId().equals(regCateGory) && preRegularDate.compareTo(regDate) <= 0) {
            warningMsgList.add(ResManager.loadKDString((String)"\u5982\u679c\u5458\u5de5\u63d0\u524d\u8f6c\u6b63\uff0c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u9700\u65e9\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        errorMap.put(level.getCode(), warningMsgList);
    }

    @Override
    public void doValidateEffectDateAfterPreActualDate(DynamicObject bill, Map<String, List<String>> errorMap, RegBillServiceEnum level) {
        Date regDate = bill.getDate("effectdate");
        Date preRegularDate = bill.getDate("preactualdate");
        if (regDate == null || preRegularDate == null) {
            return;
        }
        List<String> warningMsgList = errorMap.get(level.getCode());
        String warningMsgForRisk = ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u665a\u4e8e\u9884\u8f6c\u6b63\u65e5\u671f\uff0c\u53ef\u80fd\u4f1a\u6709\u7528\u5de5\u98ce\u9669\uff0c\u662f\u5426\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\uff1f", (String)"RegBillServiceImpl_11", (String)"hr-hdm-business", (Object[])new Object[0]);
        if (regDate.after(preRegularDate)) {
            warningMsgList.add(warningMsgForRisk);
        }
        errorMap.put(level.getCode(), warningMsgList);
    }

    @Override
    public void doValidateEffectDateAfterEntryDate(DynamicObject bill, Map<String, List<String>> errorMap, RegBillServiceEnum level) {
        Date entryDate = bill.getDate("entrydate");
        Date regDate = bill.getDate("effectdate");
        if (Objects.isNull(entryDate) || Objects.isNull(regDate)) {
            return;
        }
        List<String> warningMsgList = errorMap.get(level.getCode());
        if (regDate.before(entryDate)) {
            warningMsgList.add(ResManager.loadKDString((String)"\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RegBillServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    private boolean executeErrorMsg(DynamicObject bill, Map<String, List<String>> retMap, DynamicObject[] dynamicObjects, Boolean tipsWithBillNo) {
        String thisBillNo = this.getBillno(bill);
        long billId = bill.getLong("id");
        List objectFilteredList = Arrays.stream(dynamicObjects).filter(dynamicObject -> {
            if (thisBillNo.equals(this.getBillno((DynamicObject)dynamicObject))) {
                return false;
            }
            if (billId == dynamicObject.getLong("id")) {
                return false;
            }
            if (RegBillStatusEnum.APPROVEREJECTED.getCode().equals(dynamicObject.getString("billstatus"))) {
                return false;
            }
            return !RegBusinessStatusEnum.WAIT_REG.getCode().equals(dynamicObject.getString("regstatus")) || !RegBillStatusEnum.APPROVEPASSED.getCode().equals(dynamicObject.getString("billstatus"));
        }).collect(Collectors.toList());
        if (HRCollUtil.isNotEmpty(objectFilteredList)) {
            String retErrorMsg;
            List<String> errorMsgList = retMap.get(RegBillServiceEnum.ERROR.getCode());
            String personName = bill.getDynamicObject("ermanfile").getString("name");
            DynamicObject processRegBill = (DynamicObject)objectFilteredList.get(0);
            String processBillNo = this.getProcessBillNo(processRegBill);
            if (Boolean.TRUE.equals(tipsWithBillNo)) {
                String errorMsg = ResManager.loadKDString((String)"{0}\uff1a\u68c0\u6d4b\u5230{1}\u5b58\u5728\u5176\u4ed6\u7684\u8f6c\u6b63\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{2}\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u8d77\uff1b", (String)"RegBillServiceImpl_13", (String)"hr-hdm-business", (Object[])new Object[0]);
                retErrorMsg = MessageFormat.format(errorMsg, this.getBillno(bill), personName, processBillNo);
            } else {
                String errorMsg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u201c{0}\u201d\u5b58\u5728\u5176\u4ed6\u7684\u8f6c\u6b63\u4e8b\u52a1\uff0c\u5355\u636e\u7f16\u53f7\u4e3a\u201c{1}\u201d\uff0c\u4e0d\u53ef\u91cd\u590d\u53d1\u8d77\uff1b", (String)"RegBillServiceImpl_14", (String)"hr-hdm-business", (Object[])new Object[0]);
                retErrorMsg = MessageFormat.format(errorMsg, personName, processBillNo);
            }
            errorMsgList.add(retErrorMsg);
            retMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
            return true;
        }
        return false;
    }

    private String getProcessBillNo(DynamicObject regBill) {
        long fMid = regBill.getLong("mid");
        if (fMid != 0L) {
            DynamicObject dy = IBatchRegBillService.getInstance().queryOne("billno", fMid);
            return dy.getString("billno");
        }
        return regBill.getString("billno");
    }

    @Override
    public boolean doValidateBillInProcess(DynamicObject bill, Map<String, List<String>> errorMap) {
        return this.doValidateBillInProcess(bill, errorMap, Boolean.TRUE);
    }

    @Override
    public boolean doValidateBillInProcess(DynamicObject bill, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        long employeeId = bill.getLong("ermanfile.employee.id");
        QFilter employeeQFilter = new QFilter("bemployee", "in", Collections.singletonList(employeeId));
        QFilter billStatusQFilter = this.setQFilterByBillInProcess();
        DynamicObject[] dynamicObjects = this.queryDatas(new QFilter[]{employeeQFilter, billStatusQFilter});
        return this.executeErrorMsg(bill, errorMap, dynamicObjects, tipsWithBillNo);
    }

    @Override
    public Map<String, Map<String, List<String>>> doBatchValidateBillInProcess(List<DataValidate<DynamicObject>> dataValidateList) {
        HashMap<String, Map<String, List<String>>> resultMap = new HashMap<String, Map<String, List<String>>>(dataValidateList.size());
        List employeeIds = dataValidateList.stream().map(item -> ((DynamicObject)item.getData()).getLong("ermanfile.employee.id")).collect(Collectors.toList());
        QFilter employeeFilter = new QFilter("bemployee", "in", employeeIds);
        QFilter billStatusFilter = this.setQFilterByBillInProcess();
        Object[] dynamicObjects = this.queryDatas(new QFilter[]{employeeFilter, billStatusFilter});
        if (HRArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> regAppBillMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(item -> item.getLong("ermanfile.employee.id")));
        for (DataValidate<DynamicObject> dataValidate : dataValidateList) {
            DynamicObject data = (DynamicObject)dataValidate.getData();
            List<DynamicObject> dys = regAppBillMap.get(data.getLong("ermanfile.employee.id"));
            if (HRCollUtil.isEmpty(dys)) continue;
            HashMap<String, List<String>> errorMap = new HashMap<String, List<String>>(16);
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList(1));
            errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList(1));
            this.executeErrorMsg(data, errorMap, dys.toArray(new DynamicObject[0]), Boolean.FALSE);
            List errorMsgList = (List)errorMap.get(RegBillServiceEnum.ERROR.getCode());
            for (String errorMsg : errorMsgList) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "errorMsg", errorMsg);
            }
            if (data.containsProperty("billno")) {
                resultMap.put(data.getString("billno"), errorMap);
                continue;
            }
            resultMap.put(data.getString("ebillno"), errorMap);
        }
        return resultMap;
    }

    private DynamicObject[] queryDatas(QFilter[] qFilters) {
        String selectProperties = "id,person,billno,ermanfile,billstatus,regstatus,org,regbilltype,regcategory,mid";
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, qFilters);
    }

    @Override
    public void update(DynamicObject billObj) {
        HDMRegBaseBillRepository.getInstance().updateDataOne(billObj);
    }

    @Override
    public void update(DynamicObject[] billObjs) {
        HDMRegBaseBillRepository.getInstance().update(billObjs);
    }

    @Override
    public DynamicObject[] query(String selectProperties, QFilter[] qFilters) {
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, qFilters);
    }

    private QFilter setQFilterByBillInProcess() {
        return new QFilter("billstatus", "in", (Object)new String[]{RegBillStatusEnum.ALREADYSUBMIT.getCode(), RegBillStatusEnum.WAITRESUBMIT.getCode(), RegBillStatusEnum.TEMPSTORAGE.getCode(), RegBillStatusEnum.APPROVING.getCode(), RegBillStatusEnum.APPROVEPASSED.getCode()});
    }

    @Override
    public DynamicObject[] queryBillInProcess(List<Long> employeeIdList, String selectProperties) {
        QFilter employeeFilter = new QFilter("bemployee", "in", employeeIdList);
        QFilter billStatusQFilter = this.setQFilterByBillInProcess();
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, new QFilter[]{billStatusQFilter, employeeFilter}, "createtime desc");
    }

    @Override
    public void syncRegProcess(DynamicObject billObj, String processStatus) {
        this.syncRegProcess(new DynamicObject[]{billObj}, processStatus);
    }

    @Override
    public void syncRegProcess(DynamicObject[] billObjs, String processStatus) {
        List<Long> empIds = Arrays.stream(billObjs).map(temp -> temp.getLong("bemployee.id")).collect(Collectors.toList());
        List<Long> personIds = Arrays.stream(billObjs).map(temp -> temp.getLong("person.id")).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)processStatus)) {
            String regBillType = billObjs[0].getString("regbilltype");
            Map<Long, Boolean> overDueMap = IRegProbationService.getInstance().getOverDue(billObjs);
            RegProcessServiceHelper.updateWhenRegBatch(empIds, personIds, RegBillTypeEnum.QUICKSINGLE.getStatus().equals(regBillType) ? Boolean.TRUE : Boolean.FALSE, processStatus, overDueMap);
            this.syncRegNearPreDate(personIds, processStatus);
        }
    }

    private void syncRegNearPreDate(List<Long> personIdList, String regStatus) {
        QFilter qFilter = new QFilter("person", "in", personIdList);
        DynamicObject[] regNearPreDates = RegNearPreDateRepository.getRepository().query("regstatus", new QFilter[]{qFilter});
        if (regNearPreDates != null && regNearPreDates.length > 0) {
            for (DynamicObject regNearPreDate : regNearPreDates) {
                regNearPreDate.set("regstatus", (Object)regStatus);
            }
            RegNearPreDateRepository.getRepository().update(regNearPreDates);
        }
    }

    @Override
    public void syncRegTrace(DynamicObject[] billObjs, String traceType) {
        long userId = RequestContext.get().getCurrUserId() == 0L ? 1L : RequestContext.get().getCurrUserId();
        this.syncRegTrace(new ArrayList<DynamicObject>(Arrays.asList(billObjs)), traceType, userId);
    }

    @Override
    public void syncRegTrace(List<DynamicObject> bills, String traceType, long userId) {
        ArrayList<Long> personIds = new ArrayList<Long>();
        Consumer<DynamicObject> setPersonId = dy -> personIds.add(dy.getLong("id"));
        List<Long> empIds = bills.stream().peek(setPersonId).map(bill -> bill.getLong("bemployee.id")).collect(Collectors.toList());
        RegTraceServiceHelper.logBatchRegular(empIds, personIds, userId, traceType);
    }

    @Override
    public void executeAuditPassed(DynamicObject regBillObj) {
        try {
            long labStatusClsId = regBillObj.getLong("laborrelstatus.labrelstatuscls_id");
            if (LabRelConstants.QUIT.equals(labStatusClsId) || RegBillStatusEnum.ABANDONED.getCode().equals(regBillObj.getString(this.getStatusField(regBillObj)))) {
                LOGGER.info("the bill has already be quited when we execute audit passed , we do nothing in this process");
                return;
            }
            if ("entryentity".equals(regBillObj.getDynamicObjectType().toString())) {
                regBillObj.set("entrybillstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
            } else {
                regBillObj.set("billstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
            }
            long commentId = regBillObj.getDynamicObject("regcomment").getLong("id");
            long categoryId = regBillObj.getDynamicObject("regcategory").getLong("id");
            if (1020L == commentId) {
                if (RegCategoryEnum.POSTPHONE.getId() == categoryId) {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
                    this.syncRegProcess(regBillObj, "1010");
                    this.syncRegTrace(new DynamicObject[]{regBillObj}, "1060");
                } else {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
                    this.syncRegProcess(regBillObj, "1050");
                }
            } else if (1010L == commentId) {
                Date effectDate = regBillObj.getDate("effectdate");
                if (ObjectUtils.isEmpty((Object)effectDate)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u4e3a\u7a7a\u3002", (String)"RegBillServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
                if (effectDate.before(new Date()) || DateUtils.isSameDay((Date)effectDate, (Date)new Date())) {
                    if (!this.validatePersonQuitAlready(regBillObj)) {
                        regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.ALREADY_REGED.getCode());
                        if (regBillObj.getDynamicObject("laborrelstatus") == null) {
                            DynamicObject affaction = regBillObj.getDynamicObject("affaction");
                            List<DynamicObject> laborrelstatusList = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction(affaction);
                            regBillObj.set("laborrelstatus", laborrelstatusList.size() > 0 ? laborrelstatusList.get(0) : null);
                        }
                        this.syncRegProcess(regBillObj, "1040");
                    }
                } else {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode());
                    this.syncRegProcess(regBillObj, "1030");
                }
            } else {
                LOGGER.error(this.getClass().getName() + "the regcomment put with error ID , please check table t_hdm_regcomment that if only contains 1020 and 1010");
            }
        }
        catch (Exception exception) {
            LOGGER.error("reg apply auditPassed error:", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6b63\u7533\u8bf7\u63d0\u4ea4\u5e76\u751f\u6548\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"RegBillServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
    }

    private boolean validatePersonQuitAlready(DynamicObject regBillObj) {
        long empId = regBillObj.getLong("bemployee.id");
        Map<Long, DynamicObject> labStatusByEmpId = IPersonAboutService.getInstance().getLabStatusByEmpId(Collections.singletonList(empId));
        DynamicObject labStatus = labStatusByEmpId.get(empId);
        Long labStatusClsId = (Long)labStatus.get("labrelstatuscls_id");
        if (LabRelConstants.QUIT.equals(labStatusClsId)) {
            LOGGER.info("validate the labStatusClsId equals quit(1040L) during we are on auditPassed process ... ");
            long erManFile = regBillObj.getLong("ermanfile.id");
            List<Map<String, Object>> quitEffectTimeList = IPersonAboutService.getInstance().getQuitEffectTime(Collections.singletonList(erManFile));
            regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
            regBillObj.set("laborrelstatus", (Object)labStatus);
            regBillObj.set("termuser", (Object)1L);
            String date = DateUtils.formatDate((Date)((Date)quitEffectTimeList.get(0).get("enddate")), (Object[])new Object[]{FORMAT_DATE});
            this.fillTerminateInfo(regBillObj, date);
            this.syncRegProcess(regBillObj, "1050");
            this.syncRegTrace(Collections.singletonList(regBillObj), "1080", 1L);
            return true;
        }
        return false;
    }

    @Override
    public void fillTerminateInfo(DynamicObject regBillObj, String dateString) {
        regBillObj.set("modifytime", (Object)new Date());
        regBillObj.set("termdate", (Object)new Date());
        regBillObj.set("termreason", (Object)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u6210\u529f\u79bb\u804c\uff08\u65e5\u671f\uff1a%s\uff09\uff0c\u8f6c\u6b63\u6d41\u7a0b\u81ea\u52a8\u7ec8\u6b62\u3002", (String)"RegBillServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[]{dateString}));
    }

    @Override
    public boolean terminateWorkFlow(Object billId) {
        block15: {
            Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)String.valueOf(billId));
            if (!Objects.isNull(instanceId) && !instanceId.equals(0L)) {
                try (TXHandle txHandle = TX.notSupported();){
                    LOGGER.info("RegBaseBill terminate work flow , instanceId : [{}]", (Object)instanceId);
                    WorkflowServiceHelper.abandon((Long)instanceId);
                    break block15;
                }
                catch (Exception exception) {
                    LOGGER.error("RegBaseBill terminate work flow exception : [{}] ", (Object)exception.getMessage());
                    return false;
                }
            }
            LOGGER.info("RegBaseBill terminate work flow , but not found active instance ");
        }
        return true;
    }

    @Override
    public boolean terminateWorkFlow(DynamicObject regBill) {
        boolean terminated = this.terminateWorkFlow(regBill.getPkValue());
        if (terminated) {
            try (TXHandle txHandle = TX.notSupported();){
                IHSSCService.getInstance().terminateSSCTask(regBill);
            }
            catch (Exception exception) {
                LOGGER.error("RegBaseBill terminate ssc task exception : [{}] ", (Object)exception.getMessage());
                return false;
            }
        }
        return terminated;
    }

    @Override
    public boolean terminateValidate(DynamicObject regBill) {
        String billStatus = regBill.getString("billstatus");
        String regStatus = regBill.getString("regstatus");
        if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
            return true;
        }
        return RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus) && RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus);
    }

    @Override
    public DynamicObject[] queryRegBill(Map<String, Object> param, String selectProperties) {
        if (param == null || param.size() < 1) {
            return new DynamicObject[0];
        }
        ArrayList qFilters = new ArrayList(param.size());
        param.forEach((k, v) -> {
            QFilter filter = new QFilter(k, "in", v);
            qFilters.add(filter);
        });
        return HDMRegBaseBillRepository.getInstance().query(selectProperties, qFilters.toArray(new QFilter[0]));
    }

    @Override
    public void updatePersonCrossDataByAuditPass(List<DynamicObject> regBillList) {
        List<DynamicObject> rejectBills;
        List<DynamicObject> delayBills;
        List<DynamicObject> alreadyBills;
        List<DynamicObject> waitEffectBills = regBillList.stream().filter(temp -> RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList());
        if (HRCollUtil.isNotEmpty(waitEffectBills)) {
            IRegEffectService.getInstance().updateReg(waitEffectBills);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(waitEffectBills, "1020");
        }
        if (HRCollUtil.isNotEmpty(alreadyBills = regBillList.stream().filter(temp -> RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) {
            IRegEffectService.getInstance().effectReg(alreadyBills);
            IRegBillService.getInstance().updateSyncStatus(alreadyBills, "-1");
        }
        if (!ObjectUtils.isEmpty(delayBills = regBillList.stream().filter(temp -> RegBusinessStatusEnum.WAIT_REG.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) {
            IRegEffectService.getInstance().delayReg(delayBills);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(delayBills, "1040");
        }
        if (!ObjectUtils.isEmpty(rejectBills = regBillList.stream().filter(temp -> RegBusinessStatusEnum.REJECT_REG.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList()))) {
            IRegEffectService.getInstance().updateReg(rejectBills);
            IPersonAboutService.getInstance().doUpdatePersonCrossData(rejectBills, "1040");
        }
    }

    @Override
    public void beforeValidateUnSubmit(AbstractFormPlugin formPlugin, BeforeDoOperationEventArgs args, String billStatus) {
        if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e3a\u201c%s\u201d\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"RegBillServiceImpl_24", (String)"hr-hdm-business", (Object[])new Object[]{RegBillStatusEnum.getName((String)billStatus)}));
            args.setCancel(true);
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin);
            String confirmTip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u64a4\u9500\u540e\u6d41\u7a0b\u5c06\u56de\u5230\u201c\u6682\u5b58\u201d\u72b6\u6001\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegBillServiceImpl_25", (String)"hr-hdm-business", (Object[])new Object[0]);
            formPlugin.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
        }
    }

    @Override
    public void beforeValidateDelete(AbstractFormPlugin formPlugin, BeforeDoOperationEventArgs args, String billStatus) {
        if (!RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billStatus)) {
            formPlugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"RegBillServiceImpl_26", (String)"hr-hdm-business", (Object[])new Object[]{RegBillStatusEnum.getName((String)billStatus)}));
            args.setCancel(true);
        }
    }

    @Override
    public boolean addDLock(DynamicObject regBill) {
        String entityName = regBill.getDynamicObjectType().getName();
        DLock dLock = DLock.create((String)(entityName + regBill.getLong("bemployee.id")));
        try {
            if (!dLock.tryLock()) {
                LOGGER.info("\u5b58\u5728\u5728\u9014\u5355\u636e\uff1a{},{}", (Object)regBill.getString("billno"), (Object)regBill.getLong("bemployee.id"));
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("tryLock error:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void releaseDLock(DynamicObject regBill) {
        String entityName = regBill.getDynamicObjectType().getName();
        DLock.forceUnlock((String[])new String[]{entityName + regBill.getLong("bemployee.id")});
    }

    @Override
    public void beforeBeginTransactionValidateProcessIn(DynamicObject regBill) {
        boolean success = this.addDLock(regBill);
        if (!success) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e3a\u8be5\u5458\u5de5\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RegBillServiceImpl_29", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
        errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
        this.doValidateBillInProcess(regBill, errorMap, false);
        if (((List)errorMap.get(RegBillServiceEnum.ERROR.getCode())).size() > 0) {
            this.releaseDLock(regBill);
            throw new KDBizException((String)((List)errorMap.get(RegBillServiceEnum.ERROR.getCode())).get(0));
        }
    }

    @Override
    public boolean doValidatelaborrelstatus(DynamicObject regBill, Map<String, List<String>> errorMap) {
        DynamicObject laborrelstatus = regBill.getDynamicObject("laborrelstatus");
        if (laborrelstatus == null) {
            return false;
        }
        DynamicObject affaction = regBill.getDynamicObject("affaction");
        List<Long> laborrelstatusList = PersonnelChangeServiceHelper.getLaborrelstatusByAffaction(affaction);
        if (laborrelstatusList == null || laborrelstatusList.isEmpty() || !laborrelstatusList.contains(laborrelstatus.getLong("id"))) {
            errorMap.get(RegBillServiceEnum.ERROR.getCode()).add(ResManager.loadKDString((String)"\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u586b\u5199\u6709\u8bef\uff0c \u8bf7\u4fee\u6539\u3002", (String)"RegBillServiceImpl_31", (String)"hr-hdm-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    @Override
    public void setLaborrelStatusByRegComment(DynamicObject regBill) {
        List<DynamicObject> laborrelStatusList;
        DynamicObject affaction;
        if (RegCommentEnum.AGREE.getId().equals(regBill.getLong("regcomment.id")) && !HRObjectUtils.isEmpty((Object)(affaction = regBill.getDynamicObject("affaction"))) && HRCollUtil.isNotEmpty(laborrelStatusList = PersonnelChangeServiceHelper.getLaborrelstatusDyByAffaction(affaction))) {
            regBill.set("laborrelstatus", (Object)laborrelStatusList.get(0));
        }
    }

    @Override
    public void executeAuditPassed(DynamicObject[] regBillObjs) {
        Arrays.stream(regBillObjs).forEach(this::executeAuditPassed);
    }

    @Override
    public void executeSubmit(DynamicObject[] regBillObjs) {
        Arrays.stream(regBillObjs).forEach(temp -> {
            temp.set("submittime", (Object)new Date());
            temp.set("regstatus", (Object)RegBusinessStatusEnum.REGING.getCode());
        });
        this.syncRegProcess(regBillObjs, "1020");
        this.syncRegTrace(regBillObjs, "1030");
    }

    @Override
    public void executeAuditNotPassed(DynamicObject[] regBillObjs) {
        Arrays.stream(regBillObjs).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.APPROVEREJECTED.getCode());
            temp.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
        });
        this.update(regBillObjs);
        this.syncRegProcess(regBillObjs, "1010");
        this.syncRegTrace(regBillObjs, "1080");
    }

    @Override
    public void executeAuditToSubmit(DynamicObject[] regBillObjs) {
        Arrays.stream(regBillObjs).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.WAITRESUBMIT.getCode());
            temp.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
        });
        this.update(regBillObjs);
        this.syncRegProcess(regBillObjs, "1010");
    }

    @Override
    public void executeAuditToEdit(DynamicObject[] regBillObjs) {
        Arrays.stream(regBillObjs).forEach(temp -> {
            temp.set("billstatus", (Object)RegBillStatusEnum.ALREADYSUBMIT.getCode());
            temp.set("auditstatus", (Object)RegBillStatusEnum.ALREADYSUBMIT.getCode());
        });
        this.update(regBillObjs);
    }

    @Override
    public boolean doValidateBillNotInTempStorage(DynamicObject bill, Map<String, List<String>> errorMap) {
        return this.doValidateBillNotInTempStorage(bill, errorMap, Boolean.TRUE);
    }

    @Override
    public boolean doValidateBillNotInTempStorage(DynamicObject bill, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        if (!RegBillStatusEnum.TEMPSTORAGE.getCode().equals(bill.getString("billstatus")) && !RegBillStatusEnum.WAITRESUBMIT.getCode().equals(bill.getString("billstatus"))) {
            List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
            String errMsg = tipsWithBillNo != false ? ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"RegBillServiceImpl_16", (String)"hr-hdm-business", (Object[])new Object[]{bill.getString("billno")}) : ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u548c\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"RegBillServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0]);
            errorMsgList.add(errMsg);
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
            return true;
        }
        return false;
    }

    @Override
    public boolean doValidateIfSelfApply(DynamicObject billObj, Map<String, List<String>> errorMap, Boolean tipsWithBillNo) {
        if (RegBillTypeEnum.EMP.getStatus().equals(billObj.getString("regbilltype"))) {
            List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
            String errorMsg = tipsWithBillNo != false ? ResManager.loadKDString((String)"%s\uff1a\u5458\u5de5\u7533\u8bf7\u7684\u8f6c\u6b63\u5355\u6682\u4e0d\u652f\u6301PC\u7aef\u4ee3\u63d0\u4ea4\u3002", (String)"RegBillServiceImpl_17", (String)"hr-hdm-business", (Object[])new Object[]{billObj.getString("billno")}) : ResManager.loadKDString((String)"\u5458\u5de5\u7533\u8bf7\u7684\u8f6c\u6b63\u5355\u6682\u4e0d\u652f\u6301PC\u7aef\u4ee3\u63d0\u4ea4\u3002", (String)"RegBillServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0]);
            errorMsgList.add(errorMsg);
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), errorMsgList);
            return true;
        }
        return false;
    }

    @Override
    public boolean doValidateIfSelfApply(DynamicObject billObj, Map<String, List<String>> errorMap) {
        return this.doValidateIfSelfApply(billObj, errorMap, Boolean.TRUE);
    }

    @Override
    public void updateSyncStatus(List<DynamicObject> billObjs, String syncStatus) {
        for (DynamicObject obj : billObjs) {
            obj.set("syncstatus", (Object)syncStatus);
        }
        HDMRegBaseBillRepository.getInstance().update(billObjs.toArray(new DynamicObject[billObjs.size()]));
    }

    @Override
    public void doTerminateProcess(DynamicObject billObj) {
        String billStatus = billObj.getString("billstatus");
        if (RegBillStatusEnum.APPROVING.getCode().equals(billStatus) || RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
            billObj.set("billstatus", (Object)RegBillStatusEnum.ABANDONED.getCode());
        }
        billObj.set("auditstatus", (Object)RegNewAuditStatusEnum.ABANDONED.getCode());
        billObj.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
        HDMRegBaseBillRepository.getInstance().updateDataOne(billObj);
        this.syncRegTrace(new DynamicObject[]{billObj}, "1080");
        this.syncRegProcess(billObj, RegBusinessStatusEnum.WAIT_REG.getCode());
    }

    private String getBillno(DynamicObject regbill) {
        String thisBillNo = "entryentity".equals(regbill.getDynamicObjectType().toString()) ? regbill.getString("ebillno") : regbill.getString("billno");
        return thisBillNo;
    }

    private String getStatusField(DynamicObject regbill) {
        String billStatusfield = "entryentity".equals(regbill.getDynamicObjectType().toString()) ? "entrybillstatus" : "billstatus";
        return billStatusfield;
    }

    @Override
    public void doBatchTerminateProcess(DynamicObject[] billObjs) {
        for (DynamicObject billObj : billObjs) {
            String billStatus = billObj.getString("billstatus");
            if (RegBillStatusEnum.APPROVING.getCode().equals(billStatus) || RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
                billObj.set("billstatus", (Object)RegBillStatusEnum.ABANDONED.getCode());
            }
            billObj.set("auditstatus", (Object)RegNewAuditStatusEnum.ABANDONED.getCode());
            billObj.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
        }
        HDMRegBaseBillRepository.getInstance().updateDatas(billObjs);
        this.syncRegTrace(billObjs, "1080");
        this.syncRegProcess(billObjs, RegBusinessStatusEnum.WAIT_REG.getCode());
    }

    @Override
    public void batchExecuteAuditPassed(DynamicObject[] regBillObjs) {
        List<DynamicObject> regBillObjList = Arrays.stream(regBillObjs).filter(regBillObj -> !LabRelConstants.QUIT.equals(regBillObj.getLong("laborrelstatus.labrelstatuscls_id")) && !RegBillStatusEnum.ABANDONED.getCode().equals(regBillObj.getString(this.getStatusField((DynamicObject)regBillObj)))).collect(Collectors.toList());
        if (regBillObjList.isEmpty()) {
            return;
        }
        HashMap<String, List> map = new HashMap<String, List>();
        Date date = new Date();
        regBillObjList.forEach(regBillObj -> {
            if ("entryentity".equals(regBillObj.getDynamicObjectType().toString())) {
                regBillObj.set("entrybillstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
            } else {
                regBillObj.set("billstatus", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
            }
            long commentId = regBillObj.getLong("regcomment.id");
            long categoryId = regBillObj.getLong("regcategory.id");
            String processStatus = "";
            if (1020L == commentId) {
                if (RegCategoryEnum.POSTPHONE.getId() == categoryId) {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.WAIT_REG.getCode());
                    processStatus = "1010";
                } else {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
                    processStatus = "1050";
                }
            } else if (1010L == commentId) {
                Date effectDate = regBillObj.getDate("effectdate");
                if (ObjectUtils.isEmpty((Object)effectDate)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u4e3a\u7a7a\u3002", (String)"RegBillServiceImpl_15", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
                if (effectDate.before(date) || DateUtils.isSameDay((Date)effectDate, (Date)date)) {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.ALREADY_REGED.getCode());
                    processStatus = "1040";
                } else {
                    regBillObj.set("regstatus", (Object)RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode());
                    processStatus = "1030";
                }
            } else {
                LOGGER.error(this.getClass().getName() + "the regcomment put with error code , please check table t_hdm_regcomment that if only contains 1020_S and 1010_S");
            }
            if (!processStatus.isEmpty()) {
                List billList = map.getOrDefault(processStatus, new ArrayList());
                billList.add(regBillObj);
                map.put(processStatus, billList);
            }
        });
        map.forEach((traceType, list) -> {
            DynamicObject[] billObjs = list.toArray(new DynamicObject[0]);
            if ("1010".equals(traceType)) {
                this.syncRegTrace(billObjs, "1060");
            }
            if ("1040".equals(traceType)) {
                this.deleteQuitPersons((List<DynamicObject>)list);
                ArrayList<Long> actionIds = new ArrayList<Long>();
                List<DynamicObject> needSetLaborrelstatus = list.stream().filter(dy -> dy.getDynamicObject("laborrelstatus") == null).peek(dy -> actionIds.add(dy.getLong("affaction.id"))).collect(Collectors.toList());
                if (needSetLaborrelstatus == null || needSetLaborrelstatus.isEmpty()) {
                    return;
                }
                Map<Long, List<DynamicObject>> laborrelstatusMap = PersonnelChangeServiceHelper.getLaborrelstatusByAffactions(actionIds);
                needSetLaborrelstatus.forEach(regBillObj -> {
                    Long actionId = regBillObj.getLong("affaction.id");
                    if (laborrelstatusMap.containsKey(actionId)) {
                        List laborrelstatus = (List)laborrelstatusMap.get(actionId);
                        regBillObj.set("laborrelstatus", laborrelstatus.isEmpty() ? null : laborrelstatus.get(0));
                    }
                });
            }
            this.syncRegProcess(billObjs, (String)traceType);
        });
    }

    private void deleteQuitPersons(List<DynamicObject> list) {
        ArrayList<DynamicObject> discardList = new ArrayList<DynamicObject>();
        ArrayList<Long> ermanfileIds = new ArrayList<Long>();
        List<Long> empIds = list.stream().map(regBillObj -> regBillObj.getLong("bemployee.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> labStatusByEmpMap = IPersonAboutService.getInstance().getLabStatusByEmpId(empIds);
        list.forEach(regBillObj -> {
            long empId = regBillObj.getLong("bemployee.id");
            DynamicObject labStatus = (DynamicObject)labStatusByEmpMap.get(empId);
            Long labStatusClsId = labStatus.getLong("labrelstatuscls_id");
            if (LabRelConstants.QUIT.equals(labStatusClsId)) {
                ermanfileIds.add(regBillObj.getLong("ermanfile.id"));
                discardList.add((DynamicObject)regBillObj);
            }
        });
        if (discardList.isEmpty()) {
            return;
        }
        list.removeAll(discardList);
        LOGGER.info("validate the labStatusClsId equals quit(1040L) during we are on auditPassed process ... ", ermanfileIds);
        List<Map<String, Object>> quitEffectTimeList = IPersonAboutService.getInstance().getQuitEffectTime(ermanfileIds);
        HashMap empIdWithEndDate = new HashMap();
        Date date = new Date();
        quitEffectTimeList.forEach(temp -> empIdWithEndDate.put((Long)temp.get("employee_id"), DateUtils.formatDate((Date)((Date)temp.get("enddate")), (Object[])new Object[]{FORMAT_DATE})));
        discardList.forEach(disrardReg -> {
            long empId = disrardReg.getLong("bemployee.id");
            disrardReg.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
            disrardReg.set("laborrelstatus", labStatusByEmpMap.get(empId));
            disrardReg.set("termuser", (Object)1L);
            disrardReg.set("modifytime", (Object)date);
            disrardReg.set("termdate", (Object)date);
            disrardReg.set("termreason", (Object)ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u6210\u529f\u79bb\u804c\uff08\u65e5\u671f\uff1a%s\uff09\uff0c\u8f6c\u6b63\u6d41\u7a0b\u81ea\u52a8\u7ec8\u6b62\u3002", (String)"RegBillServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[]{empIdWithEndDate.get(empId)}));
        });
        this.syncRegProcess(discardList.toArray(new DynamicObject[0]), "1050");
        this.syncRegTrace(discardList, "1080", 1L);
    }

    @Override
    public Map<String, List<Long>> terminateBatchValidate(DynamicObject[] regBills) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        for (DynamicObject regBill : regBills) {
            String billStatus = regBill.getString("billstatus");
            String regStatus = regBill.getString("regstatus");
            if (RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus) || RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus) && RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode().equals(regStatus)) continue;
            List fails = map.getOrDefault(regStatus, new ArrayList());
            fails.add(regBill.getLong("id"));
            map.put(regStatus, fails);
        }
        return map;
    }
}

