/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hdm.business.reg.RegPeronalBillHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IRegInitService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.util.RegDirectUtil;
import org.apache.commons.collections.CollectionUtils;

public class RegInitServiceImpl
implements IRegInitService {
    @Override
    public void initDynamicObjectByErmanFile(DynamicObject newData, DynamicObject ermanFile) {
        this.setErmanFile(newData, ermanFile);
        DynamicObject empPosorgrel = ermanFile.getDynamicObject("empposrel");
        this.setEmpPosorgrel(newData, empPosorgrel);
        long employeeId = ermanFile.getLong("employee_id");
        this.setTrialPeriod(newData, employeeId);
        Date entryDate = (Date)ermanFile.get("empentrel.startdate");
        newData.set("entrydate", (Object)entryDate);
        newData.set("billstatus", (Object)RegBillStatusEnum.TEMPSTORAGE.getCode());
    }

    @Override
    public DynamicObject getErmanFileBySysId() {
        Map<String, Object> hrPersonMap = RegPeronalBillHelper.getInstance().queryHRPersonMap();
        Long personId = (Long)hrPersonMap.get("person");
        return (DynamicObject)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getPrimaryErmanfFile", (Object[])new Object[]{personId});
    }

    private void setErmanFile(DynamicObject newData, DynamicObject ermanFile) {
        newData.set("ermanfile", (Object)ermanFile);
        newData.set("org", (Object)ermanFile.getDynamicObject("org"));
        newData.set("bhrbu", (Object)ermanFile.getDynamicObject("org"));
        newData.set("bempgroup", (Object)ermanFile.getDynamicObject("empgroup"));
        newData.set("baffiliateadminorg", (Object)ermanFile.getDynamicObject("affiliateadminorg"));
        newData.set("bdependency", (Object)ermanFile.getDynamicObject("dependency"));
        newData.set("bdependencytype", (Object)ermanFile.getDynamicObject("dependencytype"));
        newData.set("person", (Object)ermanFile.getDynamicObject("person"));
        newData.set("bemployee", (Object)ermanFile.getDynamicObject("employee"));
        newData.set("cmpemp", ermanFile.getDynamicObject("cmpemp").get("managingscope"));
    }

    private void setEmpPosorgrel(DynamicObject newData, DynamicObject empPosorgrel) {
        newData.set("badminorg", (Object)empPosorgrel.getDynamicObject("adminorg"));
        newData.set("bposition", (Object)empPosorgrel.getDynamicObject("position"));
        newData.set("standardpost", (Object)empPosorgrel.getDynamicObject("stdposition"));
        newData.set("bjob", (Object)empPosorgrel.getDynamicObject("job"));
    }

    private void setTrialPeriod(DynamicObject newData, Long employeeId) {
        List trialPeriodList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployeeAttachs", (Object[])new Object[]{employeeId, "hrpi_trialperiod"});
        if (!CollectionUtils.isEmpty((Collection)trialPeriodList)) {
            Map trialPeriod = (Map)trialPeriodList.get(0);
            Object probation = trialPeriod.get("probation");
            String periodUnit = (String)trialPeriod.get("probationunit");
            String periodUnitName = RegDirectUtil.getProbationUnit((String)periodUnit);
            newData.set("probation", probation);
            newData.set("probationunit", (Object)periodUnit);
            newData.set("probationtext", (Object)(probation + periodUnitName));
            newData.set("preactualdate", trialPeriod.get("preregulardate"));
            newData.set("effectdate", trialPeriod.get("preregulardate"));
        }
    }
}

