/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.domain.transfer.service.impl.EffectTransferServiceImpl;
import kd.hr.hdm.business.personnelchange.servicehelper.PersonnelChangeServiceHelper;
import kd.hr.hdm.business.reg.RegProcessServiceHelper;
import kd.hr.hdm.business.reg.RegTraceServiceHelper;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegEffectService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegPersonChangeService;
import kd.hr.hdm.common.reg.constants.LabRelConstants;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.transfer.util.ObjectUtils;

public class RegPersonChangeServiceImpl
implements IRegPersonChangeService {
    private static final Log logger = LogFactory.getLog(EffectTransferServiceImpl.class);
    private static final String SELECT_FIELDS = "id,billno,org,regstatus,effectdate,regcomment,affaction,auditstatus,syncstatus,laborrelstatus,person,bemployee,ermanfile,regbilltype,termuser,termdate,termreason,modifytime";

    @Override
    public void executeRegEffect() {
        ArrayList<DynamicObject> allBills = new ArrayList<DynamicObject>();
        try (TXHandle txHandle = TX.required();){
            try {
                Calendar now = Calendar.getInstance();
                QFilter effectDateFilter = new QFilter("effectdate", "<=", (Object)now.getTime());
                QFilter regStatusFilter = new QFilter("regstatus", "=", (Object)RegBusinessStatusEnum.REG_PENDINGTOBEVALID.getCode());
                QFilter[] qFilters = new QFilter[]{effectDateFilter, regStatusFilter};
                DynamicObject[] regBills = IRegBillService.getInstance().query(SELECT_FIELDS, qFilters);
                QFilter syncError = new QFilter("syncstatus", "=", (Object)"0");
                QFilter regStatus = new QFilter("regstatus", "=", (Object)RegBusinessStatusEnum.ALREADY_REGED.getCode());
                DynamicObject[] regErrorBills = IRegBillService.getInstance().query(SELECT_FIELDS, new QFilter[]{syncError, regStatus});
                if (ObjectUtils.isEmpty((Object)regErrorBills) || 0 == regErrorBills.length) {
                    logger.info(this.getClass().getName() + "executeRegEffect : there is no syncFailed data will be executed personChange ...");
                } else {
                    logger.info(this.getClass().getName() + "executeRegEffect : there are " + regBills.length + regErrorBills.length + "  data will be executed personChange ...");
                }
                List<Long> empIds = Arrays.stream(regBills).map(temp -> temp.getLong("bemployee.id")).collect(Collectors.toList());
                Map<Long, DynamicObject> labStatusByEmpId = IPersonAboutService.getInstance().getLabStatusByEmpId(empIds);
                List<Long> empIdsOfQuitAlready = IPersonAboutService.getInstance().getIdsOfQuitAlready(labStatusByEmpId);
                List<Long> erManFiles = Arrays.stream(regBills).filter(temp -> empIdsOfQuitAlready.contains(temp.getLong("bemployee.id"))).map(temp -> temp.getLong("ermanfile.id")).collect(Collectors.toList());
                List<Map<String, Object>> quitEffectTimeList = IPersonAboutService.getInstance().getQuitEffectTime(erManFiles);
                HashMap empIdWithEndDate = new HashMap();
                quitEffectTimeList.forEach(temp -> empIdWithEndDate.put((Long)temp.get("employee_id"), DateUtils.formatDate((Date)((Date)temp.get("enddate")), (Object[])new Object[]{"yyyy-MM-dd"})));
                if (ObjectUtils.isEmpty((Object)regBills) || 0 == regBills.length) {
                    logger.info(this.getClass().getName() + "executeRegEffect : there is no normal data will be executed personChange ...");
                } else {
                    ArrayList<Long> actionIdList = new ArrayList<Long>(regBills.length);
                    Arrays.stream(regBills).forEach(regBill -> {
                        long actionId = regBill.getLong("affaction.id");
                        actionIdList.add(actionId);
                    });
                    Map<Long, List<DynamicObject>> laborrelstatusMap = PersonnelChangeServiceHelper.getLaborrelstatusByAffactions(actionIdList);
                    ArrayList<Long> empIds4Agree = new ArrayList<Long>(regBills.length);
                    ArrayList<Long> personIds4Agree = new ArrayList<Long>(regBills.length);
                    ArrayList<Long> empIds4Reject = new ArrayList<Long>();
                    ArrayList<Long> personIds4Reject = new ArrayList<Long>();
                    Arrays.stream(regBills).forEach(temp -> {
                        DynamicObject labStatus = (DynamicObject)labStatusByEmpId.get(temp.getLong("bemployee.id"));
                        if (!ObjectUtils.isEmpty((Object)labStatus)) {
                            Long labStatusClsId = (Long)labStatus.get("labrelstatuscls_id");
                            if (LabRelConstants.QUIT.equals(labStatusClsId)) {
                                temp.set("regstatus", (Object)RegBusinessStatusEnum.REJECT_REG.getCode());
                                temp.set("laborrelstatus", (Object)labStatus);
                                temp.set("termuser", (Object)1L);
                                IRegBillService.getInstance().fillTerminateInfo((DynamicObject)temp, (String)empIdWithEndDate.get(temp.getLong("bemployee.id")));
                                personIds4Reject.add(temp.getLong("person.id"));
                                empIds4Reject.add(temp.getLong("bemployee.id"));
                            } else {
                                temp.set("regstatus", (Object)RegBusinessStatusEnum.ALREADY_REGED.getCode());
                                Long actionId = temp.getDynamicObject("affaction").getLong("id");
                                if (temp.getDynamicObject("laborrelstatus") == null && laborrelstatusMap.containsKey(actionId)) {
                                    List laborrelstatus = (List)laborrelstatusMap.get(actionId);
                                    temp.set("laborrelstatus", laborrelstatus.isEmpty() ? null : laborrelstatus.get(0));
                                }
                                personIds4Agree.add(temp.getLong("person.id"));
                                empIds4Agree.add(temp.getLong("bemployee.id"));
                            }
                        }
                    });
                    logger.info("RegPersonChangeServiceImpl executeRegEffect start sync process and trace ... ");
                    IRegBillService.getInstance().update(regBills);
                    RegProcessServiceHelper.updateWhenRegBatch(empIds4Agree, personIds4Agree, false, "1040", null);
                    RegProcessServiceHelper.updateWhenRegBatch(empIds4Reject, personIds4Reject, false, "1050", null);
                    RegTraceServiceHelper.logBatchRegular(empIds4Reject, personIds4Reject, 1L, "1080");
                }
                allBills.addAll(Arrays.asList(regBills));
                allBills.addAll(Arrays.asList(regErrorBills));
            }
            catch (Exception error) {
                logger.error("RegPersonChangeServiceImpl.executeRegEffect(..) error:" + error.getMessage());
                txHandle.markRollback();
                if (txHandle != null) {
                    if (var3_3 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return;
            }
        }
        if (HRCollUtil.isEmpty(allBills)) {
            logger.info(new Date() + "no regBill will effect reg_status");
        } else {
            List<DynamicObject> effectRegList = allBills.stream().filter(temp -> RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(temp.getString("regstatus"))).collect(Collectors.toList());
            IRegBillService.getInstance().updateSyncStatus(effectRegList, "-1");
            IRegEffectService.getInstance().effectReg(effectRegList);
            logger.info("reg effect schedule job end:" + effectRegList.size());
        }
    }
}

