/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.bill;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.common.TipsUtil;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegProbationService;
import kd.hr.hdm.business.reg.domain.service.common.IRegDateService;
import kd.hr.hdm.business.reg.domain.service.common.IRuleEngineService;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.enums.PostponeAskResultEnum;
import kd.hr.hdm.common.reg.enums.PostponeAskResultUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkEnum;
import kd.hr.hdm.common.reg.enums.ProbationRemarkUpdateSourceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegCategoryEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.reg.enums.RegDateUnitEnum;
import kd.hr.hdm.common.reg.enums.RegRuleEngineLevelEnum;
import kd.hr.hdm.common.transfer.util.TransferCommonUtil;

public class RegProbationServiceImpl
implements IRegProbationService {
    private static final Log LOGGER = LogFactory.getLog(RegProbationServiceImpl.class);

    @Override
    public Map<Long, DataValidate<DynamicObject>> batchValidateProbationPostponeByRuleEngine(List<DynamicObject> regBillList, String regEvent, boolean isWeakBulletBox) {
        if (HRCollUtil.isEmpty(regBillList)) {
            return new HashMap<Long, DataValidate<DynamicObject>>();
        }
        HashMap validateResultMap = Maps.newHashMapWithExpectedSize((int)regBillList.size());
        Map<Long, Map<String, Object>> ruleEngineResultMap = this.getBatchRuleEngineResult(regBillList);
        for (DynamicObject regBill : regBillList) {
            long regBillId = regBill.getLong("id");
            Map<String, Object> singleRuleEngineResultMap = ruleEngineResultMap.get(regBillId);
            DataValidate<DynamicObject> dataValidate = this.validateProbationPostponeByRuleEngine(singleRuleEngineResultMap, regBill, regEvent, isWeakBulletBox);
            validateResultMap.put(regBillId, dataValidate);
        }
        return validateResultMap;
    }

    private DataValidate<DynamicObject> validateProbationPostponeByRuleEngine(Map<String, Object> singleRuleEngineResultMap, DynamicObject regBill, String regEvent, boolean isWeakBulletBox) {
        Object delayThreshold;
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)regBill);
        if (singleRuleEngineResultMap == null || singleRuleEngineResultMap.size() < 1) {
            return dataValidate;
        }
        long categoryId = regBill.getDynamicObject("regcategory").getLong("id");
        if (RegCategoryEnum.POSTPHONE.getId() != categoryId) {
            return dataValidate;
        }
        Object level = singleRuleEngineResultMap.get("check_level");
        if (HRObjectUtils.isEmpty((Object)level)) {
            return dataValidate;
        }
        ValidateRangeEnum validateRangeEnum = RegRuleEngineLevelEnum.STRONG.getCode().equals(level) ? ValidateRangeEnum.VALIDATE_ERROR : ValidateRangeEnum.VALIDATE_WARN;
        Object promptContent = singleRuleEngineResultMap.get("prompt_content");
        Object probationThresholdStr = singleRuleEngineResultMap.get("probation_threshold");
        Object probationThresholdUnit = singleRuleEngineResultMap.get("probation_threshold_unit");
        if (!HRObjectUtils.isEmpty((Object)probationThresholdStr) && !HRObjectUtils.isEmpty((Object)probationThresholdUnit)) {
            double probationThreshold = Double.parseDouble(probationThresholdStr.toString());
            DataValidate<DynamicObject> probationValidate = this.validateProbation(validateRangeEnum, regBill, probationThreshold, (String)probationThresholdUnit, promptContent, isWeakBulletBox);
            if (ValidateRangeEnum.VALIDATE_PASS != probationValidate.getValidatorContext().getRange()) {
                return probationValidate;
            }
            probationValidate = this.validatePostponeProbation(validateRangeEnum, regBill, probationThreshold, (String)probationThresholdUnit, promptContent, isWeakBulletBox);
            if (ValidateRangeEnum.VALIDATE_PASS != probationValidate.getValidatorContext().getRange()) {
                return probationValidate;
            }
        }
        if ("operate_event".equals(regEvent) && !HRObjectUtils.isEmpty((Object)(delayThreshold = singleRuleEngineResultMap.get("delay_regular_number_threshold")))) {
            return this.validatePostponeProbationCount(validateRangeEnum, regBill, (int)Double.parseDouble(delayThreshold.toString()), promptContent, isWeakBulletBox);
        }
        return dataValidate;
    }

    private DataValidate<DynamicObject> validatePostponeProbationCount(ValidateRangeEnum validateRangeEnum, DynamicObject regBill, int delayThreshold, Object content, boolean isWeakBulletBox) {
        String title;
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)regBill);
        long employeeId = regBill.getLong("bemployee.id");
        QFilter employFilter = new QFilter("bemployee", "=", (Object)employeeId);
        QFilter regCategoryFilter = new QFilter("regcategory", "=", (Object)RegCategoryEnum.POSTPHONE.getId());
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
        DynamicObject[] dynamicObjects = IRegBillService.getInstance().query("id", new QFilter[]{employFilter, regCategoryFilter, billStatusFilter});
        if (dynamicObjects == null || dynamicObjects.length < delayThreshold) {
            return dataValidate;
        }
        if (ValidateRangeEnum.VALIDATE_ERROR == validateRangeEnum) {
            title = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5ef6\u671f\u8f6c\u6b63\u6b21\u6570\u8d85\u8fc7\u6cd5\u5b9a\u4e0a\u9650\uff08%s\u6b21\uff09\u3002", (String)"RegProbationServiceImpl_8", (String)"hr-hdm-business", (Object[])new Object[]{delayThreshold});
        } else {
            title = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5ef6\u671f\u8f6c\u6b63\u6b21\u6570\u8d85\u8fc7\u6cd5\u5b9a\u4e0a\u9650\uff08%s\u6b21\uff09\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegProbationServiceImpl_9", (String)"hr-hdm-business", (Object[])new Object[]{delayThreshold});
            if (!isWeakBulletBox) {
                title = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5ef6\u671f\u8f6c\u6b63\u6b21\u6570\u8d85\u8fc7\u6cd5\u5b9a\u4e0a\u9650\uff08%s\u6b21\uff09\u3002", (String)"RegProbationServiceImpl_7", (String)"hr-hdm-business", (Object[])new Object[]{delayThreshold});
            }
        }
        dataValidate.getValidatorContext().setResult(validateRangeEnum, "title", title);
        if (!HRObjectUtils.isEmpty((Object)content)) {
            dataValidate.getValidatorContext().setResult(validateRangeEnum, "content", (String)content);
        }
        return dataValidate;
    }

    private DataValidate<DynamicObject> validatePostponeProbation(ValidateRangeEnum validateRangeEnum, DynamicObject regBill, double probationThreshold, String probationThresholdUnit, Object content, boolean isWeakBulletBox) {
        String title;
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)regBill);
        int probationex = regBill.getInt("probationex");
        String probationexUnit = regBill.getString("probationunitex");
        if (probationex == 0 || HRStringUtils.isEmpty((String)probationexUnit)) {
            return dataValidate;
        }
        Date entryDate = regBill.getDate("entrydate");
        boolean success = this.greaterThanThreshold(entryDate, probationex, probationexUnit, (int)probationThreshold, probationThresholdUnit);
        if (!success) {
            return dataValidate;
        }
        String unitName = RegDateUnitEnum.getName((String)probationThresholdUnit);
        String probationThresholdView = (int)probationThreshold + unitName;
        if (ValidateRangeEnum.VALIDATE_ERROR == validateRangeEnum) {
            title = ResManager.loadKDString((String)"\u5ef6\u957f\u540e\u8bd5\u7528\u671f\u4e0d\u5f97\u8d85\u8fc7\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\u3002", (String)"RegProbationServiceImpl_3", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
        } else {
            title = ResManager.loadKDString((String)"\u5ef6\u957f\u540e\u8bd5\u7528\u671f\u8d85\u8fc7\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegProbationServiceImpl_4", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
            if (!isWeakBulletBox) {
                title = ResManager.loadKDString((String)"\u5ef6\u957f\u540e\u8bd5\u7528\u671f\u8d85\u8fc7\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\u3002", (String)"RegProbationServiceImpl_6", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
            }
        }
        dataValidate.getValidatorContext().setResult(validateRangeEnum, "title", title);
        if (!HRObjectUtils.isEmpty((Object)content)) {
            dataValidate.getValidatorContext().setResult(validateRangeEnum, "content", (String)content);
        }
        return dataValidate;
    }

    private DataValidate<DynamicObject> validateProbation(ValidateRangeEnum validateRangeEnum, DynamicObject regBill, double probationThreshold, String probationThresholdUnit, Object content, boolean isWeakBulletBox) {
        String title;
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)regBill);
        int probation = regBill.getInt("probation");
        String probationUnit = regBill.getString("probationunit");
        Date entryDate = regBill.getDate("entrydate");
        boolean success = this.greaterThanThreshold(entryDate, probation, probationUnit, (int)probationThreshold, probationThresholdUnit);
        if (!success) {
            return dataValidate;
        }
        String unitName = RegDateUnitEnum.getName((String)probationThresholdUnit);
        String probationThresholdView = (int)probationThreshold + unitName;
        if (ValidateRangeEnum.VALIDATE_ERROR == validateRangeEnum) {
            title = ResManager.loadKDString((String)"\u539f\u8bd5\u7528\u671f\u4e0d\u5c0f\u4e8e\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\uff0c\u65e0\u6cd5\u5ef6\u957f\u8bd5\u7528\u671f\u3002", (String)"RegProbationServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
        } else {
            title = ResManager.loadKDString((String)"\u539f\u8bd5\u7528\u671f\u5df2\u8fbe\u5230\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"RegProbationServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
            if (!isWeakBulletBox) {
                title = ResManager.loadKDString((String)"\u539f\u8bd5\u7528\u671f\u5df2\u8fbe\u5230\u8be5\u5458\u5de5\u7684\u8bd5\u7528\u671f\u6cd5\u5b9a\u4e0a\u9650\u201c%s\u201d\u3002", (String)"RegProbationServiceImpl_5", (String)"hr-hdm-business", (Object[])new Object[]{probationThresholdView});
            }
        }
        dataValidate.getValidatorContext().setResult(validateRangeEnum, "title", title);
        if (!HRObjectUtils.isEmpty((Object)content)) {
            dataValidate.getValidatorContext().setResult(validateRangeEnum, "content", (String)content);
        }
        return dataValidate;
    }

    private boolean greaterThanThreshold(Date entryDate, int probation, String probationUnit, int probationThreshold, String probationThresholdUnit) {
        Date probationDate = IRegDateService.getInstance().calcDate(entryDate, probation, probationUnit);
        Date probationThresholdDate = IRegDateService.getInstance().calcDate(entryDate, probationThreshold, probationThresholdUnit);
        return HRDateTimeUtils.dayAfter((Date)probationDate, (Date)probationThresholdDate);
    }

    private Map<Long, Map<String, Object>> getBatchRuleEngineResult(List<DynamicObject> regBillList) {
        HashMap ruleResultMap = Maps.newHashMapWithExpectedSize((int)regBillList.size());
        HashMap regBillIdMap = Maps.newHashMapWithExpectedSize((int)regBillList.size());
        ArrayList<DynamicObject> ermanFileList = new ArrayList<DynamicObject>(regBillList.size());
        for (DynamicObject regBill : regBillList) {
            DynamicObject ermanFile = regBill.getDynamicObject("ermanfile");
            regBillIdMap.put(regBill.getLong("id"), ermanFile.getLong("id"));
            ermanFileList.add(ermanFile);
        }
        Map<Long, List<Map<String, Object>>> ruleEngineMap = IRuleEngineService.getInstance().batchCallProbationExceptionRuleEngineList(ermanFileList);
        HashMap promptContentMap = new HashMap(16);
        regBillIdMap.forEach((regBillId, ermanFileId) -> {
            Object prompt;
            List ruleResultList = (List)ruleEngineMap.get(ermanFileId);
            Map<String, String> singleRuleResultMap = new HashMap(16);
            if (!HRCollUtil.isEmpty((Collection)ruleResultList)) {
                singleRuleResultMap = (Map)ruleResultList.get(0);
            }
            if ((prompt = singleRuleResultMap.get("hrcs_prompt")) != null) {
                Object promptId = ((DynamicObject)prompt).get("id");
                String promptContent = this.getPromptContentByPromptId(promptContentMap, promptId);
                singleRuleResultMap.put("prompt_content", promptContent);
            }
            ruleResultMap.put(regBillId, singleRuleResultMap);
        });
        return ruleResultMap;
    }

    private String getPromptContentByPromptId(Map<Object, String> promptContentMap, Object promptId) {
        if (HRObjectUtils.isEmpty((Object)promptId)) {
            return null;
        }
        String promptContent = promptContentMap.get(promptId);
        if (HRStringUtils.isNotEmpty((String)promptContent)) {
            return promptContent;
        }
        promptContent = TipsUtil.getPromptById((Long)promptId);
        promptContentMap.put(promptId, promptContent);
        return promptContent;
    }

    @Override
    public String getPostponeProbationUnit(DynamicObject regBill) {
        Map<Long, Map<String, Object>> batchRuleEngineResultMap = this.getBatchRuleEngineResult(Collections.singletonList(regBill));
        String probationUnit = regBill.getString("probationunit");
        if (batchRuleEngineResultMap.get(regBill.getLong("id")) == null) {
            return probationUnit;
        }
        Object unit = batchRuleEngineResultMap.get(regBill.getLong("id")).get("probation_threshold_unit");
        if (HRObjectUtils.isEmpty((Object)unit)) {
            return probationUnit;
        }
        if (!probationUnit.equals(unit)) {
            return RegDateUnitEnum.DAY.getCode();
        }
        return String.valueOf(unit);
    }

    @Override
    public Map<String, Object> getPostponeInfoOfView(DynamicObject regBill) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject regCategory = regBill.getDynamicObject("regcategory");
        if (regCategory != null && RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            String postponeUnit = regBill.getString("postponeprobationunit");
            int postponeProbation = regBill.getInt("postponeprobation");
            String postponeUnitName = RegDateUnitEnum.getName((String)postponeUnit);
            map.put("postponeprobationview", postponeProbation + postponeUnitName);
            String probationExUnit = regBill.getString("probationunitex");
            String probationExUnitName = RegDateUnitEnum.getName((String)probationExUnit);
            int probationEx = regBill.getInt("probationex");
            map.put("probationexview", probationEx + probationExUnitName);
        }
        String probationUnit = regBill.getString("probationunit");
        int probation = regBill.getInt("probation");
        if (!HRStringUtils.isEmpty((String)probationUnit)) {
            String probationUnitName = RegDateUnitEnum.getName((String)probationUnit);
            map.put("probationtext", probation + probationUnitName);
        }
        return map;
    }

    @Override
    public Map<String, Object> getPostponeInfoOfEdit(DynamicObject regBill) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject regCategory = regBill.getDynamicObject("regcategory");
        if (regCategory != null && RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) {
            String postponeUnit = regBill.getString("postponeprobationunit");
            int postponeProbation = regBill.getInt("postponeprobation");
            if (HRStringUtils.isEmpty((String)postponeUnit) || postponeProbation == 0) {
                return map;
            }
            Date preActualDate = regBill.getDate("preactualdate");
            Date postponeDate = IRegDateService.getInstance().calcDate(preActualDate, postponeProbation, postponeUnit);
            map.put("postponedate", postponeDate);
            String probationUnit = regBill.getString("probationunit");
            int probation = regBill.getInt("probation");
            if (HRStringUtils.equals((String)postponeUnit, (String)probationUnit)) {
                map.put("probationex", postponeProbation + probation);
                map.put("probationunitex", postponeUnit);
            } else {
                Date entryDate = regBill.getDate("entrydate");
                long dateDiff = HRDateTimeUtils.dateDiff((String)"d", (Date)entryDate, (Date)postponeDate);
                map.put("probationex", dateDiff);
                map.put("probationunitex", RegDateUnitEnum.DAY.getCode());
            }
            Object probationExUnit = map.get("probationunitex");
            String probationExView = map.get("probationex") + RegDateUnitEnum.getName((String)probationExUnit.toString());
            map.put("probationexview", probationExView);
        }
        return map;
    }

    @Override
    public String getMustInputErrorMsg(DynamicObject regBillEntity) {
        Date date;
        long regCommentId = regBillEntity.getLong("regcomment.id");
        StringBuilder sb = new StringBuilder();
        if (RegCommentEnum.AGREE.getId().equals(regCommentId) && (date = regBillEntity.getDate("effectdate")) == null) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"RegProbationServiceImpl_10", (String)"hr-hdm-business", (Object[])new Object[0]));
        }
        long regCategoryId = regBillEntity.getLong("regcategory.id");
        if (RegCategoryEnum.POSTPHONE.getId().equals(regCategoryId)) {
            int postponeProbation = regBillEntity.getInt("postponeprobation");
            String postponeProbationUnit = regBillEntity.getString("postponeprobationunit");
            if (postponeProbation == 0) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8bd5\u7528\u671f\u5ef6\u957f\u201d\u3002", (String)"RegProbationServiceImpl_11", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isEmpty((String)postponeProbationUnit)) {
                sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8bd5\u7528\u671f\u5ef6\u957f\u5355\u4f4d\u201d\u3002", (String)"RegProbationServiceImpl_12", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        }
        return sb.toString();
    }

    @Override
    public boolean fieldModifiedOfWorkFlow(IFormView formView) {
        boolean auditView = TransferCommonUtil.isAuditView((IFormView)formView);
        if (!auditView) {
            return false;
        }
        Map customParams = formView.getFormShowParameter().getCustomParams();
        if (customParams == null || customParams.size() < 1) {
            return false;
        }
        Object processInstanceId = customParams.get("processInstanceId");
        Object taskDefinitionKey = customParams.get("taskDefinitionKey");
        if (HRObjectUtils.isEmpty(taskDefinitionKey)) {
            taskDefinitionKey = customParams.get("taskdefinitionKey");
        }
        WorkflowServiceHelper workflowServiceHelper = new WorkflowServiceHelper();
        BillSetting nodeProp = (BillSetting)workflowServiceHelper.getNodeProp((Long)processInstanceId, (String)taskDefinitionKey, "billSetting");
        return nodeProp.isFieldModified();
    }

    @Override
    public void setPostponeAskResult(DynamicObject[] regBills, PostponeAskResultUpdateSourceEnum updateSourceEnum) {
        if (regBills == null || regBills.length < 1 || updateSourceEnum == null) {
            return;
        }
        for (DynamicObject regBill : regBills) {
            regBill.set("postponeaskresult", (Object)updateSourceEnum.getPostponeAskResult().getCode());
            DynamicObject regCategory = regBill.getDynamicObject("regcategory");
            if (regCategory == null || updateSourceEnum != PostponeAskResultUpdateSourceEnum.HR_SUBMIT_BILL || !RegCategoryEnum.POSTPHONE.getId().equals(regCategory.getLong("id"))) continue;
            regBill.set("postponeaskresult", (Object)PostponeAskResultUpdateSourceEnum.HR_SUBMIT_POSTPONE_BILL.getPostponeAskResult().getCode());
        }
    }

    @Override
    public String covertRegBillStatusByPostponeAskResult(String billStatus, Object postponeAskResult) {
        if ((RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) || RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) && postponeAskResult != null && HRObjectUtils.equals((Object)PostponeAskResultEnum.PENDING_FEEDBACK.getCode(), (Object)postponeAskResult)) {
            return RegBillStatusEnum.PENDING_PERSONNEL_CONFIRM.getCode();
        }
        return billStatus;
    }

    @Override
    public void setProbationRemark(DynamicObject[] regBills, ProbationRemarkUpdateSourceEnum updateSourceEnum) {
        if (regBills == null || regBills.length < 1 || updateSourceEnum == null) {
            return;
        }
        for (DynamicObject regBill : regBills) {
            String probationRemark = regBill.getString("probationremark");
            if (!ProbationRemarkEnum.PROBATION_ABNORMAL.getCode().equals(probationRemark)) continue;
            regBill.set("probationremark", (Object)updateSourceEnum.getProbationRemarkEnum().getCode());
        }
    }

    @Override
    public Map<Long, Boolean> getOverDue(DynamicObject[] regBills) {
        if (regBills == null || regBills.length < 1) {
            return new HashMap<Long, Boolean>();
        }
        HashMap overDueMap = Maps.newHashMapWithExpectedSize((int)regBills.length);
        try {
            for (DynamicObject regBill : regBills) {
                Date currentDate;
                Date oldPreActualDate = regBill.getDate("preactualdate");
                String preActualDateStr = HRDateTimeUtils.format((Date)oldPreActualDate, (String)"yyyy-MM-dd");
                Date preActualDate = HRDateTimeUtils.parseDate((String)preActualDateStr, (String)"yyyy-MM-dd");
                boolean isBefore = HRDateTimeUtils.dayBefore((Date)preActualDate, (Date)(currentDate = HRDateTimeUtils.localDate2Date((LocalDate)LocalDate.now())));
                if (!isBefore) continue;
                long employeeId = regBill.getLong("bemployee.id");
                overDueMap.put(employeeId, Boolean.TRUE);
            }
        }
        catch (ParseException e) {
            LOGGER.error("preactualdate parse error", (Throwable)e);
        }
        return overDueMap;
    }

    @Override
    public Map<Long, DynamicObject> getTrailPeriodByPersonId(Collection<Long> personIds) {
        String selectProperties = "employee,person,regstatus,entrydate";
        List<Long> employeeIds = this.getEmployeeIds(personIds);
        if (employeeIds.size() < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        QFilter employeeFilter = new QFilter("employee", "in", employeeIds);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        employeeFilter.and(currentVersionFilter).and(dataStatusFilter);
        DynamicObject[] trailPeriods = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectProperties, employeeFilter, "hrpi_trialperiod"});
        if (trailPeriods == null || trailPeriods.length < 1) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(trailPeriods).collect(Collectors.toMap(temp -> temp.getLong("person.id"), temp -> temp, (o, n) -> n));
    }

    private List<Long> getEmployeeIds(Collection<Long> personIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("person", new QFilter[]{new QFilter("person", "in", personIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("islatestrecord", "=", (Object)"1")});
        if (dynamicObjects == null || dynamicObjects.length < 1) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }
}

