/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.common;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.domain.service.brm.IBRMRuleEngineService;
import kd.hr.hdm.business.domain.service.hlcm.IHLCMService;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.reg.domain.service.common.IRuleEngineService;

public class RuleEngineServiceImpl
implements IRuleEngineService {
    private static final Log LOGGER = LogFactory.getLog(RuleEngineServiceImpl.class);
    private static final String HPB_REGNEARPREDATE_SCENE = "hpb_regnearpredate";
    private static final String HPB_PROBATIONEXCEPTION_SCENE = "hpb_probationexception";

    @Override
    public Map<Long, String> batchCallRegNearPreDateRuleEngine(List<DynamicObject> erManFileDys) {
        if (CollectionUtils.isEmpty(erManFileDys)) {
            return new HashMap<Long, String>(0);
        }
        List<Long> erManFileIds = erManFileDys.stream().filter(erManFile -> !HRObjectUtils.isEmpty((Object)erManFile.getString("org.number"))).map(erManFile -> erManFile.getLong("id")).collect(Collectors.toList());
        return IRuleEngineService.getInstance().batchCallRegNearPreDateRuleEngineByErManFileIds(erManFileIds);
    }

    @Override
    public Map<Long, String> batchCallRegNearPreDateRuleEngineByErManFileIds(List<Long> erManFileIds) {
        if (CollectionUtils.isEmpty(erManFileIds)) {
            return new HashMap<Long, String>(0);
        }
        LOGGER.info("batchCallRegNearPreDateRuleEngineByErManFileIds erManFileIds:{}", (Object)JSON.toJSONString(erManFileIds));
        List<Map<String, Object>> inputParamsMaps = this.buildInputParamsMaps(erManFileIds, HPB_REGNEARPREDATE_SCENE, false, false, true);
        List<Map<String, Object>> results = IBRMRuleEngineService.getInstance().batchCallRuleEngine(inputParamsMaps, true);
        if (CollectionUtils.isEmpty(results)) {
            LOGGER.error("batchCallRegNearPreDateRuleEngineByErManFileIds results is empty");
            return new HashMap<Long, String>(0);
        }
        HashMap<Long, String> earlyWarnLevelMap = new HashMap<Long, String>(inputParamsMaps.size());
        for (int i = 0; i < inputParamsMaps.size(); ++i) {
            String earlyWarnLevel;
            Map<String, Object> result = results.get(i);
            String string = earlyWarnLevel = result != null ? (String)Optional.ofNullable(result.get("earlywarnlevel")).map(Object::toString).orElse(null) : null;
            if (!HRStringUtils.isNotEmpty(earlyWarnLevel)) continue;
            earlyWarnLevelMap.put(erManFileIds.get(i), earlyWarnLevel);
        }
        LOGGER.info("batchCallRegNearPreDateRuleEngineByErManFileIds earlyWarnLevelMap:{}", (Object)JSON.toJSONString(earlyWarnLevelMap));
        return earlyWarnLevelMap;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> batchCallProbationExceptionRuleEngineList(List<DynamicObject> erManFileDys) {
        if (CollectionUtils.isEmpty(erManFileDys)) {
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        Map erManFileIdsMap = erManFileDys.stream().filter(erManFile -> !HRObjectUtils.isEmpty((Object)erManFile.getString("org.number"))).collect(Collectors.groupingBy(erManFile -> erManFile.getString("org.number"), Collectors.mapping(erManFile -> (Long)erManFile.get("id"), Collectors.toList())));
        HashMap<Long, List<Map<String, Object>>> resultMap = new HashMap<Long, List<Map<String, Object>>>(erManFileIdsMap.size());
        erManFileIdsMap.values().forEach(fileIds -> resultMap.putAll(this.batchCallProbationExceptionRuleEngineListByErManFileIds((List<Long>)fileIds)));
        return resultMap;
    }

    @Override
    public Map<Long, List<Map<String, Object>>> batchCallProbationExceptionRuleEngineListByErManFileIds(List<Long> erManFileIds) {
        if (CollectionUtils.isEmpty(erManFileIds)) {
            LOGGER.error("batchCallProbationExceptionRuleEngineListByErManFileIds erManFileIds is empty");
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        LOGGER.info("batchCallProbationExceptionRuleEngineListByErManFileIds erManFileIds:{}", (Object)JSON.toJSONString(erManFileIds));
        List<Map<String, Object>> inputParamsMaps = this.buildInputParamsMaps(erManFileIds, HPB_PROBATIONEXCEPTION_SCENE, true, true, false);
        List<List<Map<String, Object>>> results = IBRMRuleEngineService.getInstance().batchCallRuleEngineResultList(inputParamsMaps, false);
        if (CollectionUtils.isEmpty(results)) {
            LOGGER.error("batchCallProbationExceptionRuleEngineListByErManFileIds results is empty");
            return new HashMap<Long, List<Map<String, Object>>>(0);
        }
        HashMap<Long, List<Map<String, Object>>> resultMap = new HashMap<Long, List<Map<String, Object>>>(inputParamsMaps.size());
        for (int i = 0; i < inputParamsMaps.size(); ++i) {
            resultMap.put(erManFileIds.get(i), results.get(i));
        }
        return resultMap;
    }

    private List<Map<String, Object>> buildInputParamsMaps(List<Long> erManFileIds, String sceneNumber, boolean hasWorkplace, boolean hasContract, boolean hasTrailPeriod) {
        Map<Long, DynamicObject> erManFileMap = this.getErManFileMap(erManFileIds);
        Map<Long, DynamicObject> empPosOrgElMap = this.getEmpPosOrgElMap(erManFileMap);
        Map<Long, DynamicObject> empPosOrgElJobMap = this.getEmpPosOrgElJobMap(empPosOrgElMap);
        Map<Long, DynamicObject> empPosOrgElPositionMap = this.getEmpPosOrgElPositionMap(empPosOrgElMap);
        Map<Long, DynamicObject> empPosOrgElStdPositionMap = this.getEmpPosOrgElStdPositionMap(empPosOrgElMap);
        Map<Long, DynamicObject> empJobRelMap = this.getEmpJobRelMap(erManFileMap);
        int size = erManFileIds.size();
        HashMap<Long, DynamicObject> workplaceMap = new HashMap<Long, DynamicObject>(size);
        if (hasWorkplace) {
            workplaceMap.putAll(this.getWorkplaceMap(erManFileMap));
        }
        HashMap<Long, DynamicObject> contractMap = new HashMap<Long, DynamicObject>(size);
        if (hasContract) {
            contractMap.putAll(this.getContractMap(erManFileMap));
        }
        HashMap<Long, DynamicObject> trailPeriodMap = new HashMap<Long, DynamicObject>(size);
        if (hasTrailPeriod) {
            trailPeriodMap.putAll(this.getTrailPeriodMap(erManFileMap));
        }
        return erManFileIds.stream().map(erManFileId -> {
            DynamicObject trailPeriodDy;
            DynamicObject contractDy;
            DynamicObject workplaceDy;
            DynamicObject empJobRelDy;
            DynamicObject empPosOrgElStdPositionDy;
            DynamicObject empPosOrgElPositionDy;
            DynamicObject empPosOrgElJobDy;
            DynamicObject empPosOrgElDy;
            HashMap<String, Object> inputParamsMap = new HashMap<String, Object>(16);
            inputParamsMap.put("bizApp", "hpb");
            inputParamsMap.put("sceneNumber", sceneNumber);
            inputParamsMap.put("serialNumber", erManFileId + "");
            HashMap<String, DynamicObject> inputParams = new HashMap<String, DynamicObject>(16);
            DynamicObject erManFileDy = (DynamicObject)erManFileMap.get(erManFileId);
            if (!HRObjectUtils.isEmpty((Object)erManFileDy)) {
                inputParams.put("hspm_ermanfile", erManFileDy);
                inputParamsMap.put("buNumber", erManFileDy.getString("org.number"));
            }
            if (!HRObjectUtils.isEmpty((Object)(empPosOrgElDy = (DynamicObject)empPosOrgElMap.get(erManFileId)))) {
                inputParams.put("hrpi_empposorgrel", empPosOrgElDy);
            }
            if (!HRObjectUtils.isEmpty((Object)(empPosOrgElJobDy = (DynamicObject)empPosOrgElJobMap.get(erManFileId)))) {
                inputParams.put("hbjm_jobhr", empPosOrgElJobDy);
            }
            if (!HRObjectUtils.isEmpty((Object)(empPosOrgElPositionDy = (DynamicObject)empPosOrgElPositionMap.get(erManFileId)))) {
                inputParams.put("hbpm_positionhr", empPosOrgElPositionDy);
            }
            if (!HRObjectUtils.isEmpty((Object)(empPosOrgElStdPositionDy = (DynamicObject)empPosOrgElStdPositionMap.get(erManFileId)))) {
                inputParams.put("hbpm_stposition", empPosOrgElStdPositionDy);
            }
            if (!HRObjectUtils.isEmpty((Object)(empJobRelDy = (DynamicObject)empJobRelMap.get(erManFileId)))) {
                inputParams.put("hrpi_empjobrel", empJobRelDy);
            }
            if (hasWorkplace && !HRObjectUtils.isEmpty((Object)(workplaceDy = (DynamicObject)workplaceMap.get(erManFileId)))) {
                inputParams.put("hbss_workplace", workplaceDy);
            }
            if (hasContract && !HRObjectUtils.isEmpty((Object)(contractDy = (DynamicObject)contractMap.get(erManFileId)))) {
                inputParams.put("hlcm_contract", contractDy);
            }
            if (hasTrailPeriod && !HRObjectUtils.isEmpty((Object)(trailPeriodDy = (DynamicObject)trailPeriodMap.get(erManFileId)))) {
                inputParams.put("hrpi_trialperiod", trailPeriodDy);
            }
            inputParamsMap.put("inputParams", inputParams);
            return inputParamsMap;
        }).collect(Collectors.toList());
    }

    private Map<Long, DynamicObject> getContractMap(Map<Long, DynamicObject> erManFileMap) {
        if (erManFileMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<String, Long> empNumberMap = erManFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getString("person.number"), dy -> dy.getLong("id"), (v1, v2) -> v2));
        List<Map<String, Object>> contractMaps = IHLCMService.getInstance().queryContractByEmpNumbers(new ArrayList<String>(empNumberMap.keySet()));
        if (contractMaps == null || contractMaps.size() == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        List contractIds = contractMaps.stream().map(contract -> contract.get("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hlcm_contract");
        DynamicObject[] contracts = serviceHelper.query(String.join((CharSequence)",", "periodunit", "period", "person", "periodtype"), new QFilter[]{new QFilter("id", "in", contractIds)});
        if (contracts.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(contracts).collect(Collectors.toMap(dy -> (Long)empNumberMap.get(dy.getString("person.number")), dy -> dy, (v1, v2) -> v2));
    }

    private Map<Long, DynamicObject> getWorkplaceMap(Map<Long, DynamicObject> erManFileMap) {
        if (erManFileMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> employeeIdMap = erManFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("employee.id"), (v1, v2) -> v2));
        DynamicObject[] contrWorkLocDys = IHRPIService.getInstance().listFieldsFilterInfo(String.join((CharSequence)",", "agreedlocation", "employee"), new QFilter("employee.id", "in", employeeIdMap.values()), "hrpi_contrworkloc");
        if (contrWorkLocDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> contrWorkLockIdMap = Arrays.stream(contrWorkLocDys).collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy.getLong("agreedlocation.id"), (v1, v2) -> v2));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workplace");
        DynamicObject[] workplaceDys = serviceHelper.query("country", new QFilter[]{new QFilter("id", "in", new ArrayList<Long>(contrWorkLockIdMap.values()))});
        if (workplaceDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, DynamicObject> workplaceDyMap = Arrays.stream(workplaceDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        HashMap<Long, DynamicObject> workplaceMap = new HashMap<Long, DynamicObject>(workplaceDyMap.size());
        employeeIdMap.forEach((erManFileId, employeeId) -> {
            DynamicObject workplace = (DynamicObject)workplaceDyMap.get(contrWorkLockIdMap.get(employeeId));
            if (!HRObjectUtils.isEmpty((Object)workplace)) {
                workplaceMap.put((Long)erManFileId, workplace);
            }
        });
        return workplaceMap;
    }

    private Map<Long, DynamicObject> getTrailPeriodMap(Map<Long, DynamicObject> erManFileMap) {
        if (erManFileMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> employeeIdMap = erManFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy.getLong("id"), (v1, v2) -> v2));
        IHRPIService instance = IHRPIService.getInstance();
        DynamicObject[] trailPeriodDys = instance.listFieldsFilterInfo(String.join((CharSequence)",", "preregulardate", "employee"), new QFilter("employee.id", "in", employeeIdMap.keySet()), "hrpi_trialperiod");
        if (trailPeriodDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(trailPeriodDys).collect(Collectors.toMap(dy -> (Long)employeeIdMap.get(dy.getLong("employee.id")), dy -> dy, (v1, v2) -> v2));
    }

    private Map<Long, DynamicObject> getEmpJobRelMap(Map<Long, DynamicObject> erManFileMap) {
        if (erManFileMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> employeeIdMap = erManFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("employee.id"), dy -> dy.getLong("id"), (v1, v2) -> v2));
        DynamicObject[] empJobRelDys = IHRPIService.getInstance().listFieldsFilterInfo(String.join((CharSequence)",", "joblevel", "jobgrade", "job", "joblevelscm", "jobgradescm", "hrbu", "jobseq", "jobscm", "jobclass", "jobfamily", "employee"), new QFilter("employee.id", "in", employeeIdMap.keySet()), "hrpi_empjobrel");
        if (empJobRelDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(empJobRelDys).collect(Collectors.toMap(dy -> (Long)employeeIdMap.get(dy.getLong("employee.id")), dy -> dy, (v1, v2) -> v2));
    }

    private Map<Long, DynamicObject> getEmpPosOrgElStdPositionMap(Map<Long, DynamicObject> empPosOrgElMap) {
        if (empPosOrgElMap == null || empPosOrgElMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, Long> empPosRelStdPositionIdMap = new HashMap<Long, Long>(empPosOrgElMap.size());
        empPosOrgElMap.forEach((erManFileId, empPosOrgElDy) -> empPosRelStdPositionIdMap.put((Long)erManFileId, empPosOrgElDy.getLong("stdposition.id")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        DynamicObject[] empPosRelStdPositionDys = serviceHelper.query(String.join((CharSequence)",", "positionclassify", "positiontype"), new QFilter[]{new QFilter("id", "in", empPosRelStdPositionIdMap.values())});
        if (empPosRelStdPositionDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, DynamicObject> empPosRelStdPositionDyMap = Arrays.stream(empPosRelStdPositionDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        HashMap<Long, DynamicObject> empPosRelStdPositionMap = new HashMap<Long, DynamicObject>(empPosOrgElMap.size());
        empPosRelStdPositionIdMap.forEach((erManFileId, empPosRelStdPositionId) -> {
            DynamicObject empPosRelStdPositionDy = (DynamicObject)empPosRelStdPositionDyMap.get(empPosRelStdPositionId);
            if (!HRObjectUtils.isEmpty((Object)empPosRelStdPositionDy)) {
                empPosRelStdPositionMap.put((Long)erManFileId, empPosRelStdPositionDy);
            }
        });
        return empPosRelStdPositionMap;
    }

    private Map<Long, DynamicObject> getEmpPosOrgElPositionMap(Map<Long, DynamicObject> empPosOrgElMap) {
        if (empPosOrgElMap == null || empPosOrgElMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, Long> empPosRelPositionIdMap = new HashMap<Long, Long>(empPosOrgElMap.size());
        empPosOrgElMap.forEach((erManFileId, empPosOrgElDy) -> empPosRelPositionIdMap.put((Long)erManFileId, empPosOrgElDy.getLong("position.id")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        DynamicObject[] empPosRelPositionDys = serviceHelper.query(String.join((CharSequence)",", "group", "positionclassify", "positiontype", "keyposition", "isleader", "deputytype", "issensitive"), new QFilter[]{new QFilter("id", "in", empPosRelPositionIdMap.values())});
        if (empPosRelPositionDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, DynamicObject> empPosRelPositionDyMap = Arrays.stream(empPosRelPositionDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        HashMap<Long, DynamicObject> empPosRelPositionMap = new HashMap<Long, DynamicObject>(empPosOrgElMap.size());
        empPosRelPositionIdMap.forEach((erManFileId, empPosRelPositionId) -> {
            DynamicObject empPosRelPositionDy = (DynamicObject)empPosRelPositionDyMap.get(empPosRelPositionId);
            if (!HRObjectUtils.isEmpty((Object)empPosRelPositionDy)) {
                empPosRelPositionMap.put((Long)erManFileId, empPosRelPositionDy);
            }
        });
        return empPosRelPositionMap;
    }

    private Map<Long, DynamicObject> getEmpPosOrgElJobMap(Map<Long, DynamicObject> empPosOrgElMap) {
        if (empPosOrgElMap == null || empPosOrgElMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        HashMap<Long, Long> empPosRelJobIdMap = new HashMap<Long, Long>(empPosOrgElMap.size());
        empPosOrgElMap.forEach((erManFileId, empPosOrgElDy) -> empPosRelJobIdMap.put((Long)erManFileId, empPosOrgElDy.getLong("job.id")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbjm_jobhr");
        DynamicObject[] empPosRelJobDys = serviceHelper.query(String.join((CharSequence)",", "jobscm", "jobseq", "jobfamily", "jobclass"), new QFilter[]{new QFilter("id", "in", empPosRelJobIdMap.values())});
        if (empPosRelJobDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, DynamicObject> empPosRelJobDyMap = Arrays.stream(empPosRelJobDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        HashMap<Long, DynamicObject> empPosRelJobMap = new HashMap<Long, DynamicObject>(empPosOrgElMap.size());
        empPosRelJobIdMap.forEach((erManFileId, empPosRelJobId) -> {
            DynamicObject empPosRelJobDy = (DynamicObject)empPosRelJobDyMap.get(empPosRelJobId);
            if (!HRObjectUtils.isEmpty((Object)empPosRelJobDy)) {
                empPosRelJobMap.put((Long)erManFileId, empPosRelJobDy);
            }
        });
        return empPosRelJobMap;
    }

    private Map<Long, DynamicObject> getErManFileMap(List<Long> erManFileIds) {
        if (CollectionUtils.isEmpty(erManFileIds)) {
            return new HashMap<Long, DynamicObject>(0);
        }
        DynamicObject[] erManFileDys = IHRPIService.getInstance().listFieldsFilterInfo(String.join((CharSequence)",", "empgroup", "org", "dependency", "affiliateadminorg", "hbsscmpemp", "empposrel", "person", "employee"), new QFilter("id", "in", erManFileIds), "hspm_ermanfile");
        if (erManFileDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(erManFileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
    }

    private Map<Long, DynamicObject> getEmpPosOrgElMap(Map<Long, DynamicObject> erManFileMap) {
        if (erManFileMap == null || erManFileMap.isEmpty()) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, Long> empPosRelIdMap = erManFileMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("empposrel.id"), (v1, v2) -> v2));
        DynamicObject[] empPosOrgRelDys = IHRPIService.getInstance().listFieldsFilterInfo(String.join((CharSequence)",", "company", "job", "position", "stdposition", "postype", "adminorg", "cmpemp", "workplace", "apositiontype"), new QFilter("id", "in", empPosRelIdMap.values()), "hrpi_empposorgrel");
        if (empPosOrgRelDys.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        Map<Long, DynamicObject> empPosRelDyMap = Arrays.stream(empPosOrgRelDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v2));
        HashMap<Long, DynamicObject> empPosRelMap = new HashMap<Long, DynamicObject>(empPosRelDyMap.size());
        empPosRelIdMap.forEach((erManFileId, empPosRelId) -> {
            DynamicObject empPosRelDy = (DynamicObject)empPosRelDyMap.get(empPosRelId);
            if (!HRObjectUtils.isEmpty((Object)empPosRelDy)) {
                empPosRelMap.put((Long)erManFileId, empPosRelDy);
            }
        });
        return empPosRelMap;
    }
}

