/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.earlywarn;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hdm.business.domain.service.hrpi.IHRPIService;
import kd.hr.hdm.business.domain.service.hspm.IHSPMService;
import kd.hr.hdm.business.reg.domain.service.earlywarn.IRegEarlyWarnService;
import kd.hr.hdm.business.repository.BosUserRepository;

public class RegEarlyWarnServiceImpl
implements IRegEarlyWarnService {
    private static final Log LOGGER = LogFactory.getLog(RegEarlyWarnServiceImpl.class);

    @Override
    public Map<String, Set<Long>> batchGetReceiver(DynamicObjectCollection collection, boolean isGetSuperior, boolean isGetCharge, boolean isGetTutor, boolean isGetProbationPerson) {
        LOGGER.info("batchGetReceiver start");
        HashMap<String, Set<Long>> receiverUserIdMap = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set> receiverNumberMap = new HashMap<String, Set>(16);
        List empNumbers = collection.stream().map(dy -> dy.getString("person.number")).collect(Collectors.toList());
        int batchSize = 500;
        int dataSize = empNumbers.size();
        if (dataSize == 0) {
            return new HashMap<String, Set<Long>>(0);
        }
        int batch = dataSize / batchSize;
        for (int i = 0; i < batch + 1; ++i) {
            DynamicObject[] users;
            int indexStart = i * batchSize;
            int indexEnd = Math.min(indexStart + batchSize, dataSize);
            LOGGER.info("batchSize:{} i:{} indexStart:{} indexEnd:{}", new Object[]{batchSize, i, indexStart, indexEnd});
            List<String> subEmpNumbers = empNumbers.subList(indexStart, indexEnd);
            LOGGER.info("subEmpNumbers:{}", (Object)JSONObject.toJSONString(subEmpNumbers));
            DynamicObject[] erManFileDys = IHSPMService.getInstance().listPrimaryErManFilesByEmpNumber(subEmpNumbers);
            if (erManFileDys.length == 0) {
                LOGGER.warn("erManFileDys.length == 0");
                break;
            }
            List<Long> erManFileIds = Arrays.stream(erManFileDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
            Map<Object, Map<String, Object>> erManFiles = IHSPMService.getInstance().getCardFieldByErManFileIds(erManFileIds, "id");
            if (erManFiles == null || erManFiles.isEmpty()) {
                LOGGER.warn("erManFiles is empty()");
                break;
            }
            HashMap<Long, List<String>> tutorNumberMap = new HashMap<Long, List<String>>(16);
            if (isGetTutor) {
                List<Long> employeeIds = erManFiles.values().stream().map(erManFile -> (Long)erManFile.get("employee_id")).collect(Collectors.toList());
                tutorNumberMap.putAll(IHRPIService.getInstance().getTutorByEmployeeIds(employeeIds));
            }
            HashSet<String> numbers = new HashSet<String>(erManFiles.size());
            erManFiles.values().forEach(erManFile -> {
                Long employeeId;
                List tutorNumbers;
                List chargeInfos;
                List superiorInfos;
                String erManFileNumber = erManFile.get("number").toString();
                LOGGER.info("erManFileNumber:{}", (Object)erManFileNumber);
                HashSet<Object> receiverNumberSet = new HashSet<Object>(16);
                if (isGetSuperior && CollectionUtils.isNotEmpty((Collection)(superiorInfos = (List)erManFile.get("superiorinfo")))) {
                    Set superiorNumberSet = superiorInfos.stream().filter(Objects::nonNull).map(superiorInfo -> superiorInfo.get("number")).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
                    receiverNumberSet.addAll(superiorNumberSet);
                    LOGGER.info("erManFileNumber:{} superiorSize:{} superiorNumberSet:{}", new Object[]{erManFileNumber, superiorNumberSet.size(), superiorNumberSet});
                }
                if (isGetCharge && CollectionUtils.isNotEmpty((Collection)(chargeInfos = (List)erManFile.get("chargeinfo")))) {
                    Set chargeNumberSet = chargeInfos.stream().filter(Objects::nonNull).map(chargeInfo -> chargeInfo.get("number")).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet());
                    receiverNumberSet.addAll(chargeNumberSet);
                    LOGGER.info("erManFileNumber:{} chargeSize:{} chargeNumberSet:{}", new Object[]{erManFileNumber, chargeNumberSet.size(), chargeNumberSet});
                }
                if (isGetProbationPerson) {
                    receiverNumberSet.add(erManFileNumber);
                    LOGGER.info("erManFileNumber:{}", (Object)erManFileNumber);
                }
                if (isGetTutor && CollectionUtils.isNotEmpty((Collection)(tutorNumbers = (List)tutorNumberMap.get(employeeId = (Long)erManFile.get("employee_id"))))) {
                    receiverNumberSet.addAll(tutorNumbers);
                    LOGGER.info("tutorNumbers:{}", (Object)tutorNumbers);
                }
                numbers.addAll(receiverNumberSet);
                receiverNumberMap.put(erManFileNumber, receiverNumberSet);
            });
            if (numbers.size() == 0 || (users = BosUserRepository.getRepository().queryByNumbers(numbers, new String[]{"id", "number"})).length == 0) continue;
            Map<String, Long> numberIdMap = Arrays.stream(users).collect(Collectors.toMap(user -> user.getString("number"), user -> user.getLong("id"), (v1, v2) -> v2));
            receiverNumberMap.forEach((erManFileNumber, receiverNumbers) -> {
                Set receiverUserIds = receiverNumbers.stream().map(numberIdMap::get).filter(Objects::nonNull).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(receiverUserIds)) {
                    receiverUserIdMap.put((String)erManFileNumber, receiverUserIds);
                    LOGGER.info("erManFileNumber:{} receiverUserIds{}", erManFileNumber, receiverUserIds);
                }
            });
        }
        LOGGER.info("DueRegEarlyWarnDataSource.batchGetReceiver end");
        return receiverUserIdMap;
    }
}

