/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.domain.service.impl.validate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.service.validate.IBatchRegApplyValidateService;
import kd.hr.hdm.business.reg.validator.BatchRegValidateWrapper;
import kd.hr.hdm.common.reg.constants.LabRelConstants;

public class BatchRegApplyValidateServiceImpl
implements IBatchRegApplyValidateService {
    @Override
    public Predicate<List<BatchRegValidateWrapper>> batchRegValidate() {
        return this.validateRegBillStatus().and(this.validateLaborrelstatus());
    }

    @Override
    public Predicate<List<BatchRegValidateWrapper>> validateRegBillStatus() {
        return batchRegValidateWrappers -> {
            batchRegValidateWrappers.forEach(batchRegValidateWrapper -> {
                Map data = batchRegValidateWrapper.getData().getEmployeeAttachInfo();
                String regStatus = (String)data.get("regstatus");
                if (!"".equals(regStatus) && !HRStringUtils.equalsIgnoreCase((String)regStatus, (String)"1010")) {
                    batchRegValidateWrapper.getValidateContext().setResult("validateRegBillsTatus", ResManager.loadKDString((String)"\u53ea\u53ef\u4e3a\u5f85\u8f6c\u6b63\u4eba\u5458\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"BatchRegApplyValidateServiceImpl_1", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<BatchRegValidateWrapper>> validateLaborrelstatus() {
        return batchRegValidateWrappers -> {
            Map<Long, BatchRegValidateWrapper> gourpByEmployeeIdMap = batchRegValidateWrappers.stream().collect(Collectors.toMap(temp -> (Long)temp.getData().getErmanfileMap().get("employee_id"), temp -> temp, (k1, k2) -> k1));
            Map employeeList = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmployeeStatus", (Object[])new Object[]{new ArrayList<Long>(gourpByEmployeeIdMap.keySet())});
            gourpByEmployeeIdMap.forEach((employeeId, batchRegValidateWrapper) -> {
                DynamicObject dynamicObject = (DynamicObject)employeeList.get(employeeId);
                Long laborrelStatus = (Long)dynamicObject.get("labrelstatuscls_id");
                if (!LabRelConstants.PROBATION.equals(laborrelStatus)) {
                    batchRegValidateWrapper.getValidateContext().setResult("validateRegBillsTatus", ResManager.loadKDString((String)"\u53ea\u53ef\u4e3a\u8bd5\u7528\u4e2d\u5458\u5de5\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"BatchRegApplyValidateServiceImpl_2", (String)"hr-hdm-business", (Object[])new Object[0]));
                }
            });
            return true;
        };
    }

    @Override
    public Predicate<List<BatchRegValidateWrapper>> validateMainOrg() {
        return batchRegValidateWrappers -> {
            AtomicBoolean result = new AtomicBoolean(true);
            Map<Object, List<BatchRegValidateWrapper>> groupByOrgMap = batchRegValidateWrappers.stream().collect(Collectors.groupingBy(temp -> temp.getData().getErmanfileMap().get("org_id")));
            if (groupByOrgMap.size() > 1) {
                batchRegValidateWrappers.forEach(batchRegValidateWrapper -> {
                    batchRegValidateWrapper.getValidateContext().setResult("validateRegBillsTatus", ResManager.loadKDString((String)"\u60f3\u9009\u62e9\u540c\u4e00\u201c\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u201d\u7684\u4eba\u5458\u53d1\u8d77\u6279\u91cf\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"BatchRegApplyValidateServiceImpl_0", (String)"hr-hdm-business", (Object[])new Object[0]));
                    result.set(false);
                });
            }
            return result.get();
        };
    }
}

