/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.mq;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hdm.business.reg.domain.repository.bill.HDMRegBaseBillRepository;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.constants.RegActionConstants;

public class PersonChangeCallBack
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(PersonChangeCallBack.class);
    private static final String SUCCESS = "success";
    private static final String BILL_ID = "billId";
    private static final String RECORD_ID = "recordId";
    private static final String MSGPUBNO = "MP20220407000106";
    private static final String MSGSYN_ACTIONID = "msgSynActionId";
    private static final String selectProperties = "id,billno,syncstatus,affaction,ermanfile,person,bemployee";

    public void onMessage(Object message, String messageId, boolean resend, MessageAcker messageAcker) {
        LOGGER.info("PersonChangeCallBack,the response message is:{}", (Object)JSONObject.toJSONString((Object)message));
        try {
            JSONArray messageArray = (JSONArray)JSONObject.parse((String)((String)message));
            JSONObject chgResult = (JSONObject)messageArray.get(0);
            this.dealWithMessage(chgResult);
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
    }

    public void dealWithMessage(JSONObject chgResult) {
        LOGGER.info("dealWithMessage chgResult={}", (Object)chgResult);
        DynamicObject billObj = HDMRegBaseBillRepository.getInstance().queryOne(selectProperties, chgResult.getLong(BILL_ID));
        if (!chgResult.getBoolean(SUCCESS).booleanValue()) {
            LOGGER.error("kd.hr.hdm.business.reg.mq.PersonChangeCallBack.onMessage get error , PerChg is failed");
            billObj.set("syncstatus", (Object)"0");
            IRegBillService.getInstance().update(billObj);
            return;
        }
        billObj.set("syncstatus", (Object)"1");
        IRegBillService.getInstance().update(billObj);
        Long msgSynActionId = chgResult.getLong(MSGSYN_ACTIONID);
        if (!billObj.getBoolean("affaction.isnewchgaction") && RegActionConstants.REG_ACTION_ID.equals(billObj.getLong("affaction.id"))) {
            Map<String, Object> messageContent = this.getMessageContent(chgResult, billObj);
            this.sendToHRMP(messageContent, billObj, msgSynActionId);
        }
    }

    private void sendToHRMP(Map<String, Object> messageContent, DynamicObject billObj, Long actionId) {
        HashMap messageParams = Maps.newHashMapWithExpectedSize((int)8);
        messageParams.put("msgNumber", String.valueOf(billObj.getLong("id")));
        messageParams.put("msgPubNo", MSGPUBNO);
        messageParams.put("msgTitle", billObj.getDynamicObject("ermanfile").getString("name") + billObj.getString("affaction.name"));
        messageParams.put("actionId", actionId);
        messageParams.put("senderId", RequestContext.get().getCurrUserId());
        messageParams.put("sendTime", new Date());
        messageParams.put("params", SerializationUtils.serializeToBase64(messageContent));
        LOGGER.info(String.format("PersonChangeCallBack------sendToHRMP----messageParams:%s", JSONObject.toJSONString((Object)messageParams)));
        HRProducerServiceHelper.publishAction((Map)messageParams);
    }

    private Map<String, Object> getMessageContent(JSONObject chgResult, DynamicObject billObj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("affactionId", billObj.getLong("affaction.id"));
        params.put("chgcategoryId", billObj.getDynamicObject("affaction.chgcategory").getLong("id"));
        params.put(RECORD_ID, chgResult.get((Object)RECORD_ID));
        return params;
    }
}

