/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.business.reg.validator.RegApplyValidatorHelper;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.ValidateContext;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegCommentEnum;
import kd.hr.hdm.common.transfer.enums.TransferOperateTypeEnum;
import kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper;
import org.apache.commons.lang3.time.StopWatch;

public class BatchRegValidateHelper {
    private static final Log LOGGER = LogFactory.getLog(BatchRegValidateHelper.class);
    public static final String SUFFIX_ID = "_id";

    public static void saveAndSubmitValidate(DynamicObject batchRegBill, List<DynamicObject> regBillList, List<DataValidate<DynamicObject>> dataValidateList) {
        List<Long> empIds = regBillList.stream().map(regBill -> regBill.getLong("bemployee.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> labStatusMap = IPersonAboutService.getInstance().getLabStatusByEmpId(empIds);
        BatchRegValidateHelper.validateLicense(dataValidateList);
        StopWatch stopWatch = new StopWatch("BatchRegValidateHelper_saveAndSubmitValidate");
        stopWatch.start();
        Map<Long, List<Map<String, Object>>> crossListMap = RegApplyValidatorHelper.getCrossListMap(regBillList);
        stopWatch.stop();
        LOGGER.info("BatchRegValidateHelper_saveAndSubmitValidate doPersonCrossValidateBatch ,cost time :{}", (Object)stopWatch.getNanoTime());
        dataValidateList.stream().filter(dataDiv -> ValidateRangeEnum.VALIDATE_ERROR != dataDiv.getValidatorContext().getRange()).forEach(dataValidate -> {
            HashMap errorMap = Maps.newHashMapWithExpectedSize((int)regBillList.size());
            errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
            DynamicObject regBill = (DynamicObject)dataValidate.getData();
            long empId = regBill.getLong("bemployee.id");
            boolean hitErrorMsg = IPersonAboutService.getInstance().validateLabStatus(regBill, errorMap, (DynamicObject)labStatusMap.get(empId), Boolean.FALSE);
            if (!hitErrorMsg) {
                if (RegCommentEnum.AGREE.getId().equals(regBill.getLong("regcomment.id")) && regBill.getDate("effectdate") == null) {
                    ((List)errorMap.get(RegBillServiceEnum.ERROR.getCode())).add(ResManager.loadKDString((String)"\u5982\u679c\u540c\u610f\u8f6c\u6b63\uff0c\u9700\u586b\u5199\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"RegBillServiceImpl_28", (String)"hr-hdm-business", (Object[])new Object[0]));
                    hitErrorMsg = true;
                } else {
                    hitErrorMsg = IRegBillService.getInstance().doValidateEffectDateAndPreActualDate(regBill, errorMap, Boolean.FALSE);
                }
                if (RegCommentEnum.AGREE.getId().equals(regBill.getLong("regcomment.id")) && regBill.getDynamicObject("laborrelstatus") == null) {
                    ((List)errorMap.get(RegBillServiceEnum.ERROR.getCode())).add(ResManager.loadKDString((String)"\u5982\u679c\u540c\u610f\u8f6c\u6b63\uff0c\u201c\u8f6c\u6b63\u540e\u7528\u5de5\u5173\u7cfb\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RegBillServiceImpl_30", (String)"hr-hdm-business", (Object[])new Object[0]));
                    hitErrorMsg = true;
                } else {
                    hitErrorMsg = IRegBillService.getInstance().doValidatelaborrelstatus(regBill, errorMap);
                }
            }
            if (!hitErrorMsg) {
                hitErrorMsg = BatchRegValidateHelper.entryHrbuValidate(batchRegBill, regBill, errorMap);
            }
            if (!hitErrorMsg) {
                Long depEmpId = regBill.getDynamicObject("ermanfile").getLong("depemp_id");
                IPersonAboutService.getInstance().doPersonCrossValidateForBatch(regBill, errorMap, (List)crossListMap.get(depEmpId), Boolean.FALSE);
            }
            BatchRegValidateHelper.convert(errorMap, dataValidate.getValidatorContext());
        });
        IRegBillService.getInstance().doBatchValidateBillInProcess(dataValidateList.stream().filter(dataDiv -> ValidateRangeEnum.VALIDATE_ERROR != dataDiv.getValidatorContext().getRange()).collect(Collectors.toList()));
    }

    private static boolean entryHrbuValidate(DynamicObject batchRegBill, DynamicObject regBill, Map<String, List<String>> errorMap) {
        long personHrbu;
        long batchgRegBillOrgId = batchRegBill.getLong("org.id");
        if (batchgRegBillOrgId != (personHrbu = regBill.getLong("ermanfile.org.id"))) {
            List<String> errorMsgList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
            errorMsgList.add(ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u7684\u4e3b\u6863\u6848\u6240\u5c5e\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u4e0e\u5f53\u524d\u5355\u636e\u7684\u4eba\u4e8b\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u53d1\u8d77\u8f6c\u6b63\u7533\u8bf7\u3002", (String)"BatchRegValidateHelper_5", (String)"hr-hdm-business", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public static void validateAffiliationOrg(BeforeDoOperationEventArgs args, AbstractFormPlugin formPlugin, DynamicObject batchRegBill, List<DynamicObject> regBillList) {
        long affiliationOrgId = batchRegBill.getLong("affiliationord.id");
        for (DynamicObject regBill : regBillList) {
            long adminOrgId = regBill.getLong("badminorg.id");
            if (affiliationOrgId == adminOrgId) continue;
            FormOperate operate = (FormOperate)args.getSource();
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) break;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)formPlugin);
            String confirmTip = ResManager.loadKDString((String)"\u5458\u5de5\u7684\u4e3b\u4efb\u804c\u90e8\u95e8\u4e0e\u5f53\u524d\u5355\u636e\u7684\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u518d\u6b21\u786e\u5b9a\u3002", (String)"BatchRegValidateHelper_6", (String)"hr-hdm-business", (Object[])new Object[0]);
            formPlugin.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            args.setCancel(true);
            break;
        }
    }

    public static Map<String, Object> buildOperateInfoByValResult(List<DataValidate<DynamicObject>> dataValidateList, TransferOperateTypeEnum operateTypeEnum) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Integer sumPerson = dataValidateList.size();
        Integer failPersoner = 0;
        Integer successPerson = 0;
        ArrayList detailExcelDataList = Lists.newArrayListWithExpectedSize((int)dataValidateList.size());
        Map<String, String> exportFieldMap = BatchRegValidateHelper.getExportFieldMap();
        for (DataValidate<DynamicObject> dataDiv : dataValidateList) {
            Integer n;
            Integer n2;
            ValidateContext validatorContext = dataDiv.getValidatorContext();
            if (ValidateRangeEnum.VALIDATE_ERROR == validatorContext.getRange()) {
                n2 = failPersoner;
                n = failPersoner = Integer.valueOf(failPersoner + 1);
            } else {
                n2 = successPerson;
                n = successPerson = Integer.valueOf(successPerson + 1);
            }
            detailExcelDataList.add(BatchRegValidateHelper.getDetailExcelData(dataDiv, exportFieldMap));
        }
        result.put("sumperson", sumPerson);
        result.put("failperson", failPersoner);
        result.put("successperson", successPerson);
        result.put("headDataList", BatchRegValidateHelper.getDetailExcelHead(exportFieldMap));
        result.put("exportDataList", detailExcelDataList);
        result.put("operatetype", operateTypeEnum.getType());
        return result;
    }

    private static void convert(Map<String, List<String>> errorMap, ValidateContext validatorContext) {
        List<String> errorList = errorMap.get(RegBillServiceEnum.ERROR.getCode());
        List<String> warningMsgList = errorMap.get(RegBillServiceEnum.WARNING.getCode());
        int index = 0;
        for (String warningMsg : warningMsgList) {
            validatorContext.setResult(ValidateRangeEnum.VALIDATE_WARN, String.valueOf(index), warningMsg);
            ++index;
        }
        for (String errorMsg : errorList) {
            validatorContext.setResult(ValidateRangeEnum.VALIDATE_ERROR, String.valueOf(index), errorMsg);
            ++index;
        }
    }

    private static List<HRExportHeadObject> getDetailExcelHead(Map<String, String> exportFieldMap) {
        List<HRExportHeadObject> excelHeadList = exportFieldMap.entrySet().stream().map(entry -> new HRExportHeadObject((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        excelHeadList.add(new HRExportHeadObject("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u7ed3\u679c", (String)"BatchTransferValidatorServiceImpl_18", (String)"hr-hdm-business", (Object[])new Object[0])));
        excelHeadList.add(new HRExportHeadObject("errormsg", ResManager.loadKDString((String)"\u6821\u9a8c\u8bf4\u660e", (String)"BatchTransferValidatorServiceImpl_19", (String)"hr-hdm-business", (Object[])new Object[0])));
        return excelHeadList;
    }

    private static Map<String, Object> getDetailExcelData(DataValidate dataDiv, Map<String, String> exportFieldMap) {
        ValidateContext validatorContext = dataDiv.getValidatorContext();
        DynamicObject regBill = (DynamicObject)dataDiv.getData();
        HashMap<String, Object> data = new HashMap<String, Object>(32);
        exportFieldMap.forEach((key, value) -> BatchRegValidateHelper.putValueToMap(key).accept(regBill, data));
        if (ValidateRangeEnum.VALIDATE_ERROR == validatorContext.getRange()) {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25", (String)"BatchTransferValidatorServiceImpl_20", (String)"hr-hdm-business", (Object[])new Object[0]));
            data.put("errormsg", String.join((CharSequence)"\uff1b", validatorContext.getValidateResult().values()));
        } else {
            data.put("valresult", ResManager.loadKDString((String)"\u6821\u9a8c\u901a\u8fc7", (String)"BatchTransferValidatorServiceImpl_21", (String)"hr-hdm-business", (Object[])new Object[0]));
            data.put("errormsg", String.join((CharSequence)"\uff1b", validatorContext.getValidateResult().values()));
        }
        return data;
    }

    private static BiConsumer<DynamicObject, Map<String, Object>> putValueToMap(String field) {
        return (dynamicObject, map) -> {
            Object value = dynamicObject.get(field);
            if (value == null) {
                return;
            }
            if (DynamicObject.class.equals(value.getClass())) {
                map.put(field, ((DynamicObject)value).getString("name"));
            } else if (Date.class.equals(value.getClass())) {
                map.put(field, HRDateTimeUtils.format((Date)((Date)value), (String)"yyyy-MM-dd"));
            } else {
                map.put(field, value.toString());
            }
        };
    }

    private static Map<String, String> getExportFieldMap() {
        LinkedHashMap<String, String> exportFieldMap = new LinkedHashMap<String, String>(16);
        exportFieldMap.put("ermanfile.person.name", ResManager.loadKDString((String)"\u59d3\u540d", (String)"BatchRegValidateHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("ermanfile.person.number", ResManager.loadKDString((String)"\u5de5\u53f7", (String)"BatchRegValidateHelper_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("entrydate", ResManager.loadKDString((String)"\u5165\u804c\u65e5\u671f", (String)"BatchRegValidateHelper_2", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("probationtext", ResManager.loadKDString((String)"\u8bd5\u7528\u671f", (String)"BatchRegValidateHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
        exportFieldMap.put("preactualdate", ResManager.loadKDString((String)"\u9884\u8f6c\u6b63\u65e5\u671f", (String)"BatchRegValidateHelper_4", (String)"hr-hdm-business", (Object[])new Object[0]));
        return exportFieldMap;
    }

    private void validateEffectDate(DataValidate<DynamicObject> dataValidate, DynamicObject entryDynamicObject) {
        Date startDate;
        if (ValidateRangeEnum.VALIDATE_PASS != dataValidate.getValidatorContext().getRange()) {
            return;
        }
        DynamicObject data = (DynamicObject)dataValidate.getData();
        Date effectDate = data.getDate("effectdate");
        if (HRDateTimeUtils.dayBefore((Date)effectDate, (Date)(startDate = entryDynamicObject.getDate("startdate")))) {
            String errorMsg = ResManager.loadKDString((String)"\u517c\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5165\u804c\u65e5\u671f\u201c{0}\u201d\u3002", (String)"PartBillPChValidator_11", (String)"hr-hdm-opplugin", (Object[])new Object[]{startDate});
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", errorMsg);
        }
    }

    private static void validateLicense(List<DataValidate<DynamicObject>> dataValidates) {
        ArrayList personIds = new ArrayList(dataValidates.size());
        dataValidates.forEach(dataValidate -> {
            DynamicObject regBill = (DynamicObject)dataValidate.getData();
            personIds.add(regBill.getLong("person.id"));
        });
        Map personLicensesMap = HRCertValidateServiceHelper.checkPersonLicenses(personIds);
        dataValidates.stream().forEach(dataValidate -> {
            DynamicObject regAppBill = (DynamicObject)dataValidate.getData();
            long personId = regAppBill.getLong("person_id");
            Map personInfo = (Map)personLicensesMap.get(personId);
            String errMsg = null;
            try {
                if (HRMapUtils.isEmpty((Map)personInfo)) {
                    errMsg = ResManager.loadKDString((String)"\u672a\u68c0\u67e5\u5230\u8bb8\u53ef\u4eba\u5458\u3002", (String)"RegAppBillValidator_9", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                }
                if (Boolean.FALSE.equals(personInfo.get("status"))) {
                    String name = (String)personInfo.get("name");
                    String number = (String)personInfo.get("number");
                    errMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u53d1\u8d77\u8f6c\u6b63\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"RegAppBillValidator_10", (String)"hr-hdm-opplugin", (Object[])new Object[0]), name, number);
                }
            }
            catch (Exception e) {
                errMsg = ResManager.loadKDString((String)"\u6821\u9a8c\u8bb8\u53ef\u5f02\u5e38", (String)"RegAppBillValidator_11", (String)"hr-hdm-opplugin", (Object[])new Object[0]);
                LOGGER.error("###RegAppBillValidator.validateLicense error:", (Throwable)e);
            }
            LOGGER.info("###RegAppBillValidator.validateLicense msg:{}, personId:{}", (Object)errMsg, (Object)personId);
            if (!HRStringUtils.isBlank((CharSequence)errMsg)) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "RegAppBillValidator_7", errMsg);
            }
        });
    }
}

