/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.reg.validator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hdm.business.reg.domain.service.bill.IPersonAboutService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.parttime.entity.DataValidate;
import kd.hr.hdm.common.parttime.entity.DataValidateBuilder;
import kd.hr.hdm.common.parttime.enums.ValidateRangeEnum;
import kd.hr.hdm.common.parttime.model.ValidateContentDTO;
import kd.hr.hdm.common.reg.enums.RegBillServiceEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;

public class RegApplyValidatorHelper {
    private static final Log LOGGER = LogFactory.getLog(RegApplyValidatorHelper.class);

    public static Map<Long, Map<String, List<ValidateContentDTO>>> regApplyValidate(List<DynamicObject> regBillList, String operateEvent, boolean isTipsWithBillNo, boolean isWeakBulletBox, boolean isSkipValidate) {
        if (HRCollUtil.isEmpty(regBillList)) {
            return new HashMap<Long, Map<String, List<ValidateContentDTO>>>();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)regBillList.size());
        List<Long> empIds = regBillList.stream().map(regBill -> regBill.getLong("bemployee.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> labStatusMap = IPersonAboutService.getInstance().getLabStatusByEmpId(empIds);
        Map<Long, List<Map<String, Object>>> crossListMap = RegApplyValidatorHelper.getCrossListMap(regBillList);
        regBillList.forEach(regBill -> {
            HashMap validateLevelMap = Maps.newHashMapWithExpectedSize((int)16);
            validateLevelMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
            validateLevelMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
            HashMap errorMap = Maps.newHashMapWithExpectedSize((int)16);
            errorMap.put(RegBillServiceEnum.WARNING.getCode(), new ArrayList());
            errorMap.put(RegBillServiceEnum.ERROR.getCode(), new ArrayList());
            long empId = regBill.getLong("bemployee.id");
            boolean hitErrorMsg = false;
            if ("operate_event".equals(operateEvent)) {
                hitErrorMsg = IRegBillService.getInstance().doValidateBillNotInTempStorage((DynamicObject)regBill, errorMap, isTipsWithBillNo);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
                if (!hitErrorMsg) {
                    hitErrorMsg = IRegBillService.getInstance().doValidateIfSelfApply((DynamicObject)regBill, errorMap, isTipsWithBillNo);
                    RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
                }
            }
            if (!hitErrorMsg) {
                hitErrorMsg = IRegBillService.getInstance().doValidateEffectDateAndPreActualDate((DynamicObject)regBill, errorMap, isTipsWithBillNo);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
            }
            if (!hitErrorMsg) {
                hitErrorMsg = IPersonAboutService.getInstance().validateLabStatus((DynamicObject)regBill, errorMap, (DynamicObject)labStatusMap.get(empId), isTipsWithBillNo);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
            }
            if (!hitErrorMsg && !isSkipValidate) {
                hitErrorMsg = IRegBillService.getInstance().doValidateBillInProcess((DynamicObject)regBill, errorMap);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
            }
            Long depEmpId = regBill.getDynamicObject("ermanfile").getLong("depemp_id");
            if (!hitErrorMsg && crossListMap.size() > 0) {
                hitErrorMsg = IPersonAboutService.getInstance().doPersonCrossValidateForBatch((DynamicObject)regBill, errorMap, (List)crossListMap.get(depEmpId), isTipsWithBillNo);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
            }
            if (!hitErrorMsg) {
                IPersonAboutService.getInstance().validateErmanFile((DynamicObject)regBill, errorMap);
                RegApplyValidatorHelper.covert(errorMap, validateLevelMap);
            }
            if (((List)validateLevelMap.get(RegBillServiceEnum.ERROR.getCode())).size() > 0 || ((List)validateLevelMap.get(RegBillServiceEnum.WARNING.getCode())).size() > 0) {
                resultMap.put(regBill.getLong("id"), validateLevelMap);
            }
        });
        return resultMap;
    }

    private static void covert(Map<String, List<String>> errMap, Map<String, List<ValidateContentDTO>> resultMap) {
        RegApplyValidatorHelper.covert(errMap.get(RegBillServiceEnum.ERROR.getCode()), resultMap.get(RegBillServiceEnum.ERROR.getCode()));
        RegApplyValidatorHelper.covert(errMap.get(RegBillServiceEnum.WARNING.getCode()), resultMap.get(RegBillServiceEnum.WARNING.getCode()));
    }

    private static void covert(List<String> msgList, List<ValidateContentDTO> validateContentDTOS) {
        if (msgList.size() > 0) {
            Iterator<String> iterator = msgList.iterator();
            while (iterator.hasNext()) {
                String errMsg = iterator.next();
                validateContentDTOS.add(new ValidateContentDTO(errMsg));
                iterator.remove();
            }
        }
    }

    private static boolean validateProbationLaw(DataValidate<DynamicObject> dataValidate, Map<String, List<ValidateContentDTO>> resultMap, boolean isTipsWithBillNo) {
        ValidateRangeEnum range = dataValidate.getValidatorContext().getRange();
        if (ValidateRangeEnum.VALIDATE_PASS == range) {
            return false;
        }
        Map validateResult = dataValidate.getValidatorContext().getValidateResult();
        ValidateContentDTO validateContentDTO = new ValidateContentDTO();
        String title = (String)validateResult.get("title");
        if (isTipsWithBillNo) {
            title = ((DynamicObject)dataValidate.getData()).getString("billno") + "\uff1a" + title;
        }
        validateContentDTO.setTitle(title);
        validateContentDTO.setContent((String)validateResult.get("content"));
        if (ValidateRangeEnum.VALIDATE_ERROR == range) {
            List<ValidateContentDTO> validateContentDTOS = resultMap.get(RegBillServiceEnum.ERROR.getCode());
            validateContentDTOS.add(validateContentDTO);
            return true;
        }
        if (ValidateRangeEnum.VALIDATE_WARN == range) {
            List<ValidateContentDTO> validateContentDTOS = resultMap.get(RegBillServiceEnum.WARNING.getCode());
            validateContentDTOS.add(validateContentDTO);
            return false;
        }
        return false;
    }

    public static Map<Long, List<Map<String, Object>>> getCrossListMap(List<DynamicObject> regBillList) {
        Map<String, Object> crossBatchMap = IPersonAboutService.getInstance().doPersonCrossValidateBatch(regBillList);
        if (crossBatchMap == null || crossBatchMap.size() < 1) {
            return new HashMap<Long, List<Map<String, Object>>>();
        }
        Boolean isSuccess = (Boolean)crossBatchMap.get("success");
        if (isSuccess.booleanValue()) {
            return (Map)crossBatchMap.get("data");
        }
        LOGGER.error((String)crossBatchMap.get("errorMsg"));
        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4eba\u4e8b\u4e8b\u52a1\u53d8\u52a8\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"RegApplyValidatorHelper_3", (String)"hr-hdm-business", (Object[])new Object[0]));
    }

    private static boolean isOver(List<DynamicObject> regBills) {
        return HRCollUtil.isEmpty(regBills);
    }

    public static DataValidate<List<DynamicObject>> validateRegApplyBillStatus(List<DynamicObject> regBillList) {
        DataValidate dataValidate = DataValidateBuilder.builderSinge(regBillList);
        if (RegApplyValidatorHelper.isOver(regBillList)) {
            return dataValidate;
        }
        regBillList.forEach(regBill -> {
            String billStatus = regBill.getString("billstatus");
            if (!RegBillStatusEnum.TEMPSTORAGE.getCode().equals(billStatus) && !RegBillStatusEnum.WAITRESUBMIT.getCode().equals(billStatus)) {
                dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u53ea\u80fd\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u4e3a\u201c\u6682\u5b58\u201d\u548c\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u7684\u5355\u636e\u3002", (String)"RegApplyValidatorHelper_1", (String)"hr-hdm-business", (Object[])new Object[0]));
            }
        });
        return dataValidate;
    }

    public static DataValidate<DynamicObject> validateUnsubmit(DynamicObject regBill) {
        String billStatus = regBill.getString("billstatus");
        DataValidate dataValidate = DataValidateBuilder.builderSinge((Object)regBill);
        if (!RegBillStatusEnum.ALREADYSUBMIT.getCode().equals(billStatus) && !RegBillStatusEnum.APPROVING.getCode().equals(billStatus)) {
            dataValidate.getValidatorContext().setResult(ValidateRangeEnum.VALIDATE_ERROR, "all", ResManager.loadKDString((String)"\u53ea\u80fd\u64a4\u9500\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u201c\u5ba1\u6279\u4e2d\u201d\u7684\u5355\u636e\uff0c\u5f53\u524d\u5355\u636e\u4e3a\u201c%s\u201d\uff0c\u4e0d\u80fd\u64a4\u9500\u3002", (String)"RegApplyValidatorHelper_2", (String)"hr-hdm-business", (Object[])new Object[]{RegBillStatusEnum.getName((String)billStatus)}));
        }
        return dataValidate;
    }
}

