/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.repository;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hdm.common.reg.constants.RegProcessConstants;
import kd.hr.hdm.common.reg.enums.PostponeAskResultEnum;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;

public class RegApplyRepository
extends HRBaseServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(RegApplyRepository.class);
    private static final RegApplyRepository REPOSITORY = new RegApplyRepository("hdm_regbasebill");

    public RegApplyRepository(String entityName) {
        super(entityName);
    }

    public static RegApplyRepository getRepository() {
        return REPOSITORY;
    }

    public Map<Long, DynamicObject> queryWaitRegBills(List<Long> erManFileIds, String[] selectProperties) {
        DynamicObject[] regBills;
        QFilter[] filters = new QFilter[]{new QFilter("ermanfile.id", "in", erManFileIds), new QFilter("billstatus", "not in", (Object)new String[]{RegBillStatusEnum.ABANDONED.getCode(), RegBillStatusEnum.DELETED.getCode(), RegBillStatusEnum.APPROVEREJECTED.getCode()}), new QFilter("auditstatus", "!=", (Object)RegNewAuditStatusEnum.ABANDONED.getCode()), new QFilter("regstatus", "in", (Object)new String[]{"1010", "1020", "1030"})};
        DynamicObject[] dynamicObjectArray = regBills = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), filters);
        if (regBills.length == 0) {
            LOGGER.error("regBills is null");
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(regBills).collect(Collectors.toMap(regBill -> regBill.getLong("ermanfile.id"), regBill -> regBill, (v1, v2) -> v2));
    }

    public Map<Long, DynamicObject> queryNearPreRegBills(List<Long> erManFileIds, String[] selectProperties) {
        DynamicObject[] regBills;
        QFilter filter = new QFilter("ermanfile.id", "in", erManFileIds);
        filter.and(new QFilter("billstatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{RegBillStatusEnum.ABANDONED.getCode(), RegBillStatusEnum.APPROVEREJECTED.getCode()})));
        filter.and(new QFilter("auditstatus", "!=", (Object)RegNewAuditStatusEnum.ABANDONED.getCode()));
        QFilter delayRegFilter = new QFilter("regcategory", "=", (Object)RegProcessConstants.DELAY_REG_CATEGORY_ID).and("billstatus", "!=", (Object)RegBillStatusEnum.APPROVEPASSED.getCode());
        QFilter notDelayRegFilter = new QFilter("regcategory", "!=", (Object)RegProcessConstants.DELAY_REG_CATEGORY_ID);
        QFilter[] filters = new QFilter[]{filter.and(delayRegFilter.or(notDelayRegFilter))};
        DynamicObject[] dynamicObjectArray = regBills = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), filters);
        if (regBills.length == 0) {
            LOGGER.error("regBills is null");
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(regBills).collect(Collectors.toMap(regBill -> regBill.getLong("ermanfile.id"), regBill -> regBill, (v1, v2) -> v2));
    }

    public int proDelayWaitHandleCount(QFilter filter) {
        QFilter[] filters = new QFilter[]{filter, new QFilter("regcategory", "=", (Object)RegProcessConstants.DELAY_REG_CATEGORY_ID), new QFilter("postponeaskresult", "in", (Object)new String[]{PostponeAskResultEnum.PENDING_FEEDBACK.getCode(), PostponeAskResultEnum.DISAGREE.getCode()}), new QFilter("billstatus", "in", (Object)new String[]{RegBillStatusEnum.ALREADYSUBMIT.getCode(), RegBillStatusEnum.WAITRESUBMIT.getCode(), RegBillStatusEnum.APPROVING.getCode()})};
        return REPOSITORY.count("hdm_regbasebill", filters);
    }

    public Map<Long, DynamicObject> queryByIds(String[] selectProperties, List<Long> ids) {
        DynamicObject[] regBills;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] dynamicObjectArray = regBills = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), filters);
        if (regBills.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(regBills).collect(Collectors.toMap(regBill -> regBill.getLong("id"), regBill -> regBill, (v1, v2) -> v2));
    }

    public DynamicObject queryById(String[] selectProperties, Long id) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        return selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObject(filters) : REPOSITORY.queryOne(String.join((CharSequence)",", selectProperties), filters);
    }
}

