/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.repository;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class RegAskDetailsRepository
extends HRBaseServiceHelper {
    private static final RegAskDetailsRepository REPOSITORY = new RegAskDetailsRepository("hdm_regaskdetails");

    public RegAskDetailsRepository(String entityName) {
        super(entityName);
    }

    public static RegAskDetailsRepository getRepository() {
        return REPOSITORY;
    }

    public DynamicObject queryById(Long id, String[] selectProperties) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)id)};
        return selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObject(filters) : REPOSITORY.queryOne(String.join((CharSequence)",", selectProperties), filters);
    }

    public Map<Long, DynamicObject> queryByIds(List<Long> ids, String[] selectProperties) {
        DynamicObject[] regAskDetails;
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObject[] dynamicObjectArray = regAskDetails = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(filters) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), filters);
        if (regAskDetails.length == 0) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(regAskDetails).collect(Collectors.toMap(examResult -> examResult.getLong("id"), examResult -> examResult, (v1, v2) -> v2));
    }

    public Map<Long, Map<Long, List<DynamicObject>>> queryByPersonIds(List<Long> employeeIds, String[] selectProperties) {
        DynamicObject[] regExamDetailArray;
        QFilter filter = new QFilter("bemployee", "in", employeeIds);
        filter.and("isnewest", "=", (Object)"1");
        DynamicObject[] dynamicObjectArray = regExamDetailArray = selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(new QFilter[]{filter}) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), new QFilter[]{filter});
        if (regExamDetailArray.length == 0) {
            return new HashMap<Long, Map<Long, List<DynamicObject>>>();
        }
        Map<Long, List<DynamicObject>> regExamDetailsMap = Arrays.stream(regExamDetailArray).collect(Collectors.groupingBy(dy -> dy.getLong("bemployee")));
        HashMap<Long, Map<Long, List<DynamicObject>>> resultMap = new HashMap<Long, Map<Long, List<DynamicObject>>>(regExamDetailsMap.size());
        regExamDetailsMap.forEach((employeeId, regExamDetails) -> resultMap.put((Long)employeeId, regExamDetails.stream().collect(Collectors.groupingBy(dy -> dy.getLong("askperson.id")))));
        return resultMap;
    }

    public Map<Long, String> getAskCompProgress(List<Long> employeeIds) {
        Map<Long, Map<Long, List<DynamicObject>>> regAskDetailsMap = this.queryByPersonIds(employeeIds, new String[]{"bemployee", "person.id", "status", "askperson.id"});
        if (regAskDetailsMap.isEmpty()) {
            return new HashMap<Long, String>();
        }
        HashMap<Long, String> askCompProgressMap = new HashMap<Long, String>(regAskDetailsMap.size());
        regAskDetailsMap.forEach((employeeId, askDetailsMap) -> {
            HashSet askCompPersonIdSet = new HashSet();
            askDetailsMap.forEach((askPersonId, askDetails) -> askDetails.stream().filter(dy -> HRStringUtils.equals((String)dy.getString("status"), (String)"1030")).forEach(dy -> askCompPersonIdSet.add(dy.getLong("askperson.id"))));
            askCompProgressMap.put((Long)employeeId, String.format("%s/%s", askCompPersonIdSet.size(), askDetailsMap.size()));
        });
        return askCompProgressMap;
    }

    public DynamicObject[] queryNewestExamIngByPersonIds(List<Long> employeeIds, String[] selectProperties) {
        QFilter filter = new QFilter("bemployee", "in", employeeIds);
        filter.and("status", "=", (Object)"1020");
        filter.and("isnewest", "=", (Object)"1");
        return selectProperties == null || selectProperties.length == 0 ? REPOSITORY.loadDynamicObjectArray(new QFilter[]{filter}) : REPOSITORY.query(String.join((CharSequence)",", selectProperties), new QFilter[]{filter});
    }
}

