/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hdm.business.domain.parttime.repository.ParttimeBatchRepository;
import kd.hr.hdm.business.domain.service.hssc.IHSSCService;
import kd.hr.hdm.business.repository.ParttimeApplyRepository;

public class BatchPartTimeQuitTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BatchPartTimeQuitTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            this.dealBatchPartTimeBills();
        }
        catch (Exception exception) {
            logger.error("BatchPartTimeQuitTask exception:", (Throwable)exception);
        }
    }

    private void dealBatchPartTimeBills() {
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{"A", "B", "C", "D", "G"});
        DynamicObject[] batchParttimeBills = ParttimeBatchRepository.getInstance().query("id, billno,billstatus, auditstatus, modifytime,termuser, termdate, termreason", filter.toArray());
        Map batchPartTimeBillMap = Arrays.stream(batchParttimeBills).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (oldV, newV) -> newV));
        ArrayList updatebatchPartTimeBills = new ArrayList(batchParttimeBills.length);
        QFilter qFilter = new QFilter("mid", "in", batchPartTimeBillMap.keySet());
        DynamicObject[] entryBills = ParttimeApplyRepository.getInstance().query("id, mid, billno, parttimestatus, auditstatus, billstatus,modifytime", qFilter.toArray(), null);
        Map<Long, List<DynamicObject>> entryBillMap = Arrays.stream(entryBills).collect(Collectors.groupingBy(entry -> entry.getLong("mid")));
        Date date = new Date();
        entryBillMap.forEach((mid, entrys) -> {
            DynamicObject batchPartTimeBill = (DynamicObject)batchPartTimeBillMap.get(mid);
            String billstatus = batchPartTimeBill.getString("billstatus");
            Map<String, List<DynamicObject>> entryMap = entrys.stream().collect(Collectors.groupingBy(entry -> entry.getString("parttimestatus")));
            if (entryMap.size() == 1 && entryMap.containsKey("-1")) {
                if (!"C".equals(billstatus)) {
                    batchPartTimeBill.set("billstatus", (Object)"F");
                    this.setAuditStatus(batchPartTimeBill, date, updatebatchPartTimeBills);
                    if (!"A".equals(billstatus)) {
                        this.abandonWorkFlow(batchPartTimeBill);
                    }
                } else if ("C".equals(batchPartTimeBill.getString("auditstatus"))) {
                    this.setAuditStatus(batchPartTimeBill, date, updatebatchPartTimeBills);
                }
            } else if (!entryMap.containsKey("0") && entryMap.containsKey("-1")) {
                if ("C".equals(billstatus) && "F".equals(batchPartTimeBill.getString("auditstatus"))) {
                    return;
                }
                this.setAuditStatus(batchPartTimeBill, date, updatebatchPartTimeBills);
            }
        });
        ParttimeApplyRepository.getInstance().update(updatebatchPartTimeBills.toArray(new DynamicObject[0]));
    }

    private void abandonWorkFlow(DynamicObject batchPartTimeBill) {
        String billId = batchPartTimeBill.getString("id");
        Long instanceId = WorkflowServiceHelper.getProcessInstanceIdByBusinessKey((String)billId);
        if (!Objects.isNull(instanceId) && !instanceId.equals(0L)) {
            try (TXHandle txHandle = TX.notSupported();){
                logger.info("PartBill terminate work flow , instanceid : [{}]", (Object)instanceId);
                IHSSCService.getInstance().terminateSSCTask(batchPartTimeBill);
                WorkflowServiceHelper.abandon((Long)instanceId);
            }
            catch (Exception exception) {
                logger.error("batchparttime terminate exception:", (Throwable)exception);
            }
        }
    }

    private void setAuditStatus(DynamicObject batchPartTimeBill, Date date, List<DynamicObject> updatebatchPartTimeBills) {
        batchPartTimeBill.set("auditstatus", (Object)"F");
        batchPartTimeBill.set("modifytime", (Object)date);
        batchPartTimeBill.set("termreason", (Object)ResManager.loadKDString((String)"\u7531\u4e8e\u5355\u636e\u4e2d\u517c\u804c\u5458\u5de5\u5df2\u79bb\u804c\uff0c \u8be5\u5355\u636e\u5df2\u81ea\u52a8\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchPartTimeQuitTask_0", (String)"hr-hdm-business", (Object[])new Object[0]));
        batchPartTimeBill.set("termuser", (Object)1L);
        batchPartTimeBill.set("termdate", (Object)date);
        updatebatchPartTimeBills.add(batchPartTimeBill);
    }
}

