/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hdm.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hdm.business.reg.domain.service.bill.IBatchRegBillService;
import kd.hr.hdm.business.reg.domain.service.bill.IRegBillService;
import kd.hr.hdm.common.reg.enums.RegBillStatusEnum;
import kd.hr.hdm.common.reg.enums.RegBusinessStatusEnum;
import kd.hr.hdm.common.reg.enums.RegNewAuditStatusEnum;

public class BatchRegTerminateTask
extends AbstractTask {
    private static final String BATCH_REG_SELECT_PROPERTIES = "billstatus,auditstatus,termuser,termdate,termreason";
    private static final String REG_SELECT_PROPERTIES = "mid,billstatus,auditstatus,regstatus";
    private static final String[] billStatusArr = new String[]{RegBillStatusEnum.TEMPSTORAGE.getCode(), RegBillStatusEnum.ALREADYSUBMIT.getCode(), RegBillStatusEnum.APPROVING.getCode(), RegBillStatusEnum.WAITRESUBMIT.getCode(), RegBillStatusEnum.APPROVEPASSED.getCode()};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)billStatusArr);
        DynamicObject[] batchRegs = IBatchRegBillService.getInstance().query(BATCH_REG_SELECT_PROPERTIES, new QFilter[]{billStatusFilter});
        if (batchRegs == null || batchRegs.length < 1) {
            return;
        }
        List idList = Arrays.stream(batchRegs).map(batchReg -> batchReg.getLong("id")).collect(Collectors.toList());
        QFilter midFilter = new QFilter("mid", "in", idList);
        DynamicObject[] regBills = IRegBillService.getInstance().query(REG_SELECT_PROPERTIES, new QFilter[]{midFilter});
        Map<Long, Boolean> notUpdateMap = Arrays.stream(regBills).filter(regBill -> !RegBusinessStatusEnum.REJECT_REG.getCode().equals(regBill.getString("regstatus")) && !RegBusinessStatusEnum.ALREADY_REGED.getCode().equals(regBill.getString("regstatus"))).collect(Collectors.toMap(regBill -> regBill.getLong("mid"), regBill -> Boolean.TRUE, (o, n) -> n));
        Map<Long, Boolean> updateMap = Arrays.stream(regBills).filter(regBill -> notUpdateMap.get(regBill.getLong("mid")) == null).filter(regBill -> RegBusinessStatusEnum.REJECT_REG.getCode().equals(regBill.getString("regstatus")) && RegNewAuditStatusEnum.ABANDONED.getCode().equals(regBill.getString("auditstatus"))).collect(Collectors.toMap(regBill -> regBill.getLong("mid"), regBill -> Boolean.TRUE, (o, n) -> n));
        ArrayList<DynamicObject> updateBatchRegList = new ArrayList<DynamicObject>();
        for (DynamicObject batchReg2 : batchRegs) {
            long id = batchReg2.getLong("id");
            String auditStatus = batchReg2.getString("auditstatus");
            if (updateMap.get(id) == null || RegNewAuditStatusEnum.ABANDONED.getCode().equals(auditStatus)) continue;
            batchReg2.set("auditstatus", (Object)RegNewAuditStatusEnum.ABANDONED.getCode());
            String billStatus = batchReg2.getString("billstatus");
            if (!RegBillStatusEnum.APPROVEPASSED.getCode().equals(billStatus)) {
                batchReg2.set("billstatus", (Object)RegBillStatusEnum.ABANDONED.getCode());
                IRegBillService.getInstance().terminateWorkFlow(batchReg2);
            }
            batchReg2.set("termuser", (Object)1L);
            batchReg2.set("termdate", (Object)new Date());
            batchReg2.set("termreason", (Object)ResManager.loadKDString((String)"\u7531\u4e8e\u5355\u636e\u4e2d\u5f85\u8f6c\u6b63\u4eba\u5458\u5df2\u79bb\u804c\uff0c\u8be5\u5355\u636e\u5df2\u81ea\u52a8\u7ec8\u6b62\u6d41\u7a0b\u3002", (String)"BatchRegTerminateTask_0", (String)"hr-hdm-business", (Object[])new Object[0]));
            updateBatchRegList.add(batchReg2);
        }
        if (updateBatchRegList.size() > 0) {
            IBatchRegBillService.getInstance().update(updateBatchRegList.toArray(updateBatchRegList.toArray(new DynamicObject[0])));
        }
    }
}

